/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.CommonConfigurationXMLCodec;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.xml.sax.Attributes;

class AuxConfigurationXMLCodec
extends CommonConfigurationXMLCodec {
    private String tag;
    private ConfigurationDescriptor configurationDescriptor;
    private Configuration currentConf;
    private List<XMLDecoder> decoders = new ArrayList<XMLDecoder>();
    private int descriptorVersion = -1;

    public AuxConfigurationXMLCodec(String tag, ConfigurationDescriptor configurationDescriptor) {
        super(configurationDescriptor, false);
        this.tag = tag;
        this.configurationDescriptor = configurationDescriptor;
    }

    public String tag() {
        return this.tag;
    }

    public void start(Attributes atts) throws VersionException {
        String what = "project configuration";
        this.checkVersion(atts, what, 80);
        String versionString = atts.getValue("version");
        if (versionString != null) {
            this.descriptorVersion = new Integer(versionString);
        }
    }

    public void end() {
    }

    public void startElement(String element, Attributes atts) {
        if (element.equals("conf")) {
            String currentConfName = atts.getValue("name");
            Configurations confs = this.configurationDescriptor.getConfs();
            this.currentConf = confs.getConf(currentConfName);
            if (this.currentConf == null) {
                return;
            }
            for (int dx = 0; dx < this.decoders.size(); ++dx) {
                XMLDecoder decoder = this.decoders.get(dx);
                this.deregisterXMLDecoder(decoder);
            }
            ConfigurationAuxObject[] profileAuxObjects = this.currentConf.getAuxObjects();
            this.decoders = new ArrayList<XMLDecoder>();
            for (int i = 0; i < profileAuxObjects.length; ++i) {
                if (profileAuxObjects[i].shared()) continue;
                XMLDecoder newDecoder = profileAuxObjects[i].getXMLDecoder();
                this.registerXMLDecoder(newDecoder);
                this.decoders.add(newDecoder);
            }
        }
    }

    public void endElement(String element, String currentText) {
        if (element.equals("defaultConf")) {
            this.configurationDescriptor.getConfs().setActive(new Integer(currentText));
        } else if (element.equals("developmentServer")) {
            if (this.currentConf instanceof MakeConfiguration) {
                ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)currentText);
                env = CppUtils.convertAfterReading(env, (MakeConfiguration)this.currentConf);
                ((MakeConfiguration)this.currentConf).getDevelopmentHost().setHost(env);
            }
        } else if (element.equals("platform") && this.currentConf instanceof MakeConfiguration) {
            int set = new Integer(currentText);
            if (this.descriptorVersion <= 37 && set == 4) {
                set = 5;
            }
            ((MakeConfiguration)this.currentConf).getDevelopmentHost().setBuildPlatform(set);
        }
    }

    @Override
    protected void writeToolsSetBlock(XMLEncoderStream xes, MakeConfiguration makeConfiguration) {
        xes.elementOpen("toolsSet");
        String hostKey = makeConfiguration.getDevelopmentHost().getHostKey();
        ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)hostKey);
        env = CppUtils.convertBeforeWriting(env, makeConfiguration);
        hostKey = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        xes.element("developmentServer", hostKey);
        xes.element("platform", "" + makeConfiguration.getDevelopmentHost().getBuildPlatform());
        xes.elementClose("toolsSet");
    }
}

