/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.project.NativeProjectType;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectTypeImpl;
import org.netbeans.modules.cnd.makeproject.SmartOutputStream;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectEvent;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectHelper;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectListener;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakSet;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MakeProjectHelperImpl
implements MakeProjectHelper {
    static final String PRIVATE_NS = "http://www.netbeans.org/ns/project-private/1";
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");
    private static final Logger LOG = Logger.getLogger(MakeProjectHelperImpl.class.getName());
    private static RequestProcessor RP;
    private final FileObject dir;
    private FileSystem fileSystem;
    private final ProjectState state;
    private final MakeProjectTypeImpl type;
    private static final Document NONEXISTENT;
    private Document projectXml;
    private boolean projectXmlValid;
    private Document privateXml;
    private boolean privateXmlValid;
    private final Set<String> modifiedMetadataPaths = new HashSet<String>();
    private Throwable addedProjectXmlPath;
    private final List<MakeProjectListener> listeners = new ArrayList<MakeProjectListener>();
    private final FileChangeListener fileListener;
    private final Set<FileSystem.AtomicAction> saveActions = new WeakSet();
    static boolean QUIETLY_SWALLOW_XML_LOAD_ERRORS;
    private static final DocumentBuilder db;

    public static MakeProjectHelperImpl create(FileObject dir, Document projectXml, ProjectState state, MakeProjectTypeImpl type) {
        FileObject substituted = MakeProjectHelperImpl.substituteIfNeed(dir, projectXml);
        if (substituted != null) {
            dir = substituted;
        }
        return new MakeProjectHelperImpl(dir, projectXml, state, type);
    }

    private static FileObject substituteIfNeed(FileObject dir, Document projectXml) {
        if (!dir.getNameExt().endsWith("shadow")) {
            return null;
        }
        Element root = projectXml.getDocumentElement();
        if (root != null) {
            String mode = MakeProjectHelperImpl.getNodeValue(root, "remote-sources-mode");
            if (RemoteProject.Mode.REMOTE_SOURCES.name().equals(mode)) {
                String hostUid = MakeProjectHelperImpl.getNodeValue(root, "remote-filesystem-host");
                String remotebaseDir = MakeProjectHelperImpl.getNodeValue(root, "remote-filesystem-base-dir");
                if (hostUid != null && remotebaseDir != null) {
                    ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)hostUid);
                    FileObject fo = FileSystemProvider.getFileObject((ExecutionEnvironment)env, (String)remotebaseDir);
                    return fo;
                }
            }
        }
        return null;
    }

    private static String getNodeValue(Element root, String tag) {
        Node node;
        NodeList childNodes;
        NodeList nodeList;
        if (root != null && (nodeList = root.getElementsByTagName(tag)).getLength() > 0 && (childNodes = (node = nodeList.item(0)).getChildNodes()).getLength() > 0) {
            return childNodes.item(0).getNodeValue();
        }
        return null;
    }

    private MakeProjectHelperImpl(FileObject dir, Document projectXml, ProjectState state, MakeProjectTypeImpl type) {
        this.dir = dir;
        try {
            this.fileSystem = dir.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            throw new IllegalStateException(ex);
        }
        this.state = state;
        assert (state != null);
        this.type = type;
        assert (type != null);
        this.projectXml = projectXml;
        this.projectXmlValid = true;
        assert (projectXml != null);
        this.fileListener = new FileListener();
        FileObject resolveFileObject = this.resolveFileObject("nbproject/project.xml");
        if (resolveFileObject != null) {
            resolveFileObject.addFileChangeListener(this.fileListener);
        } else {
            FileSystemProvider.addFileChangeListener((FileChangeListener)this.fileListener, (FileSystem)this.fileSystem, (String)"nbproject/project.xml");
        }
        resolveFileObject = this.resolveFileObject("nbproject/private/private.xml");
        if (resolveFileObject != null) {
            resolveFileObject.addFileChangeListener(this.fileListener);
        } else {
            FileSystemProvider.addFileChangeListener((FileChangeListener)this.fileListener, (FileSystem)this.fileSystem, (String)"nbproject/private/private.xml");
        }
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public FileObject resolveFileObject(String filename) throws IllegalArgumentException {
        if (filename == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(filename).matches()) {
            return this.dir.getFileObject(filename);
        }
        try {
            return this.dir.getFileSystem().findResource(filename);
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private String resolvePath(String filename) throws IllegalArgumentException {
        if (filename == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        String result = RELATIVE_SLASH_SEPARATED_PATH.matcher(filename).matches() ? this.dir.getPath() + CndFileUtils.getFileSeparatorChar((FileSystem)this.fileSystem) + filename : filename;
        return FileSystemProvider.normalizeAbsolutePath((String)result, (FileSystem)this.fileSystem);
    }

    @Override
    public NativeProjectType getType() {
        return this.type;
    }

    private Document getConfigurationXml(boolean shared) {
        Document xml;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        if (!(!shared ? this.privateXmlValid : this.projectXmlValid)) {
            String path = shared ? "nbproject/project.xml" : "nbproject/private/private.xml";
            Document _xml = this.loadXml(path);
            if (_xml != null && _xml != NONEXISTENT) {
                if (shared) {
                    this.projectXml = _xml;
                } else {
                    this.privateXml = _xml;
                }
            } else if (_xml == NONEXISTENT && !shared) {
                this.privateXml = null;
            }
        }
        if (!shared && this.privateXml == null) {
            this.privateXml = XMLUtil.createDocument((String)"project-private", (String)PRIVATE_NS, null, null);
        }
        if (shared) {
            this.projectXmlValid = true;
        } else {
            this.privateXmlValid = true;
        }
        Document document = xml = shared ? this.projectXml : this.privateXml;
        assert (xml != null) : "shared=" + shared + " projectXml=" + this.projectXml + " privateXml=" + this.privateXml + " projectXmlValid=" + this.projectXmlValid + " privateXmlValid=" + this.privateXmlValid;
        return xml;
    }

    private Document loadXml(String path) {
        block7: {
            assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
            assert (Thread.holdsLock(this.modifiedMetadataPaths));
            FileObject xml = this.dir.getFileObject(path);
            if (xml == null || !xml.isData()) {
                return NONEXISTENT;
            }
            try {
                Document doc = XMLUtil.parse((InputSource)new InputSource(xml.getInputStream()), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
                return doc;
            }
            catch (IOException e) {
                if (!QUIETLY_SWALLOW_XML_LOAD_ERRORS) {
                    LOG.log(Level.INFO, "Load XML: {0}", xml.getPath());
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            catch (SAXException e) {
                if (QUIETLY_SWALLOW_XML_LOAD_ERRORS) break block7;
                LOG.log(Level.INFO, "Load XML: {0}", xml.getPath());
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSaveAA(FileSystem.AtomicAction action) throws IOException {
        Set<FileSystem.AtomicAction> set = this.saveActions;
        synchronized (set) {
            this.saveActions.add(action);
        }
        this.dir.getFileSystem().runAtomicAction(action);
    }

    private FileLock saveXml(final Document doc, final String path) throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        final FileLock[] _lock = new FileLock[1];
        this.runSaveAA(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLUtil.write((Document)doc, (OutputStream)baos, (String)"UTF-8");
                byte[] data = baos.toByteArray();
                FileObject xml = FileUtil.createData((FileObject)MakeProjectHelperImpl.this.dir, (String)path);
                try {
                    _lock[0] = xml.lock();
                    OutputStream os = SmartOutputStream.getSmartOutputStream(xml, _lock[0]);
                    try {
                        os.write(data);
                    }
                    finally {
                        os.close();
                    }
                }
                catch (UserQuestionException uqe) {
                    ErrorManager.getDefault().notify((Throwable)uqe);
                    if (path.equals("nbproject/project.xml")) {
                        Set set = MakeProjectHelperImpl.this.modifiedMetadataPaths;
                        synchronized (set) {
                            MakeProjectHelperImpl.this.projectXmlValid = false;
                        }
                    }
                    assert (path.equals("nbproject/private/private.xml")) : path;
                    Set set = MakeProjectHelperImpl.this.modifiedMetadataPaths;
                    synchronized (set) {
                        MakeProjectHelperImpl.this.privateXmlValid = false;
                    }
                    MakeProjectHelperImpl.this.fireExternalChange(path);
                }
            }
        });
        return _lock[0];
    }

    private Element getConfigurationDataRoot(boolean shared) {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        Document doc = this.getConfigurationXml(shared);
        if (shared) {
            Element project = doc.getDocumentElement();
            Element config = XMLUtil.findElement((Element)project, (String)"configuration", (String)"http://www.netbeans.org/ns/project/1");
            assert (config != null);
            return config;
        }
        return doc.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMakeProjectListener(MakeProjectListener listener) {
        List<MakeProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMakeProjectListener(MakeProjectListener listener) {
        List<MakeProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    void fireExternalChange(String path) {
        ActionImpl action = new ActionImpl(this, path);
        if (ProjectManager.mutex().isWriteAccess()) {
            ProjectManager.mutex().readAccess((Mutex.Action)action);
        } else if (ProjectManager.mutex().isReadAccess()) {
            action.run();
        } else {
            MakeProjectHelperImpl.rp().post((Runnable)new RunnableImpl(action));
        }
    }

    private static synchronized RequestProcessor rp() {
        if (RP == null) {
            RP = new RequestProcessor("MakeProjectHelper.RP");
        }
        return RP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(String path, boolean expected) {
        MakeProjectListener[] _listeners;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        List<MakeProjectListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return;
            }
            _listeners = this.listeners.toArray(new MakeProjectListener[this.listeners.size()]);
        }
        final MakeProjectEvent ev = new MakeProjectEvent(this, path, expected);
        final boolean xml = path.equals("nbproject/project.xml") || path.equals("nbproject/private/private.xml");
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                for (MakeProjectListener l : _listeners) {
                    try {
                        if (xml) {
                            l.configurationXmlChanged(ev);
                            continue;
                        }
                        l.propertiesChanged(ev);
                    }
                    catch (RuntimeException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    private void modifying(String path) {
        assert (ProjectManager.mutex().isWriteAccess());
        this.state.markModified();
        this.addModifiedMetadataPath(path);
        this.fireChange(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModifiedMetadataPath(String path) {
        Set<String> set = this.modifiedMetadataPaths;
        synchronized (set) {
            boolean added = this.modifiedMetadataPaths.add(path);
            if (added && path.equals("nbproject/project.xml")) {
                this.addedProjectXmlPath = new Throwable();
            }
        }
    }

    @Override
    public FileObject getProjectDirectory() {
        return this.dir;
    }

    @Override
    public void notifyDeleted() {
        this.state.notifyDeleted();
    }

    public void markModified() {
        assert (ProjectManager.mutex().isWriteAccess());
        this.state.markModified();
        this.addModifiedMetadataPath("nbproject/project.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureProjectXmlUnmodified(String msg, boolean doSave) {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        Set<String> set = this.modifiedMetadataPaths;
        synchronized (set) {
            if (this.modifiedMetadataPaths.contains("nbproject/project.xml")) {
                IllegalStateException ise = new IllegalStateException(msg);
                if (this.addedProjectXmlPath != null) {
                    ise.initCause(this.addedProjectXmlPath);
                }
                LOG.log(Level.INFO, null, ise);
                if (doSave) {
                    try {
                        this.save();
                    }
                    catch (IOException x) {
                        LOG.log(Level.INFO, null, x);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        if (!this.getProjectDirectory().isValid()) {
            return;
        }
        HashSet<FileLock> locks = new HashSet<FileLock>();
        try {
            Set<String> set = this.modifiedMetadataPaths;
            synchronized (set) {
                assert (!this.modifiedMetadataPaths.isEmpty());
                HashSet<String> toBeCleared = new HashSet<String>();
                try {
                    for (String path : new TreeSet<String>(this.modifiedMetadataPaths)) {
                        try {
                            if (path.equals("nbproject/project.xml")) {
                                assert (this.projectXml != null);
                                locks.add(this.saveXml(this.projectXml, path));
                            } else if (path.equals("nbproject/private/private.xml")) {
                                assert (this.privateXml != null);
                                locks.add(this.saveXml(this.privateXml, path));
                            }
                        }
                        catch (FileAlreadyLockedException x) {
                            LOG.log(Level.INFO, null, x);
                        }
                        toBeCleared.add(path);
                    }
                    this.modifiedMetadataPaths.removeAll(toBeCleared);
                }
                catch (Throwable throwable) {
                    this.modifiedMetadataPaths.removeAll(toBeCleared);
                    LOG.log(Level.FINE, "saved {0} and have left {1}", new Object[]{toBeCleared, this.modifiedMetadataPaths});
                    throw throwable;
                }
                LOG.log(Level.FINE, "saved {0} and have left {1}", new Object[]{toBeCleared, this.modifiedMetadataPaths});
            }
        }
        finally {
            locks.remove(null);
            for (FileLock lock : locks) {
                lock.releaseLock();
            }
        }
    }

    @Override
    public Element getPrimaryConfigurationData(final boolean shared) {
        final String name = this.type.getPrimaryConfigurationDataElementName(shared);
        assert (name.indexOf(58) == -1);
        final String namespace = this.type.getPrimaryConfigurationDataElementNamespace(shared);
        assert (namespace != null && namespace.length() > 0);
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Element run() {
                Set set = MakeProjectHelperImpl.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element el = MakeProjectHelperImpl.this.getConfigurationFragment(name, namespace, shared);
                    if (el != null) {
                        return el;
                    }
                    return MakeProjectHelperImpl.cloneSafely(MakeProjectHelperImpl.this.getConfigurationXml(shared).createElementNS(namespace, name));
                }
            }
        });
    }

    @Override
    public void putPrimaryConfigurationData(Element data, boolean shared) throws IllegalArgumentException {
        String name = this.type.getPrimaryConfigurationDataElementName(shared);
        assert (name.indexOf(58) == -1);
        String namespace = this.type.getPrimaryConfigurationDataElementNamespace(shared);
        assert (namespace != null && namespace.length() > 0);
        if (!name.equals(data.getLocalName()) || !namespace.equals(data.getNamespaceURI())) {
            throw new IllegalArgumentException("Wrong name/namespace: expected {" + namespace + "}" + name + " but was {" + data.getNamespaceURI() + "}" + data.getLocalName());
        }
        this.putConfigurationFragment(data, shared);
    }

    Element getConfigurationFragment(final String elementName, final String namespace, final boolean shared) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Element run() {
                Set set = MakeProjectHelperImpl.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element root = MakeProjectHelperImpl.this.getConfigurationDataRoot(shared);
                    Element data = XMLUtil.findElement((Element)root, (String)elementName, (String)namespace);
                    if (data != null) {
                        return MakeProjectHelperImpl.cloneSafely(data);
                    }
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element cloneSafely(Element el) {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            Document dummy = db.newDocument();
            return (Element)dummy.importNode(el, true);
        }
    }

    void putConfigurationFragment(final Element fragment, final boolean shared) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                Set set = MakeProjectHelperImpl.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element root = MakeProjectHelperImpl.this.getConfigurationDataRoot(shared);
                    Element existing = XMLUtil.findElement((Element)root, (String)fragment.getLocalName(), (String)fragment.getNamespaceURI());
                    if (existing != null) {
                        root.removeChild(existing);
                    }
                    Node ref = null;
                    NodeList list = root.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        Node node = list.item(i);
                        if (node.getNodeType() != 1) continue;
                        int comparison = node.getNodeName().compareTo(fragment.getNodeName());
                        if (comparison == 0) {
                            comparison = node.getNamespaceURI().compareTo(fragment.getNamespaceURI());
                        }
                        if (comparison <= 0) continue;
                        ref = node;
                        break;
                    }
                    root.insertBefore(root.getOwnerDocument().importNode(fragment, true), ref);
                    MakeProjectHelperImpl.this.modifying(shared ? "nbproject/project.xml" : "nbproject/private/private.xml");
                }
                return null;
            }
        });
    }

    boolean removeConfigurationFragment(final String elementName, final String namespace, final boolean shared) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                Set set = MakeProjectHelperImpl.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element root = MakeProjectHelperImpl.this.getConfigurationDataRoot(shared);
                    Element data = XMLUtil.findElement((Element)root, (String)elementName, (String)namespace);
                    if (data != null) {
                        root.removeChild(data);
                        MakeProjectHelperImpl.this.modifying(shared ? "nbproject/project.xml" : "nbproject/private/private.xml");
                        return true;
                    }
                    return false;
                }
            }
        });
    }

    @Override
    public AuxiliaryConfiguration createAuxiliaryConfiguration() {
        return new ExtensibleMetadataProviderImpl(this);
    }

    @Override
    public CacheDirectoryProvider createCacheDirectoryProvider() {
        return new ExtensibleMetadataProviderImpl(this);
    }

    @Override
    public SharabilityQueryImplementation createSharabilityQuery(String[] sourceRoots, String[] buildDirectories) {
        String[] includes = new String[sourceRoots.length + 1];
        System.arraycopy(sourceRoots, 0, includes, 0, sourceRoots.length);
        includes[sourceRoots.length] = "";
        String[] excludes = new String[buildDirectories.length + 1];
        System.arraycopy(buildDirectories, 0, excludes, 0, buildDirectories.length);
        excludes[buildDirectories.length] = "nbproject/private";
        return new SharabilityQueryImpl(this, includes, excludes);
    }

    public String toString() {
        return "MakeProjectHelper[" + this.getProjectDirectory() + "]";
    }

    static {
        NONEXISTENT = XMLUtil.createDocument((String)"does-not-exist", null, null, null);
        QUIETLY_SWALLOW_XML_LOAD_ERRORS = false;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final class SharabilityQueryImpl
    implements SharabilityQueryImplementation,
    PropertyChangeListener,
    MakeProjectListener {
        private final MakeProjectHelperImpl h;
        private final String[] includes;
        private final String[] excludes;
        private String[] includePaths;
        private String[] excludePaths;

        SharabilityQueryImpl(MakeProjectHelperImpl h, String[] includes, String[] excludes) {
            this.h = h;
            this.includes = includes;
            this.excludes = excludes;
            this.computeFiles();
            h.addMakeProjectListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeFiles() {
            String[] _includePaths = this.computeFrom(this.includes, false);
            String[] _excludePaths = this.computeFrom(this.excludes, true);
            SharabilityQueryImpl sharabilityQueryImpl = this;
            synchronized (sharabilityQueryImpl) {
                this.includePaths = _includePaths;
                this.excludePaths = _excludePaths;
            }
        }

        private String[] computeFrom(String[] list, boolean excludeProjectLibraryPrivate) {
            ArrayList<String> result = new ArrayList<String>(list.length);
            for (String val : list) {
                result.add(this.h.resolvePath(val));
            }
            return result.toArray(new String[result.size()]);
        }

        public synchronized int getSharability(File file) {
            String path = file.getAbsolutePath();
            if (SharabilityQueryImpl.contains(path, this.excludePaths, false)) {
                return 2;
            }
            return SharabilityQueryImpl.contains(path, this.includePaths, false) ? (SharabilityQueryImpl.contains(path, this.excludePaths, true) ? 3 : 1) : 0;
        }

        private static boolean contains(String path, String[] list, boolean reverse) {
            for (String s : list) {
                if (path.equals(s)) {
                    return true;
                }
                if (!(reverse ? s.startsWith(path + File.separatorChar) : path.startsWith(s + File.separatorChar))) continue;
                return true;
            }
            return false;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.computeFiles();
        }

        @Override
        public void configurationXmlChanged(MakeProjectEvent ev) {
            this.computeFiles();
        }

        @Override
        public void propertiesChanged(MakeProjectEvent ev) {
        }
    }

    private static final class ExtensibleMetadataProviderImpl
    implements AuxiliaryConfiguration,
    CacheDirectoryProvider {
        private static final String CACHE_PATH = "nbproject/private";
        private final MakeProjectHelperImpl helper;

        ExtensibleMetadataProviderImpl(MakeProjectHelperImpl helper) {
            this.helper = helper;
        }

        public FileObject getCacheDirectory() throws IOException {
            return FileUtil.createFolder((FileObject)this.helper.getProjectDirectory(), (String)CACHE_PATH);
        }

        public Element getConfigurationFragment(String elementName, String namespace, boolean shared) {
            if (elementName == null || elementName.indexOf(58) != -1 || namespace == null) {
                throw new IllegalArgumentException("Illegal elementName and/or namespace");
            }
            return this.helper.getConfigurationFragment(elementName, namespace, shared);
        }

        public void putConfigurationFragment(Element fragment, boolean shared) throws IllegalArgumentException {
            if (fragment.getNamespaceURI() == null || fragment.getNamespaceURI().length() == 0) {
                throw new IllegalArgumentException("Illegal elementName and/or namespace");
            }
            if (fragment.getLocalName().equals(this.helper.getType().getPrimaryConfigurationDataElementName(shared)) && fragment.getNamespaceURI().equals(this.helper.getType().getPrimaryConfigurationDataElementNamespace(shared))) {
                throw new IllegalArgumentException("elementName + namespace reserved for project's primary configuration data");
            }
            this.helper.putConfigurationFragment(fragment, shared);
        }

        public boolean removeConfigurationFragment(String elementName, String namespace, boolean shared) throws IllegalArgumentException {
            if (elementName == null || elementName.indexOf(58) != -1 || namespace == null) {
                throw new IllegalArgumentException("Illegal elementName and/or namespace");
            }
            if (elementName.equals(this.helper.getType().getPrimaryConfigurationDataElementName(shared)) && namespace.equals(this.helper.getType().getPrimaryConfigurationDataElementNamespace(shared))) {
                throw new IllegalArgumentException("elementName + namespace reserved for project's primary configuration data");
            }
            return this.helper.removeConfigurationFragment(elementName, namespace, shared);
        }
    }

    private static class ActionImpl
    implements Mutex.Action<Void> {
        private final String path;
        private MakeProjectHelperImpl helper;

        public ActionImpl(MakeProjectHelperImpl helper, String path) {
            this.path = path;
            this.helper = helper;
        }

        public Void run() {
            this.helper.fireChange(this.path, false);
            this.helper = null;
            return null;
        }
    }

    private static class RunnableImpl
    implements Runnable {
        private final Mutex.Action<Void> action;

        public RunnableImpl(Mutex.Action<Void> action) {
            this.action = action;
        }

        @Override
        public void run() {
            ProjectManager.mutex().readAccess(this.action);
        }
    }

    private final class FileListener
    implements FileChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void change(FileEvent fe) {
            String path;
            Set set = MakeProjectHelperImpl.this.saveActions;
            synchronized (set) {
                for (FileSystem.AtomicAction a : MakeProjectHelperImpl.this.saveActions) {
                    if (!fe.firedFrom(a)) continue;
                    return;
                }
            }
            FileObject f = fe.getFile();
            Set set2 = MakeProjectHelperImpl.this.modifiedMetadataPaths;
            synchronized (set2) {
                if (f.equals(MakeProjectHelperImpl.this.resolveFileObject("nbproject/project.xml"))) {
                    if (MakeProjectHelperImpl.this.modifiedMetadataPaths.contains("nbproject/project.xml")) {
                        return;
                    }
                    path = "nbproject/project.xml";
                    MakeProjectHelperImpl.this.projectXmlValid = false;
                } else if (f.equals(MakeProjectHelperImpl.this.resolveFileObject("nbproject/private/private.xml"))) {
                    if (MakeProjectHelperImpl.this.modifiedMetadataPaths.contains("nbproject/private/private.xml")) {
                        return;
                    }
                    path = "nbproject/private/private.xml";
                    MakeProjectHelperImpl.this.privateXmlValid = false;
                } else {
                    LOG.log(Level.WARNING, "#184132: unexpected file change in {0}; possibly deleted project?", f);
                    return;
                }
            }
            MakeProjectHelperImpl.this.fireExternalChange(path);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.change(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.change(fe);
        }

        public void fileChanged(FileEvent fe) {
            this.change(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.change(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.change((FileEvent)fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

