/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ReferencesFactory;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ReferencesMultiViewElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    public static final int REFERENCES_ELEMENT_INDEX = 5;
    private SectionView view;
    private ToolBarDesignEditor comp;
    private DDDataObject dObj;
    private WebApp webApp;
    private ReferencesFactory factory;
    private Action addAction;
    private Action removeAction;
    private boolean needInit = true;
    private int index;
    private RequestProcessor.Task repaintingTask;
    private static final String REFERENCES_MV_ID = "dd_multiviewReferences";
    private static final String HELP_ID_PREFIX = "dd_multiview_references_";

    public ReferencesMultiViewElement(Lookup context) {
        super((XmlMultiViewDataObject)context.lookup(DDDataObject.class));
        this.dObj = (DDDataObject)context.lookup(DDDataObject.class);
        this.index = 5;
        this.comp = new ToolBarDesignEditor();
        this.factory = new ReferencesFactory(this.comp, this.dObj);
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReferencesMultiViewElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(this.index);
        if (this.needInit || !this.dObj.isDocumentParseable()) {
            this.repaintView();
            this.needInit = false;
        }
    }

    private void repaintView() {
        this.webApp = this.dObj.getWebApp();
        this.view = new ReferencesView(this.webApp);
        this.comp.setContentView((PanelView)this.view);
        Object lastActive = this.comp.getLastActive();
        if (lastActive != null) {
            this.view.openPanel(lastActive);
        } else {
            ReferencesView referencesView = (ReferencesView)this.view;
            Node initialNode = referencesView.getResRefsNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount() > 0) {
                initialNode = ch.getNodes()[0];
            }
            referencesView.selectNode(initialNode);
        }
        this.view.checkValidity();
        this.dObj.checkParseable();
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.getWebApp().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.getWebApp().removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name;
        if (!(this.dObj.isChangedFromUI() || (name = evt.getPropertyName()).indexOf("Ref") <= 0 && name.indexOf("EnvEntry") <= 0)) {
            if (REFERENCES_MV_ID.equals(this.dObj.getSelectedPerspective().preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private class MessageDestRefsNode
    extends AbstractNode {
        MessageDestRefsNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(ReferencesMultiViewElement.class, (String)"TTL_MessageDestRefs"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/paramNode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_references_messageDestRefsNode");
        }
    }

    private class EjbRefsNode
    extends AbstractNode {
        EjbRefsNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(ReferencesMultiViewElement.class, (String)"TTL_EjbRefs"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/paramNode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_references_ejbRefsNode");
        }
    }

    private class ResEnvRefsNode
    extends AbstractNode {
        ResEnvRefsNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(ReferencesMultiViewElement.class, (String)"TTL_ResEnvRefs"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/paramNode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_references_resEnvRefsNode");
        }
    }

    private class ResRefsNode
    extends AbstractNode {
        ResRefsNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(ReferencesMultiViewElement.class, (String)"TTL_ResRefs"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/paramNode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_references_resRefsNode");
        }
    }

    private class EnvEntriesNode
    extends AbstractNode {
        EnvEntriesNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(ReferencesMultiViewElement.class, (String)"TTL_EnvEntries"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/paramNode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_references_envEntriesNode");
        }
    }

    class ReferencesView
    extends SectionView {
        private Node envEntriesNode;
        private Node resRefsNode;
        private Node resEnvRefsNode;
        private Node ejbRefsNode;
        private Node messageDestRefsNode;

        ReferencesView(WebApp webApp) {
            super((InnerPanelFactory)ReferencesMultiViewElement.this.factory);
            this.envEntriesNode = new EnvEntriesNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.envEntriesNode, (Object)"env_entries"));
            this.resRefsNode = new ResRefsNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.resRefsNode, (Object)"res_refs"));
            this.resEnvRefsNode = new ResEnvRefsNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.resEnvRefsNode, (Object)"res_env_refs"));
            this.ejbRefsNode = new EjbRefsNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.ejbRefsNode, (Object)"ejb_refs"));
            this.messageDestRefsNode = new MessageDestRefsNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.messageDestRefsNode, (Object)"message_dest_refs"));
            Children.Array rootChildren = new Children.Array();
            rootChildren.add(new Node[]{this.envEntriesNode, this.resRefsNode, this.resEnvRefsNode, this.ejbRefsNode, this.messageDestRefsNode});
            AbstractNode root = new AbstractNode((Children)rootChildren);
            this.setRoot((Node)root);
        }

        Node getEnvEntriesNode() {
            return this.envEntriesNode;
        }

        Node getResRefsNode() {
            return this.resRefsNode;
        }

        Node getResEnvRefsNode() {
            return this.resEnvRefsNode;
        }

        Node getEjbRefsNode() {
            return this.ejbRefsNode;
        }

        Node getMessageDestRefsNode() {
            return this.messageDestRefsNode;
        }
    }
}

