/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import javax.swing.SwingUtilities;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.OverviewFactory;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.PagesMultiViewElement;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OverviewMultiViewElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    public static final int OVERVIEW_ELEMENT_INDEX = 1;
    private SectionView view;
    private ToolBarDesignEditor comp;
    private DDDataObject dObj;
    private WebApp webApp;
    private OverviewFactory factory;
    private boolean needInit = true;
    private int index;
    private RequestProcessor.Task repaintingTask;
    private static final String OVERVIEW_MV_ID = "dd_multiviewOverview";
    private static final String HELP_ID_PREFIX = "dd_multiview_overview_";

    public OverviewMultiViewElement(Lookup context) {
        super((XmlMultiViewDataObject)context.lookup(DDDataObject.class));
        this.dObj = (DDDataObject)context.lookup(DDDataObject.class);
        this.index = 1;
        this.comp = new ToolBarDesignEditor();
        this.factory = new OverviewFactory(this.comp, this.dObj);
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OverviewMultiViewElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(this.index);
        if (this.needInit || !this.dObj.isDocumentParseable()) {
            this.repaintView();
            this.needInit = false;
        }
    }

    private void repaintView() {
        this.webApp = this.dObj.getWebApp();
        this.view = new OverView(this.webApp);
        this.comp.setContentView((PanelView)this.view);
        Object lastActive = this.comp.getLastActive();
        if (lastActive != null) {
            this.view.openPanel(lastActive);
        } else {
            this.view.openPanel((Object)"overview");
        }
        this.view.checkValidity();
        this.dObj.checkParseable();
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.getWebApp().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.getWebApp().removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name;
        if (!(this.dObj.isChangedFromUI() || (name = evt.getPropertyName()).indexOf("/WebApp/DisplayName") < 0 && name.indexOf("/WebApp/Description") < 0 && name.indexOf("/WebApp/Name") < 0 && name.indexOf("Distributable") <= 0 && name.indexOf("ContextParam") <= 0 && name.indexOf("Listener") <= 0 && name.indexOf("SessionConfig") <= 0)) {
            MultiViewPerspective selectedPerspective = this.dObj.getSelectedPerspective();
            if (selectedPerspective != null && OVERVIEW_MV_ID.equals(selectedPerspective.preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private class ListenersNode
    extends AbstractNode {
        ListenersNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_Listeners"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/class.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_overview_listenersNode");
        }
    }

    private class ContextParamsNode
    extends AbstractNode {
        ContextParamsNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_ContextParams"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/paramsNode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_overview_contextParamsNode");
        }
    }

    private class RelativeOrderingNode
    extends AbstractNode {
        RelativeOrderingNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_Ordering"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/paramsNode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_overview_relativeOrderingNode");
        }
    }

    private class AbsoluteOrderingNode
    extends AbstractNode {
        AbsoluteOrderingNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_Ordering"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/paramsNode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_overview_absoluteOrderingNode");
        }
    }

    private class OverviewNode
    extends AbstractNode {
        OverviewNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_Overview"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/class.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_overview_overviewNode");
        }
    }

    class OverView
    extends SectionView {
        private Node overviewNode;
        private Node absoluteOrderingNode;
        private Node relativeOrderingNode;
        private Node contextParamsNode;
        private Node listenersNode;

        OverView(WebApp webApp) {
            super((InnerPanelFactory)OverviewMultiViewElement.this.factory);
            this.overviewNode = new OverviewNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.overviewNode, (Object)"overview"));
            String ver = webApp.getVersion();
            boolean jee6 = ver == null ? false : new BigDecimal(ver).compareTo(new BigDecimal(3.0)) >= 0;
            boolean fragment = webApp instanceof WebFragment;
            if (jee6) {
                if (fragment) {
                    this.relativeOrderingNode = new RelativeOrderingNode();
                    this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.relativeOrderingNode, (Object)"relativeOrdering"));
                } else {
                    this.absoluteOrderingNode = new AbsoluteOrderingNode();
                    this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.absoluteOrderingNode, (Object)"absoluteOrdering"));
                }
            }
            this.contextParamsNode = new ContextParamsNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.contextParamsNode, (Object)"context_params"));
            this.listenersNode = new ListenersNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.listenersNode, (Object)"listeners"));
            Children.Array rootChildren = new Children.Array();
            if (jee6) {
                if (fragment) {
                    rootChildren.add(new Node[]{this.overviewNode, this.relativeOrderingNode, this.contextParamsNode, this.listenersNode});
                } else {
                    rootChildren.add(new Node[]{this.overviewNode, this.absoluteOrderingNode, this.contextParamsNode, this.listenersNode});
                }
            } else {
                rootChildren.add(new Node[]{this.overviewNode, this.contextParamsNode, this.listenersNode});
            }
            AbstractNode root = new AbstractNode((Children)rootChildren);
            this.setRoot((Node)root);
        }
    }
}

