/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.global;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;

public class CalibrationDataFileIO {
    private static final String CALIBRATION_FILE_NOT_EXIST_MSG;
    private static final String CALIBRATION_FILE_NOT_READABLE_MSG;
    private static final String CALIBRATION_DATA_CORRUPTED_PREFIX;
    private static final String SHORTER_THAN_EXPECTED_STRING;
    private static final String ORIGINAL_MESSAGE_STRING;
    private static final String RERUN_CALIBRATION_MSG;
    private static final String ERROR_WRITING_CALIBRATION_FILE_PREFIX;
    private static final String REEXECUTE_CALIBRATION_MSG;
    private static String errorMessage;

    public static String getErrorMessage() {
        String res = errorMessage;
        errorMessage = null;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readSavedCalibrationData(ProfilingSessionStatus status) {
        String fn = null;
        try {
            fn = CalibrationDataFileIO.getCalibrationDataFileName(status.targetJDKVersionString);
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
            return -1;
        }
        File savedDataFile = new File(fn);
        if (!savedDataFile.exists()) {
            errorMessage = MessageFormat.format(CALIBRATION_FILE_NOT_EXIST_MSG, savedDataFile.toString());
            return 1;
        }
        if (!savedDataFile.canRead()) {
            errorMessage = MessageFormat.format(CALIBRATION_FILE_NOT_READABLE_MSG, savedDataFile.toString());
            return -1;
        }
        FileInputStream fiStream = null;
        try {
            fiStream = new FileInputStream(savedDataFile);
            ObjectInputStream oiStream = new ObjectInputStream(fiStream);
            status.methodEntryExitCallTime = (double[])oiStream.readObject();
            status.methodEntryExitInnerTime = (double[])oiStream.readObject();
            status.methodEntryExitOuterTime = (double[])oiStream.readObject();
            status.timerCountsInSecond = (long[])oiStream.readObject();
            fiStream.close();
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            String prefix = CALIBRATION_DATA_CORRUPTED_PREFIX;
            if (errorMessage == null) {
                if (e instanceof EOFException) {
                    errorMessage = prefix + " " + SHORTER_THAN_EXPECTED_STRING;
                }
            } else {
                errorMessage = prefix + "\n" + ORIGINAL_MESSAGE_STRING + " " + errorMessage;
            }
            errorMessage = errorMessage + "\n" + RERUN_CALIBRATION_MSG + "\n";
            int n = -2;
            return n;
        }
        finally {
            if (fiStream != null) {
                try {
                    fiStream.close();
                }
                catch (IOException e) {}
            }
        }
        return 0;
    }

    public static boolean saveCalibrationData(ProfilingSessionStatus status) {
        try {
            FileOutputStream foStream = new FileOutputStream(CalibrationDataFileIO.getCalibrationDataFileName(status.targetJDKVersionString));
            ObjectOutputStream ooStream = new ObjectOutputStream(foStream);
            ooStream.writeObject(status.methodEntryExitCallTime);
            ooStream.writeObject(status.methodEntryExitInnerTime);
            ooStream.writeObject(status.methodEntryExitOuterTime);
            ooStream.writeObject(status.timerCountsInSecond);
            foStream.close();
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
            String prefix = ERROR_WRITING_CALIBRATION_FILE_PREFIX;
            errorMessage = prefix + "\n" + ORIGINAL_MESSAGE_STRING + "\n" + errorMessage;
            if (!status.remoteProfiling) {
                errorMessage = errorMessage + "\n" + REEXECUTE_CALIBRATION_MSG + "\n";
            }
            return false;
        }
        return true;
    }

    public static boolean validateCalibrationInput(String javaVersionString, String javaExecutable) {
        return javaVersionString != null && javaExecutable != null && ("jdk15".equals(javaVersionString) || "jdk16".equals(javaVersionString) || "jdk17".equals(javaVersionString)) && new File(javaExecutable).exists();
    }

    private static String getCalibrationDataFileName(String targetJDKVerString) throws IOException {
        String fileName = "machinedata." + targetJDKVerString;
        return Platform.getProfilerUserDir() + File.separator + fileName;
    }

    static {
        ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.global.Bundle");
        CALIBRATION_FILE_NOT_EXIST_MSG = messages.getString("CalibrationDataFileIO_CalibrationFileNotExistMsg");
        CALIBRATION_FILE_NOT_READABLE_MSG = messages.getString("CalibrationDataFileIO_CalibrationFileNotReadableMsg");
        CALIBRATION_DATA_CORRUPTED_PREFIX = messages.getString("CalibrationDataFileIO_CalibrationDataCorruptedPrefix");
        SHORTER_THAN_EXPECTED_STRING = messages.getString("CalibrationDataFileIO_ShorterThanExpectedString");
        ORIGINAL_MESSAGE_STRING = messages.getString("CalibrationDataFileIO_OriginalMessageString");
        RERUN_CALIBRATION_MSG = messages.getString("CalibrationDataFileIO_ReRunCalibrationMsg");
        ERROR_WRITING_CALIBRATION_FILE_PREFIX = messages.getString("CalibrationDataFileIO_ErrorWritingCalibrationFilePrefix");
        REEXECUTE_CALIBRATION_MSG = messages.getString("CalibrationDataFileIO_ReExecuteCalibrationMsg");
    }
}

