/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.UIResource;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.ui.JFXApplicationClassChooser;
import org.netbeans.modules.javafx2.project.ui.JFXApplicationParametersPanel;
import org.netbeans.modules.javafx2.project.ui.JFXDeploymentPanel;
import org.netbeans.modules.javafx2.project.ui.JFXPreloaderChooserWizard;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.MouseUtils;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JFXRunPanel
extends JPanel
implements HelpCtx.Provider,
LookupListener {
    private static final String EA_HIDDEN = "hidden";
    private static final String BROWSERS_FOLDER = "Services/Browsers";
    private Lookup.Result<HtmlBrowser.Factory> lookupResult = null;
    private Project project;
    private PropertyEvaluator evaluator;
    private JTextField[] data;
    private JLabel[] dataLabels;
    private String[] keys;
    private final Map<String, Map<String, String>> configs;
    private JFXProjectProperties jfxProps;
    private File lastHtmlFolder = null;
    private static final String[] appParamsColumnNames = new String[]{NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.applicationParams.name"), NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.applicationParams.value")};
    private JButton buttonAppClass;
    private JButton buttonDelete;
    private ButtonGroup buttonGroupRunAs;
    private JButton buttonNew;
    private JButton buttonParams;
    private JButton buttonPreloader;
    private JButton buttonWebBrowser;
    private JButton buttonWebPage;
    private JButton buttonWorkDir;
    private JCheckBox checkBoxPreloader;
    private JComboBox comboBoxPreloaderClass;
    private JComboBox comboBoxWebBrowser;
    private JComboBox comboConfig;
    private JPanel configPanel;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel labelAppClass;
    private JLabel labelConfig;
    private JLabel labelHeight;
    private JLabel labelParams;
    private JLabel labelPreloaderClass;
    private JLabel labelRunAs;
    private JLabel labelSAProps;
    private JLabel labelVMOptions;
    private JLabel labelVMOptionsRemark;
    private JLabel labelWSBAProps;
    private JLabel labelWebBrowser;
    private JLabel labelWebPage;
    private JLabel labelWebPageRemark;
    private JLabel labelWidth;
    private JLabel labelWorkDir;
    private JPanel mainPanel;
    private JPanel panelRunAsChoices;
    private JRadioButton radioButtonBE;
    private JRadioButton radioButtonSA;
    private JRadioButton radioButtonWS;
    private JTextField textFieldAppClass;
    private JTextField textFieldHeight;
    private JTextField textFieldParams;
    private JTextField textFieldPreloader;
    private JTextField textFieldVMOptions;
    private JTextField textFieldWebPage;
    private JTextField textFieldWidth;
    private JTextField textFieldWorkDir;

    public JFXRunPanel(JFXProjectProperties props) {
        this.jfxProps = props;
        this.initComponents();
        this.project = this.jfxProps.getProject();
        this.evaluator = this.jfxProps.getEvaluator();
        this.configs = this.jfxProps.getRunConfigs();
        this.data = new JTextField[]{this.textFieldAppClass, this.textFieldVMOptions, this.textFieldWebPage, this.textFieldHeight, this.textFieldWidth, this.textFieldWorkDir};
        this.dataLabels = new JLabel[]{this.labelAppClass, this.labelVMOptions, this.labelWebPage, this.labelHeight, this.labelWidth, this.labelWorkDir};
        this.keys = new String[]{"javafx.main.class", "run.jvmargs", "javafx.run.htmltemplate", "javafx.run.height", "javafx.run.width", "work.dir"};
        assert (this.data.length == this.keys.length);
        for (int i = 0; i < this.data.length; ++i) {
            final JTextField field = this.data[i];
            final String prop = this.keys[i];
            final JLabel label = this.dataLabels[i];
            field.getDocument().addDocumentListener(new DocumentListener(){
                Font basefont;
                Font emphfont;
                {
                    this.basefont = label != null ? label.getFont() : null;
                    this.emphfont = this.basefont != null ? this.basefont.deriveFont(2) : null;
                    this.updateFont();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changed();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changed();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                void changed() {
                    String v;
                    String config = (String)JFXRunPanel.this.comboConfig.getSelectedItem();
                    if (config.length() == 0) {
                        config = null;
                    }
                    if ((v = field.getText()) != null && config != null && v.equals(((Map)JFXRunPanel.this.configs.get(null)).get(prop))) {
                        v = null;
                    }
                    ((Map)JFXRunPanel.this.configs.get(config)).put(prop, v);
                    this.updateFont();
                }

                void updateFont() {
                    String v = field.getText();
                    String config = (String)JFXRunPanel.this.comboConfig.getSelectedItem();
                    if (config.length() == 0) {
                        config = null;
                    }
                    String def = (String)((Map)JFXRunPanel.this.configs.get(null)).get(prop);
                    if (label != null) {
                        label.setFont(config != null && !Utilities.compareObjects((Object)(v != null ? v : ""), (Object)(def != null ? def : "")) ? this.emphfont : this.basefont);
                    }
                }
            });
        }
        this.jfxProps.getPreloaderClassModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(final ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean preloaderClassAvailable;
                        String config = (String)JFXRunPanel.this.comboConfig.getSelectedItem();
                        if (config.length() == 0) {
                            config = null;
                        }
                        Map activeConfig = (Map)JFXRunPanel.this.configs.get(config);
                        boolean preloaderEnabled = JFXProjectProperties.isTrue((String)activeConfig.get("javafx.preloader.enabled"));
                        boolean bl = preloaderClassAvailable = e != null;
                        if (!preloaderClassAvailable) {
                            activeConfig.put("javafx.preloader.enabled", "false");
                        }
                        JFXRunPanel.this.checkBoxPreloader.setSelected(preloaderEnabled && preloaderClassAvailable);
                        JFXRunPanel.this.checkBoxPreloader.setEnabled(preloaderClassAvailable);
                        JFXRunPanel.this.textFieldPreloader.setEnabled(preloaderClassAvailable);
                        JFXRunPanel.this.labelPreloaderClass.setEnabled(preloaderClassAvailable);
                        JFXRunPanel.this.comboBoxPreloaderClass.setEnabled(preloaderClassAvailable);
                        JFXRunPanel.this.setEmphasized(JFXRunPanel.this.checkBoxPreloader, JFXRunPanel.this.preloaderConfigChanged(config));
                        String sel = (String)JFXRunPanel.this.comboBoxPreloaderClass.getSelectedItem();
                        JFXRunPanel.this.setEmphasized(JFXRunPanel.this.labelPreloaderClass, !JFXProjectProperties.isEqual(sel, (String)((Map)JFXRunPanel.this.configs.get(null)).get("javafx.preloader.class")));
                    }
                });
            }
        });
        this.comboConfig.setRenderer(new ConfigListCellRenderer());
        this.buttonAppClass.addActionListener(new MainClassListener(this.project, this.evaluator));
        this.comboBoxPreloaderClass.setModel(this.jfxProps.getPreloaderClassModel());
        this.setupWebBrowsersCombo();
        this.configChanged(this.jfxProps.getActiveConfig());
    }

    void setEmphasized(Component label, boolean emphasized) {
        Font basefont = label.getFont();
        if (emphasized) {
            label.setFont(basefont.deriveFont(2));
        } else {
            label.setFont(basefont.deriveFont(0));
        }
    }

    private void initComponents() {
        this.buttonGroupRunAs = new ButtonGroup();
        this.configPanel = new JPanel();
        this.labelConfig = new JLabel();
        this.comboConfig = new JComboBox();
        this.buttonNew = new JButton();
        this.buttonDelete = new JButton();
        this.jSeparator1 = new JSeparator();
        this.mainPanel = new JPanel();
        this.labelAppClass = new JLabel();
        this.textFieldAppClass = new JTextField();
        this.buttonAppClass = new JButton();
        this.labelParams = new JLabel();
        this.textFieldParams = new JTextField();
        this.buttonParams = new JButton();
        this.labelVMOptions = new JLabel();
        this.textFieldVMOptions = new JTextField();
        this.labelVMOptionsRemark = new JLabel();
        this.checkBoxPreloader = new JCheckBox();
        this.textFieldPreloader = new JTextField();
        this.buttonPreloader = new JButton();
        this.labelPreloaderClass = new JLabel();
        this.comboBoxPreloaderClass = new JComboBox();
        this.jSeparator2 = new JSeparator();
        this.labelRunAs = new JLabel();
        this.panelRunAsChoices = new JPanel();
        this.radioButtonSA = new JRadioButton();
        this.filler2 = new Box.Filler(new Dimension(99, 0), new Dimension(99, 0), new Dimension(99, Short.MAX_VALUE));
        this.radioButtonWS = new JRadioButton();
        this.filler3 = new Box.Filler(new Dimension(109, 0), new Dimension(109, 0), new Dimension(109, Short.MAX_VALUE));
        this.radioButtonBE = new JRadioButton();
        this.filler4 = new Box.Filler(new Dimension(95, 0), new Dimension(95, 0), new Dimension(95, Short.MAX_VALUE));
        this.labelSAProps = new JLabel();
        this.labelWorkDir = new JLabel();
        this.textFieldWorkDir = new JTextField();
        this.buttonWorkDir = new JButton();
        this.labelWSBAProps = new JLabel();
        this.labelWidth = new JLabel();
        this.textFieldWidth = new JTextField();
        this.labelHeight = new JLabel();
        this.textFieldHeight = new JTextField();
        this.labelWebPage = new JLabel();
        this.textFieldWebPage = new JTextField();
        this.buttonWebPage = new JButton();
        this.labelWebPageRemark = new JLabel();
        this.labelWebBrowser = new JLabel();
        this.comboBoxWebBrowser = new JComboBox();
        this.buttonWebBrowser = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setLayout(new GridBagLayout());
        this.configPanel.setLayout(new GridBagLayout());
        this.labelConfig.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelConfig.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.configPanel.add((Component)this.labelConfig, gridBagConstraints);
        this.comboConfig.setModel(new DefaultComboBoxModel<String>(new String[]{"<default config>"}));
        this.comboConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.comboConfigActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.configPanel.add((Component)this.comboConfig, gridBagConstraints);
        this.buttonNew.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.buttonNew.text"));
        this.buttonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.buttonNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 768;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.configPanel.add((Component)this.buttonNew, gridBagConstraints);
        this.buttonDelete.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.buttonDelete.text"));
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.buttonDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 768;
        this.configPanel.add((Component)this.buttonDelete, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.configPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.mainPanel.setLayout(new GridBagLayout());
        this.labelAppClass.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelAppClass.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.mainPanel.add((Component)this.labelAppClass, gridBagConstraints);
        this.textFieldAppClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.textFieldAppClassActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 20, 0);
        this.mainPanel.add((Component)this.textFieldAppClass, gridBagConstraints);
        this.buttonAppClass.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.buttonAppClass.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 768;
        gridBagConstraints.insets = new Insets(0, 5, 20, 0);
        this.mainPanel.add((Component)this.buttonAppClass, gridBagConstraints);
        this.labelParams.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelParams.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.labelParams, gridBagConstraints);
        this.textFieldParams.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mainPanel.add((Component)this.textFieldParams, gridBagConstraints);
        this.buttonParams.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.buttonParams.text"));
        this.buttonParams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.buttonParamsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mainPanel.add((Component)this.buttonParams, gridBagConstraints);
        this.labelVMOptions.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelVMOptions.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 512;
        this.mainPanel.add((Component)this.labelVMOptions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.mainPanel.add((Component)this.textFieldVMOptions, gridBagConstraints);
        this.labelVMOptionsRemark.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelVMOptionsRemark.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.mainPanel.add((Component)this.labelVMOptionsRemark, gridBagConstraints);
        this.checkBoxPreloader.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.checkBoxPreloader.text"));
        this.checkBoxPreloader.setEnabled(false);
        this.checkBoxPreloader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.checkBoxPreloaderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.checkBoxPreloader, gridBagConstraints);
        this.textFieldPreloader.setEditable(false);
        this.textFieldPreloader.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mainPanel.add((Component)this.textFieldPreloader, gridBagConstraints);
        this.buttonPreloader.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.buttonPreloader.text"));
        this.buttonPreloader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.buttonPreloaderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mainPanel.add((Component)this.buttonPreloader, gridBagConstraints);
        this.labelPreloaderClass.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelPreloaderClass.text"));
        this.labelPreloaderClass.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 768;
        this.mainPanel.add((Component)this.labelPreloaderClass, gridBagConstraints);
        this.comboBoxPreloaderClass.setEnabled(false);
        this.comboBoxPreloaderClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.comboBoxPreloaderClassActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.mainPanel.add((Component)this.comboBoxPreloaderClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.mainPanel.add((Component)this.jSeparator2, gridBagConstraints);
        this.labelRunAs.setFont(this.labelRunAs.getFont().deriveFont(this.labelRunAs.getFont().getStyle() | 1));
        this.labelRunAs.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelRunAs.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.mainPanel.add((Component)this.labelRunAs, gridBagConstraints);
        this.panelRunAsChoices.setLayout(new GridBagLayout());
        this.buttonGroupRunAs.add(this.radioButtonSA);
        this.radioButtonSA.setFont(this.radioButtonSA.getFont().deriveFont(this.radioButtonSA.getFont().getStyle() | 1));
        this.radioButtonSA.setSelected(true);
        this.radioButtonSA.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.radioButtonSA.text"));
        this.radioButtonSA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.radioButtonSAActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.panelRunAsChoices.add((Component)this.radioButtonSA, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panelRunAsChoices.add((Component)this.filler2, gridBagConstraints);
        this.buttonGroupRunAs.add(this.radioButtonWS);
        this.radioButtonWS.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.radioButtonWS.text"));
        this.radioButtonWS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.radioButtonWSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.panelRunAsChoices.add((Component)this.radioButtonWS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.panelRunAsChoices.add((Component)this.filler3, gridBagConstraints);
        this.buttonGroupRunAs.add(this.radioButtonBE);
        this.radioButtonBE.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.radioButtonBE.text"));
        this.radioButtonBE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.radioButtonBEActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.panelRunAsChoices.add((Component)this.radioButtonBE, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.panelRunAsChoices.add((Component)this.filler4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.mainPanel.add((Component)this.panelRunAsChoices, gridBagConstraints);
        this.labelSAProps.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelSAProps.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.labelSAProps, gridBagConstraints);
        this.labelWorkDir.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelWorkDir.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 15, 20, 0);
        this.mainPanel.add((Component)this.labelWorkDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 20, 0);
        this.mainPanel.add((Component)this.textFieldWorkDir, gridBagConstraints);
        this.buttonWorkDir.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.buttonWorkDir.text"));
        this.buttonWorkDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.buttonWorkDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.insets = new Insets(0, 5, 20, 0);
        this.mainPanel.add((Component)this.buttonWorkDir, gridBagConstraints);
        this.labelWSBAProps.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelWSBAProps.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.labelWSBAProps, gridBagConstraints);
        this.labelWidth.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelWidth.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 15, 5, 0);
        this.mainPanel.add((Component)this.labelWidth, gridBagConstraints);
        this.textFieldWidth.setMinimumSize(new Dimension(70, 20));
        this.textFieldWidth.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mainPanel.add((Component)this.textFieldWidth, gridBagConstraints);
        this.labelHeight.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelHeight.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 20, 5, 0);
        this.mainPanel.add((Component)this.labelHeight, gridBagConstraints);
        this.textFieldHeight.setMinimumSize(new Dimension(70, 20));
        this.textFieldHeight.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mainPanel.add((Component)this.textFieldHeight, gridBagConstraints);
        this.labelWebPage.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelWebPage.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.mainPanel.add((Component)this.labelWebPage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.mainPanel.add((Component)this.textFieldWebPage, gridBagConstraints);
        this.buttonWebPage.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.buttonWebPage.text"));
        this.buttonWebPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.buttonWebPageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.mainPanel.add((Component)this.buttonWebPage, gridBagConstraints);
        this.labelWebPageRemark.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelWebPageRemark.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.mainPanel.add((Component)this.labelWebPageRemark, gridBagConstraints);
        this.labelWebBrowser.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.labelWebBrowser.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 15, 5, 0);
        this.mainPanel.add((Component)this.labelWebBrowser, gridBagConstraints);
        this.comboBoxWebBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.comboBoxWebBrowserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mainPanel.add((Component)this.comboBoxWebBrowser, gridBagConstraints);
        this.buttonWebBrowser.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXRunPanel.buttonWebBrowser.text"));
        this.buttonWebBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXRunPanel.this.buttonWebBrowserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mainPanel.add((Component)this.buttonWebBrowser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        this.add((Component)this.mainPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private void textFieldAppClassActionPerformed(ActionEvent evt) {
    }

    private void buttonDeleteActionPerformed(ActionEvent evt) {
        String config = (String)this.comboConfig.getSelectedItem();
        assert (config != null);
        this.configs.put(config, null);
        this.configChanged(null);
        this.jfxProps.setActiveConfig(null);
    }

    private void comboConfigActionPerformed(ActionEvent evt) {
        String config = (String)this.comboConfig.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        this.configChanged(config);
        this.jfxProps.setActiveConfig(config);
    }

    private void buttonNewActionPerformed(ActionEvent evt) {
        NotifyDescriptor.InputLine d = new NotifyDescriptor.InputLine(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXConfigurationProvider.input.prompt"), NbBundle.getMessage(JFXRunPanel.class, (String)"JFXConfigurationProvider.input.title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String name = d.getInputText();
        String config = name.replaceAll("[^a-zA-Z0-9_.-]", "_");
        if (config.trim().length() == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFXRunPanel.class, (String)"JFXConfigurationProvider.input.empty", (Object)config), 2));
            return;
        }
        if (this.configs.get(config) != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFXRunPanel.class, (String)"JFXConfigurationProvider.input.duplicate", (Object)config), 2));
            return;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        if (!name.equals(config)) {
            m.put("$label", name);
        }
        this.configs.put(config, m);
        this.configChanged(config);
        this.jfxProps.setActiveConfig(config);
    }

    private void buttonWorkDirActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(null);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        String workDir = this.textFieldWorkDir.getText();
        if (workDir.equals("")) {
            workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getAbsolutePath();
        }
        chooser.setSelectedFile(new File(workDir));
        chooser.setDialogTitle(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXConfigurationProvider_Run_Working_Directory_Browse_Title"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.textFieldWorkDir.setText(file.getAbsolutePath());
        }
    }

    private void radioButtonWSActionPerformed(ActionEvent evt) {
        this.runTypeChanged(JFXProjectProperties.RunAsType.ASWEBSTART);
    }

    private void radioButtonSAActionPerformed(ActionEvent evt) {
        this.runTypeChanged(JFXProjectProperties.RunAsType.STANDALONE);
    }

    private void radioButtonBEActionPerformed(ActionEvent evt) {
        this.runTypeChanged(JFXProjectProperties.RunAsType.INBROWSER);
    }

    void runTypeChanged(JFXProjectProperties.RunAsType runType) {
        String v;
        String config = (String)this.comboConfig.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        if ((v = runType.getString()) != null && config != null && v.equals(this.configs.get(null).get("javafx.run.as"))) {
            v = null;
        }
        this.configs.get(config).put("javafx.run.as", v);
        Font basefont = this.radioButtonWS.getFont();
        Font plainfont = basefont.deriveFont(0);
        Font boldfont = basefont.deriveFont(1);
        if (runType == JFXProjectProperties.RunAsType.STANDALONE) {
            this.radioButtonSA.setFont(boldfont);
            this.radioButtonSA.setSelected(true);
        } else {
            this.radioButtonSA.setFont(plainfont);
        }
        if (runType == JFXProjectProperties.RunAsType.ASWEBSTART) {
            this.radioButtonWS.setFont(boldfont);
            this.radioButtonWS.setSelected(true);
        } else {
            this.radioButtonWS.setFont(plainfont);
        }
        if (runType == JFXProjectProperties.RunAsType.INBROWSER) {
            this.radioButtonBE.setFont(boldfont);
            this.radioButtonBE.setSelected(true);
        } else {
            this.radioButtonBE.setFont(plainfont);
        }
    }

    private void buttonWebPageActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(null);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new HtmlFileFilter());
        if (this.lastHtmlFolder != null) {
            chooser.setSelectedFile(this.lastHtmlFolder);
        }
        chooser.setDialogTitle(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"LBL_Select_HTML_File"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.textFieldWebPage.setText(file.getAbsolutePath());
            this.lastHtmlFolder = file.getParentFile();
        }
    }

    private void buttonParamsActionPerformed(ActionEvent evt) {
        List<Map<String, String>> origProps = this.jfxProps.getActiveAppParameters();
        List<Map<String, String>> props = this.copyList(origProps);
        JFXProjectProperties.PropertiesTableModel appParametersTableModel = new JFXProjectProperties.PropertiesTableModel(props, JFXProjectProperties.APP_PARAM_SUFFIXES, appParamsColumnNames);
        JFXApplicationParametersPanel panel = new JFXApplicationParametersPanel(appParametersTableModel);
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, NbBundle.getMessage(JFXRunPanel.class, (String)"TITLE_ApplicationParameters"), true, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.setVisible(true);
        if (dialogDesc.getValue() == DialogDescriptor.OK_OPTION) {
            this.jfxProps.setActiveAppParameters(props);
            String paramString = this.getParamsString(props);
            this.textFieldParams.setText(paramString);
            this.setEmphasized(this.labelParams, !JFXProjectProperties.isEqual(paramString, this.getParamsString(this.jfxProps.getActiveAppParameters(null))));
        }
        dialog.dispose();
    }

    private void checkBoxPreloaderActionPerformed(ActionEvent evt) {
        boolean sel = this.checkBoxPreloader.isSelected();
        this.textFieldPreloader.setEnabled(sel);
        this.labelPreloaderClass.setEnabled(sel);
        this.comboBoxPreloaderClass.setEnabled(sel);
        String config = (String)this.comboConfig.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        this.configs.get(config).put("javafx.preloader.enabled", sel ? "true" : "false");
        this.setEmphasized(this.checkBoxPreloader, this.preloaderConfigChanged(config));
    }

    private void buttonPreloaderActionPerformed(ActionEvent evt) {
        File file;
        JFXPreloaderChooserWizard wizard = new JFXPreloaderChooserWizard();
        if (wizard.show() && (file = wizard.getSelectedSource()) != null) {
            String config = (String)this.comboConfig.getSelectedItem();
            if (config.length() == 0) {
                config = null;
            }
            Map<String, String> activeConfig = this.configs.get(config);
            this.textFieldPreloader.setText(file.getAbsolutePath());
            if (wizard.getSourceType() == JFXProjectProperties.PreloaderSourceType.PROJECT) {
                activeConfig.put("javafx.preloader.project.path", file.getAbsolutePath());
                activeConfig.put("javafx.preloader.type", JFXProjectProperties.PreloaderSourceType.PROJECT.getString());
                activeConfig.put("javafx.preloader.jar.path", "${dist.dir}" + File.separatorChar + "lib" + File.separatorChar + file.getName() + ".jar");
                activeConfig.put("javafx.preloader.jar.filename", file.getName() + ".jar");
            } else if (wizard.getSourceType() == JFXProjectProperties.PreloaderSourceType.JAR) {
                activeConfig.put("javafx.preloader.project.path", "");
                activeConfig.put("javafx.preloader.type", JFXProjectProperties.PreloaderSourceType.JAR.getString());
                activeConfig.put("javafx.preloader.jar.path", file.getAbsolutePath());
                activeConfig.put("javafx.preloader.jar.filename", file.getName());
            }
            activeConfig.put("javafx.preloader.enabled", "true");
            this.fillPreloaderCombo(file, wizard.getSourceType(), null, activeConfig);
        }
    }

    private void fillPreloaderCombo(File file, JFXProjectProperties.PreloaderSourceType type, String select, Map<String, String> config) {
        FileObject fileObj = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObj != null) {
            if (type == JFXProjectProperties.PreloaderSourceType.PROJECT) {
                try {
                    Project foundProject = ProjectManager.getDefault().findProject(fileObj);
                    if (foundProject != null) {
                        this.jfxProps.getPreloaderClassModel().fillFromProject(foundProject, select, config);
                    }
                }
                catch (IOException ex) {}
            } else if (type == JFXProjectProperties.PreloaderSourceType.JAR) {
                this.jfxProps.getPreloaderClassModel().fillFromJAR(fileObj, select, config);
            }
        }
    }

    private void buttonWebBrowserActionPerformed(ActionEvent evt) {
        Object old = this.comboBoxWebBrowser.getSelectedItem();
        OptionsDisplayer.getDefault().open("General");
        this.comboBoxWebBrowser.setSelectedItem(old);
        String config = (String)this.comboConfig.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        String sel = (String)this.comboBoxWebBrowser.getSelectedItem();
        this.configs.get(config).put("javafx.run.inbrowser", sel);
    }

    private void comboBoxPreloaderClassActionPerformed(ActionEvent evt) {
        String sel;
        String config = (String)this.comboConfig.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        if ((sel = (String)this.comboBoxPreloaderClass.getSelectedItem()) != null && sel.equalsIgnoreCase(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"))) {
            sel = null;
        }
        this.configs.get(config).put("javafx.preloader.class", sel);
        this.setEmphasized(this.labelPreloaderClass, !JFXProjectProperties.isEqual(sel, this.configs.get(null).get("javafx.preloader.class")));
    }

    private void comboBoxWebBrowserActionPerformed(ActionEvent evt) {
        String config = (String)this.comboConfig.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        String sel = (String)this.comboBoxWebBrowser.getSelectedItem();
        this.configs.get(config).put("javafx.run.inbrowser", sel);
        this.setEmphasized(this.labelWebBrowser, !JFXProjectProperties.isEqual(sel, this.configs.get(null).get("javafx.run.inbrowser")));
    }

    private List<Map<String, String>> copyList(List<Map<String, String>> list2Copy) {
        ArrayList<Map<String, String>> list2Return = new ArrayList<Map<String, String>>();
        if (list2Copy != null) {
            for (Map<String, String> map : list2Copy) {
                HashMap<String, String> newMap = new HashMap<String, String>();
                for (String key : map.keySet()) {
                    String value = map.get(key);
                    newMap.put(key, value);
                }
                list2Return.add(newMap);
            }
        }
        return list2Return;
    }

    private String getParamsString(List<Map<String, String>> props) {
        String s = new String();
        if (props != null) {
            for (Map<String, String> m : props) {
                if (s.length() > 0) {
                    s = s + ", ";
                }
                int suffixIdx = 0;
                for (String propName : JFXProjectProperties.APP_PARAM_SUFFIXES) {
                    if (m.get(propName) == null || m.get(propName).isEmpty()) continue;
                    if (suffixIdx > 0) {
                        s = s + "=";
                    }
                    s = s + m.get(propName);
                    ++suffixIdx;
                }
            }
        }
        return s;
    }

    private void configChanged(String activeConfig) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        TreeSet<String> alphaConfigs = new TreeSet<String>(new Comparator<String>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(String s1, String s2) {
                return this.coll.compare(this.label(s1), this.label(s2));
            }

            private String label(String c) {
                Map m = (Map)JFXRunPanel.this.configs.get(c);
                String label = (String)m.get("$label");
                return label != null ? label : c;
            }
        });
        for (Map.Entry<String, Map<String, String>> entry : this.configs.entrySet()) {
            String config = entry.getKey();
            if (config == null || entry.getValue() == null) continue;
            alphaConfigs.add(config);
        }
        for (String c : alphaConfigs) {
            model.addElement(c);
        }
        this.comboConfig.setModel(model);
        this.comboConfig.setSelectedItem(activeConfig != null ? activeConfig : "");
        Map<String, String> m = this.configs.get(activeConfig);
        Map<String, String> def = this.configs.get(null);
        if (m != null) {
            for (int i = 0; i < this.data.length; ++i) {
                String v = m.get(this.keys[i]);
                if (v == null) {
                    v = def.get(this.keys[i]);
                }
                this.data[i].setText(v);
            }
            String preloaderEnabled = m.get("javafx.preloader.enabled");
            this.preloaderSelectionChanged(preloaderEnabled, m.get("javafx.preloader.project.path"), m.get("javafx.preloader.jar.path"), m.get("javafx.preloader.jar.filename"), m.get("javafx.preloader.class"), m);
            String runType = m.get("javafx.run.as");
            if (runType == null) {
                this.runTypeChanged(JFXProjectProperties.RunAsType.STANDALONE);
            } else if (runType.equals(JFXProjectProperties.RunAsType.ASWEBSTART.getString())) {
                this.runTypeChanged(JFXProjectProperties.RunAsType.ASWEBSTART);
            } else if (runType.equals(JFXProjectProperties.RunAsType.INBROWSER.getString())) {
                this.runTypeChanged(JFXProjectProperties.RunAsType.INBROWSER);
            } else {
                this.runTypeChanged(JFXProjectProperties.RunAsType.STANDALONE);
            }
            String paramString = this.getParamsString(this.jfxProps.getActiveAppParameters(activeConfig));
            this.textFieldParams.setText(paramString);
            this.setEmphasized(this.labelParams, !JFXProjectProperties.isEqual(paramString, this.getParamsString(this.jfxProps.getActiveAppParameters(null))));
            this.setEmphasized(this.checkBoxPreloader, this.preloaderConfigChanged(activeConfig));
            this.setEmphasized(this.labelPreloaderClass, !JFXProjectProperties.isEqual(m.get("javafx.preloader.class"), def.get("javafx.preloader.class")));
            this.browserSelectionChanged(activeConfig, m.get("javafx.run.inbrowser"));
        }
        this.buttonDelete.setEnabled(activeConfig != null);
    }

    private void browserSelectionChanged(String config, String browser) {
        if (browser != null) {
            this.comboBoxWebBrowser.setSelectedItem(browser);
            this.setEmphasized(this.labelWebBrowser, !JFXProjectProperties.isEqual(this.configs.get(config).get("javafx.run.inbrowser"), this.configs.get(null).get("javafx.run.inbrowser")));
        }
    }

    private void preloaderSelectionChanged(String enabled, String projectDir, String jarFilePath, String jarFileName, String cls, Map<String, String> config) {
        this.checkBoxPreloader.setSelected(JFXProjectProperties.isTrue(enabled));
        if (projectDir != null && !projectDir.isEmpty()) {
            File proj = new File(projectDir);
            if (!proj.exists() || !proj.isDirectory()) {
                this.textFieldPreloader.setText("");
                this.jfxProps.getPreloaderClassModel().fillNoPreloaderAvailable();
            } else {
                this.textFieldPreloader.setText(projectDir);
                this.fillPreloaderCombo(proj, JFXProjectProperties.PreloaderSourceType.PROJECT, cls, config);
            }
            return;
        }
        if (jarFilePath != null && jarFileName != null) {
            File jar = new File(jarFilePath);
            if (!jar.exists() || !jar.isFile()) {
                this.textFieldPreloader.setText("");
                this.jfxProps.getPreloaderClassModel().fillNoPreloaderAvailable();
            } else {
                this.textFieldPreloader.setText(jarFilePath);
                this.fillPreloaderCombo(jar, JFXProjectProperties.PreloaderSourceType.JAR, cls, config);
            }
            return;
        }
        this.textFieldPreloader.setText("");
        this.jfxProps.getPreloaderClassModel().fillNoPreloaderAvailable();
        config.put("javafx.preloader.enabled", "false");
        this.checkBoxPreloader.setSelected(false);
        this.checkBoxPreloader.setEnabled(false);
        this.textFieldPreloader.setEnabled(false);
        this.labelPreloaderClass.setEnabled(false);
        this.comboBoxPreloaderClass.setEnabled(false);
    }

    private boolean preloaderConfigChanged(String config) {
        return JFXProjectProperties.isTrue(this.configs.get(config).get("javafx.preloader.enabled")) != JFXProjectProperties.isTrue(this.configs.get(null).get("javafx.preloader.enabled")) || !JFXProjectProperties.isEqualIgnoreCase(this.configs.get(config).get("javafx.preloader.project.path"), this.configs.get(null).get("javafx.preloader.project.path")) || !JFXProjectProperties.isEqualIgnoreCase(this.configs.get(config).get("javafx.preloader.jar.path"), this.configs.get(null).get("javafx.preloader.jar.path")) || !JFXProjectProperties.isEqualIgnoreCase(this.configs.get(config).get("javafx.preloader.jar.filename"), this.configs.get(null).get("javafx.preloader.jar.filename"));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JFXRunPanel.class);
    }

    public void resultChanged(LookupEvent ev) {
        final ArrayList<String> list = new ArrayList<String>(6);
        for (Lookup.Item i : this.lookupResult.allItems()) {
            list.add(i.getDisplayName());
        }
        String config = this.jfxProps.getActiveConfig();
        final String sel = this.configs.get(config).get("javafx.run.inbrowser");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFXRunPanel.this.fillWebBrowsersCombo(list, sel);
            }
        });
    }

    private void setupWebBrowsersCombo() {
        this.lookupResult = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);
        this.resultChanged(null);
        this.lookupResult.addLookupListener((LookupListener)this);
    }

    private void fillWebBrowsersCombo(List<String> list, String select) {
        FileObject fo = FileUtil.getConfigFile((String)BROWSERS_FOLDER);
        if (fo != null) {
            DataFolder folder = DataFolder.findFolder((FileObject)fo);
            DataObject[] dobjs = folder.getChildren();
            for (int i = 0; i < dobjs.length; ++i) {
                if (!Boolean.TRUE.equals(dobjs[i].getPrimaryFile().getAttribute(EA_HIDDEN)) && dobjs[i].getCookie(InstanceCookie.class) != null) continue;
                FileObject fo2 = dobjs[i].getPrimaryFile();
                String n = fo2.getName();
                try {
                    n = fo2.getFileSystem().getStatus().annotateName(n, dobjs[i].files());
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
                list.remove(n);
            }
        }
        this.comboBoxWebBrowser.removeAllItems();
        if (!list.isEmpty()) {
            for (String tag : list) {
                this.comboBoxWebBrowser.addItem(tag);
            }
            if (select != null) {
                this.comboBoxWebBrowser.setSelectedItem(select);
            }
            this.labelWebBrowser.setEnabled(true);
            this.comboBoxWebBrowser.setEnabled(true);
            this.jSeparator2.setEnabled(true);
        } else {
            this.labelWebBrowser.setEnabled(false);
            this.comboBoxWebBrowser.setEnabled(false);
            this.jSeparator2.setEnabled(false);
        }
    }

    private static class HtmlFileFilter
    extends FileFilter {
        private HtmlFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            String ext;
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            return index > 0 && index < name.length() - 1 && ("htm".equals(ext = name.substring(index + 1).toLowerCase()) || "html".equals(ext));
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(JFXRunPanel.class, (String)"MSG_HtmlFileFilter_Description");
        }
    }

    private final class ConfigListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ConfigListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            this.setName("ComboBox.listRenderer");
            String config = (String)value;
            if (config == null) {
                label = null;
            } else if (config.length() > 0) {
                Map m = (Map)JFXRunPanel.this.configs.get(config);
                String string = label = m != null ? (String)m.get("$label") : null;
                if (label == null) {
                    label = config;
                }
            } else {
                label = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.default.label");
            }
            this.setText(label);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private class MainClassListener
    implements ActionListener {
        private final JButton okButton;
        private final PropertyEvaluator evaluator;
        private final Project project;

        MainClassListener(@NonNull Project p, PropertyEvaluator pe) {
            this.evaluator = pe;
            this.project = p;
            this.okButton = new JButton(NbBundle.getMessage(JFXRunPanel.class, (String)"LBL_ChooseMainClass_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXRunPanel.class, (String)"AD_ChooseMainClass_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final JFXApplicationClassChooser panel = new JFXApplicationClassChooser(this.project, this.evaluator);
            Object[] options = new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION};
            panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                        MainClassListener.this.okButton.doClick();
                    } else {
                        MainClassListener.this.okButton.setEnabled(panel.getSelectedClass() != null);
                    }
                }
            });
            this.okButton.setEnabled(false);
            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(JFXRunPanel.class, (String)"LBL_ChooseMainClass_Title"), true, options, options[0], 0, null, null);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.setVisible(true);
            if (desc.getValue() == options[0]) {
                JFXRunPanel.this.textFieldAppClass.setText(panel.getSelectedClass());
            }
            dlg.dispose();
        }
    }
}

