/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.JavaFXProjectWizardIterator;
import org.netbeans.modules.javafx2.project.PanelConfigureProject;
import org.netbeans.modules.javafx2.project.SettingsPanel;
import org.netbeans.modules.javafx2.project.WizardSettings;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class PanelOptionsVisual
extends SettingsPanel
implements TaskListener,
PropertyChangeListener,
DocumentListener {
    private static boolean lastMainClassCheck = true;
    public static final String SHARED_LIBRARIES = "sharedLibraries";
    private volatile RequestProcessor.Task task;
    private DetectPlatformTask detectPlatformTask;
    private final JavaFXProjectWizardIterator.WizardType type;
    private PanelConfigureProject panel;
    private ComboBoxModel platformsModel;
    private ListCellRenderer platformsCellRenderer;
    private JavaPlatformChangeListener jpcl;
    private String currentLibrariesLocation;
    private String projectLocation;
    private boolean isMainClassValid;
    private boolean isPreloaderNameValid;
    private JButton btnLibFolder;
    private JButton btnManagePlatforms;
    private JCheckBox cbSharable;
    private JCheckBox createMainCheckBox;
    private JSeparator jSeparator1;
    private JLabel lblHint;
    private JLabel lblLibFolder;
    private JLabel lblPlatform;
    private JLabel lblPreloaderProject;
    private JTextField mainClassTextField;
    private JComboBox platformComboBox;
    private JCheckBox preloaderCheckBox;
    private JCheckBox setAsMainCheckBox;
    private JTextField txtLibFolder;
    private JTextField txtPreloaderProject;

    PanelOptionsVisual(PanelConfigureProject panel, JavaFXProjectWizardIterator.WizardType type) {
        this.panel = panel;
        this.type = type;
        this.detectPlatformTask = new DetectPlatformTask();
        this.preInitComponents();
        this.initComponents();
        this.postInitComponents();
    }

    private void preInitComponents() {
        this.platformsModel = PlatformUiSupport.createPlatformComboBoxModel((String)"default_platform");
        this.platformsCellRenderer = PlatformUiSupport.createPlatformListCellRenderer();
    }

    private void postInitComponents() {
        this.platformComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.jpcl = new JavaPlatformChangeListener();
        JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.jpcl, (Object)JavaPlatformManager.getDefault()));
        this.selectJavaFXEnabledPlatform();
        this.currentLibrariesLocation = "." + File.separatorChar + "lib";
        this.txtLibFolder.setText(this.currentLibrariesLocation);
        this.cbSharableActionPerformed(null);
        switch (this.type) {
            case LIBRARY: {
                this.setAsMainCheckBox.setVisible(false);
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
                this.preloaderCheckBox.setVisible(false);
                this.txtPreloaderProject.setVisible(false);
                break;
            }
            case APPLICATION: {
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                break;
            }
            case PRELOADER: {
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_createPrealoaderCheckBox"));
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                this.preloaderCheckBox.setVisible(false);
                this.txtPreloaderProject.setVisible(false);
                break;
            }
            case FXML: {
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                this.preloaderCheckBox.setVisible(false);
                this.txtPreloaderProject.setVisible(false);
                break;
            }
            case EXTISTING: {
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
                this.preloaderCheckBox.setVisible(false);
                this.txtPreloaderProject.setVisible(false);
            }
        }
        this.setAsMainCheckBox.setSelected(WizardSettings.getSetAsMain(this.type));
        this.mainClassTextField.getDocument().addDocumentListener(this);
        this.txtLibFolder.getDocument().addDocumentListener(this);
        this.txtPreloaderProject.getDocument().addDocumentListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propName = event.getPropertyName();
        if ("projectName".equals(propName)) {
            String projectName = (String)event.getNewValue();
            this.mainClassTextField.setText(PanelOptionsVisual.createMainClassName(projectName, this.type));
            this.txtPreloaderProject.setText(PanelOptionsVisual.createPreloaderProjectName(projectName));
        } else if ("projectLocation".equals(propName)) {
            this.projectLocation = (String)event.getNewValue();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e.getDocument());
    }

    private void documentChanged(Document doc) {
        if (this.txtLibFolder.getDocument().equals(doc)) {
            this.librariesLocationChanged();
        } else if (this.mainClassTextField.getDocument().equals(doc)) {
            this.mainClassChanged();
        } else if (this.txtPreloaderProject.getDocument().equals(doc)) {
            this.preloaderNameChanged();
        }
    }

    private static String createPreloaderProjectName(String projectName) {
        return projectName + "-Preloader";
    }

    private static String createMainClassName(String projectName, JavaFXProjectWizardIterator.WizardType type) {
        String part;
        StringBuilder pkg = new StringBuilder();
        StringBuilder main = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        boolean needsEscape = false;
        for (int i = 0; i < projectName.length(); ++i) {
            char c = projectName.charAt(i);
            if (first) {
                if (!Character.isJavaIdentifierStart(c)) {
                    if (!Character.isJavaIdentifierPart(c)) continue;
                    needsEscape = true;
                    sb.append(c);
                    first = false;
                    continue;
                }
                sb.append(c);
                first = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            if (sb.length() <= 0) continue;
            part = sb.toString();
            if (pkg.length() > 0) {
                pkg.append('.');
            }
            if (needsEscape || !Utilities.isJavaIdentifier((String)part.toLowerCase())) {
                pkg.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNamePrefix"));
            }
            pkg.append(part.toLowerCase());
            if (!needsEscape || main.length() > 0) {
                main.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
            sb = new StringBuilder();
            first = true;
            needsEscape = false;
        }
        if (sb.length() > 0) {
            part = sb.toString();
            if (pkg.length() > 0) {
                pkg.append('.');
            }
            if (needsEscape || !Utilities.isJavaIdentifier((String)part.toLowerCase())) {
                pkg.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNamePrefix"));
            }
            pkg.append(part.toLowerCase());
            if (!needsEscape || main.length() > 0) {
                main.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
        }
        if (main.length() == 0) {
            main.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)(type == JavaFXProjectWizardIterator.WizardType.PRELOADER ? "TXT_ClassNamePreloader" : "TXT_ClassName")));
        }
        return pkg.length() == 0 ? main.toString() : String.format("%s.%s", pkg.toString(), main.toString());
    }

    private JavaPlatform getSelectedPlatform() {
        Object selectedItem = this.platformComboBox.getSelectedItem();
        JavaPlatform platform = selectedItem == null ? null : PlatformUiSupport.getPlatform((Object)selectedItem);
        return platform;
    }

    private void selectJavaFXEnabledPlatform() {
        for (int i = 0; i < this.platformsModel.getSize(); ++i) {
            JavaPlatform platform = PlatformUiSupport.getPlatform(this.platformsModel.getElementAt(i));
            if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)platform)) continue;
            this.platformComboBox.setSelectedIndex(i);
            break;
        }
    }

    private void initComponents() {
        this.cbSharable = new JCheckBox();
        this.lblLibFolder = new JLabel();
        this.txtLibFolder = new JTextField();
        this.btnLibFolder = new JButton();
        this.lblHint = new JLabel();
        this.createMainCheckBox = new JCheckBox();
        this.mainClassTextField = new JTextField();
        this.setAsMainCheckBox = new JCheckBox();
        this.lblPlatform = new JLabel();
        this.platformComboBox = new JComboBox();
        this.btnManagePlatforms = new JButton();
        this.preloaderCheckBox = new JCheckBox();
        this.lblPreloaderProject = new JLabel();
        this.txtPreloaderProject = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.cbSharable.setSelected(SharableLibrariesUtils.isLastProjectSharable());
        Mnemonics.setLocalizedText((AbstractButton)this.cbSharable, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_SharableProject_Checkbox"));
        this.cbSharable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.cbSharableActionPerformed(evt);
            }
        });
        this.lblLibFolder.setLabelFor(this.txtLibFolder);
        Mnemonics.setLocalizedText((JLabel)this.lblLibFolder, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Location_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLibFolder, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Browse_Button"));
        this.btnLibFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.btnLibFolderActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"HINT_LibrariesFolder"));
        this.createMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_createMainCheckBox"));
        this.createMainCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelOptionsVisual.this.createMainCheckBoxItemStateChanged(evt);
            }
        });
        this.mainClassTextField.setText("com.myapp.Main");
        Mnemonics.setLocalizedText((AbstractButton)this.setAsMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_setAsMainCheckBox"));
        this.lblPlatform.setLabelFor(this.platformComboBox);
        Mnemonics.setLocalizedText((JLabel)this.lblPlatform, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Platform_ComboBox"));
        this.platformComboBox.setModel(this.platformsModel);
        this.platformComboBox.setRenderer(this.platformsCellRenderer);
        this.platformComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelOptionsVisual.this.platformComboBoxItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnManagePlatforms, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Manage_Button"));
        this.btnManagePlatforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.btnManagePlatformsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.preloaderCheckBox, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Preloader_Checkbox"));
        this.preloaderCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelOptionsVisual.this.preloaderCheckBoxItemStateChanged(evt);
            }
        });
        this.lblPreloaderProject.setLabelFor(this.txtPreloaderProject);
        Mnemonics.setLocalizedText((JLabel)this.lblPreloaderProject, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_PreloaderName_TextBox"));
        this.lblPreloaderProject.setEnabled(false);
        this.txtPreloaderProject.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PanelOptions_Preloader_Project_Name"));
        this.txtPreloaderProject.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.lblPreloaderProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPreloaderProject, -1, 265, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.lblPlatform).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.platformComboBox, 0, 272, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnManagePlatforms)).addGroup(layout.createSequentialGroup().addComponent(this.preloaderCheckBox).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.cbSharable).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.lblLibFolder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtLibFolder, -1, 298, Short.MAX_VALUE).addComponent(this.lblHint, -1, 298, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLibFolder, -2, 87, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.createMainCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainClassTextField, -1, 382, Short.MAX_VALUE)).addComponent(this.setAsMainCheckBox, GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 495, Short.MAX_VALUE)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPlatform).addComponent(this.platformComboBox, -2, 23, -2).addComponent(this.btnManagePlatforms)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preloaderCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPreloaderProject).addComponent(this.txtPreloaderProject, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSharable).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtLibFolder, -2, -1, -2).addComponent(this.btnLibFolder)).addComponent(this.lblLibFolder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createMainCheckBox).addComponent(this.mainClassTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setAsMainCheckBox).addContainerGap(24, Short.MAX_VALUE)));
        this.cbSharable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_sharableProject"));
        this.txtLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_LibrariesLocation"));
        this.btnLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_browseLibraries"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_createMainCheckBox"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_createMainCheckBox"));
        this.mainClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCN_mainClassTextFiled"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCD_mainClassTextFiled"));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_setAsMainCheckBox"));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_setAsMainCheckBox"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_PanelOptionsVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_PanelOptionsVisual"));
    }

    private void cbSharableActionPerformed(ActionEvent evt) {
        this.txtLibFolder.setEnabled(this.cbSharable.isSelected());
        this.btnLibFolder.setEnabled(this.cbSharable.isSelected());
        this.lblHint.setEnabled(this.cbSharable.isSelected());
        this.lblLibFolder.setEnabled(this.cbSharable.isSelected());
        if (this.cbSharable.isSelected()) {
            this.txtLibFolder.setText(this.currentLibrariesLocation);
        } else {
            this.txtLibFolder.setText("");
        }
    }

    private void btnLibFolderActionPerformed(ActionEvent evt) {
        File f = FileUtil.normalizeFile((File)new File(this.projectLocation + File.separatorChar + "project_folder"));
        String curr = SharableLibrariesUtils.browseForLibraryLocation((String)this.txtLibFolder.getText().trim(), (Component)this, (File)f);
        if (curr != null) {
            this.currentLibrariesLocation = curr;
            if (this.cbSharable.isSelected()) {
                this.txtLibFolder.setText(this.currentLibrariesLocation);
            }
        }
    }

    private void btnManagePlatformsActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.getSelectedPlatform());
    }

    private void platformComboBoxItemStateChanged(ItemEvent evt) {
        this.panel.fireChangeEvent();
    }

    private void preloaderCheckBoxItemStateChanged(ItemEvent evt) {
        this.txtPreloaderProject.setEnabled(this.preloaderCheckBox.isSelected());
    }

    private void createMainCheckBoxItemStateChanged(ItemEvent evt) {
        lastMainClassCheck = this.createMainCheckBox.isSelected();
        this.mainClassTextField.setEnabled(lastMainClassCheck);
        this.panel.fireChangeEvent();
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)this.getSelectedPlatform())) {
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.notFXPlatform"));
            return false;
        }
        if (this.cbSharable.isSelected()) {
            String location = this.txtLibFolder.getText();
            if (this.projectLocation != null) {
                if (new File(location).isAbsolute()) {
                    settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.absolutePath"));
                } else {
                    File libLoc;
                    File projectLoc = FileUtil.normalizeFile((File)new File(this.projectLocation));
                    if (!CollocationQuery.areCollocated((File)projectLoc, (File)(libLoc = PropertyUtils.resolveFile((File)projectLoc, (String)location)))) {
                        settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.relativePath"));
                    }
                }
            }
        }
        if (this.mainClassTextField.isVisible() && this.mainClassTextField.isEnabled()) {
            if (!this.isMainClassValid) {
                settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalMainClassName"));
            }
            return this.isMainClassValid;
        }
        if (this.txtPreloaderProject.isVisible() && this.txtPreloaderProject.isEnabled()) {
            if (!this.isPreloaderNameValid) {
                settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalPreloaderProjectName"));
            }
            return this.isPreloaderNameValid;
        }
        return true;
    }

    @Override
    synchronized void read(WizardDescriptor d) {
        if (this.task == null) {
            this.checkPlatforms();
        }
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    @Override
    void store(WizardDescriptor d) {
        Templates.setDefinesMainProject((WizardDescriptor)d, (boolean)this.setAsMainCheckBox.isSelected());
        WizardSettings.setSetAsMain(this.type, this.setAsMainCheckBox.isSelected());
        d.putProperty("mainClass", this.createMainCheckBox.isSelected() && this.createMainCheckBox.isVisible() ? this.mainClassTextField.getText() : null);
        d.putProperty(SHARED_LIBRARIES, this.cbSharable.isSelected() ? this.txtLibFolder.getText() : null);
        String platformName = (String)this.getSelectedPlatform().getProperties().get("platform.ant.name");
        d.putProperty("java.platform.name", (Object)platformName);
        if (this.preloaderCheckBox.isSelected()) {
            d.putProperty("preloader.name", (Object)this.txtPreloaderProject.getText());
        }
    }

    private void mainClassChanged() {
        String mainClassName = this.mainClassTextField.getText();
        StringTokenizer tk = new StringTokenizer(mainClassName, ".");
        boolean isValid = true;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (token.length() != 0 && Utilities.isJavaIdentifier((String)token)) continue;
            isValid = false;
            break;
        }
        this.isMainClassValid = isValid;
        this.panel.fireChangeEvent();
    }

    private void librariesLocationChanged() {
        this.panel.fireChangeEvent();
    }

    private void preloaderNameChanged() {
        String name = this.txtPreloaderProject.getText();
        this.isPreloaderNameValid = !JavaFXProjectWizardIterator.isIllegalProjectName(name);
        this.panel.fireChangeEvent();
    }

    private void checkPlatforms() {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
        boolean fxPlatformExists = false;
        for (JavaPlatform javaPlatform : platforms) {
            if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)javaPlatform)) continue;
            fxPlatformExists = true;
            break;
        }
        if (!fxPlatformExists) {
            if (this.task != null) {
                this.task.removeTaskListener((TaskListener)this);
            }
            this.task = RequestProcessor.getDefault().create((Runnable)this.detectPlatformTask);
            this.task.addTaskListener((TaskListener)this);
            this.task.schedule(0);
        }
    }

    public synchronized void taskFinished(Task task) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaPlatform platform = PanelOptionsVisual.this.detectPlatformTask.getPlatform();
                if (platform != null) {
                    PanelOptionsVisual.this.platformComboBox.setModel(PanelOptionsVisual.this.platformsModel);
                    PanelOptionsVisual.this.selectJavaFXEnabledPlatform();
                }
            }
        });
        this.task = null;
    }

    private class DetectPlatformTask
    implements Runnable {
        private JavaPlatform platform;

        private DetectPlatformTask() {
        }

        public JavaPlatform getPlatform() {
            return this.platform;
        }

        @Override
        public void run() {
            this.platform = JavaFXPlatformUtils.createDefaultJavaFXPlatform();
        }
    }

    private class JavaPlatformChangeListener
    implements PropertyChangeListener {
        private JavaPlatformChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PanelOptionsVisual.this.panel.fireChangeEvent();
        }
    }
}

