/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class JFXProjectUtils {
    private static Set<ClassIndex.SearchKind> kinds = new HashSet<ClassIndex.SearchKind>(Arrays.asList(ClassIndex.SearchKind.IMPLEMENTORS));
    private static Set<ClassIndex.SearchScope> scopes = new HashSet<ClassIndex.SearchScope>(Arrays.asList(ClassIndex.SearchScope.SOURCE));

    public static Map<String, List<String>> getJSCallbacks(String platformName) {
        String[][] c = new String[][]{{"onDeployError", "app", "mismatchEvent"}, {"onGetNoPluginMessage", "app"}, {"onGetSplash", "app"}, {"onInstallFinished", "placeholder", "component", "status", "relaunchNeeded"}, {"onInstallNeeded", "app", "platform", "cb", "isAutoinstall", "needRelaunch", "launchFunc"}, {"onInstallStarted", "placeholder", "component", "isAuto", "restartNeeded"}, {"onJavascriptReady", "id"}, {"onRuntimeError", "id", "code"}};
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        for (int i = 0; i < c.length; ++i) {
            String[] s = c[i];
            assert (s.length > 0);
            ArrayList<String> l = null;
            if (s.length > 1) {
                l = new ArrayList<String>();
                for (int j = 1; j < s.length; ++j) {
                    l.add(s[j]);
                }
            }
            m.put(s[0], l);
        }
        return m;
    }

    public static Map<FileObject, List<ClassPath>> getClassPathMap(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] srcGroups = sources.getSourceGroups("java");
        HashMap<FileObject, List<ClassPath>> classpathMap = new HashMap<FileObject, List<ClassPath>>();
        for (SourceGroup srcGroup : srcGroups) {
            FileObject srcRoot = srcGroup.getRootFolder();
            ClassPath bootCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/boot");
            ClassPath executeCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/execute");
            ClassPath sourceCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/source");
            ArrayList<ClassPath> cpList = new ArrayList<ClassPath>();
            if (bootCP != null) {
                cpList.add(bootCP);
            }
            if (executeCP != null) {
                cpList.add(executeCP);
            }
            if (sourceCP != null) {
                cpList.add(sourceCP);
            }
            if (cpList.size() != 3) continue;
            classpathMap.put(srcRoot, cpList);
        }
        return classpathMap;
    }

    public static Set<String> getAppClassNames(Map<FileObject, List<ClassPath>> classpathMap, final String classType) {
        final HashSet<String> appClassNames = new HashSet<String>();
        for (FileObject fo : classpathMap.keySet()) {
            List<ClassPath> paths = classpathMap.get(fo);
            ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)paths.get(0), (ClassPath)paths.get(1), (ClassPath)paths.get(2));
            final ClassIndex classIndex = cpInfo.getClassIndex();
            JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
            try {
                js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        Elements elems = controller.getElements();
                        TypeElement fxAppElement = elems.getTypeElement(classType);
                        ElementHandle appHandle = ElementHandle.create((Element)fxAppElement);
                        Set appHandles = classIndex.getElements(appHandle, kinds, scopes);
                        for (ElementHandle elemHandle : appHandles) {
                            appClassNames.add(elemHandle.getQualifiedName());
                        }
                    }

                    public void cancel() {
                    }
                }, true);
            }
            catch (Exception e) {}
        }
        return appClassNames;
    }

    public static Set<String> getAppClassNamesInJar(@NonNull FileObject jarFile, String classType) {
        JarFile jf;
        File jarF = FileUtil.toFile((FileObject)jarFile);
        if (jarF == null) {
            return null;
        }
        HashSet<String> appClassNames = new HashSet<String>();
        try {
            jf = new JarFile(jarF);
        }
        catch (IOException x) {
            return null;
        }
        Enumeration<JarEntry> entries = jf.entries();
        if (entries == null) {
            return null;
        }
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class") || entry.getName().contains("$")) continue;
            String classname = entry.getName().substring(0, entry.getName().length() - 6).replace('\\', '/').replace('/', '.');
            if (classname.startsWith(".")) {
                classname = classname.substring(1);
            }
            appClassNames.add(classname);
        }
        return appClassNames;
    }

    public static boolean isFXProject(@NonNull Project prj) {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (ep == null) {
            return false;
        }
        return JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.enabled"));
    }

    public static String getFXProjectRunAs(@NonNull Project prj) {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (ep == null) {
            return null;
        }
        return ep.evaluator().getProperty("javafx.run.as");
    }
}

