/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JavaFXProjectWizardIterator;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JFXProjectGenerator {
    private static final String loggerName = "org.netbeans.ui.metrics.j2se";
    private static final String loggerKey = "USG_PROJECT_CREATE_J2SE";
    private static SpecificationVersion defaultSourceLevel;
    private static final Pattern INVALID_NAME;

    private JFXProjectGenerator() {
    }

    static AntProjectHelper createProject(File dir, final String name, final String mainClass, final String manifestFile, final String librariesDefinition, final String platformName, final String preloader, final JavaFXProjectWizardIterator.WizardType type) throws IOException {
        Parameters.notNull((CharSequence)"dir", (Object)dir);
        Parameters.notNull((CharSequence)"name", (Object)name);
        final FileObject dirFO = FileUtil.createFolder((File)dir);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        dirFO.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                h[0] = JFXProjectGenerator.createProject(dirFO, name, "src", "test", mainClass, manifestFile, librariesDefinition, platformName, preloader, type);
                Project p = ProjectManager.getDefault().findProject(dirFO);
                JFXProjectGenerator.createJfxExtension(p, dirFO);
                ProjectManager.getDefault().saveProject(p);
                final ReferenceHelper refHelper = JFXProjectGenerator.getReferenceHelper(p);
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            JFXProjectGenerator.copyRequiredLibraries(h[0], refHelper);
                            return null;
                        }
                    });
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex.getException());
                }
                FileObject srcFolder = dirFO.createFolder("src");
                dirFO.createFolder("test");
                if (mainClass != null) {
                    JFXProjectGenerator.createFiles(mainClass, srcFolder, type);
                }
            }
        });
        return h[0];
    }

    private static ReferenceHelper getReferenceHelper(Project p) {
        try {
            return (ReferenceHelper)p.getClass().getMethod("getReferenceHelper", new Class[0]).invoke((Object)p, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static AntProjectHelper createProject(File dir, final String name, final File[] sourceFolders, final File[] testFolders, final String manifestFile, final String librariesDefinition, final String buildXmlName, final String platformName, final String preloader, final JavaFXProjectWizardIterator.WizardType type) throws IOException {
        Parameters.notNull((CharSequence)"dir", (Object)dir);
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"sourceFolders", (Object)sourceFolders);
        Parameters.notNull((CharSequence)"testFolders", (Object)testFolders);
        final FileObject dirFO = FileUtil.createFolder((File)dir);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        dirFO.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                h[0] = JFXProjectGenerator.createProject(dirFO, name, null, null, null, manifestFile, librariesDefinition, platformName, preloader, type);
                final Project p = ProjectManager.getDefault().findProject(dirFO);
                final ReferenceHelper refHelper = JFXProjectGenerator.getReferenceHelper(p);
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            Element root;
                            EditableProperties props;
                            int rootIndex;
                            String propName;
                            int i;
                            Element data = h[0].getPrimaryConfigurationData(true);
                            Document doc = data.getOwnerDocument();
                            NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
                            assert (nl.getLength() == 1);
                            Element sourceRoots = (Element)nl.item(0);
                            nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
                            assert (nl.getLength() == 1);
                            Element testRoots = (Element)nl.item(0);
                            for (i = 0; i < sourceFolders.length; ++i) {
                                if (i == 0) {
                                    propName = "src.dir";
                                } else {
                                    String name = sourceFolders[i].getName();
                                    propName = name + ".dir";
                                }
                                rootIndex = 1;
                                props = h[0].getProperties("nbproject/project.properties");
                                while (props.containsKey((Object)propName)) {
                                    propName = name + ++rootIndex + ".dir";
                                }
                                String srcReference = refHelper.createForeignFileReference(sourceFolders[i], "java");
                                root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                                root.setAttribute("id", propName);
                                sourceRoots.appendChild(root);
                                props = h[0].getProperties("nbproject/project.properties");
                                props.put(propName, srcReference);
                                h[0].putProperties("nbproject/project.properties", props);
                            }
                            for (i = 0; i < testFolders.length; ++i) {
                                if (!testFolders[i].exists()) {
                                    testFolders[i].mkdirs();
                                }
                                if (i == 0) {
                                    propName = "test.src.dir";
                                } else {
                                    String name = testFolders[i].getName();
                                    propName = "test." + name + ".dir";
                                }
                                rootIndex = 1;
                                props = h[0].getProperties("nbproject/project.properties");
                                while (props.containsKey((Object)propName)) {
                                    propName = "test." + name + ++rootIndex + ".dir";
                                }
                                String testReference = refHelper.createForeignFileReference(testFolders[i], "java");
                                root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                                root.setAttribute("id", propName);
                                testRoots.appendChild(root);
                                props = h[0].getProperties("nbproject/project.properties");
                                props.put(propName, testReference);
                                h[0].putProperties("nbproject/project.properties", props);
                            }
                            h[0].putPrimaryConfigurationData(data, true);
                            if (buildXmlName != null) {
                                EditableProperties props2 = h[0].getProperties("nbproject/project.properties");
                                props2.put("buildfile", buildXmlName);
                                h[0].putProperties("nbproject/project.properties", props2);
                            }
                            JFXProjectGenerator.createJfxExtension(p, dirFO);
                            ProjectManager.getDefault().saveProject(p);
                            JFXProjectGenerator.copyRequiredLibraries(h[0], refHelper);
                            ProjectUtils.getSources((Project)p).getSourceGroups("java");
                            return null;
                        }
                    });
                }
                catch (MutexException me) {
                    ErrorManager.getDefault().notify((Throwable)me);
                }
            }
        });
        return h[0];
    }

    static AntProjectHelper createPreloaderProject(File dir, final String name, final String librariesDefinition, final String platformName, final String preloaderClassName) throws IOException {
        Parameters.notNull((CharSequence)"dir", (Object)dir);
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"preloaderClassName", (Object)preloaderClassName);
        final FileObject dirFO = FileUtil.createFolder((File)dir);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        dirFO.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                h[0] = JFXProjectGenerator.createProject(dirFO, name, "src", "test", preloaderClassName, "manifest.mf", librariesDefinition, platformName, null, JavaFXProjectWizardIterator.WizardType.PRELOADER);
                Project p = ProjectManager.getDefault().findProject(dirFO);
                JFXProjectGenerator.createJfxExtension(p, dirFO);
                ProjectManager.getDefault().saveProject(p);
                final ReferenceHelper refHelper = JFXProjectGenerator.getReferenceHelper(p);
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            JFXProjectGenerator.copyRequiredLibraries(h[0], refHelper);
                            return null;
                        }
                    });
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex.getException());
                }
                FileObject srcFolder = dirFO.createFolder("src");
                dirFO.createFolder("test");
                JFXProjectGenerator.createPreloaderClass(preloaderClassName, srcFolder);
            }
        });
        JavaFXProjectWizardIterator.createManifest(FileUtil.toFileObject((File)dir), true);
        return h[0];
    }

    private static void createJfxExtension(Project p, FileObject dirFO) throws IOException {
        FileObject templateFO = FileUtil.getConfigFile((String)"Templates/JFX/jfx-impl.xml");
        FileObject platformFO = FileUtil.getConfigFile((String)"Templates/JFX/jfx-impl-platform.xmlinc");
        FileObject parametersFO = FileUtil.getConfigFile((String)"Templates/JFX/jfx-impl-parameters.xmlinc");
        FileObject callbacksFO = FileUtil.getConfigFile((String)"Templates/JFX/jfx-impl-callbacks.xmlinc");
        if (templateFO != null && platformFO != null && parametersFO != null && callbacksFO != null) {
            FileUtil.copyFile((FileObject)platformFO, (FileObject)dirFO.getFileObject("nbproject"), (String)"jfx-impl-platform");
            FileUtil.copyFile((FileObject)parametersFO, (FileObject)dirFO.getFileObject("nbproject"), (String)"jfx-impl-parameters");
            FileUtil.copyFile((FileObject)callbacksFO, (FileObject)dirFO.getFileObject("nbproject"), (String)"jfx-impl-callbacks");
            FileObject jfxBuildFile = FileUtil.copyFile((FileObject)templateFO, (FileObject)dirFO.getFileObject("nbproject"), (String)"jfx-impl");
            AntBuildExtender extender = (AntBuildExtender)p.getLookup().lookup(AntBuildExtender.class);
            if (extender != null) {
                assert (jfxBuildFile != null);
                if (extender.getExtension("jfx") == null) {
                    AntBuildExtender.Extension ext = extender.addExtension("jfx", jfxBuildFile);
                    ext.addDependency("-post-jar", "jfx-deployment");
                    ext.addDependency("run", "jar");
                    ext.addDependency("debug", "jar");
                    ext.addDependency("profile", "jar");
                }
            }
        }
    }

    private static AntProjectHelper createProject(FileObject dirFO, String name, String srcRoot, String testRoot, String mainClass, String manifestFile, String librariesDefinition, String platformName, String preloader, JavaFXProjectWizardIterator.WizardType type) throws IOException {
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.java.j2seproject", (String)librariesDefinition);
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        Element explicitPlatformEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "explicit-platform");
        explicitPlatformEl.setAttribute("explicit-source-supported", "true");
        data.appendChild(explicitPlatformEl);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "src.dir");
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
        if (testRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "test.src.dir");
            testRoots.appendChild(root);
            ep.setProperty("test.src.dir", testRoot);
        }
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        ep.setProperty("javafx.enabled", "true");
        ep.setComment("javafx.enabled", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_javafx")}, false);
        ep.setProperty("jnlp.enabled", "false");
        ep.setComment("jnlp.enabled", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_oldjnlp")}, false);
        ep.setProperty("compile.on.save", "true");
        ep.setProperty("compile.on.save.unsupported.javafx", "true");
        ep.setProperty("javafx.binarycss", "true");
        ep.setProperty("javafx.deploy.backgroundupdate", "true");
        ep.setComment("javafx.deploy.backgroundupdate", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_updatemode")}, false);
        ep.setProperty("javafx.deploy.allowoffline", "true");
        ep.setProperty("javafx.sdk", JavaFXPlatformUtils.getJavaFXSDKPath((String)platformName));
        ep.setProperty("javafx.runtime", JavaFXPlatformUtils.getJavaFXRuntimePath((String)platformName));
        ep.setProperty("endorsed.classpath", JavaFXPlatformUtils.getJavaFXClassPath());
        ep.setProperty("javafx.run.width", "800");
        ep.setProperty("javafx.run.height", "600");
        if (type == JavaFXProjectWizardIterator.WizardType.PRELOADER) {
            ep.setProperty("javafx.preloader", "true");
            ep.setComment("javafx.preloader", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_preloader")}, false);
            ep.setProperty("javafx.preloader.enabled", "false");
            ep.setComment("javafx.preloader.enabled", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_prepreloader")}, false);
        } else {
            ep.setProperty("main.class", "com.javafx.main.Main");
            ep.setComment("main.class", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_main.class")}, false);
            if (type != JavaFXProjectWizardIterator.WizardType.LIBRARY) {
                ep.setProperty("javafx.main.class", mainClass == null ? "" : mainClass);
                ep.setComment("javafx.main.class", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_main.fxclass")}, false);
            }
            if (preloader != null && preloader.length() > 0) {
                String preloaderProj = FileUtil.toFile((FileObject)dirFO).getParentFile().getAbsolutePath() + File.separatorChar + preloader;
                String preloaderJarPath = preloaderProj + File.separatorChar + "dist" + File.separatorChar;
                String preloaderJarFileName = preloader + ".jar";
                String copiedPreloaderJarPath = FileUtil.toFile((FileObject)dirFO).getAbsolutePath() + File.separatorChar + "dist" + File.separatorChar + "lib" + File.separatorChar + preloaderJarFileName;
                ep.setProperty("javafx.preloader.enabled", "true");
                ep.setProperty("javafx.preloader.type", JFXProjectProperties.PreloaderSourceType.PROJECT.getString());
                ep.setComment("javafx.preloader.enabled", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_use_preloader")}, false);
                ep.setProperty("javafx.preloader.project.path", preloaderProj);
                ep.setProperty("javafx.preloader.class", JavaFXProjectWizardIterator.generatePreloaderClassName(preloader));
                ep.setProperty("javafx.preloader.jar.path", copiedPreloaderJarPath);
                ep.setProperty("javafx.preloader.jar.filename", preloaderJarFileName);
            } else {
                ep.setProperty("javafx.preloader.enabled", "false");
                ep.setProperty("javafx.preloader.type", JFXProjectProperties.PreloaderSourceType.NONE.getString());
                ep.setComment("javafx.preloader.enabled", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_dontuse_preloader")}, false);
                ep.setProperty("javafx.preloader.project.path", "");
                ep.setProperty("javafx.preloader.class", "");
                ep.setProperty("javafx.preloader.jar.path", "");
                ep.setProperty("javafx.preloader.jar.filename", "");
            }
        }
        ep.setProperty("javafx.fallback.class", "com.javafx.main.NoJavaFXFallback");
        ep.setProperty("annotation.processing.enabled", "true");
        ep.setProperty("annotation.processing.enabled.in.editor", "false");
        ep.setProperty("annotation.processing.run.all.processors", "true");
        ep.setProperty("annotation.processing.processors.list", "");
        ep.setProperty("annotation.processing.source.output", "${build.generated.sources.dir}/ap-source-output");
        ep.setProperty("annotation.processing.processor.options", "");
        ep.setProperty("dist.dir", "dist");
        ep.setComment("dist.dir", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_dist.dir")}, false);
        ep.setProperty("dist.jar", "${dist.dir}/" + JFXProjectGenerator.validatePropertyValue(name) + ".jar");
        ep.setProperty("javac.classpath", "");
        ep.setProperty("application.vendor", System.getProperty("user.name", "User Name"));
        ep.setProperty("application.title", name);
        ep.setProperty("javac.processorpath", new String[]{"${javac.classpath}"});
        ep.setProperty("javac.test.processorpath", new String[]{"${javac.test.classpath}"});
        ep.setProperty("build.sysclasspath", "ignore");
        ep.setComment("build.sysclasspath", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_build.sysclasspath")}, false);
        ep.setProperty("run.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}:", "${dist.jar}"});
        ep.setProperty("debug.classpath", new String[]{"${run.classpath}"});
        ep.setComment("debug.classpath", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_debug.transport"), "#debug.transport=dt_socket"}, false);
        ep.setProperty("jar.compress", "false");
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_javac.compilerargs")}, false);
        SpecificationVersion sourceLevel = JFXProjectGenerator.getDefaultSourceLevel();
        ep.setProperty("javac.source", sourceLevel.toString());
        ep.setProperty("javac.target", sourceLevel.toString());
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}"});
        ep.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        ep.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("meta.inf.dir", "${src.dir}/META-INF");
        ep.setProperty("build.dir", "build");
        ep.setComment("build.dir", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_build.dir")}, false);
        ep.setProperty("build.classes.dir", "${build.dir}/classes");
        ep.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("platform.active", platformName);
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "${source.encoding}");
        ep.setProperty("javadoc.additionalparam", "");
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        if (manifestFile != null) {
            ep.setProperty("manifest.file", manifestFile);
        }
        h.putProperties("nbproject/project.properties", ep);
        JFXProjectGenerator.logUsage();
        return h;
    }

    private static void logUsage() {
        LogRecord logRecord = new LogRecord(Level.INFO, loggerKey);
        logRecord.setLoggerName(loggerName);
        Logger.getLogger(loggerName).log(logRecord);
    }

    private static void copyRequiredLibraries(AntProjectHelper h, ReferenceHelper rh) throws IOException {
        if (!h.isSharableProject()) {
            return;
        }
        if (rh.getProjectLibraryManager().getLibrary("junit") == null && LibraryManager.getDefault().getLibrary("junit") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit"));
        }
        if (rh.getProjectLibraryManager().getLibrary("junit_4") == null && LibraryManager.getDefault().getLibrary("junit_4") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit_4"));
        }
        if (rh.getProjectLibraryManager().getLibrary("CopyLibs") == null && LibraryManager.getDefault().getLibrary("CopyLibs") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("CopyLibs"));
        }
        if (rh.getProjectLibraryManager().getLibrary("JavaFX2Runtime") == null && LibraryManager.getDefault().getLibrary("JavaFX2Runtime") != null) {
            File mainPropertiesFile = h.resolveFile(h.getLibrariesLocation());
            JFXProjectGenerator.referenceLibrary(LibraryManager.getDefault().getLibrary("JavaFX2Runtime"), mainPropertiesFile.toURI().toURL(), true);
        }
    }

    private static String getJarFolder(URI uri) {
        String u = uri.toString();
        int index = u.indexOf("!/");
        if (index != -1 && index + 2 < u.length()) {
            return u.substring(index + 2);
        }
        return null;
    }

    private static URI appendJarFolder(URI u, String jarFolder) {
        try {
            if (u.isAbsolute()) {
                return new URI("jar:" + u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
            }
            return new URI(u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Library referenceLibrary(final Library lib, URL location, final boolean generateLibraryUniqueName) throws IOException {
        String[] volumes;
        File libBaseFolder = new File(URI.create(location.toExternalForm())).getParentFile();
        final HashMap content = new HashMap();
        for (String volume : volumes = LibrariesSupport.getLibraryTypeProvider((String)lib.getType()).getSupportedVolumeTypes()) {
            ArrayList<URI> volumeContent = new ArrayList<URI>();
            Iterator i$ = lib.getContent(volume).iterator();
            while (i$.hasNext()) {
                FileObject libEntryFO;
                URL origlibEntry;
                URL libEntry = origlibEntry = (URL)i$.next();
                String jarFolder = null;
                if ("jar".equals(libEntry.getProtocol())) {
                    jarFolder = JFXProjectGenerator.getJarFolder(URI.create(libEntry.toExternalForm()));
                    libEntry = FileUtil.getArchiveFile((URL)libEntry);
                }
                if ((libEntryFO = URLMapper.findFileObject((URL)libEntry)) == null) {
                    if (!"file".equals(libEntry.getProtocol()) && !"nbinst".equals(libEntry.getProtocol())) {
                        Logger.getLogger(JFXProjectGenerator.class.getName()).log(Level.INFO, "referenceLibrary is ignoring entry {0}", libEntry);
                        continue;
                    }
                    Logger.getLogger(JFXProjectGenerator.class.getName()).log(Level.WARNING, "Library '{0}' contains entry ({1}) which does not exist. This entry is ignored and will not be refernced from sharable libraries.", new Object[]{lib.getDisplayName(), libEntry});
                    continue;
                }
                String name = PropertyUtils.relativizeFile((File)libBaseFolder, (File)FileUtil.toFile((FileObject)libEntryFO));
                if (name == null) {
                    Logger.getLogger(JFXProjectGenerator.class.getName()).log(Level.WARNING, "Can not relativize file: {0}", libEntryFO.getPath());
                    continue;
                }
                URI u = LibrariesSupport.convertFilePathToURI((String)name);
                if (FileUtil.isArchiveFile((FileObject)libEntryFO)) {
                    u = JFXProjectGenerator.appendJarFolder(u, jarFolder);
                }
                volumeContent.add(u);
            }
            content.put(volume, volumeContent);
        }
        final LibraryManager man = LibraryManager.forLocation((URL)location);
        try {
            return (Library)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Library>(){

                public Library run() throws IOException {
                    String name = lib.getName();
                    if (generateLibraryUniqueName) {
                        int index = 2;
                        while (man.getLibrary(name) != null) {
                            name = lib.getName() + "-" + index;
                            ++index;
                        }
                    }
                    return man.createURILibrary(lib.getType(), name, content);
                }
            });
        }
        catch (MutexException ex) {
            throw (IOException)ex.getException();
        }
    }

    private static void createFiles(String mainClassName, FileObject srcFolder, JavaFXProjectWizardIterator.WizardType type) throws IOException {
        String pName;
        String mName;
        int lastDotIdx = mainClassName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            mName = mainClassName.trim();
            pName = null;
        } else {
            mName = mainClassName.substring(lastDotIdx + 1).trim();
            pName = mainClassName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0) {
            return;
        }
        HashMap<String, String> params = null;
        FileObject template = null;
        switch (type) {
            case APPLICATION: {
                template = FileUtil.getConfigFile((String)"Templates/javafx/FXMain.java");
                break;
            }
            case PRELOADER: {
                template = FileUtil.getConfigFile((String)"Templates/javafx/FXPreloader.java");
                break;
            }
            case FXML: {
                template = FileUtil.getConfigFile((String)"Templates/javafx/FXML.java");
                params = new HashMap<String, String>(1);
                params.put("fxmlname", "Sample");
            }
        }
        if (template == null) {
            return;
        }
        DataObject mt = DataObject.find((FileObject)template);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
        }
        DataFolder pDf = DataFolder.findFolder((FileObject)pkgFolder);
        if (params != null) {
            mt.createFromTemplate(pDf, mName, params);
        } else {
            mt.createFromTemplate(pDf, mName);
        }
        if (type == JavaFXProjectWizardIterator.WizardType.FXML) {
            FileObject xmlTemplate = FileUtil.getConfigFile((String)"Templates/javafx/FXML.fxml");
            DataObject dXMLTemplate = DataObject.find((FileObject)xmlTemplate);
            dXMLTemplate.createFromTemplate(pDf, "Sample");
            FileObject javaTemplate = FileUtil.getConfigFile((String)"Templates/javafx/FXML2.java");
            DataObject dJavaTemplate = DataObject.find((FileObject)javaTemplate);
            dJavaTemplate.createFromTemplate(pDf, "Sample");
        }
    }

    private static void createPreloaderClass(String preloaderClassName, FileObject srcFolder) throws IOException {
        String pName;
        String mName;
        int lastDotIdx = preloaderClassName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            mName = preloaderClassName.trim();
            pName = null;
        } else {
            mName = preloaderClassName.substring(lastDotIdx + 1).trim();
            pName = preloaderClassName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0) {
            return;
        }
        FileObject template = FileUtil.getConfigFile((String)"Templates/javafx/FXPreloader.java");
        if (template == null) {
            return;
        }
        DataObject mt = DataObject.find((FileObject)template);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
        }
        DataFolder pDf = DataFolder.findFolder((FileObject)pkgFolder);
        mt.createFromTemplate(pDf, mName);
    }

    private static SpecificationVersion getDefaultSourceLevel() {
        if (defaultSourceLevel != null) {
            return defaultSourceLevel;
        }
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion v = defaultPlatform.getSpecification().getVersion();
        if (v.equals((Object)new SpecificationVersion("1.6")) || v.equals((Object)new SpecificationVersion("1.7"))) {
            return new SpecificationVersion("1.5");
        }
        return v;
    }

    private static String validatePropertyValue(String value) {
        Matcher m = INVALID_NAME.matcher(value);
        if (m.find()) {
            value = m.replaceAll("_");
        }
        return value;
    }

    public static void setDefaultSourceLevel(SpecificationVersion version) {
        defaultSourceLevel = version;
    }

    static {
        INVALID_NAME = Pattern.compile("[$/\\\\\\p{Cntrl}]");
    }
}

