/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class JFXActionProvider
implements ActionProvider {
    private final Project prj;
    private static final Map<String, String> ACTIONS = new HashMap<String, String>(){
        {
            this.put("run", "run");
            this.put("debug", "debug");
        }
    };

    public JFXActionProvider(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.prj = project;
    }

    @NonNull
    public String[] getSupportedActions() {
        return ACTIONS.keySet().toArray(new String[ACTIONS.size()]);
    }

    public void invokeAction(@NonNull String command, @NonNull Lookup context) throws IllegalArgumentException {
        block8: {
            String target = command;
            if (target != null) {
                FileObject buildFo = this.findBuildXml();
                assert (buildFo != null && buildFo.isValid());
                String runAs = JFXProjectUtils.getFXProjectRunAs(this.prj);
                if (runAs == null) {
                    runAs = JFXProjectProperties.RunAsType.STANDALONE.getString();
                }
                try {
                    if (runAs.equalsIgnoreCase(JFXProjectProperties.RunAsType.STANDALONE.getString())) {
                        Properties p = new Properties();
                        ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{target}, (Properties)p);
                        break block8;
                    }
                    if (runAs.equalsIgnoreCase(JFXProjectProperties.RunAsType.ASWEBSTART.getString())) {
                        target = "jfxws-".concat(command);
                        Properties p = new Properties();
                        ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{target}, (Properties)p);
                        break block8;
                    }
                    target = "jfxbe-".concat(command);
                    Properties p = new Properties();
                    ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{target}, (Properties)p);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                throw new IllegalArgumentException(command);
            }
        }
    }

    public boolean isActionEnabled(@NonNull String command, @NonNull Lookup context) throws IllegalArgumentException {
        if (!JFXProjectUtils.isFXProject(this.prj)) {
            return false;
        }
        if (this.findBuildXml() == null) {
            return false;
        }
        return JFXActionProvider.findTarget(command) != null;
    }

    @NonNull
    private static String getBuildXmlName(@NonNull PropertyEvaluator evaluator) {
        String buildScriptPath = evaluator.getProperty("buildfile");
        if (buildScriptPath == null) {
            buildScriptPath = "build.xml";
        }
        return buildScriptPath;
    }

    @CheckForNull
    private FileObject findBuildXml() {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)this.prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        assert (ep != null);
        return this.prj.getProjectDirectory().getFileObject(JFXActionProvider.getBuildXmlName(ep.evaluator()));
    }

    @CheckForNull
    private static String findTarget(@NonNull String command) {
        return ACTIONS.get(command);
    }
}

