/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.modules.cnd.makefile.utils.IpeFileSystemView;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.ui.CndUIUtilities;

public class ItemChooser
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = 6653452210904639697L;
    private JLabel dirLabel;
    private JTextField dirText;
    private JButton dirChooser;
    private JLabel label;
    private JTextField text;
    private JFileChooser fc;
    private boolean directoryValid;
    private boolean uncreatedDirOK;
    private boolean dirReadOnly;
    private boolean textNotFile;

    protected ItemChooser(MakefileWizard wd) {
        this(wd, false, false);
    }

    protected ItemChooser(MakefileWizard wd, boolean uncreatedDirOK) {
        this(wd, uncreatedDirOK, false);
    }

    protected ItemChooser(MakefileWizard wd, boolean uncreatedDirOK, boolean dirReadOnly) {
        super(wd);
        this.uncreatedDirOK = uncreatedDirOK;
        this.dirReadOnly = dirReadOnly;
    }

    @Override
    public boolean isPanelValid() {
        return this.uncreatedDirOK && this.textNotFile || this.directoryValid;
    }

    protected final void onOk() {
        this.checkit();
    }

    private void validateDirectory() {
        String dir = this.dirText.getText();
        if (dir.length() > 0) {
            File file = dir.charAt(0) == File.separatorChar ? new File(dir) : new File(".", dir);
            if (this.uncreatedDirOK) {
                boolean tnf;
                boolean bl = tnf = !file.isFile();
                if (tnf != this.textNotFile) {
                    this.textNotFile = tnf;
                    MakefileWizard.getMakefileWizard().updateState();
                }
            } else {
                boolean isfile = file.isDirectory();
                if (isfile != this.directoryValid) {
                    this.directoryValid = isfile;
                    MakefileWizard.getMakefileWizard().updateState();
                }
            }
        }
    }

    private final void checkit() {
        boolean oldVal = this.directoryValid;
        this.validateDirectory();
        if (this.directoryValid != oldVal) {
            MakefileWizard.getMakefileWizard().updateState();
        }
    }

    protected void create(String dlabel, char dmnem, String nlabel, char nmnem) {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        GridBagConstraints grid = new GridBagConstraints();
        Insets defaults = grid.insets;
        this.dirLabel = new JLabel(dlabel);
        this.dirLabel.setDisplayedMnemonic(dmnem);
        grid.anchor = 17;
        grid.gridx = 0;
        grid.gridy = gridy++;
        grid.gridwidth = 0;
        this.add((Component)this.dirLabel, grid);
        this.dirText = new JTextField();
        this.dirText.addFocusListener(this);
        this.dirLabel.setLabelFor(this.dirText);
        grid.gridy = gridy++;
        grid.gridwidth = -1;
        grid.weightx = 1.0;
        grid.fill = 2;
        grid.anchor = 17;
        grid.insets = defaults;
        this.add((Component)this.dirText, grid);
        this.dirText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                ItemChooser.this.checkit();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                ItemChooser.this.checkit();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                ItemChooser.this.checkit();
            }
        });
        if (this.dirReadOnly) {
            this.dirText.setEnabled(false);
        } else {
            this.dirChooser = new JButton(this.getString("BTN_Chooser"));
            this.dirChooser.setMnemonic(this.getString("MNEM_Chooser").charAt(0));
            grid.gridx = 2;
            grid.gridwidth = 0;
            grid.fill = 0;
            grid.anchor = 17;
            grid.weightx = 0.0;
            grid.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.dirChooser, grid);
            this.dirChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String cwd = ItemChooser.this.getMakefileData().getBaseDirectory(true);
                    ItemChooser.this.fc = new JFileChooser();
                    ItemChooser.this.fc.setApproveButtonText(ItemChooser.this.getString("BTN_Approve"));
                    ItemChooser.this.fc.setDialogTitle(ItemChooser.this.getString("TITLE_DirChooser"));
                    ItemChooser.this.fc.setCurrentDirectory(new File(cwd));
                    ItemChooser.this.fc.setFileSelectionMode(1);
                    ItemChooser.this.fc.setFileSystemView(new IpeFileSystemView(ItemChooser.this.fc.getFileSystemView()));
                    int returnVal = ItemChooser.this.fc.showDialog(ItemChooser.this, null);
                    if (returnVal == 0) {
                        String path = ItemChooser.this.fc.getSelectedFile().getAbsolutePath();
                        ItemChooser.this.dirText.setText(CndPathUtilitities.getRelativePath((String)cwd, (String)path));
                    }
                }
            });
        }
        this.label = new JLabel(nlabel);
        this.label.setDisplayedMnemonic(nmnem);
        grid.anchor = 18;
        grid.gridx = 0;
        grid.gridy = gridy++;
        grid.gridwidth = 0;
        grid.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.label, grid);
        this.text = new JTextField();
        this.text.addFocusListener(this);
        this.label.setLabelFor(this.text);
        grid.gridy = gridy++;
        grid.gridwidth = -1;
        grid.weightx = 1.0;
        grid.insets = defaults;
        grid.fill = 2;
        grid.anchor = 17;
        this.add((Component)this.text, grid);
        Keymap km = JTextField.addKeymap("ItemChooserKeymap", this.text.getKeymap());
        km.addActionForKeyStroke(KeyStroke.getKeyStroke('/'), new DefaultEditorKit.BeepAction());
        this.text.setKeymap(km);
        grid.gridx = 0;
        grid.gridy = gridy++;
        grid.gridwidth = 0;
        grid.gridheight = 0;
        grid.weightx = 1.0;
        grid.weighty = 1.0;
        this.add((Component)new JLabel(""), grid);
    }

    final void convertLabel(String nlabel, char nmnem) {
        this.label.setText(nlabel);
        this.label.setDisplayedMnemonic(nmnem);
    }

    final JTextField getText() {
        return this.text;
    }

    final JTextField getDirText() {
        return this.dirText;
    }

    final JLabel getNameLabel() {
        return this.label;
    }

    @Override
    public void focusGained(FocusEvent evt) {
    }

    @Override
    public void focusLost(FocusEvent evt) {
        ((JTextComponent)evt.getComponent()).setSelectionEnd(0);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.dirText.selectAll();
        CndUIUtilities.requestFocus((Component)this.dirText);
        this.validateDirectory();
    }

    @Override
    public void removeNotify() {
        Container o;
        super.removeNotify();
        if (this.fc != null && this.fc.isShowing() && (o = this.fc.getTopLevelAncestor()) != null && o instanceof JDialog) {
            ((JDialog)o).dispose();
        }
    }
}

