/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanCommand
extends GitCommand<Set<String>> {
    private Set<String> paths = Collections.emptySet();

    protected CleanCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Set<String> call() {
        TreeSet<String> files = new TreeSet<String>();
        try {
            StatusCommand command = new StatusCommand(this.repo);
            Status status = command.call();
            for (String file : status.getUntracked()) {
                if (!this.paths.isEmpty() && !this.paths.contains(file)) continue;
                FileUtils.delete(new File(this.repo.getWorkTree(), file));
                files.add(file);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        return files;
    }

    public CleanCommand setPaths(Set<String> paths) {
        this.paths = paths;
        return this;
    }
}

