/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openide.util.lookup.implspi.ServiceLoaderLine;

public abstract class AbstractServiceProviderProcessor
extends AbstractProcessor {
    private final Map<ProcessingEnvironment, Map<String, SortedSet<ServiceLoaderLine>>> outputFilesByProcessor = new WeakHashMap<ProcessingEnvironment, Map<String, SortedSet<ServiceLoaderLine>>>();
    private final Map<ProcessingEnvironment, Map<String, List<Element>>> originatingElementsByProcessor = new WeakHashMap<ProcessingEnvironment, Map<String, List<Element>>>();
    private final Map<TypeElement, Boolean> verifiedClasses = new WeakHashMap<TypeElement, Boolean>();

    protected AbstractServiceProviderProcessor() {
        if (this.getClass().getName().equals("org.netbeans.modules.openide.util.ServiceProviderProcessor")) {
            return;
        }
        if (this.getClass().getName().equals("org.netbeans.modules.openide.util.URLStreamHandlerRegistrationProcessor")) {
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.errorRaised()) {
            return false;
        }
        if (roundEnv.processingOver()) {
            this.writeServices();
            this.outputFilesByProcessor.clear();
            this.originatingElementsByProcessor.clear();
            return true;
        }
        return this.handleProcess(annotations, roundEnv);
    }

    protected abstract boolean handleProcess(Set<? extends TypeElement> var1, RoundEnvironment var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void register(Element el, Class<? extends Annotation> annotation, TypeMirror type, String path, int position, String[] supersedes) {
        SortedSet<ServiceLoaderLine> lines;
        List<Element> origEls;
        if (el.getKind() != ElementKind.CLASS) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, annotation.getName() + " is not applicable to a " + (Object)((Object)el.getKind()), el);
            return;
        }
        TypeElement clazz = (TypeElement)el;
        Boolean verify = this.verifiedClasses.get(clazz);
        if (verify == null) {
            verify = this.verifyServiceProviderSignature(clazz, annotation);
            this.verifiedClasses.put(clazz, verify);
        }
        if (!verify.booleanValue()) {
            return;
        }
        String impl = this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
        String xface = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.processingEnv.getTypeUtils().asElement(type)).toString();
        if (!this.processingEnv.getTypeUtils().isAssignable(clazz.asType(), type)) {
            AnnotationMirror ann = this.findAnnotationMirror(clazz, annotation);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, impl + " is not assignable to " + xface, clazz, ann, this.findAnnotationValue(ann, "service"));
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, impl + " to be registered as a " + xface + (path.length() > 0 ? " under " + path : ""));
        String rsrc = (path.length() > 0 ? "META-INF/namedservices/" + path + "/" : "META-INF/services/") + xface;
        Map<String, List<Element>> originatingElements = this.originatingElementsByProcessor.get(this.processingEnv);
        if (originatingElements == null) {
            originatingElements = new HashMap<String, List<Element>>();
            this.originatingElementsByProcessor.put(this.processingEnv, originatingElements);
        }
        if ((origEls = originatingElements.get(rsrc)) == null) {
            origEls = new ArrayList<Element>();
            originatingElements.put(rsrc, origEls);
        }
        origEls.add(clazz);
        Map<String, SortedSet<ServiceLoaderLine>> outputFiles = this.outputFilesByProcessor.get(this.processingEnv);
        if (outputFiles == null) {
            outputFiles = new HashMap<String, SortedSet<ServiceLoaderLine>>();
            this.outputFilesByProcessor.put(this.processingEnv, outputFiles);
        }
        if ((lines = outputFiles.get(rsrc)) == null) {
            lines = new TreeSet<ServiceLoaderLine>();
            try {
                try {
                    FileObject in = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", rsrc);
                    in.openInputStream().close();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot generate " + rsrc + " because it already exists in sources: " + in.toUri());
                    return;
                }
                catch (NullPointerException ex) {
                }
                catch (FileNotFoundException x) {
                    // empty catch block
                }
                try {
                    FileObject in = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", rsrc);
                    InputStream is = in.openInputStream();
                    try {
                        ServiceLoaderLine.parse(new InputStreamReader(is, "UTF-8"), lines);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (FileNotFoundException x) {}
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, x.toString());
                return;
            }
            outputFiles.put(rsrc, lines);
        }
        lines.add(new ServiceLoaderLine(impl, position, supersedes));
    }

    private AnnotationMirror findAnnotationMirror(Element element, Class<? extends Annotation> annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).contentEquals(annotation.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private AnnotationValue findAnnotationValue(AnnotationMirror annotation, String name) {
        if (annotation != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals(name)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private boolean verifyServiceProviderSignature(TypeElement clazz, Class<? extends Annotation> annotation) {
        AnnotationMirror ann = this.findAnnotationMirror(clazz, annotation);
        if (!clazz.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must be public", clazz, ann);
            return false;
        }
        if (clazz.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must not be abstract", clazz, ann);
            return false;
        }
        boolean hasDefaultCtor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(clazz.getEnclosedElements())) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
            hasDefaultCtor = true;
            break;
        }
        if (!hasDefaultCtor) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must have a public no-argument constructor", clazz, ann);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServices() {
        for (Map.Entry<ProcessingEnvironment, Map<String, SortedSet<ServiceLoaderLine>>> outputFiles : this.outputFilesByProcessor.entrySet()) {
            for (Map.Entry<String, SortedSet<ServiceLoaderLine>> entry : outputFiles.getValue().entrySet()) {
                try {
                    FileObject out = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", entry.getKey(), this.originatingElementsByProcessor.get(outputFiles.getKey()).get(entry.getKey()).toArray(new Element[0]));
                    OutputStream os = out.openOutputStream();
                    try {
                        PrintWriter w = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
                        for (ServiceLoaderLine line : entry.getValue()) {
                            line.write(w);
                        }
                        w.flush();
                        w.close();
                    }
                    finally {
                        os.close();
                    }
                }
                catch (IOException x) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write to " + entry.getKey() + ": " + x.toString());
                }
            }
        }
    }

    @Deprecated
    protected final void register(TypeElement el, Class<? extends Annotation> annotation, TypeMirror type, String path, int position, String[] supersedes) {
        this.register((Element)el, annotation, type, path, position, supersedes);
    }
}

