/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.conditionapi;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.declarative.APIAccessor;
import org.netbeans.modules.java.hints.declarative.Hacks;
import org.netbeans.modules.java.hints.declarative.conditionapi.Variable;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.openide.filesystems.FileObject;

public class Context {
    final HintContext ctx;
    final List<Map<String, TreePath>> variables = new LinkedList<Map<String, TreePath>>();
    final List<Map<String, Collection<? extends TreePath>>> multiVariables = new LinkedList<Map<String, Collection<? extends TreePath>>>();
    final List<Map<String, String>> variableNames = new LinkedList<Map<String, String>>();
    private final AtomicInteger auxiliaryVariableCounter = new AtomicInteger();

    public Context(HintContext ctx) {
        this.ctx = ctx;
        this.variables.add(Collections.unmodifiableMap(ctx.getVariables()));
        this.multiVariables.add(Collections.unmodifiableMap(ctx.getMultiVariables()));
        this.variableNames.add(Collections.unmodifiableMap(ctx.getVariableNames()));
    }

    @NonNull
    public SourceVersion sourceVersion() {
        String sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)this.ctx.getInfo().getFileObject());
        if (sourceLevel == null) {
            return SourceVersion.latest();
        }
        String[] splited = sourceLevel.split("\\.");
        String spec = splited[1];
        return SourceVersion.valueOf("RELEASE_" + spec);
    }

    @NonNull
    public Set<Modifier> modifiers(@NonNull Variable variable) {
        Element e = this.ctx.getInfo().getTrees().getElement(this.getSingleVariable(variable));
        if (e == null) {
            return Collections.unmodifiableSet(EnumSet.noneOf(Modifier.class));
        }
        return Collections.unmodifiableSet(e.getModifiers());
    }

    @CheckForNull
    public ElementKind elementKind(@NonNull Variable variable) {
        Element e = this.ctx.getInfo().getTrees().getElement(this.getSingleVariable(variable));
        if (e == null) {
            return null;
        }
        return e.getKind();
    }

    @CheckForNull
    public TypeKind typeKind(@NonNull Variable variable) {
        TypeMirror tm = this.ctx.getInfo().getTrees().getTypeMirror(this.getSingleVariable(variable));
        if (tm == null) {
            return null;
        }
        return tm.getKind();
    }

    @CheckForNull
    public String name(@NonNull Variable variable) {
        Element e = this.ctx.getInfo().getTrees().getElement(this.getSingleVariable(variable));
        if (e == null) {
            return null;
        }
        return e.getSimpleName().toString();
    }

    @CheckForNull
    public Variable parent(@NonNull Variable variable) {
        TreePath tp = this.getSingleVariable(variable);
        if (tp.getParentPath() == null) {
            return null;
        }
        return this.enterAuxiliaryVariable(tp.getParentPath());
    }

    private Variable enterAuxiliaryVariable(TreePath path) {
        String output = "*" + this.auxiliaryVariableCounter.getAndIncrement();
        this.variables.get(0).put(output, path);
        return new Variable(output);
    }

    @NonNull
    public Variable variableForName(@NonNull String variableName) {
        Variable result = new Variable(variableName);
        if (this.getSingleVariable(result) == null) {
            throw new IllegalStateException("Unknown variable");
        }
        return result;
    }

    public void createRenamed(@NonNull Variable from, @NonNull Variable to, @NonNull String newName) {
        this.variableNames.get(0).put(to.variableName, newName);
        TreePath origVariablePath = this.getSingleVariable(from);
        TreePath newVariablePath = new TreePath(origVariablePath.getParentPath(), Hacks.createRenameTree(origVariablePath.getLeaf(), newName));
        this.variables.get(0).put(to.variableName, newVariablePath);
    }

    public boolean isNullLiteral(@NonNull Variable var) {
        TreePath varPath = this.getSingleVariable(var);
        return varPath.getLeaf().getKind() == Tree.Kind.NULL_LITERAL;
    }

    @NonNull
    public Iterable<? extends Variable> getIndexedVariables(@NonNull Variable multiVariable) {
        Collection<? extends TreePath> paths = this.getMultiVariable(multiVariable);
        if (paths == null) {
            throw new IllegalArgumentException("TODO: explanation");
        }
        LinkedList<Variable> result = new LinkedList<Variable>();
        int index = 0;
        for (TreePath treePath : paths) {
            result.add(new Variable(multiVariable.variableName, index++));
        }
        return result;
    }

    public void enterScope() {
        this.variables.add(0, new HashMap());
        this.multiVariables.add(0, new HashMap());
        this.variableNames.add(0, new HashMap());
    }

    public void leaveScope() {
        this.variables.remove(0);
        this.multiVariables.remove(0);
        this.variableNames.remove(0);
    }

    Iterable<? extends TreePath> getVariable(Variable v) {
        if (Context.isMultistatementWildcard(v.variableName) && v.index == -1) {
            return this.getMultiVariable(v);
        }
        return Collections.singletonList(this.getSingleVariable(v));
    }

    private static boolean isMultistatementWildcard(CharSequence name) {
        return name.charAt(name.length() - 1) == '$';
    }

    TreePath getSingleVariable(Variable v) {
        if (v.index == -1) {
            for (Map<String, TreePath> map : this.variables) {
                if (!map.containsKey(v.variableName)) continue;
                return map.get(v.variableName);
            }
            return null;
        }
        return new ArrayList<TreePath>(this.getMultiVariable(v)).get(v.index);
    }

    private Collection<? extends TreePath> getMultiVariable(Variable v) {
        for (Map<String, Collection<? extends TreePath>> multi : this.multiVariables) {
            if (!multi.containsKey(v.variableName)) continue;
            return multi.get(v.variableName);
        }
        return null;
    }

    @NonNull
    public Iterable<? extends String> enclosingClasses(Variable forVariable) {
        ArrayList<String> result = new ArrayList<String>();
        for (TreePath path = this.getSingleVariable(forVariable); path != null; path = path.getParentPath()) {
            Element e;
            TreePath current = path;
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)current.getLeaf().getKind()) || (e = this.ctx.getInfo().getTrees().getElement(current)) == null || !e.getKind().isClass() && !e.getKind().isInterface()) continue;
            result.add(((TypeElement)e).getQualifiedName().toString());
        }
        return result;
    }

    @NonNull
    public String enclosingPackage() {
        CompilationUnitTree cut = this.ctx.getInfo().getCompilationUnit();
        return cut.getPackageName() != null ? cut.getPackageName().toString() : "";
    }

    static {
        APIAccessor.IMPL = new APIAccessorImpl();
    }

    static final class APIAccessorImpl
    extends APIAccessor {
        APIAccessorImpl() {
        }

        @Override
        public TreePath getSingleVariable(Context ctx, Variable var) {
            return ctx.getSingleVariable(var);
        }

        @Override
        public HintContext getHintContext(Context ctx) {
            return ctx.ctx;
        }

        @Override
        public Map<String, TreePath> getVariables(Context ctx) {
            HashMap<String, TreePath> result = new HashMap<String, TreePath>();
            for (Map<String, TreePath> m : this.reverse(ctx.variables)) {
                result.putAll(m);
            }
            return result;
        }

        @Override
        public Map<String, Collection<? extends TreePath>> getMultiVariables(Context ctx) {
            HashMap<String, Collection<? extends TreePath>> result = new HashMap<String, Collection<? extends TreePath>>();
            for (Map<String, Collection<? extends TreePath>> m : this.reverse(ctx.multiVariables)) {
                result.putAll(m);
            }
            return result;
        }

        @Override
        public Map<String, String> getVariableNames(Context ctx) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map<String, String> m : this.reverse(ctx.variableNames)) {
                result.putAll(m);
            }
            return result;
        }

        private <T> List<T> reverse(List<T> original) {
            LinkedList<T> result = new LinkedList<T>();
            for (T t : original) {
                result.add(0, t);
            }
            return result;
        }

        @Override
        public Variable enterAuxiliaryVariable(Context ctx, TreePath source) {
            return ctx.enterAuxiliaryVariable(source);
        }
    }
}

