/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.web.model.FilterInfo;
import org.netbeans.modules.j2ee.dd.api.web.model.ServletInfo;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.BaseWizardPanel;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.DeployDataExtraPanel;
import org.netbeans.modules.web.wizards.DeployDataPanel;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.TargetEvaluator;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ServletPanel
implements WizardDescriptor.FinishablePanel {
    private transient BaseWizardPanel wizardPanel;
    private transient TemplateWizard wizard;
    private ChangeListener listener;
    private DeployData deployData;
    private transient TargetEvaluator evaluator;

    private ServletPanel(TargetEvaluator evaluator, TemplateWizard wizard, boolean first) {
        this.evaluator = evaluator;
        this.wizard = wizard;
        this.deployData = evaluator.getDeployData();
        this.wizardPanel = first ? new DeployDataPanel(evaluator, wizard) : new DeployDataExtraPanel(evaluator, wizard);
    }

    public boolean isFinishPanel() {
        return true;
    }

    public static ServletPanel createServletPanel(TargetEvaluator evaluator, TemplateWizard wizard) {
        return new ServletPanel(evaluator, wizard, true);
    }

    public static ServletPanel createFilterPanel(TargetEvaluator evaluator, TemplateWizard wizard) {
        return new ServletPanel(evaluator, wizard, false);
    }

    public Component getComponent() {
        return this.wizardPanel;
    }

    public boolean isValid() {
        WebModule wm;
        if (!this.deployData.isValid()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)this.deployData.getErrorMessage());
            return false;
        }
        if (Utilities.isJavaEE6(this.wizard) && (wm = Utilities.findWebModule(this.wizard)) != null && this.deployData instanceof ServletData) {
            ServletData servletData = (ServletData)this.deployData;
            String name = servletData.getName();
            if (servletData.fileType == FileType.SERVLET) {
                for (ServletInfo si : this.getServlets(wm)) {
                    if (!si.getName().equals(name)) continue;
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ServletData.class, (String)"MSG_servlet_name_defined", (Object)name, (Object)si.getServletClass()));
                    return false;
                }
                for (ServletInfo si : this.getServlets(wm)) {
                    List patterns = si.getUrlPatterns();
                    for (String pattern : patterns) {
                        for (String m : servletData.getUrlMappings()) {
                            if (!pattern.equals(m)) continue;
                            this.wizard.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(ServletData.class, (String)"MSG_servlet_mapping_defined", (Object)m, (Object)si.getServletClass()));
                            return true;
                        }
                    }
                }
            } else if (servletData.fileType == FileType.FILTER) {
                for (FilterInfo fi : this.getFilters(wm)) {
                    if (!fi.getName().equals(name)) continue;
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ServletData.class, (String)"MSG_filter_name_defined", (Object)name, (Object)fi.getFilterClass()));
                    return false;
                }
                for (FilterInfo fi : this.getFilters(wm)) {
                    List patterns = fi.getUrlPatterns();
                    for (String pattern : patterns) {
                        for (FilterMappingData m : servletData.getFilterMappings()) {
                            if (!pattern.equals(m.getPattern())) continue;
                            this.wizard.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(ServletData.class, (String)"MSG_filter_mapping_defined", (Object)m.getPattern(), (Object)fi.getFilterClass()));
                            return true;
                        }
                    }
                }
            }
        }
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    private List<ServletInfo> getServlets(WebModule wm) {
        try {
            List servlets = (List)wm.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, List<ServletInfo>>(){

                public List<ServletInfo> run(WebAppMetadata metadata) throws Exception {
                    return metadata.getServlets();
                }
            });
            return servlets;
        }
        catch (MetadataModelException e) {
            Logger.global.log(Level.WARNING, "getServlets failed", e);
        }
        catch (IOException e) {
            Logger.global.log(Level.WARNING, "getServlets failed", e);
        }
        return Collections.emptyList();
    }

    private List<FilterInfo> getFilters(WebModule wm) {
        try {
            List filters = (List)wm.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, List<FilterInfo>>(){

                public List<FilterInfo> run(WebAppMetadata metadata) throws Exception {
                    return metadata.getFilters();
                }
            });
            return filters;
        }
        catch (MetadataModelException e) {
            Logger.global.log(Level.WARNING, "getFilters failed", e);
        }
        catch (IOException e) {
            Logger.global.log(Level.WARNING, "getFilters failed", e);
        }
        return Collections.emptyList();
    }

    public HelpCtx getHelp() {
        if (this.evaluator.getFileType() == FileType.SERVLET) {
            return this.wizardPanel.getHelp();
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        if (this.wizardPanel != null) {
            this.wizardPanel.addChangeListener(l);
        }
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
        if (this.wizardPanel != null) {
            this.wizardPanel.removeChangeListener(l);
        }
    }

    public void readSettings(Object settings) {
        if (settings instanceof TemplateWizard) {
            TemplateWizard w = (TemplateWizard)settings;
            String targetName = w.getTargetName();
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)w);
            Project project = Templates.getProject((WizardDescriptor)w);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("java");
            String packageName = null;
            for (int i = 0; i < groups.length && packageName == null; ++i) {
                if (WebModule.getWebModule((FileObject)groups[i].getRootFolder()) == null) continue;
                packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
            }
            packageName = packageName != null ? packageName.replace('/', '.') : "";
            if (targetName == null) {
                this.evaluator.setClassName(w.getTemplate().getName(), packageName);
            } else {
                this.evaluator.setClassName(targetName, packageName);
            }
        }
        this.wizardPanel.setData();
    }

    public void storeSettings(Object settings) {
    }
}

