/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.modules.java.j2seplatform.queries.Bundle;
import org.netbeans.modules.java.j2seplatform.queries.SelectJavadocPanel;
import org.netbeans.modules.java.j2seplatform.queries.SelectSourcesPanel;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public final class SourceJavadocAttacherUtil {
    private SourceJavadocAttacherUtil() {
    }

    public static void callListener(@NonNull SourceJavadocAttacher.AttachmentListener listener, boolean success) {
        if (success) {
            listener.attachmentSucceeded();
        } else {
            listener.attachmentFailed();
        }
    }

    @CheckForNull
    public static List<? extends URI> selectJavadoc(@NonNull URL root, @NonNull Callable<List<? extends String>> browseCall, @NonNull Function<String, URI> convertor) {
        assert (root != null);
        assert (browseCall != null);
        assert (convertor != null);
        SelectJavadocPanel selectJavadoc = new SelectJavadocPanel(SourceJavadocAttacherUtil.getDisplayName(root), browseCall, convertor);
        DialogDescriptor dd = new DialogDescriptor((Object)selectJavadoc, Bundle.TXT_SelectJavadoc());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            try {
                return selectJavadoc.getJavadoc();
            }
            catch (Exception e) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.TXT_InvalidJavadocRoot(), 0));
            }
        }
        return null;
    }

    @CheckForNull
    public static List<? extends URI> selectSources(@NonNull URL root, @NonNull Callable<List<? extends String>> browseCall, @NonNull Function<String, URI> convertor) {
        assert (root != null);
        assert (browseCall != null);
        assert (convertor != null);
        SelectSourcesPanel selectSources = new SelectSourcesPanel(SourceJavadocAttacherUtil.getDisplayName(root), browseCall, convertor);
        DialogDescriptor dd = new DialogDescriptor((Object)selectSources, Bundle.TXT_SelectSources());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            try {
                return selectSources.getSources();
            }
            catch (Exception e) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.TXT_InvalidSourceRoot(), 0));
            }
        }
        return null;
    }

    @NonNull
    public static Callable<List<? extends String>> createDefaultBrowseCall(final @NonNull String title, final @NonNull String filterDescription, final @NonNull File[] currentFolder) {
        assert (title != null);
        assert (filterDescription != null);
        assert (currentFolder != null);
        Callable<List<? extends String>> call = new Callable<List<? extends String>>(){

            @Override
            public List<? extends String> call() throws Exception {
                JFileChooser chooser = new JFileChooser();
                chooser.setMultiSelectionEnabled(true);
                chooser.setFileSelectionMode(2);
                if (Utilities.isMac()) {
                    chooser.putClientProperty("JFileChooser.packageIsTraversable", "always");
                }
                chooser.setDialogTitle(title);
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        try {
                            return f.isDirectory() || FileUtil.isArchiveFile((URL)f.toURI().toURL());
                        }
                        catch (MalformedURLException ex) {
                            return false;
                        }
                    }

                    @Override
                    public String getDescription() {
                        return filterDescription;
                    }
                });
                chooser.setApproveButtonText(Bundle.TXT_Select());
                chooser.setApproveButtonMnemonic(Bundle.MNE_Select().charAt(0));
                if (currentFolder[0] != null) {
                    chooser.setCurrentDirectory(currentFolder[0]);
                }
                if (chooser.showOpenDialog(null) == 0) {
                    currentFolder[0] = chooser.getCurrentDirectory();
                    File[] files = chooser.getSelectedFiles();
                    ArrayList<String> result = new ArrayList<String>(files.length);
                    for (File f : files) {
                        result.add(f.getAbsolutePath());
                    }
                    return result;
                }
                return null;
            }
        };
        return call;
    }

    public static Function<String, URI> createDefaultURIConvertor(final boolean forSources) {
        return new Function<String, URI>(){

            @Override
            public URI call(String param) throws Exception {
                FileObject root;
                File f = new File(param);
                assert (f.isAbsolute());
                FileObject fo = FileUtil.toFileObject((File)f);
                if (fo.isData()) {
                    fo = FileUtil.getArchiveRoot((FileObject)fo);
                }
                FileObject fileObject = root = forSources ? JavadocAndSourceRootDetection.findSourceRoot((FileObject)fo) : JavadocAndSourceRootDetection.findJavadocRoot((FileObject)fo);
                if (root == null) {
                    root = fo;
                }
                return root.getURL().toURI();
            }
        };
    }

    @NonNull
    private static String getDisplayName(@NonNull URL root) {
        URL file = FileUtil.getArchiveFile((URL)root) != null ? FileUtil.getArchiveFile((URL)root) : root;
        FileObject fo = URLMapper.findFileObject((URL)file);
        return fo != null ? fo.getNameExt() : file.getPath();
    }

    public static interface Function<P, R> {
        public R call(P var1) throws Exception;
    }
}

