/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.j2seplatform.libraries.J2SELibraryTypeProvider;
import org.netbeans.modules.java.j2seplatform.libraries.J2SEVolumeCustomizer;
import org.netbeans.modules.java.j2seplatform.queries.SourceJavadocAttacherUtil;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public class J2SELibrarySourceJavadocAttacher
implements SourceJavadocAttacherImplementation {
    public boolean attachSources(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, "src");
    }

    public boolean attachJavadoc(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, "javadoc");
    }

    private boolean attach(final @NonNull URL root, final @NonNull SourceJavadocAttacher.AttachmentListener listener, final @NonNull String volume) {
        final Pair<LibraryManager, Library> pair = this.findOwner(root);
        if (pair == null) {
            return false;
        }
        Runnable call = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LibraryManager lm = (LibraryManager)pair.first;
                Library lib = (Library)pair.second;
                assert (lm != null);
                assert (lib != null);
                boolean success = false;
                try {
                    List<? extends URI> selected;
                    File baseFolder;
                    URL areaLocation = lm.getLocation();
                    File file = baseFolder = areaLocation == null ? null : new File(areaLocation.toURI()).getParentFile();
                    if (volume == "src") {
                        selected = SourceJavadocAttacherUtil.selectSources(root, new SelectFolder(volume, lib.getName(), baseFolder), new Convertor(volume, baseFolder));
                    } else if (volume == "javadoc") {
                        selected = SourceJavadocAttacherUtil.selectJavadoc(root, new SelectFolder(volume, lib.getName(), baseFolder), new Convertor(volume, baseFolder));
                    } else {
                        throw new IllegalStateException();
                    }
                    if (selected != null) {
                        String name = lib.getName();
                        String displayName = lib.getDisplayName();
                        String desc = lib.getDescription();
                        HashMap volumes = new HashMap();
                        for (String currentVolume : J2SELibraryTypeProvider.VOLUME_TYPES) {
                            ArrayList<Object> content = lib.getURIContent(currentVolume);
                            if (volume == currentVolume) {
                                ArrayList<Object> newContent = new ArrayList<Object>(content.size() + selected.size());
                                newContent.addAll(content);
                                newContent.addAll(selected);
                                content = newContent;
                            }
                            volumes.put(currentVolume, content);
                        }
                        lm.removeLibrary(lib);
                        lm.createURILibrary("j2se", name, displayName, desc, volumes);
                        success = true;
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
                catch (URISyntaxException use) {
                    Exceptions.printStackTrace((Throwable)use);
                }
                finally {
                    SourceJavadocAttacherUtil.callListener(listener, success);
                }
            }
        };
        Mutex.EVENT.writeAccess(call);
        return true;
    }

    private Pair<LibraryManager, Library> findOwner(URL root) {
        for (LibraryManager lm : LibraryManager.getOpenManagers()) {
            for (Library l : lm.getLibraries()) {
                List cp;
                if (!"j2se".equals(l.getType()) || !(cp = l.getContent("classpath")).contains(root)) continue;
                return Pair.of(lm, l);
            }
        }
        return null;
    }

    private static class Convertor
    implements SourceJavadocAttacherUtil.Function<String, URI> {
        private final String volume;
        private final File baseFolder;

        private Convertor(@NonNull String volume, @NullAllowed File baseFolder) {
            this.volume = volume;
            this.baseFolder = baseFolder;
        }

        @Override
        public URI call(String param) throws Exception {
            return J2SEVolumeCustomizer.pathToURI(this.baseFolder, param, this.volume);
        }
    }

    private static class SelectFolder
    implements Callable<List<? extends String>> {
        private final String volume;
        private final String libName;
        private final File baseFolder;

        private SelectFolder(@NonNull String volume, @NonNull String libName, @NullAllowed File baseFolder) {
            this.volume = volume;
            this.libName = libName;
            this.baseFolder = baseFolder;
        }

        @Override
        public List<? extends String> call() throws Exception {
            String[] paths = J2SEVolumeCustomizer.select(this.volume, this.libName, new File[1], null, this.baseFolder);
            return paths == null ? null : Arrays.asList(paths);
        }
    }

    private static class Pair<F, S> {
        public final F first;
        public final S second;

        private Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public static <F, S> Pair<F, S> of(F first, S second) {
            return new Pair<F, S>(first, second);
        }
    }
}

