/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.ProxyTag;
import org.netbeans.modules.web.jsf.editor.facelets.TagImpl;
import org.netbeans.modules.web.jsf.editor.index.IndexedFile;
import org.netbeans.modules.web.jsf.editor.index.JsfIndex;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TldProxyLibraryDescriptor
implements LibraryDescriptor {
    private LibraryDescriptor source;
    private LibraryDescriptor tld;

    public TldProxyLibraryDescriptor(LibraryDescriptor source, JsfIndex index) {
        this.source = source;
        this.initTLD(index);
    }

    @Override
    public String getNamespace() {
        return this.source.getNamespace();
    }

    @Override
    public Map<String, Tag> getTags() {
        if (this.tld == null) {
            return this.source.getTags();
        }
        Map<String, Tag> s = this.source.getTags();
        Map<String, Tag> t = this.tld.getTags();
        HashMap<String, Tag> result = new HashMap<String, Tag>();
        HashSet<String> allTagNames = new HashSet<String>();
        allTagNames.addAll(s.keySet());
        allTagNames.addAll(t.keySet());
        for (String tagName : allTagNames) {
            result.put(tagName, new ProxyTag(s.get(tagName), t.get(tagName)));
        }
        return result;
    }

    private void initTLD(JsfIndex index) {
        IndexedFile file = index.getTagLibraryDescriptor(this.getNamespace());
        if (file == null) {
            return;
        }
        try {
            InputStream is = file.getFile().getInputStream();
            this.tld = this.parseTLD(is);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected LibraryDescriptor parseTLD(InputStream content) throws ParserConfigurationException, SAXException, IOException {
        final HashMap<String, TagImpl> tags = new HashMap<String, TagImpl>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        InputSource is = new InputSource(content);
        docBuilder.setEntityResolver(UserCatalog.getDefault().getEntityResolver());
        Document doc = docBuilder.parse(is);
        Node tagLib = FaceletsLibraryDescriptor.getNodeByName(doc, "taglib");
        String prefix = this.getTextContent(tagLib, "short-name");
        String uri = this.getTextContent(tagLib, "uri");
        String displayName = this.getTextContent(tagLib, "display-name");
        NodeList tagNodes = doc.getElementsByTagName("tag");
        if (tagNodes != null) {
            for (int i = 0; i < tagNodes.getLength(); ++i) {
                Node tag = tagNodes.item(i);
                String tagName = this.getTextContent(tag, "name");
                String tagDescription = this.getTextContent(tag, "description");
                HashMap<String, Attribute> attrs = new HashMap<String, Attribute>();
                for (Node attrNode : FaceletsLibraryDescriptor.getNodesByName(tag, "attribute")) {
                    String aName = this.getTextContent(attrNode, "name");
                    String aDescription = this.getTextContent(attrNode, "description");
                    boolean aRequired = Boolean.parseBoolean(this.getTextContent(attrNode, "required"));
                    attrs.put(aName, (Attribute)new Attribute.DefaultAttribute(aName, aDescription, aRequired));
                }
                tags.put(tagName, new TagImpl(tagName, tagDescription, attrs));
            }
        }
        return new LibraryDescriptor(){

            @Override
            public String getNamespace() {
                return TldProxyLibraryDescriptor.this.getNamespace();
            }

            @Override
            public Map<String, Tag> getTags() {
                return tags;
            }
        };
    }

    private String getTextContent(Node node, String name) {
        return FaceletsLibraryDescriptor.getTextContent(node, name);
    }
}

