/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.ProxyTag;
import org.netbeans.modules.web.jsfapi.api.Tag;

public class CompositeLibraryDescriptor
implements LibraryDescriptor {
    private LibraryDescriptor first;
    private LibraryDescriptor second;

    public CompositeLibraryDescriptor(LibraryDescriptor first, LibraryDescriptor second) {
        this.first = first;
        this.second = second;
        if (first.getNamespace() != null && second.getNamespace() != null && !first.getNamespace().equals(second.getNamespace())) {
            throw new IllegalArgumentException(String.format("Both libraries must declare the same namespace if there's any. Currently the first one declares %s and the second %s!", first.getNamespace(), second.getNamespace()));
        }
    }

    @Override
    public String getNamespace() {
        return this.first.getNamespace() != null ? this.first.getNamespace() : this.second.getNamespace();
    }

    @Override
    public Map<String, Tag> getTags() {
        Map<String, Tag> s = this.first.getTags();
        Map<String, Tag> t = this.second.getTags();
        HashMap<String, Tag> result = new HashMap<String, Tag>();
        HashSet<String> allTagNames = new HashSet<String>();
        allTagNames.addAll(s.keySet());
        allTagNames.addAll(t.keySet());
        for (String tagName : allTagNames) {
            result.put(tagName, new ProxyTag(s.get(tagName), t.get(tagName)));
        }
        return result;
    }
}

