/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.fixes;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.support.AddOperationCookie;
import org.netbeans.modules.websvc.core.WebServiceActionProvider;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotation;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AddWSOperation
implements Fix {
    private FileObject fileObject;

    public AddWSOperation(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public ChangeInfo implement() {
        AddOperationCookie addOperationCookie = WebServiceActionProvider.getAddOperationAction((FileObject)this.fileObject);
        if (addOperationCookie == null) {
            Project project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
            final JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)this.fileObject);
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    if (saveCookie != null) {
                        jaxWsModel.addServiceListener(new JaxWsModel.ServiceListener(){

                            public void serviceAdded(String string, String string2) {
                                AddWSOperation.this.detachListener(jaxWsModel, this);
                                AddOperationCookie addOperationCookie = WebServiceActionProvider.getAddOperationAction((FileObject)AddWSOperation.this.fileObject);
                                if (addOperationCookie != null) {
                                    addOperationCookie.addOperation();
                                }
                            }

                            public void serviceRemoved(String string) {
                            }
                        });
                        saveCookie.save();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(AddWSOperation.class.getName()).log(Level.INFO, "Cannot save file", iOException);
                }
            }
        } else {
            addOperationCookie.addOperation();
        }
        return null;
    }

    private void detachListener(final JaxWsModel jaxWsModel, final JaxWsModel.ServiceListener serviceListener) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                jaxWsModel.removeServiceListener(serviceListener);
            }
        });
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getText() {
        if (WebServiceActionProvider.getAddOperationAction((FileObject)this.fileObject) == null) {
            return NbBundle.getMessage(RemoveAnnotation.class, (String)"LBL_SaveAndAddWSOperation");
        }
        return NbBundle.getMessage(RemoveAnnotation.class, (String)"LBL_AddWSOperation");
    }
}

