/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.views;

import java.awt.BorderLayout;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.netbeans.modules.debugger.jpda.visual.views.ViewModelListener;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class View
extends TopComponent
implements HelpCtx.Provider {
    public static final String EVENTS_VIEW_NAME = "EventsView";
    private transient JComponent contentComponent;
    private transient ViewModelListener viewModelListener;
    private String name;
    private transient String helpID;
    private transient String propertiesHelpID;
    private transient String displayNameResource;
    private transient String toolTipResource;

    private View(String icon, String name, String helpID, String propertiesHelpID, String displayNameResource, String toolTipResource) {
        this.setIcon(ImageUtilities.loadImage((String)icon));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
        this.name = name;
        this.helpID = helpID;
        this.propertiesHelpID = propertiesHelpID;
        this.displayNameResource = displayNameResource;
        this.toolTipResource = toolTipResource;
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getPackage().getName() + "." + this.name;
    }

    protected void componentShowing() {
        JComponent buttonsPane;
        super.componentShowing();
        if (this.viewModelListener != null) {
            this.viewModelListener.setUp();
            return;
        }
        if (this.contentComponent == null) {
            this.setLayout(new BorderLayout());
            this.contentComponent = new JPanel(new BorderLayout());
            this.contentComponent.setName(NbBundle.getMessage(View.class, (String)this.toolTipResource));
            this.add(this.contentComponent, "Center");
            JToolBar toolBar = new JToolBar(1);
            toolBar.setFloatable(false);
            toolBar.setRollover(true);
            toolBar.setBorderPainted(true);
            if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                toolBar.setBackground(UIManager.getColor("NbExplorerView.background"));
            }
            toolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getDefaults().getColor("Separator.background")), BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getDefaults().getColor("Separator.foreground"))));
            this.add(toolBar, "West");
            buttonsPane = toolBar;
        } else {
            buttonsPane = (JComponent)((BorderLayout)this.getLayout()).getLayoutComponent("West");
        }
        this.viewModelListener = new ViewModelListener(this.name, this.contentComponent, buttonsPane, this.propertiesHelpID, this.getIcon());
    }

    protected void componentHidden() {
        super.componentHidden();
        if (this.viewModelListener != null) {
            this.viewModelListener.destroy();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.helpID);
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.contentComponent == null) {
            return false;
        }
        if (this.contentComponent.getComponentCount() > 0) {
            return this.contentComponent.getComponent(0).requestFocusInWindow();
        }
        return this.contentComponent.requestFocusInWindow();
    }

    public void requestActive() {
        super.requestActive();
        if (this.contentComponent != null) {
            if (this.contentComponent.getComponentCount() > 0) {
                this.contentComponent.getComponent(0).requestFocusInWindow();
            } else {
                this.contentComponent.requestFocusInWindow();
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(View.class, (String)this.displayNameResource);
    }

    public String getToolTipText() {
        return NbBundle.getMessage(View.class, (String)this.toolTipResource);
    }

    public Object writeReplace() {
        return new ResolvableHelper(this.name);
    }

    public static synchronized TopComponent getEventsView() {
        return new View("org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint.gif", EVENTS_VIEW_NAME, "NetbeansDebuggerEventNode", null, "CTL_Events_view", "CTL_Events_view_tooltip");
    }

    public static TopComponent getView(String viewName) {
        if (viewName.equals(EVENTS_VIEW_NAME)) {
            return View.getEventsView();
        }
        throw new IllegalArgumentException(viewName);
    }

    private static final class ResolvableHelper
    implements Externalizable {
        private String name;
        private static final long serialVersionUID = 1L;

        public ResolvableHelper(String name) {
            this.name = name;
        }

        public ResolvableHelper() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.name);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = (String)in.readObject();
        }

        public Object readResolve() {
            return View.getView(this.name);
        }
    }
}

