/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ConditionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ControllerProvider;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteAWTScreenshot;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.AWTComponentBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.ComponentBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.FXComponentBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.spi.ScreenshotUIManager;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ComponentBreakpointPanel
extends JPanel
implements ControllerProvider {
    private static final String HELP_ID = "NetbeansDebuggerBreakpointComponentJPDA";
    private ComponentBreakpoint breakpoint;
    private LineBreakpoint fakeActionsBP;
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private CBController controller = new CBController();
    private boolean createBreakpoint = false;
    private JPanel aPanel;
    private JCheckBox addRemoveCheckBox;
    private JPanel cPanel;
    private JLabel componentActionLabel;
    private JLabel componentLabel;
    private JTextField componentTextField;
    private JPanel pushPanel;
    private JCheckBox repaintCheckBox;
    private JPanel sPanel;
    private JCheckBox showHideCheckBox;

    private static ComponentBreakpoint createBreakpoint() {
        ComponentBreakpoint cb = null;
        ComponentBreakpoint.ComponentDescription componentDescription = null;
        ScreenshotUIManager activeScreenshotManager = ScreenshotUIManager.getActive();
        if (activeScreenshotManager != null) {
            ComponentInfo ci = activeScreenshotManager.getSelectedComponent();
            if (ci instanceof JavaComponentInfo) {
                componentDescription = new ComponentBreakpoint.ComponentDescription(ci, (JPDADebugger)((JavaComponentInfo)ci).getThread().getDebugger(), ((JavaComponentInfo)ci).getComponent());
            }
            if (componentDescription == null) {
                componentDescription = new ComponentBreakpoint.ComponentDescription("");
            }
            cb = ci instanceof RemoteAWTScreenshot.AWTComponentInfo ? new AWTComponentBreakpoint(componentDescription) : new FXComponentBreakpoint(componentDescription);
        }
        return cb;
    }

    public ComponentBreakpointPanel() {
        this(ComponentBreakpointPanel.createBreakpoint(), true);
    }

    public ComponentBreakpointPanel(ComponentBreakpoint cb) {
        this(cb, false);
    }

    public ComponentBreakpointPanel(ComponentBreakpoint cb, boolean createBreakpoint) {
        this.breakpoint = cb;
        this.createBreakpoint = createBreakpoint;
        this.initComponents();
        int type = cb.getType();
        String componentName = "";
        if (cb.getComponent() != null && cb.getComponent().getComponentInfo() != null) {
            componentName = cb.getComponent().getComponentInfo().getDisplayName();
        }
        this.componentTextField.setText(componentName);
        this.addRemoveCheckBox.setSelected((type & 1) != 0 || (type & 2) != 0);
        this.addRemoveCheckBox.setVisible((3 & cb.supportedTypes()) > 0);
        this.showHideCheckBox.setSelected((type & 4) != 0 || (type & 8) != 0);
        this.showHideCheckBox.setVisible((0xC & cb.supportedTypes()) > 0);
        this.repaintCheckBox.setSelected((type & 0x10) != 0);
        this.repaintCheckBox.setVisible((0x10 & cb.supportedTypes()) > 0);
        this.conditionsPanel = new ConditionsPanel(HELP_ID);
        this.conditionsPanel.setupConditionPaneContext();
        this.conditionsPanel.showClassFilter(false);
        this.conditionsPanel.setCondition(cb.getCondition());
        this.conditionsPanel.setHitCountFilteringStyle(cb.getHitCountFilteringStyle());
        this.conditionsPanel.setHitCount(cb.getHitCountFilter());
        this.cPanel.add((Component)this.conditionsPanel, "Center");
        this.fakeActionsBP = LineBreakpoint.create((String)"", (int)0);
        this.fakeActionsBP.setPrintText(NbBundle.getBundle(ComponentBreakpointPanel.class).getString("CTL_Component_Breakpoint_Print_Text"));
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)this.fakeActionsBP);
        this.aPanel.add((Component)this.actionsPanel, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentBreakpointPanel.this.controller.checkValid();
            }
        });
    }

    public Controller getController() {
        return this.controller;
    }

    private void initComponents() {
        this.sPanel = new JPanel();
        this.componentLabel = new JLabel();
        this.componentTextField = new JTextField();
        this.componentActionLabel = new JLabel();
        this.addRemoveCheckBox = new JCheckBox();
        this.showHideCheckBox = new JCheckBox();
        this.repaintCheckBox = new JCheckBox();
        this.cPanel = new JPanel();
        this.aPanel = new JPanel();
        this.pushPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.sPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ComponentBreakpointPanel.class, (String)"TTL_ComponentBreakpointSettings")));
        this.componentLabel.setText(NbBundle.getMessage(ComponentBreakpointPanel.class, (String)"ComponentBreakpointPanel.componentLabel.text"));
        this.componentTextField.setEditable(false);
        this.componentTextField.setText(NbBundle.getMessage(ComponentBreakpointPanel.class, (String)"ComponentBreakpointPanel.componentTextField.text"));
        this.componentActionLabel.setText(NbBundle.getMessage(ComponentBreakpointPanel.class, (String)"ComponentBreakpointPanel.componentActionLabel.text"));
        this.addRemoveCheckBox.setText(NbBundle.getMessage(ComponentBreakpointPanel.class, (String)"ComponentBreakpointPanel.addRemoveCheckBox.text"));
        this.showHideCheckBox.setText(NbBundle.getMessage(ComponentBreakpointPanel.class, (String)"ComponentBreakpointPanel.showHideCheckBox.text"));
        this.repaintCheckBox.setText(NbBundle.getMessage(ComponentBreakpointPanel.class, (String)"ComponentBreakpointPanel.repaintCheckBox.text"));
        GroupLayout sPanelLayout = new GroupLayout(this.sPanel);
        this.sPanel.setLayout(sPanelLayout);
        sPanelLayout.setHorizontalGroup(sPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sPanelLayout.createSequentialGroup().addComponent(this.componentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.componentTextField, -1, 291, Short.MAX_VALUE)).addGroup(sPanelLayout.createSequentialGroup().addComponent(this.componentActionLabel).addContainerGap()).addGroup(sPanelLayout.createSequentialGroup().addContainerGap().addGroup(sPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.showHideCheckBox, GroupLayout.Alignment.LEADING).addComponent(this.addRemoveCheckBox, GroupLayout.Alignment.LEADING)).addContainerGap(173, Short.MAX_VALUE)).addGroup(sPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.repaintCheckBox).addContainerGap(289, Short.MAX_VALUE)));
        sPanelLayout.setVerticalGroup(sPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sPanelLayout.createSequentialGroup().addGroup(sPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.componentLabel).addComponent(this.componentTextField, -2, -1, -2)).addGap(2, 2, 2).addComponent(this.componentActionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addRemoveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showHideCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.repaintCheckBox)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.sPanel, gridBagConstraints);
        this.cPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cPanel, gridBagConstraints);
        this.aPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.aPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pushPanel, gridBagConstraints);
    }

    private class CBController
    implements Controller {
        private boolean valid;
        private String errMsg = null;

        private CBController() {
        }

        public boolean ok() {
            if (!this.valid) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.errMsg));
                return false;
            }
            ComponentBreakpointPanel.this.actionsPanel.ok();
            int type = (ComponentBreakpointPanel.this.addRemoveCheckBox.isSelected() ? 3 : 0) | (ComponentBreakpointPanel.this.showHideCheckBox.isSelected() ? 12 : 0) | (ComponentBreakpointPanel.this.repaintCheckBox.isSelected() ? 16 : 0);
            ComponentBreakpointPanel.this.breakpoint.setType(type);
            ComponentBreakpointPanel.this.breakpoint.setCondition(ComponentBreakpointPanel.this.conditionsPanel.getCondition());
            ComponentBreakpointPanel.this.breakpoint.setHitCountFilter(ComponentBreakpointPanel.this.conditionsPanel.getHitCount(), ComponentBreakpointPanel.this.conditionsPanel.getHitCountFilteringStyle());
            ComponentBreakpointPanel.this.breakpoint.setSuspend(ComponentBreakpointPanel.this.fakeActionsBP.getSuspend());
            ComponentBreakpointPanel.this.breakpoint.setPrintText(ComponentBreakpointPanel.this.fakeActionsBP.getPrintText());
            if (ComponentBreakpointPanel.this.createBreakpoint) {
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)ComponentBreakpointPanel.this.breakpoint);
            }
            return true;
        }

        public boolean cancel() {
            return true;
        }

        private void setValid(boolean valid) {
            this.valid = valid;
            ComponentBreakpointPanel.this.firePropertyChange("valid", !valid, valid);
        }

        private void checkValid() {
            ComponentBreakpoint.ComponentDescription component = ComponentBreakpointPanel.this.breakpoint.getComponent();
            if (component == null || component.getComponentInfo() == null) {
                this.setErrorMessage(NbBundle.getMessage(ComponentBreakpointPanel.class, (String)"MSG_No_Component_Spec"));
                this.setValid(false);
            } else {
                this.setValid(true);
            }
        }

        private void setErrorMessage(String msg) {
            this.errMsg = msg;
            ComponentBreakpointPanel.this.firePropertyChange("errorNotification", null, msg);
        }

        public boolean isValid() {
            return this.valid;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            ComponentBreakpointPanel.this.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            ComponentBreakpointPanel.this.removePropertyChangeListener(l);
        }
    }
}

