/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.actions;

import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToSourceAction;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class GoToAddIntoHierarchyAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
            if (ci == null) continue;
            JavaComponentInfo.Stack stack = ci.getAddCallStack();
            String type = null;
            int line = -1;
            if (stack != null) {
                JavaComponentInfo.Stack.Frame[] frames = stack.getFrames();
                for (int i = 0; i < frames.length; ++i) {
                    String className = frames[i].getClassName();
                    String methodName = frames[i].getMethodName();
                    if (!JavaComponentInfo.isCustomType(className) && (methodName.startsWith("add") || methodName.startsWith("onChanged") || methodName.startsWith("setParent") || methodName.startsWith("callObservers"))) continue;
                    type = className;
                    line = frames[i].getLineNumber();
                    break;
                }
                if (type == null) {
                    JavaComponentInfo.Stack.Frame f = frames.length > 1 ? frames[1] : frames[0];
                    type = f.getClassName();
                    line = f.getLineNumber();
                }
            } else {
                return;
            }
            final String showType = type;
            final int showLine = line;
            GoToSourceAction.RP.post(new Runnable(){

                @Override
                public void run() {
                    GoToAddIntoHierarchyAction.this.showSource(showType, showLine);
                }
            });
        }
    }

    private void showSource(String type, final int lineNumber) {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine != null) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            type = EditorContextBridge.getRelativePath((String)type);
            final String url = ((JPDADebuggerImpl)debugger).getEngineContext().getURL(type, true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorContextBridge.getContext().showSource(url, lineNumber, null);
                }
            });
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            JavaComponentInfo.Stack stack;
            JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
            if (ci == null || (stack = ci.getAddCallStack()) == null) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(GoToAddIntoHierarchyAction.class, (String)"CTL_GoToHierarchyAdditionSource");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(GoToAddIntoHierarchyAction.class);
    }
}

