/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.WatchpointEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteServices;
import org.netbeans.modules.debugger.jpda.visual.ui.ScreenshotComponent;
import org.openide.util.Exceptions;

public class VisualDebuggerListener
extends DebuggerManagerAdapter {
    private static final Logger logger = Logger.getLogger(VisualDebuggerListener.class.getName());
    private static final Map<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>> componentsAndStackTraces = new WeakHashMap<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>>();
    private Collection<Breakpoint> trackComponentBreakpoints = new ArrayList<Breakpoint>();

    public void engineAdded(DebuggerEngine engine) {
        final JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA.visual");
        boolean uploadAgent = p.getBoolean("UploadAgent", true);
        logger.log(Level.FINE, "engineAdded({0}), debugger = {1}, uploadAgent = {2}", new Object[]{engine, debugger, uploadAgent});
        if (debugger != null && uploadAgent) {
            final AtomicBoolean inited = new AtomicBoolean(false);
            final MethodBreakpoint[] mb = new MethodBreakpoint[]{MethodBreakpoint.create((String)"java.awt.EventQueue", (String)"getNextEvent"), MethodBreakpoint.create((String)"com.sun.javafx.tk.quantum.QuantumToolkit", (String)"pulse")};
            mb[0].setBreakpointType(1);
            mb[0].setSuspend(1);
            mb[0].setHidden(true);
            mb[0].addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    if (debugger.equals(event.getDebugger())) {
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb[0]);
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb[1]);
                        if (inited.compareAndSet(false, true)) {
                            VisualDebuggerListener.this.initDebuggerRemoteService(event.getThread(), RemoteServices.ServiceType.AWT);
                        }
                    }
                    event.resume();
                }
            });
            mb[1].setBreakpointType(1);
            mb[1].setSuspend(1);
            mb[1].setHidden(true);
            mb[1].addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    if (debugger.equals(event.getDebugger())) {
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb[0]);
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb[1]);
                        if (inited.compareAndSet(false, true)) {
                            VisualDebuggerListener.this.initDebuggerRemoteService(event.getThread(), RemoteServices.ServiceType.FX);
                        }
                    }
                    event.resume();
                }
            });
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb[0]);
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb[1]);
        }
        boolean trackComponentChanges = p.getBoolean("TrackComponentChanges", false);
        if (debugger != null && trackComponentChanges) {
            FieldBreakpoint fb = FieldBreakpoint.create((String)"java.awt.Component", (String)"parent", (int)2);
            fb.setHidden(true);
            fb.addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    VisualDebuggerListener.componentParentChanged(debugger, event);
                    event.resume();
                }
            });
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)fb);
            this.trackComponentBreakpoints.add((Breakpoint)fb);
            MethodBreakpoint mb = MethodBreakpoint.create((String)"javafx.scene.Node", (String)"setParent");
            mb.setHidden(true);
            mb.addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    VisualDebuggerListener.componentParentChanged(debugger, event);
                    event.resume();
                }
            });
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
            this.trackComponentBreakpoints.add((Breakpoint)mb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDebuggerRemoteService(JPDAThread thread, RemoteServices.ServiceType sType) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "initDebuggerRemoteService({0})", thread);
        }
        ClassObjectReference cor = null;
        try {
            cor = RemoteServices.uploadBasicClasses((JPDAThreadImpl)thread, sType);
        }
        catch (PropertyVetoException pvex) {
            Exceptions.printStackTrace((Throwable)pvex);
        }
        catch (InvalidTypeException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ClassNotLoadedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IncompatibleThreadStateException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationException ex) {
            InvocationExceptionTranslated iextr = new InvocationExceptionTranslated(ex, ((JPDAThreadImpl)thread).getDebugger());
            iextr.setPreferredThread((JPDAThreadImpl)thread);
            iextr.getMessage();
            iextr.getLocalizedMessage();
            iextr.getCause();
            iextr.getStackTrace();
            Exceptions.printStackTrace((Throwable)iextr);
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Uploaded class = {0}", cor);
        }
        if (cor == null) {
            return;
        }
        JPDAThreadImpl t = (JPDAThreadImpl)thread;
        ThreadReference tr = t.getThreadReference();
        VirtualMachine vm = tr.virtualMachine();
        ClassType serviceClass = (ClassType)cor.reflectedType();
        Method startMethod = serviceClass.concreteMethodByName("startAccessLoop", "()V");
        try {
            t.notifyMethodInvoking();
            serviceClass.invokeMethod(tr, startMethod, Collections.EMPTY_LIST, 1);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            t.notifyMethodInvokeDone();
            cor.enableCollection();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("The RemoteServiceClass is there: " + RemoteServices.getClass(vm, "org.netbeans.modules.debugger.jpda.visual.remote.RemoteService"));
        }
    }

    public void engineRemoved(DebuggerEngine engine) {
        ScreenshotComponent.closeScreenshots(engine);
        JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        logger.fine("engineRemoved(" + engine + "), debugger = " + debugger);
        if (debugger != null) {
            this.stopDebuggerRemoteService(debugger);
        }
        if (!this.trackComponentBreakpoints.isEmpty()) {
            Iterator<Breakpoint> it = this.trackComponentBreakpoints.iterator();
            while (it.hasNext()) {
                DebuggerManager.getDebuggerManager().removeBreakpoint(it.next());
                it.remove();
            }
        }
    }

    private void stopDebuggerRemoteService(JPDADebugger d) {
        ClassObjectReference serviceClass = RemoteServices.getServiceClass(d);
        if (serviceClass == null) {
            return;
        }
        try {
            serviceClass.enableCollection();
        }
        catch (VMDisconnectedException vdex) {
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaComponentInfo.Stack getStackOf(JPDADebugger debugger, ObjectReference component) {
        Map<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>> map = componentsAndStackTraces;
        synchronized (map) {
            Map<ObjectReference, JavaComponentInfo.Stack> cs = componentsAndStackTraces.get(debugger);
            if (cs != null) {
                return cs.get(component);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void componentParentChanged(JPDADebugger debugger, JPDABreakpointEvent event) {
        ObjectReference component = null;
        try {
            Field f = event.getClass().getDeclaredField("event");
            f.setAccessible(true);
            Event jdievent = (Event)f.get(event);
            if (jdievent instanceof WatchpointEvent) {
                component = ((WatchpointEvent)jdievent).object();
            } else {
                JPDAThread t = event.getThread();
                JDIVariable v = (JDIVariable)t.getCallStack(0, 1)[0].getThisVariable();
                component = (ObjectReference)v.getJDIValue();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (component != null) {
            JavaComponentInfo.Stack stack;
            try {
                stack = new JavaComponentInfo.Stack(event.getThread().getCallStack());
            }
            catch (AbsentInformationException ex) {
                return;
            }
            Map<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>> map = componentsAndStackTraces;
            synchronized (map) {
                Map<ObjectReference, JavaComponentInfo.Stack> componentAndStackTrace = componentsAndStackTraces.get(debugger);
                if (componentAndStackTrace == null) {
                    componentAndStackTrace = new HashMap<ObjectReference, JavaComponentInfo.Stack>();
                    componentsAndStackTraces.put(debugger, componentAndStackTrace);
                }
                componentAndStackTrace.put(component, stack);
            }
        }
    }
}

