/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteAWTScreenshot;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public class RemoteServices {
    private static final Logger logger = Logger.getLogger(RemoteServices.class.getName());
    private static final String REMOTE_CLASSES_ZIPFILE = "/org/netbeans/modules/debugger/jpda/visual/resources/debugger-remote.zip";
    private static final Map<JPDADebugger, ClassObjectReference> remoteServiceClasses = new WeakHashMap<JPDADebugger, ClassObjectReference>();
    private static final RequestProcessor AUTORESUME_AFTER_SUSPEND_RP = new RequestProcessor("Autoresume after suspend", 1);
    private static final Set<PropertyChangeListener> serviceListeners = new WeakSet();
    private static final Map<JPDAThread, RequestProcessor.Task> tasksByThreads = new WeakHashMap<JPDAThread, RequestProcessor.Task>();

    private RemoteServices() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServiceListener(PropertyChangeListener listener) {
        Set<PropertyChangeListener> set = serviceListeners;
        synchronized (set) {
            serviceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireServiceClass(JPDADebuggerImpl debugger) {
        PropertyChangeListener[] listeners;
        PropertyChangeEvent pche = new PropertyChangeEvent(RemoteServices.class, "serviceClass", null, debugger);
        Set<PropertyChangeListener> set = serviceListeners;
        synchronized (set) {
            listeners = serviceListeners.toArray(new PropertyChangeListener[0]);
        }
        for (PropertyChangeListener l : listeners) {
            l.propertyChange(pche);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassObjectReference uploadBasicClasses(JPDAThreadImpl t, ServiceType sType) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, IOException, PropertyVetoException {
        ThreadReference tawt = t.getThreadReference();
        VirtualMachine vm = tawt.virtualMachine();
        ReferenceType threadType = tawt.referenceType();
        Method getContextCl = ((ClassType)threadType).concreteMethodByName("getContextClassLoader", "()Ljava/lang/ClassLoader;");
        ObjectReference cl = (ObjectReference)tawt.invokeMethod(tawt, getContextCl, Collections.EMPTY_LIST, 1);
        t.notifyMethodInvoking();
        try {
            ClassType classLoaderClass = null;
            if (cl != null) {
                classLoaderClass = (ClassType)cl.referenceType();
            } else {
                classLoaderClass = RemoteServices.getClass(vm, ClassLoader.class.getName());
                Method getSystemClassLoader = classLoaderClass.concreteMethodByName("getSystemClassLoader", "()Ljava/lang/ClassLoader;");
                cl = (ObjectReference)classLoaderClass.invokeMethod(tawt, getSystemClassLoader, Collections.EMPTY_LIST, 1);
            }
            List<RemoteClass> remoteClasses = RemoteServices.getRemoteClasses();
            ObjectReference basicClass = null;
            for (RemoteClass rc : remoteClasses) {
                if ((sType != ServiceType.AWT || !rc.name.contains("AWT")) && (sType != ServiceType.FX || !rc.name.contains("FX"))) continue;
                ClassObjectReference theUploadedClass = null;
                ArrayReference byteArray = RemoteServices.createTargetBytes(vm, rc.bytes);
                ObjectReference nameMirror = null;
                try {
                    Method defineClass = classLoaderClass.concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
                    boolean uploaded = false;
                    while (!uploaded) {
                        nameMirror = vm.mirrorOf(rc.name);
                        try {
                            nameMirror.disableCollection();
                            uploaded = true;
                        }
                        catch (ObjectCollectedException ocex) {}
                    }
                    uploaded = false;
                    while (!uploaded) {
                        theUploadedClass = (ClassObjectReference)cl.invokeMethod(tawt, defineClass, Arrays.asList(nameMirror, byteArray, vm.mirrorOf(0), vm.mirrorOf(rc.bytes.length)), 1);
                        if (basicClass == null && rc.name.indexOf(36) < 0) {
                            try {
                                theUploadedClass.disableCollection();
                                basicClass = theUploadedClass;
                                uploaded = true;
                            }
                            catch (ObjectCollectedException ocex) {}
                            continue;
                        }
                        uploaded = true;
                    }
                }
                finally {
                    byteArray.enableCollection();
                    if (nameMirror == null) continue;
                    nameMirror.enableCollection();
                }
            }
            if (basicClass != null) {
                ClassType theClass = RemoteServices.getClass(vm, Class.class.getName());
                Method newInstance = theClass.concreteMethodByName("newInstance", "()Ljava/lang/Object;");
                ObjectReference newInstanceOfBasicClass = (ObjectReference)basicClass.invokeMethod(tawt, newInstance, Collections.EMPTY_LIST, 1);
                Map<JPDADebugger, ClassObjectReference> map = remoteServiceClasses;
                synchronized (map) {
                    remoteServiceClasses.put((JPDADebugger)t.getDebugger(), (ClassObjectReference)basicClass);
                }
                RemoteServices.fireServiceClass(t.getDebugger());
            }
            ObjectReference objectReference = basicClass;
            return objectReference;
        }
        finally {
            t.notifyMethodInvokeDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadAllClasses(JPDAThreadImpl t) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, IOException {
        ThreadReference tawt = t.getThreadReference();
        VirtualMachine vm = tawt.virtualMachine();
        ClassType classLoaderClass = RemoteServices.getClass(vm, ClassLoader.class.getName());
        Method getSystemClassLoader = classLoaderClass.concreteMethodByName("getSystemClassLoader", "()Ljava/lang/ClassLoader;");
        ObjectReference systemClassLoader = (ObjectReference)classLoaderClass.invokeMethod(tawt, getSystemClassLoader, Collections.EMPTY_LIST, 1);
        List<RemoteClass> remoteClasses = RemoteServices.getRemoteClasses();
        for (RemoteClass rc : remoteClasses) {
            ArrayReference byteArray = RemoteServices.createTargetBytes(vm, rc.bytes);
            try {
                Method defineClass = classLoaderClass.concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
                systemClassLoader.invokeMethod(tawt, defineClass, Arrays.asList(vm.mirrorOf(rc.name), byteArray, vm.mirrorOf(0), vm.mirrorOf(rc.bytes.length)), 1);
            }
            finally {
                byteArray.enableCollection();
            }
        }
    }

    private static void runOnBreakpoint(JPDAThread awtThread, String bpClass, String bpMethod, Runnable runnable, CountDownLatch latch) {
        MethodBreakpoint mb = MethodBreakpoint.create((String)bpClass, (String)bpMethod);
        JPDADebuggerImpl dbg = ((JPDAThreadImpl)awtThread).getDebugger();
        mb.setBreakpointType(1);
        mb.setSuspend(1);
        mb.setHidden(true);
        mb.addJPDABreakpointListener(new JPDABreakpointListener((JPDADebugger)dbg, mb, awtThread, runnable, latch){
            final /* synthetic */ JPDADebugger val$dbg;
            final /* synthetic */ MethodBreakpoint val$mb;
            final /* synthetic */ JPDAThread val$awtThread;
            final /* synthetic */ Runnable val$runnable;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$dbg = jPDADebugger;
                this.val$mb = methodBreakpoint;
                this.val$awtThread = jPDAThread;
                this.val$runnable = runnable;
                this.val$latch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void breakpointReached(JPDABreakpointEvent event) {
                try {
                    if (!this.val$dbg.equals(event.getDebugger())) return;
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.val$mb);
                    try {
                        ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvoking();
                        this.val$runnable.run();
                        return;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        return;
                    }
                    finally {
                        ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvokeDone();
                    }
                }
                finally {
                    event.resume();
                    this.val$latch.countDown();
                }
            }
        });
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnStoppedThread(JPDAThread thread, Runnable run, ServiceType sType) throws PropertyVetoException {
        block28: {
            JPDAThreadImpl t = (JPDAThreadImpl)thread;
            boolean wasSuspended = true;
            t.accessLock.writeLock().lock();
            try {
                RequestProcessor.Task autoresumeTask;
                ThreadReference threadReference = t.getThreadReference();
                wasSuspended = t.isSuspended();
                if (!t.isSuspended() || !threadReference.isAtBreakpoint()) {
                    // empty if block
                }
                if (!t.isSuspended()) {
                    CountDownLatch latch = new CountDownLatch(1);
                    t.accessLock.writeLock().unlock();
                    switch (sType) {
                        case AWT: {
                            ClassObjectReference serviceClassObject;
                            RemoteServices.runOnBreakpoint(thread, "org.netbeans.modules.debugger.jpda.visual.remote.RemoteAWTService", "calledInAWT", run, latch);
                            VirtualMachine vm = ((JPDAThreadImpl)thread).getThreadReference().virtualMachine();
                            Map<JPDADebugger, ClassObjectReference> map = remoteServiceClasses;
                            synchronized (map) {
                                serviceClassObject = remoteServiceClasses.get(((JPDAThreadImpl)thread).getDebugger());
                            }
                            ClassType serviceClass = (ClassType)serviceClassObject.reflectedType();
                            Field awtAccess = serviceClass.fieldByName("awtAccess");
                            try {
                                serviceClass.setValue(awtAccess, vm.mirrorOf(true));
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            break;
                        }
                        case FX: {
                            RemoteServices.runOnBreakpoint(thread, "org.netbeans.modules.debugger.jpda.visual.remote.RemoteFXService", "access", run, latch);
                        }
                    }
                    try {
                        latch.await();
                        t.accessLock.writeLock().lock();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    break block28;
                }
                if (!wasSuspended) {
                    AutoresumeTask resumeTask = new AutoresumeTask(t);
                    autoresumeTask = AUTORESUME_AFTER_SUSPEND_RP.create((Runnable)resumeTask);
                    Map<JPDAThread, RequestProcessor.Task> map = tasksByThreads;
                    synchronized (map) {
                        tasksByThreads.put(thread, autoresumeTask);
                    }
                }
                Map<JPDAThread, RequestProcessor.Task> map = tasksByThreads;
                synchronized (map) {
                    autoresumeTask = tasksByThreads.get(thread);
                }
                t.notifyMethodInvoking();
                if (autoresumeTask != null) {
                    autoresumeTask.schedule(Integer.MAX_VALUE);
                }
                try {
                    run.run();
                }
                finally {
                    t.notifyMethodInvokeDone();
                    if (autoresumeTask != null) {
                        autoresumeTask.schedule(500);
                    }
                }
            }
            finally {
                t.accessLock.writeLock().unlock();
            }
        }
    }

    public static List<RemoteListener> getAttachedListeners(final JavaComponentInfo ci) throws PropertyVetoException {
        final ArrayList<RemoteListener> rlisteners = new ArrayList<RemoteListener>();
        final JPDAThreadImpl thread = ci.getThread();
        final ObjectReference component = ci.getComponent();
        RemoteServices.runOnStoppedThread((JPDAThread)thread, new Runnable(){

            @Override
            public void run() {
                if (ci instanceof RemoteAWTScreenshot.AWTComponentInfo) {
                    RemoteServices.retrieveAttachedListeners(thread, component, rlisteners);
                } else {
                    RemoteServices.retrieveAttachedFXListeners(thread, component, rlisteners);
                }
            }
        }, ci instanceof RemoteAWTScreenshot.AWTComponentInfo ? ServiceType.AWT : ServiceType.FX);
        return rlisteners;
    }

    private static void retrieveAttachedListeners(JPDAThreadImpl thread, ObjectReference component, List<RemoteListener> rlisteners) {
        ThreadReference t = thread.getThreadReference();
        ReferenceType clazz = component.referenceType();
        List<Method> visibleMethods = clazz.visibleMethods();
        for (Method m : visibleMethods) {
            String listenerType;
            Value result;
            block6: {
                String name = m.name();
                if (!name.startsWith("get") || !name.endsWith("Listeners") || m.argumentTypeNames().size() > 0) continue;
                try {
                    result = component.invokeMethod(t, m, Collections.EMPTY_LIST, 1);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    continue;
                }
                listenerType = null;
                try {
                    Type returnType = m.returnType();
                    if (!(returnType instanceof ArrayType)) break block6;
                    ArrayType art = (ArrayType)returnType;
                    listenerType = art.componentTypeName();
                }
                catch (ClassNotLoadedException ex) {
                    continue;
                }
            }
            if (listenerType == null) continue;
            ArrayReference array = (ArrayReference)result;
            List<Value> listeners = array.getValues();
            for (Value v : listeners) {
                RemoteListener rl = new RemoteListener(listenerType, (ObjectReference)v);
                rlisteners.add(rl);
            }
        }
    }

    private static void retrieveAttachedFXListeners(JPDAThreadImpl thread, ObjectReference component, List<RemoteListener> rlisteners) {
        ThreadReference t = thread.getThreadReference();
        ReferenceType clazz = component.referenceType();
        List<Method> visibleMethods = clazz.visibleMethods();
        for (Method m : visibleMethods) {
            String listenerType;
            Value result;
            block7: {
                String name;
                block6: {
                    name = m.name();
                    if (!name.startsWith("getOn") || m.argumentTypeNames().size() > 0) continue;
                    try {
                        result = component.invokeMethod(t, m, Collections.EMPTY_LIST, 1);
                        if (result == null) {
                        }
                        break block6;
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    continue;
                }
                listenerType = null;
                try {
                    Type returnType = m.returnType();
                    if (!returnType.name().equals("javafx.event.EventHandler")) break block7;
                    listenerType = name.substring(5);
                }
                catch (ClassNotLoadedException ex) {
                    continue;
                }
            }
            if (listenerType == null) continue;
            RemoteListener rl = new RemoteListener(listenerType, (ObjectReference)result);
            rlisteners.add(rl);
        }
    }

    public static List<ReferenceType> getAttachableListeners(JavaComponentInfo ci) {
        ObjectReference component = ci.getComponent();
        ReferenceType clazz = component.referenceType();
        List<Method> visibleMethods = clazz.visibleMethods();
        ArrayList<ReferenceType> listenerClasses = new ArrayList<ReferenceType>();
        for (Method m : visibleMethods) {
            Type t;
            List<Type> argTypes;
            String name = m.name();
            if (!name.startsWith("add") || !name.endsWith("Listener")) continue;
            try {
                argTypes = m.argumentTypes();
            }
            catch (ClassNotLoadedException ex) {
                continue;
            }
            if (argTypes.size() != 1 || !((t = argTypes.get(0)) instanceof ReferenceType)) continue;
            ReferenceType rt = (ReferenceType)t;
            String lname = rt.name();
            int i = lname.lastIndexOf(46);
            i = i < 0 ? 0 : ++i;
            int ii = lname.lastIndexOf(36, i);
            if (ii > i) {
                i = ii + 1;
            }
            System.err.println("  getAttachableListeners() '" + name.substring(3) + "' should equal to '" + lname.substring(i) + "', lname = " + lname + ", i = " + i);
            if (!name.substring(3).equals(lname.substring(i))) continue;
            listenerClasses.add(rt);
        }
        return listenerClasses;
    }

    public static ObjectReference attachLoggingListener(final JavaComponentInfo ci, final ClassObjectReference listenerClass, final LoggingListenerCallBack listener) throws PropertyVetoException {
        final JPDAThreadImpl thread = ci.getThread();
        final ObjectReference[] listenerPtr = new ObjectReference[]{null};
        RemoteServices.runOnStoppedThread((JPDAThread)thread, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassObjectReference serviceClassObject;
                ThreadReference t = thread.getThreadReference();
                ObjectReference component = ci.getComponent();
                MethodBreakpoint mb = MethodBreakpoint.create((String)"org.netbeans.modules.debugger.jpda.visual.remote.RemoteAWTService", (String)"calledWithEventsData");
                mb.setBreakpointType(1);
                mb.setSuspend(1);
                mb.setHidden(true);
                mb.addJPDABreakpointListener(new JPDABreakpointListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void breakpointReached(JPDABreakpointEvent event) {
                        try {
                            StackFrame topFrame;
                            ThreadReference tr = ((JPDAThreadImpl)event.getThread()).getThreadReference();
                            try {
                                topFrame = tr.frame(0);
                            }
                            catch (IncompatibleThreadStateException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                                event.resume();
                                return;
                            }
                            List<Value> argumentValues = topFrame.getArgumentValues();
                            if (argumentValues.size() < 2) {
                                return;
                            }
                            if (!((Object)ci.getComponent()).equals(argumentValues.get(0))) {
                                return;
                            }
                            ArrayReference allDataArray = (ArrayReference)argumentValues.get(1);
                            int totalLength = allDataArray.length();
                            List<Value> dataValues = allDataArray.getValues();
                            String[] eventProps = null;
                            int i = 0;
                            while (i < totalLength) {
                                StringReference sr = (StringReference)dataValues.get(i);
                                String dataLengthStr = sr.value();
                                int dataLength = Integer.parseInt(dataLengthStr);
                                String[] data = new String[dataLength];
                                ++i;
                                int j = 0;
                                while (j < dataLength) {
                                    sr = (StringReference)dataValues.get(i);
                                    data[j] = sr.value();
                                    ++j;
                                    ++i;
                                }
                                if (eventProps == null) {
                                    eventProps = data;
                                    continue;
                                }
                                listener.eventsData(ci, eventProps, data);
                                eventProps = null;
                            }
                        }
                        finally {
                            event.resume();
                        }
                    }
                });
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
                VirtualMachine vm = t.virtualMachine();
                Map map = remoteServiceClasses;
                synchronized (map) {
                    serviceClassObject = (ClassObjectReference)remoteServiceClasses.get(thread.getDebugger());
                }
                ClassType serviceClass = (ClassType)serviceClassObject.reflectedType();
                Method addLoggingListener = serviceClass.concreteMethodByName("addLoggingListener", "(Ljava/awt/Component;Ljava/lang/Class;)Ljava/lang/Object;");
                try {
                    ObjectReference theListener;
                    listenerPtr[0] = theListener = (ObjectReference)serviceClass.invokeMethod(t, addLoggingListener, Arrays.asList(component, listenerClass), 1);
                }
                catch (InvalidTypeException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotLoadedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IncompatibleThreadStateException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, ServiceType.AWT);
        return listenerPtr[0];
    }

    public static boolean detachLoggingListener(final JavaComponentInfo ci, final ClassObjectReference listenerClass, final ObjectReference listener) throws PropertyVetoException {
        final JPDAThreadImpl thread = ci.getThread();
        final boolean[] retPtr = new boolean[]{false};
        RemoteServices.runOnStoppedThread((JPDAThread)thread, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassObjectReference serviceClassObject;
                ObjectReference component = ci.getComponent();
                ThreadReference t = thread.getThreadReference();
                Map map = remoteServiceClasses;
                synchronized (map) {
                    serviceClassObject = (ClassObjectReference)remoteServiceClasses.get(thread.getDebugger());
                }
                ClassType serviceClass = (ClassType)serviceClassObject.reflectedType();
                Method removeLoggingListener = serviceClass.concreteMethodByName("removeLoggingListener", "(Ljava/awt/Component;Ljava/lang/Class;Ljava/lang/Object;)Z");
                try {
                    BooleanValue success = (BooleanValue)serviceClass.invokeMethod(t, removeLoggingListener, Arrays.asList(component, listenerClass, listener), 1);
                    retPtr[0] = success.value();
                }
                catch (InvalidTypeException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotLoadedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IncompatibleThreadStateException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, ServiceType.AWT);
        return retPtr[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassObjectReference getServiceClass(JPDADebugger debugger) {
        Map<JPDADebugger, ClassObjectReference> map = remoteServiceClasses;
        synchronized (map) {
            return remoteServiceClasses.get(debugger);
        }
    }

    static ClassType getClass(VirtualMachine vm, String name) {
        List<ReferenceType> classList = vm.classesByName(name);
        ReferenceType clazz = null;
        for (ReferenceType c : classList) {
            if (c.classLoader() != null) continue;
            clazz = c;
            break;
        }
        return (ClassType)clazz;
    }

    static ArrayType getArrayClass(VirtualMachine vm, String name) {
        List<ReferenceType> classList = vm.classesByName(name);
        ReferenceType clazz = null;
        for (ReferenceType c : classList) {
            if (c.classLoader() != null) continue;
            clazz = c;
            break;
        }
        return (ArrayType)clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RemoteClass> getRemoteClasses() throws IOException {
        InputStream in = RemoteServices.class.getResourceAsStream(REMOTE_CLASSES_ZIPFILE);
        try {
            ZipEntry ze;
            ZipInputStream zin = new ZipInputStream(in);
            ArrayList<RemoteClass> rcl = new ArrayList<RemoteClass>();
            while ((ze = zin.getNextEntry()) != null) {
                int r;
                int baseEnd;
                String name;
                int baseStart;
                String fileName = ze.getName();
                if (!fileName.endsWith(".class") || (baseStart = (name = fileName.substring(0, fileName.length() - ".class".length())).lastIndexOf(47)) < 0) continue;
                if ((baseEnd = name.indexOf(36, ++baseStart)) < 0) {
                    baseEnd = name.length();
                }
                RemoteClass rc = new RemoteClass();
                rc.name = name.replace('/', '.');
                int l = (int)ze.getSize();
                byte[] bytes = new byte[l];
                for (int num = 0; num < l; num += r) {
                    r = zin.read(bytes, num, l - num);
                    if (r >= 0) continue;
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("Can not read full content of " + name + " entry. Length = " + l + ", read num = " + num));
                    break;
                }
                RemoteClass.access$102(rc, bytes);
                rcl.add(rc);
            }
            ArrayList<RemoteClass> arrayList = rcl;
            return arrayList;
        }
        finally {
            in.close();
        }
    }

    private static ArrayReference createTargetBytes(VirtualMachine vm, byte[] bytes) throws InvalidTypeException, ClassNotLoadedException {
        ArrayType bytesArrayClass = RemoteServices.getArrayClass(vm, "byte[]");
        ArrayReference array = null;
        boolean disabledCollection = false;
        while (!disabledCollection) {
            array = bytesArrayClass.newInstance(bytes.length);
            try {
                array.disableCollection();
                disabledCollection = true;
            }
            catch (ObjectCollectedException ocex) {}
        }
        for (int i = 0; i < bytes.length; ++i) {
            array.setValue(i, (Value)vm.mirrorOf(bytes[i]));
        }
        return array;
    }

    private static class AutoresumeTask
    implements Runnable,
    PropertyChangeListener {
        private static final int WAIT_TIME = 500;
        private volatile JPDAThreadImpl t;

        public AutoresumeTask(JPDAThreadImpl t) {
            this.t = t;
            t.addPropertyChangeListener((PropertyChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPDAThreadImpl thread = this.t;
            if (thread == null) {
                return;
            }
            if ("suspended".equals(evt.getPropertyName()) && !"methodInvoke".equals(evt.getPropagationId())) {
                thread.removePropertyChangeListener((PropertyChangeListener)this);
                logger.fine("AutoresumeTask: autoresume canceled, thread changed suspended state: suspended = " + thread.isSuspended());
                Map map = tasksByThreads;
                synchronized (map) {
                    tasksByThreads.remove(thread);
                }
                this.t = null;
            }
        }

        @Override
        public void run() {
            JPDAThreadImpl thread = this.t;
            this.t = null;
            if (thread != null) {
                thread.removePropertyChangeListener((PropertyChangeListener)this);
                thread.resume();
            }
        }
    }

    public static interface LoggingListenerCallBack {
        public void eventsData(JavaComponentInfo var1, String[] var2, String[] var3);
    }

    public static class RemoteListener {
        private String type;
        private ObjectReference l;

        public RemoteListener(String type, ObjectReference l) {
            this.type = type;
            this.l = l;
        }

        public String getType() {
            return this.type;
        }

        public ObjectReference getListener() {
            return this.l;
        }
    }

    private static class RemoteClass {
        private String name;
        private byte[] bytes;

        private RemoteClass() {
        }

        static /* synthetic */ byte[] access$102(RemoteClass x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }

    public static enum ServiceType {
        AWT,
        FX;

    }
}

