/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteServices;
import org.netbeans.modules.debugger.jpda.visual.RetrievalException;
import org.netbeans.modules.debugger.jpda.visual.actions.ComponentBreakpointActionProvider;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToAddIntoHierarchyAction;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToFieldDeclarationAction;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToSourceAction;
import org.netbeans.modules.debugger.jpda.visual.actions.ShowListenersAction;
import org.netbeans.modules.debugger.jpda.visual.actions.ToggleComponentBreakpointAction;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.ComponentBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.models.ComponentBreakpointsActionsProvider;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.spi.RemoteScreenshot;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RemoteAWTScreenshot {
    private static final Logger logger = Logger.getLogger(RemoteAWTScreenshot.class.getName());
    private static final String AWTThreadName = "AWT-EventQueue-";
    private static final RemoteScreenshot[] NO_SCREENSHOTS = new RemoteScreenshot[0];

    private RemoteAWTScreenshot() {
    }

    private static RemoteScreenshot createRemoteAWTScreenshot(DebuggerEngine engine, String title, int width, int height, int[] dataArray, AWTComponentInfo componentInfo) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        WritableRaster raster = bi.getRaster();
        raster.setDataElements(0, 0, width, height, dataArray);
        return new RemoteScreenshot(engine, title, width, height, bi, componentInfo);
    }

    public static RemoteScreenshot[] takeCurrent() throws RetrievalException {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine != null) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            logger.fine("Debugger = " + debugger);
            if (debugger != null) {
                return RemoteAWTScreenshot.takeCurrent(debugger, engine);
            }
        }
        return NO_SCREENSHOTS;
    }

    public static RemoteScreenshot[] takeCurrent(JPDADebugger debugger) throws RetrievalException {
        DebuggerEngine engine = ((JPDADebuggerImpl)debugger).getSession().getCurrentEngine();
        return RemoteAWTScreenshot.takeCurrent(debugger, engine);
    }

    private static RemoteScreenshot[] takeCurrent(JPDADebugger debugger, DebuggerEngine engine) throws RetrievalException {
        List allThreads = debugger.getThreadsCollector().getAllThreads();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Threads = {0}", allThreads);
        }
        for (JPDAThread t : allThreads) {
            if (!t.getName().startsWith(AWTThreadName)) continue;
            return RemoteAWTScreenshot.take(t, engine);
        }
        return NO_SCREENSHOTS;
    }

    public static RemoteScreenshot[] take(final JPDAThread t, final DebuggerEngine engine) throws RetrievalException {
        final ThreadReference tawt = ((JPDAThreadImpl)t).getThreadReference();
        final VirtualMachine vm = tawt.virtualMachine();
        final ClassType windowClass = RemoteServices.getClass(vm, "java.awt.Window");
        if (windowClass == null) {
            logger.fine("No Window");
            return NO_SCREENSHOTS;
        }
        final Method getWindows = windowClass.concreteMethodByName("getWindows", "()[Ljava/awt/Window;");
        if (getWindows == null) {
            logger.fine("No getWindows() method!");
            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.Window.getWindows()");
            throw new RetrievalException(msg);
        }
        final ArrayList screenshots = new ArrayList();
        final RetrievalException[] retrievalExceptionPtr = new RetrievalException[]{null};
        try {
            RemoteServices.runOnStoppedThread(t, new Runnable(){

                @Override
                public void run() {
                    logger.fine("RemoteScreenshot.take(" + t + ")");
                    try {
                        ArrayReference windowsArray = (ArrayReference)windowClass.invokeMethod(tawt, getWindows, Collections.EMPTY_LIST, 1);
                        List<Value> windows = windowsArray.getValues();
                        logger.fine("Have " + windows.size() + " window(s).");
                        Method isVisible = windowClass.concreteMethodByName("isVisible", "()Z");
                        if (isVisible == null) {
                            logger.fine("No isVisible() method!");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.Window.isVisible()");
                            throw new RetrievalException(msg);
                        }
                        Method getOwner = windowClass.concreteMethodByName("getOwner", "()Ljava/awt/Window;");
                        if (getOwner == null) {
                            logger.fine("No getOwner() method!");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.Window.getOwner()");
                            throw new RetrievalException(msg);
                        }
                        Method getSize = windowClass.concreteMethodByName("getSize", "()Ljava/awt/Dimension;");
                        if (getSize == null) {
                            logger.fine("No getSize() method!");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.Window.getSize()");
                            throw new RetrievalException(msg);
                        }
                        ClassType dimensionClass = RemoteServices.getClass(vm, "java.awt.Dimension");
                        if (dimensionClass == null) {
                            logger.fine("No Dimension");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingClass", (Object)"java.awt.Dimension");
                            throw new RetrievalException(msg);
                        }
                        ClassType bufferedImageClass = RemoteServices.getClass(vm, "java.awt.image.BufferedImage");
                        if (bufferedImageClass == null) {
                            logger.fine("No BufferedImage class.");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingClass", (Object)"java.awt.image.BufferedImage");
                            throw new RetrievalException(msg);
                        }
                        Method bufferedImageConstructor = bufferedImageClass.concreteMethodByName("<init>", "(III)V");
                        Method createGraphics = bufferedImageClass.concreteMethodByName("createGraphics", "()Ljava/awt/Graphics2D;");
                        if (createGraphics == null) {
                            logger.fine("createGraphics() method is not found!");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.image.BufferedImage.createGraphics()");
                            throw new RetrievalException(msg);
                        }
                        ClassType frameClass = RemoteServices.getClass(vm, "java.awt.Frame");
                        Method getFrameTitle = null;
                        if (frameClass != null) {
                            getFrameTitle = frameClass.concreteMethodByName("getTitle", "()Ljava/lang/String;");
                        }
                        ClassType dialogClass = RemoteServices.getClass(vm, "java.awt.Dialog");
                        Method getDialogTitle = null;
                        if (dialogClass != null) {
                            getDialogTitle = dialogClass.concreteMethodByName("getTitle", "()Ljava/lang/String;");
                        }
                        for (Value windowValue : windows) {
                            StringReference sr;
                            Value v2;
                            Value owner;
                            ObjectReference window = (ObjectReference)windowValue;
                            BooleanValue visible = (BooleanValue)window.invokeMethod(tawt, isVisible, Collections.EMPTY_LIST, 1);
                            if (!visible.value()) {
                                // empty if block
                            }
                            if ((owner = window.invokeMethod(tawt, getOwner, Collections.EMPTY_LIST, 1)) != null) {
                                // empty if block
                            }
                            ObjectReference sizeDimension = (ObjectReference)window.invokeMethod(tawt, getSize, Collections.EMPTY_LIST, 1);
                            Field field = dimensionClass.fieldByName("width");
                            IntegerValue widthValue = (IntegerValue)sizeDimension.getValue(field);
                            int width = widthValue.value();
                            field = dimensionClass.fieldByName("height");
                            IntegerValue heightValue = (IntegerValue)sizeDimension.getValue(field);
                            int height = heightValue.value();
                            logger.log(Level.FINE, "The size is {0} x {1}", new Object[]{width, height});
                            List<IntegerValue> args = Arrays.asList(widthValue, heightValue, vm.mirrorOf(2));
                            ObjectReference bufferedImage = bufferedImageClass.newInstance(tawt, bufferedImageConstructor, args, 1);
                            ObjectReference graphics = (ObjectReference)bufferedImage.invokeMethod(tawt, createGraphics, Collections.EMPTY_LIST, 1);
                            Method paint = windowClass.concreteMethodByName("paint", "(Ljava/awt/Graphics;)V");
                            window.invokeMethod(tawt, paint, Arrays.asList(graphics), 1);
                            Method getData = bufferedImageClass.concreteMethodByName("getData", "()Ljava/awt/image/Raster;");
                            ObjectReference raster = (ObjectReference)bufferedImage.invokeMethod(tawt, getData, Collections.EMPTY_LIST, 1);
                            Method getDataElements = ((ClassType)raster.referenceType()).concreteMethodByName("getDataElements", "(IIIILjava/lang/Object;)Ljava/lang/Object;");
                            IntegerValue zero = vm.mirrorOf(0);
                            ArrayReference data = (ArrayReference)raster.invokeMethod(tawt, getDataElements, Arrays.asList(zero, zero, widthValue, heightValue, null), 1);
                            logger.log(Level.FINE, "Image data length = {0}", data.length());
                            List<Value> dataValues = data.getValues();
                            int[] dataArray = new int[data.length()];
                            int i = 0;
                            for (Value v2 : dataValues) {
                                dataArray[i++] = ((IntegerValue)v2).value();
                            }
                            String title = null;
                            if (frameClass != null && EvaluatorVisitor.instanceOf((Type)window.referenceType(), (Type)frameClass) && (v2 = window.invokeMethod(tawt, getFrameTitle, Collections.EMPTY_LIST, 1)) instanceof StringReference) {
                                sr = (StringReference)v2;
                                title = sr.value();
                            }
                            if (dialogClass != null && EvaluatorVisitor.instanceOf((Type)window.referenceType(), (Type)dialogClass) && (v2 = window.invokeMethod(tawt, getDialogTitle, Collections.EMPTY_LIST, 1)) instanceof StringReference) {
                                sr = (StringReference)v2;
                                title = sr.value();
                            }
                            AWTComponentInfo componentInfo = new AWTComponentInfo((JPDAThreadImpl)t, window);
                            screenshots.add(RemoteAWTScreenshot.createRemoteAWTScreenshot(engine, title, width, height, dataArray, componentInfo));
                        }
                    }
                    catch (RetrievalException rex) {
                        retrievalExceptionPtr[0] = rex;
                    }
                    catch (InvocationException iex) {
                        InvocationExceptionTranslated iextr = new InvocationExceptionTranslated(iex, ((JPDAThreadImpl)t).getDebugger());
                        iextr.setPreferredThread((JPDAThreadImpl)t);
                        iextr.getMessage();
                        iextr.getLocalizedMessage();
                        iextr.getCause();
                        iextr.getStackTrace();
                        retrievalExceptionPtr[0] = new RetrievalException(iex.getMessage(), (Throwable)iextr);
                    }
                    catch (InvalidTypeException itex) {
                        retrievalExceptionPtr[0] = new RetrievalException(itex.getMessage(), itex);
                    }
                    catch (ClassNotLoadedException cnlex) {
                        return;
                    }
                    catch (IncompatibleThreadStateException itsex) {
                        retrievalExceptionPtr[0] = new RetrievalException(itsex.getMessage(), itsex);
                    }
                }
            }, RemoteServices.ServiceType.AWT);
        }
        catch (PropertyVetoException pvex) {
            throw new RetrievalException(pvex.getMessage(), pvex);
        }
        if (retrievalExceptionPtr[0] != null) {
            throw retrievalExceptionPtr[0];
        }
        return screenshots.toArray(new RemoteScreenshot[0]);
    }

    private static void retrieveComponents(AWTComponentInfo ci, JPDAThreadImpl t, VirtualMachine vm, ClassType componentClass, ClassType containerClass, ObjectReference component, Method getComponents, Method getBounds, int shiftx, int shifty) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, RetrievalException {
        ThreadReference tawt = t.getThreadReference();
        ObjectReference rectangle = (ObjectReference)component.invokeMethod(tawt, getBounds, Collections.EMPTY_LIST, 1);
        ClassType rectangleClass = RemoteServices.getClass(vm, "java.awt.Rectangle");
        Field fx = rectangleClass.fieldByName("x");
        Field fy = rectangleClass.fieldByName("y");
        Field fwidth = rectangleClass.fieldByName("width");
        Field fheight = rectangleClass.fieldByName("height");
        Map<Field, Value> rvalues = rectangle.getValues(Arrays.asList(fx, fy, fwidth, fheight));
        Rectangle r = new Rectangle();
        r.x = ((IntegerValue)rvalues.get(fx)).value();
        r.y = ((IntegerValue)rvalues.get(fy)).value();
        r.width = ((IntegerValue)rvalues.get(fwidth)).value();
        r.height = ((IntegerValue)rvalues.get(fheight)).value();
        ci.setBounds(r);
        if (shiftx == Integer.MIN_VALUE && shifty == Integer.MIN_VALUE) {
            shifty = 0;
            shiftx = 0;
        } else {
            ci.setWindowBounds(new Rectangle(shiftx += r.x, shifty += r.y, r.width, r.height));
        }
        Method getName = componentClass.concreteMethodByName("getName", "()Ljava/lang/String;");
        StringReference name = (StringReference)component.invokeMethod(tawt, getName, Collections.EMPTY_LIST, 1);
        if (name != null) {
            ci.setName(name.value());
        }
        ci.setComponent(component);
        ci.setType(component.referenceType().name());
        logger.log(Level.FINE, "  Component ''{0}'' class=''{1}'' bounds = {2}", new Object[]{ci.getName(), ci.getType(), r});
        if (RemoteAWTScreenshot.isInstanceOfClass((ClassType)component.referenceType(), containerClass)) {
            ArrayReference componentsArray = (ArrayReference)component.invokeMethod(tawt, getComponents, Collections.EMPTY_LIST, 1);
            List<Value> components = componentsArray.getValues();
            logger.log(Level.FINE, "Have {0} component(s).", components.size());
            if (components.size() > 0) {
                JavaComponentInfo[] cis = new AWTComponentInfo[components.size()];
                int i = 0;
                for (Value cv : components) {
                    ObjectReference c = (ObjectReference)cv;
                    cis[i] = new AWTComponentInfo(t, c, shiftx, shifty);
                    ++i;
                }
                ci.setSubComponents(cis);
            }
        }
    }

    private static boolean isInstanceOfClass(ClassType c1, ClassType c2) {
        if (c1.equals(c2)) {
            return true;
        }
        if ((c1 = c1.superclass()) == null) {
            return false;
        }
        return RemoteAWTScreenshot.isInstanceOfClass(c1, c2);
    }

    public static class AWTComponentInfo
    extends JavaComponentInfo {
        private int shiftX;
        private int shiftY;
        private VirtualMachine vm = this.getThread().getDebugger().getVirtualMachine();
        private ClassType containerClass;
        private ClassType componentClass;
        private Method getBounds;
        private Method getComponents;
        private static final Action CBP_CUSTOMIZE_ACTION = new NodeAction(){

            public String getName() {
                return NbBundle.getBundle(RemoteAWTScreenshot.class).getString("CTL_Component_Breakpoint_Customize_Label");
            }

            protected boolean enable(Node[] activatedNodes) {
                return true;
            }

            protected boolean asynchronous() {
                return false;
            }

            protected void performAction(Node[] activatedNodes) {
                for (Node n : activatedNodes) {
                    JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
                    if (ci == null) continue;
                    ObjectReference component = ci.getComponent();
                    ComponentBreakpoint b = ComponentBreakpointActionProvider.findBreakpoint(component);
                    ComponentBreakpointsActionsProvider.customize(b);
                }
            }

            public HelpCtx getHelpCtx() {
                return new HelpCtx("AWTComponentBreakpoint_Customize");
            }
        };

        public AWTComponentInfo(JPDAThreadImpl t, ObjectReference component) throws RetrievalException {
            this(t, component, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        public AWTComponentInfo(JPDAThreadImpl t, ObjectReference component, int shiftX, int shiftY) throws RetrievalException {
            super(t, component, RemoteServices.ServiceType.AWT);
            if (this.vm == null) {
                throw new RetrievalException(NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_NoDebugger"));
            }
            this.containerClass = RemoteServices.getClass(this.vm, "java.awt.Container");
            this.componentClass = RemoteServices.getClass(this.vm, "java.awt.Component");
            this.getBounds = this.componentClass.concreteMethodByName("getBounds", "()Ljava/awt/Rectangle;");
            this.getComponents = this.containerClass.concreteMethodByName("getComponents", "()[Ljava/awt/Component;");
            if (this.getComponents == null) {
                logger.fine("No getComponents() method!");
                String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.Container.getComponents()");
                throw new RetrievalException(msg);
            }
            this.shiftX = shiftX;
            this.shiftY = shiftY;
            this.init();
        }

        @Override
        public Action[] getActions(boolean context) {
            JavaComponentInfo.FieldInfo fieldInfo = this.getField();
            ObjectReference component = this.getComponent();
            ComponentBreakpoint b = ComponentBreakpointActionProvider.findBreakpoint(component);
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(GoToFieldDeclarationAction.get(GoToFieldDeclarationAction.class));
            actions.add(GoToSourceAction.get(GoToSourceAction.class));
            if (fieldInfo != null) {
                actions.add(GoToAddIntoHierarchyAction.get(GoToAddIntoHierarchyAction.class));
            }
            actions.add(null);
            actions.add(ShowListenersAction.get(ShowListenersAction.class));
            actions.add(null);
            actions.add(ToggleComponentBreakpointAction.get(ToggleComponentBreakpointAction.class));
            if (b != null) {
                actions.add(CBP_CUSTOMIZE_ACTION);
            }
            return actions.toArray(new Action[0]);
        }

        @Override
        public ComponentInfo findAt(int x, int y) {
            Rectangle bounds = this.getBounds();
            if (!bounds.contains(x, y)) {
                return null;
            }
            x -= bounds.x;
            y -= bounds.y;
            JavaComponentInfo[] subComponents = this.getSubComponents();
            if (subComponents != null) {
                for (int i = 0; i < subComponents.length; ++i) {
                    Rectangle sb = subComponents[i].getBounds();
                    if (!sb.contains(x, y)) continue;
                    ComponentInfo tci = subComponents[i].findAt(x, y);
                    Rectangle tbounds = tci.getBounds();
                    if (tbounds.width >= bounds.width && tbounds.height >= bounds.height) continue;
                    return tci;
                }
            }
            return this;
        }

        @Override
        protected void retrieve() throws RetrievalException {
            try {
                RemoteAWTScreenshot.retrieveComponents(this, this.getThread(), this.vm, this.componentClass, this.containerClass, this.getComponent(), this.getComponents, this.getBounds, this.shiftX, this.shiftY);
                if (this.shiftX == Integer.MIN_VALUE && this.shiftY == Integer.MIN_VALUE) {
                    this.getBounds().x = 0;
                    this.getBounds().y = 0;
                }
            }
            catch (RetrievalException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RetrievalException(e.getMessage(), e);
            }
        }
    }
}

