/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.RemoteServices;
import org.netbeans.modules.debugger.jpda.visual.RetrievalException;
import org.netbeans.modules.debugger.jpda.visual.VisualDebuggerListener;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class JavaComponentInfo
implements ComponentInfo {
    private static final JavaComponentInfo[] NO_SUBCOMPONENTS = new JavaComponentInfo[0];
    private static final int MAX_TEXT_LENGTH = 80;
    private Rectangle bounds;
    private Rectangle windowBounds;
    private String name;
    private String type;
    private JavaComponentInfo[] subComponents;
    private List<Node.PropertySet> propertySets = new ArrayList<Node.PropertySet>();
    private PropertyChangeSupport pchs = new PropertyChangeSupport(this);
    private JPDAThreadImpl thread;
    private ObjectReference component;
    private FieldInfo fieldInfo;
    private String componentText;
    private RemoteServices.ServiceType sType;

    public JavaComponentInfo(JPDAThreadImpl t, ObjectReference component, RemoteServices.ServiceType sType) throws RetrievalException {
        this.thread = t;
        this.component = component;
        this.type = component.referenceType().name();
        this.sType = sType;
    }

    protected final void init() throws RetrievalException {
        this.retrieve();
        this.addProperties();
        this.findComponentFields();
    }

    protected abstract void retrieve() throws RetrievalException;

    public final JPDAThreadImpl getThread() {
        return this.thread;
    }

    public final ObjectReference getComponent() {
        return this.component;
    }

    public final Stack getAddCallStack() {
        return VisualDebuggerListener.getStackOf((JPDADebugger)this.thread.getDebugger(), this.component);
    }

    public final String getName() {
        return this.name;
    }

    public final String getTypeName() {
        int d = this.type.lastIndexOf(46);
        String typeName = d > 0 ? this.type.substring(d + 1) : this.type;
        return typeName;
    }

    public final void setComponentText(String componentText) {
        this.componentText = componentText.length() > 80 ? componentText.substring(0, 80) + "..." : componentText;
    }

    @Override
    public String getDisplayName() {
        String typeName = this.getTypeName();
        String text = this.componentText != null ? " \"" + this.componentText + "\"" : "";
        return this.getFieldName() + "[" + typeName + "]" + text;
    }

    @Override
    public String getHtmlDisplayName() {
        if (this.isCustomType() || this.componentText != null) {
            String text;
            String typeName = this.getTypeName();
            if (this.isCustomType()) {
                typeName = "<b>" + typeName + "</b>";
            }
            if (this.componentText != null) {
                text = JavaComponentInfo.escapeHTML(this.componentText);
                text = " <font color=\"#A0A0A0\">\"" + text + "\"</font>";
            } else {
                text = "";
            }
            return this.getFieldName() + "[" + typeName + "]" + text;
        }
        return null;
    }

    protected String getFieldName() {
        return this.fieldInfo != null ? this.fieldInfo.getName() + " " : "";
    }

    public final String getType() {
        return this.type;
    }

    public final FieldInfo getField() {
        return this.fieldInfo;
    }

    public final boolean isCustomType() {
        return JavaComponentInfo.isCustomType(this.type);
    }

    public static boolean isCustomType(String type) {
        return !type.startsWith("java.awt.") && !type.startsWith("javax.swing.") && !type.startsWith("javafx.") && !type.startsWith("com.sun.javafx.");
    }

    @Override
    public final Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public final Rectangle getWindowBounds() {
        if (this.windowBounds == null) {
            return this.bounds;
        }
        return this.windowBounds;
    }

    public final void addPropertySet(Node.PropertySet ps) {
        this.propertySets.add(ps);
    }

    @Override
    public final Node.PropertySet[] getPropertySets() {
        return this.propertySets.toArray(new Node.PropertySet[0]);
    }

    protected final void setSubComponents(JavaComponentInfo[] subComponents) {
        this.subComponents = subComponents;
    }

    public final JavaComponentInfo[] getSubComponents() {
        if (this.subComponents == null) {
            return NO_SUBCOMPONENTS;
        }
        return this.subComponents;
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pchs.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pchs.removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String name, Object o, Object n) {
        this.pchs.firePropertyChange(name, o, n);
    }

    public final void setFieldInfo(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
    }

    public final void setBounds(Rectangle r) {
        this.bounds = r;
    }

    public final void setWindowBounds(Rectangle rectangle) {
        this.windowBounds = rectangle;
    }

    public final void setName(String value) {
        this.name = value;
    }

    public final void setComponent(ObjectReference component) {
        this.component = component;
    }

    public final void setType(String name) {
        this.type = name;
    }

    private void addProperties() {
        this.addPropertySet(new Node.PropertySet("main", NbBundle.getMessage(JavaComponentInfo.class, (String)"MSG_ComponentPropMain"), NbBundle.getMessage(JavaComponentInfo.class, (String)"MSG_ComponentPropMainDescr")){

            public Node.Property<?>[] getProperties() {
                return new Node.Property[]{new PropertySupport.ReadOnly("name", String.class, NbBundle.getMessage(JavaComponentInfo.class, (String)"MSG_ComponentPropName"), NbBundle.getMessage(JavaComponentInfo.class, (String)"MSG_ComponentPropNameDescr")){

                    public Object getValue() throws IllegalAccessException, InvocationTargetException {
                        return JavaComponentInfo.this.getName();
                    }
                }, new PropertySupport.ReadOnly("type", String.class, NbBundle.getMessage(JavaComponentInfo.class, (String)"MSG_ComponentPropType"), NbBundle.getMessage(JavaComponentInfo.class, (String)"MSG_ComponentPropTypeDescr")){

                    public Object getValue() throws IllegalAccessException, InvocationTargetException {
                        return JavaComponentInfo.this.getType();
                    }
                }, new PropertySupport.ReadOnly("bounds", String.class, NbBundle.getMessage(JavaComponentInfo.class, (String)"MSG_ComponentPropBounds"), NbBundle.getMessage(JavaComponentInfo.class, (String)"MSG_ComponentPropBoundsDescr")){

                    public Object getValue() throws IllegalAccessException, InvocationTargetException {
                        Rectangle r = JavaComponentInfo.this.getWindowBounds();
                        return "[x=" + r.x + ",y=" + r.y + ",width=" + r.width + ",height=" + r.height + "]";
                    }
                }};
            }
        });
        List<Method> allMethods = this.component.referenceType().allMethods();
        HashMap<String, Method> methodsByName = new HashMap<String, Method>(allMethods.size());
        for (Method m : allMethods) {
            String mName = m.name();
            if ((!mName.startsWith("get") && !mName.startsWith("set") || mName.length() <= 3) && (!mName.startsWith("is") || mName.length() <= 2) || (!mName.startsWith("get") && !mName.startsWith("is") || m.argumentTypeNames().size() != 0) && (!mName.startsWith("set") || m.argumentTypeNames().size() != 1 || !"void".equals(m.returnTypeName()))) continue;
            methodsByName.put(mName, m);
        }
        TreeMap<String, ComponentProperty> sortedProperties = new TreeMap<String, ComponentProperty>();
        for (String mName : methodsByName.keySet()) {
            String setName;
            String property;
            if (mName.startsWith("set")) continue;
            if (mName.startsWith("is")) {
                property = Character.toLowerCase(mName.charAt(2)) + mName.substring(3);
                setName = "set" + mName.substring(2);
            } else {
                property = Character.toLowerCase(mName.charAt(3)) + mName.substring(4);
                setName = "set" + mName.substring(3);
            }
            ComponentProperty p = new ComponentProperty(property, (Method)methodsByName.get(mName), (Method)methodsByName.get(setName), this, this.component, this.getThread(), this.getThread().getDebugger(), this.sType);
            sortedProperties.put(property, p);
        }
        final Node.Property[] properties = sortedProperties.values().toArray(new Node.Property[0]);
        this.addPropertySet(new Node.PropertySet("Properties", NbBundle.getMessage(JavaComponentInfo.class, (String)"MSG_ComponentProps"), NbBundle.getMessage(JavaComponentInfo.class, (String)"MSG_ComponentPropsDescr")){

            public Node.Property<?>[] getProperties() {
                return properties;
            }
        });
        Method getTextMethod = (Method)methodsByName.get("getText");
        if (getTextMethod != null) {
            try {
                Value theText = this.component.invokeMethod(this.getThread().getThreadReference(), getTextMethod, Collections.EMPTY_LIST, 1);
                if (theText instanceof StringReference) {
                    this.setComponentText(((StringReference)theText).value());
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected static boolean isInstanceOfClass(ClassType c1, ClassType c2) {
        if (c1.equals(c2)) {
            return true;
        }
        if ((c1 = c1.superclass()) == null) {
            return false;
        }
        return JavaComponentInfo.isInstanceOfClass(c1, c2);
    }

    private void findComponentFields() {
        ArrayList<JavaComponentInfo> customParents = new ArrayList<JavaComponentInfo>();
        JavaComponentInfo.fillCustomParents(customParents, this);
        JavaComponentInfo.findFieldsInParents(customParents, this);
    }

    private static void fillCustomParents(List<JavaComponentInfo> customParents, JavaComponentInfo ci) {
        JavaComponentInfo[] subs = ci.getSubComponents();
        if (subs.length > 0 && ci.isCustomType()) {
            customParents.add(ci);
        }
        for (JavaComponentInfo sci : subs) {
            JavaComponentInfo.fillCustomParents(customParents, sci);
        }
    }

    private static void findFieldsInParents(List<JavaComponentInfo> customParents, JavaComponentInfo ci) {
        JavaComponentInfo[] subComponents = ci.getSubComponents();
        ObjectReference component = ci.getComponent();
        for (JavaComponentInfo cp : customParents) {
            ObjectReference c = cp.getComponent();
            Map<Field, Value> fieldValues = c.getValues(((ClassType)c.referenceType()).fields());
            for (Map.Entry<Field, Value> e : fieldValues.entrySet()) {
                if (!((Object)component).equals(e.getValue())) continue;
                ci.setFieldInfo(new FieldInfo(e.getKey(), cp));
            }
        }
        for (JavaComponentInfo sci : subComponents) {
            JavaComponentInfo.findFieldsInParents(customParents, sci);
        }
    }

    private static String escapeHTML(String message) {
        if (message == null) {
            return null;
        }
        int len = message.length();
        StringBuilder result = new StringBuilder(len + 20);
        block6: for (int i = 0; i < len; ++i) {
            char aChar = message.charAt(i);
            switch (aChar) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(aChar);
                }
            }
        }
        return result.toString();
    }

    public static class Stack {
        private Frame[] frames;

        public Stack(Frame[] frames) {
            this.frames = frames;
        }

        public Stack(CallStackFrame[] stackFrames) {
            int n = stackFrames.length;
            this.frames = new Frame[n];
            for (int i = 0; i < n; ++i) {
                CallStackFrame sf = stackFrames[i];
                try {
                    this.frames[i] = new Frame(sf.getClassName(), sf.getMethodName(), sf.getSourceName(null), sf.getLineNumber(null));
                    continue;
                }
                catch (AbsentInformationException ex) {
                    this.frames[i] = new Frame(sf.getClassName(), sf.getMethodName(), null, sf.getLineNumber(null));
                }
            }
        }

        public Frame[] getFrames() {
            return this.frames;
        }

        public static class Frame {
            private String className;
            private String methodName;
            private String fileName;
            private int lineNumber;

            public Frame(String className, String methodName, String fileName, int lineNumber) {
                this.className = className;
                this.methodName = methodName;
                this.fileName = fileName;
                this.lineNumber = lineNumber;
            }

            public String getClassName() {
                return this.className;
            }

            public String getMethodName() {
                return this.methodName;
            }

            public String getFileName() {
                return this.fileName;
            }

            public int getLineNumber() {
                return this.lineNumber;
            }

            public String toString() {
                return "Frame " + this.className + "." + this.methodName + "(" + this.fileName + ":" + this.lineNumber + ")";
            }
        }
    }

    public static class FieldInfo {
        private String name;
        private Field f;
        private JavaComponentInfo parent;

        FieldInfo(Field f, JavaComponentInfo parent) {
            this.name = f.name();
            this.f = f;
            this.parent = parent;
        }

        public String getName() {
            return this.name;
        }

        public Field getField() {
            return this.f;
        }

        public JavaComponentInfo getParent() {
            return this.parent;
        }
    }

    private static class ComponentProperty
    extends Node.Property {
        private String propertyName;
        private Method getter;
        private Method setter;
        private JavaComponentInfo ci;
        private ObjectReference component;
        private JPDAThreadImpl t;
        private ThreadReference tawt;
        private JPDADebuggerImpl debugger;
        private String value;
        private final Object valueLock = new Object();
        private final String valueCalculating = "calculating";
        private final RemoteServices.ServiceType sType;
        private boolean valueIsEditable;
        private Type valueType;

        ComponentProperty(String propertyName, Method getter, Method setter, JavaComponentInfo ci, ObjectReference component, JPDAThreadImpl t, JPDADebuggerImpl debugger, RemoteServices.ServiceType sType) {
            super(String.class);
            this.propertyName = propertyName;
            this.getter = getter;
            this.setter = setter;
            this.ci = ci;
            this.component = component;
            this.t = t;
            this.tawt = t.getThreadReference();
            this.debugger = debugger;
            this.sType = sType;
        }

        public String getName() {
            return this.propertyName;
        }

        public String getDisplayName() {
            return this.propertyName;
        }

        public boolean canRead() {
            return this.getter != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Object object = this.valueLock;
            synchronized (object) {
                if (this.value == null) {
                    this.value = "calculating";
                    this.debugger.getRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RemoteServices.runOnStoppedThread((JPDAThread)ComponentProperty.this.t, new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        boolean[] isEditablePtr = new boolean[]{false};
                                        Type[] typePtr = new Type[]{null};
                                        String v = ComponentProperty.this.getValueLazy(isEditablePtr, typePtr);
                                        Object object = ComponentProperty.this.valueLock;
                                        synchronized (object) {
                                            ComponentProperty.this.value = v;
                                            ComponentProperty.this.valueIsEditable = isEditablePtr[0];
                                            ComponentProperty.this.valueType = typePtr[0];
                                        }
                                        ComponentProperty.this.ci.firePropertyChange(ComponentProperty.this.propertyName, null, v);
                                    }
                                }, ComponentProperty.this.sType);
                            }
                            catch (PropertyVetoException ex) {
                                ComponentProperty.this.value = ex.getLocalizedMessage();
                            }
                        }
                    });
                }
                return this.value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getValueLazy(boolean[] isEditablePtr, Type[] typePtr) {
            Object t;
            Lock l = this.t.accessLock.writeLock();
            l.lock();
            try {
                Value v = this.component.invokeMethod(this.tawt, this.getter, Collections.EMPTY_LIST, 1);
                if (v != null) {
                    typePtr[0] = v.type();
                }
                if (v instanceof StringReference) {
                    isEditablePtr[0] = true;
                    String string = ((StringReference)v).value();
                    return string;
                }
                if (v instanceof ObjectReference) {
                    Method toStringMethod;
                    t = v.type();
                    if (t instanceof ClassType && (v = ((ObjectReference)v).invokeMethod(this.tawt, toStringMethod = ((ClassType)t).concreteMethodByName("toString", "()Ljava/lang/String;"), Collections.EMPTY_LIST, 1)) instanceof StringReference) {
                        String string = ((StringReference)v).value();
                        return string;
                    }
                } else if (v instanceof PrimitiveValue) {
                    isEditablePtr[0] = true;
                }
                t = String.valueOf(v);
                return t;
            }
            catch (InvalidTypeException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                t = ex.getMessage();
                return t;
            }
            catch (ClassNotLoadedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                t = ex.getMessage();
                return t;
            }
            catch (IncompatibleThreadStateException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                t = ex.getMessage();
                return t;
            }
            catch (InvocationException ex) {
                InvocationExceptionTranslated iextr = new InvocationExceptionTranslated(ex, this.debugger);
                iextr.setPreferredThread(this.t);
                String string = iextr.getMessage();
                return string;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String setValueLazy(String val, String oldValue, Type type) {
            Value v;
            VirtualMachine vm = type.virtualMachine();
            if (type instanceof PrimitiveType) {
                String ts = type.name();
                try {
                    if (Boolean.TYPE.getName().equals(ts)) {
                        v = vm.mirrorOf(Boolean.parseBoolean(val));
                    } else if (Byte.TYPE.getName().equals(ts)) {
                        v = vm.mirrorOf(Byte.parseByte(val));
                    } else if (Character.TYPE.getName().equals(ts)) {
                        if (val.length() == 0) {
                            throw new NumberFormatException("Zero length input.");
                        }
                        v = vm.mirrorOf(val.charAt(0));
                    } else if (Short.TYPE.getName().equals(ts)) {
                        v = vm.mirrorOf(Short.parseShort(val));
                    } else if (Integer.TYPE.getName().equals(ts)) {
                        v = vm.mirrorOf(Integer.parseInt(val));
                    } else if (Long.TYPE.getName().equals(ts)) {
                        v = vm.mirrorOf(Long.parseLong(val));
                    } else if (Float.TYPE.getName().equals(ts)) {
                        v = vm.mirrorOf(Float.parseFloat(val));
                    } else if (Double.TYPE.getName().equals(ts)) {
                        v = vm.mirrorOf(Double.parseDouble(val));
                    } else {
                        throw new IllegalArgumentException("Unknown type '" + ts + "'");
                    }
                    val = v.toString();
                }
                catch (NumberFormatException nfex) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)nfex.getLocalizedMessage(), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    return oldValue;
                }
            } else if ("java.lang.String".equals(type.name())) {
                v = vm.mirrorOf(val);
            } else {
                throw new IllegalArgumentException("Unknown type '" + type.name() + "'");
            }
            Lock l = this.t.accessLock.writeLock();
            l.lock();
            try {
                this.component.invokeMethod(this.tawt, this.setter, Collections.singletonList(v), 1);
                String nfex = val;
                return nfex;
            }
            catch (InvalidTypeException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                String msg = oldValue;
                return msg;
            }
            catch (ClassNotLoadedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                String msg = oldValue;
                return msg;
            }
            catch (IncompatibleThreadStateException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                String msg = oldValue;
                return msg;
            }
            catch (InvocationException ex) {
                final InvocationExceptionTranslated iextr = new InvocationExceptionTranslated(ex, this.debugger);
                iextr.setPreferredThread(this.t);
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        iextr.getMessage();
                        iextr.getLocalizedMessage();
                        iextr.getCause();
                        iextr.getStackTrace();
                        Exceptions.printStackTrace((Throwable)iextr);
                    }
                }, 100);
                String string = oldValue;
                return string;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canWrite() {
            Object object = this.valueLock;
            synchronized (object) {
                return this.setter != null && this.valueIsEditable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(final Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Type type;
            String oldValue;
            if (!(val instanceof String)) {
                throw new IllegalArgumentException("val = " + val);
            }
            Object object = this.valueLock;
            synchronized (object) {
                oldValue = this.value;
                type = this.valueType;
                this.value = "calculating";
            }
            this.debugger.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoteServices.runOnStoppedThread((JPDAThread)ComponentProperty.this.t, new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                String v;
                                Throwable t = null;
                                try {
                                    v = ComponentProperty.this.setValueLazy((String)val, oldValue, type);
                                }
                                catch (Throwable th) {
                                    if (th instanceof ThreadDeath) {
                                        throw (ThreadDeath)th;
                                    }
                                    t = th;
                                    v = oldValue;
                                }
                                Object object = ComponentProperty.this.valueLock;
                                synchronized (object) {
                                    ComponentProperty.this.value = v;
                                }
                                ComponentProperty.this.ci.firePropertyChange(ComponentProperty.this.propertyName, null, v);
                                if (t != null) {
                                    Exceptions.printStackTrace((Throwable)t);
                                }
                            }
                        }, ComponentProperty.this.sType);
                    }
                    catch (PropertyVetoException ex) {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getLocalizedMessage(), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    }
                }
            });
        }
    }
}

