/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.impl.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTMacroExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.model.services.CsmMacroExpansionDocProvider;
import org.openide.text.NbDocument;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;

public class MacroExpansionDocProviderImpl
implements CsmMacroExpansionDocProvider {
    public static final String MACRO_EXPANSION_OFFSET_TRANSFORMER = "macro-expansion-offset-transformer";
    public static final String MACRO_EXPANSION_MACRO_TABLE = "macro-expansion-macro-table";
    public static final String MACRO_EXPANSION_STOP_ON_OFFSET_PARSE_FILE_WALKER_CACHE = "macro-expansion-stop-on-offset-parse-file-walker-cache";

    public synchronized int expand(final Document inDoc, final int startOffset, final int endOffset, Document outDoc) {
        if (inDoc == null || outDoc == null) {
            return 0;
        }
        final CsmFile file = CsmUtilities.getCsmFile((Document)inDoc, (boolean)true, (boolean)false);
        if (file == null) {
            return 0;
        }
        final MyTokenSequence fileTS = this.getFileTokenSequence(file, startOffset, endOffset);
        if (fileTS == null) {
            return 0;
        }
        final StringBuilder expandedData = new StringBuilder();
        final TransformationTable tt = new TransformationTable(DocumentUtilities.getDocumentVersion((Document)inDoc), CsmFileInfoQuery.getDefault().getFileVersion(file));
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TokenSequence docTS = CndLexerUtilities.getCppTokenSequence((Document)inDoc, (int)inDoc.getLength(), (boolean)false, (boolean)true);
                if (docTS == null) {
                    return;
                }
                docTS.move(startOffset);
                tt.setInStart(startOffset);
                tt.setOutStart(0);
                boolean inMacroParams = false;
                boolean inDeadCode = true;
                while (docTS.moveNext()) {
                    Token docToken = docTS.token();
                    int docTokenStartOffset = docTS.offset();
                    int docTokenEndOffset = docTokenStartOffset + docToken.length();
                    if (MacroExpansionDocProviderImpl.this.isWhitespace((Token<TokenId>)docToken)) continue;
                    APTToken fileToken = MacroExpansionDocProviderImpl.this.findToken(fileTS, docTokenStartOffset);
                    if (fileToken == null) {
                        if (!inMacroParams && !inDeadCode) {
                            MacroExpansionDocProviderImpl.this.copyInterval(inDoc, (endOffset > docTokenStartOffset ? docTokenStartOffset : endOffset) - tt.currentIn.start, tt, expandedData);
                        }
                        tt.appendInterval(endOffset - tt.currentIn.start, 0);
                        break;
                    }
                    if (docTokenEndOffset <= fileToken.getOffset() || !APTUtils.isMacroExpandedToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                        if (MacroExpansionDocProviderImpl.this.isOnInclude((TokenSequence<TokenId>)docTS)) {
                            if (!inMacroParams && !inDeadCode) {
                                MacroExpansionDocProviderImpl.this.copyInterval(inDoc, docTokenStartOffset - tt.currentIn.start, tt, expandedData);
                            } else {
                                tt.appendInterval(docTokenStartOffset - tt.currentIn.start, 0);
                            }
                            MacroExpansionDocProviderImpl.this.expandIcludeToken((TokenSequence<TokenId>)docTS, inDoc, file, tt, expandedData);
                        } else if (docTokenEndOffset <= fileToken.getOffset()) {
                            if (inMacroParams || inDeadCode) {
                                tt.appendInterval(docTokenEndOffset - tt.currentIn.start, 0);
                                continue;
                            }
                            MacroExpansionDocProviderImpl.this.copyInterval(inDoc, docTokenStartOffset - tt.currentIn.start, tt, expandedData);
                            tt.appendInterval(docTokenEndOffset - tt.currentIn.start, 0);
                            inDeadCode = true;
                            continue;
                        }
                        inMacroParams = false;
                        inDeadCode = false;
                        continue;
                    }
                    MacroExpansionDocProviderImpl.this.copyInterval(inDoc, docTokenStartOffset - tt.currentIn.start, tt, expandedData);
                    MacroExpansionDocProviderImpl.this.expandMacroToken(docTS, fileTS, tt, expandedData);
                    inMacroParams = true;
                }
                MacroExpansionDocProviderImpl.this.copyInterval(inDoc, endOffset - tt.currentIn.start, tt, expandedData);
                tt.cleanUp();
            }
        };
        inDoc.render(r);
        outDoc.putProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER, tt);
        try {
            outDoc.insertString(0, expandedData.toString(), null);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.initGuardedBlocks(outDoc, tt);
        return this.calcExpansionNumber(tt);
    }

    public int getOffsetInExpandedText(Document expandedDoc, int originalOffset) {
        Object o = expandedDoc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt.getOutOffset(originalOffset);
        }
        return originalOffset;
    }

    public int getOffsetInOriginalText(Document expandedDoc, int expandedOffset) {
        Object o = expandedDoc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt.getInOffset(expandedOffset);
        }
        return expandedOffset;
    }

    public int getNextMacroExpansionStartOffset(Document expandedDoc, int expandedOffset) {
        Object o = expandedDoc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt.getNextMacroExpansionStartOffset(expandedOffset);
        }
        return expandedOffset;
    }

    public int getPrevMacroExpansionStartOffset(Document expandedDoc, int expandedOffset) {
        Object o = expandedDoc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt.getPrevMacroExpansionStartOffset(expandedOffset);
        }
        return expandedOffset;
    }

    private void fillParamsToExpansionMap(APTToken fileToken, TransformationTable tt, int expandedOffsetShift, Map<Interval, List<Interval>> paramsToExpansion) {
        APTToken to = APTUtils.getExpandedToken((APTToken)fileToken);
        if (to != null) {
            Interval paramInterval = new Interval(to.getOffset(), to.getEndOffset());
            Interval paramExpansionInterval = new Interval(tt.currentOut.start + expandedOffsetShift, tt.currentOut.start + expandedOffsetShift + fileToken.getText().length());
            List<Interval> paramExpansions = paramsToExpansion.get(paramInterval);
            if (paramExpansions != null) {
                paramExpansions.add(paramExpansionInterval);
            } else {
                paramExpansions = new ArrayList<Interval>(1);
                paramExpansions.add(paramExpansionInterval);
                paramsToExpansion.put(paramInterval, paramExpansions);
            }
        }
    }

    private APTToken findToken(MyTokenSequence fileTS, int offset) {
        while (fileTS.token() != null && !APTUtils.isEOF((org.netbeans.modules.cnd.antlr.Token)fileTS.token()) && fileTS.token().getOffset() < offset) {
            fileTS.moveNext();
        }
        if (fileTS.token() == null || APTUtils.isEOF((org.netbeans.modules.cnd.antlr.Token)fileTS.token())) {
            return null;
        }
        return fileTS.token();
    }

    private TransformationTable getMacroTable(Document doc) {
        Object o = doc.getProperty(MACRO_EXPANSION_MACRO_TABLE);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt;
        }
        return null;
    }

    private TransformationTable getTransformationTable(Document doc) {
        Object o = doc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt;
        }
        return null;
    }

    public String[] getMacroExpansion(Document doc, int offset) {
        return new String[]{"", ""};
    }

    public String expand(Document doc, int startOffset, int endOffset) {
        if (doc == null) {
            return null;
        }
        return this.expand(doc, CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false), startOffset, endOffset);
    }

    public String expand(Document doc, CsmFile file, int startOffset, int endOffset) {
        TransformationTable tt = this.updateMacroTableIfNeeded(doc, file);
        return tt == null ? null : this.expandInterval(doc, tt, startOffset, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getMacroExpansionSpan(Document doc, int offset, boolean wait) {
        int startIndex;
        TransformationTable tt;
        Document file;
        int[] span = new int[]{offset, offset};
        if (wait) {
            file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
            tt = this.updateMacroTableIfNeeded(doc, (CsmFile)file);
        } else {
            file = doc;
            synchronized (file) {
                tt = this.getMacroTable(doc);
            }
        }
        if (tt != null && 0 <= (startIndex = tt.findInIntervalIndex(offset)) && startIndex < tt.intervals.size()) {
            IntervalCorrespondence ic;
            int i;
            if (((IntervalCorrespondence)tt.intervals.get(startIndex)).getInInterval().end == offset && startIndex < tt.intervals.size() - 1) {
                ++startIndex;
            }
            boolean foundMacroExpansion = false;
            int macroIndex = tt.intervals.size();
            for (i = startIndex; i >= 0; --i) {
                ic = (IntervalCorrespondence)tt.intervals.get(i);
                if (ic.isMacro()) {
                    span[0] = ic.getInInterval().start;
                    span[1] = ic.getInInterval().end;
                    foundMacroExpansion = true;
                    macroIndex = i;
                    break;
                }
                if (ic.getOutInterval().length() == 0) continue;
                return span;
            }
            if (foundMacroExpansion) {
                for (i = macroIndex + 1; i < tt.intervals.size(); ++i) {
                    ic = (IntervalCorrespondence)tt.intervals.get(i);
                    if (ic.getOutInterval().length() != 0) {
                        return span;
                    }
                    span[1] = ic.getInInterval().end;
                }
            }
        }
        return span;
    }

    public int[][] getUsages(Document expandedDoc, int offset) {
        TransformationTable tt;
        int startIndex;
        Object o = expandedDoc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable && 0 <= (startIndex = (tt = (TransformationTable)o).findInIntervalIndex(offset)) && startIndex < tt.intervals.size()) {
            if (((IntervalCorrespondence)tt.intervals.get(startIndex)).getInInterval().end == offset && startIndex < tt.intervals.size() - 1) {
                ++startIndex;
            }
            for (int i = startIndex; i >= 0; --i) {
                IntervalCorrespondence ic = (IntervalCorrespondence)tt.intervals.get(i);
                if (ic.isMacro()) {
                    if (ic.getParamsToExpansion() == null) break;
                    for (Interval in : ic.getParamsToExpansion().keySet()) {
                        if (!in.contains(offset)) continue;
                        List<Interval> intervals = ic.getParamsToExpansion().get(in);
                        int[][] usages = new int[intervals.size()][2];
                        for (int j = 0; j < usages.length; ++j) {
                            usages[j][0] = intervals.get(j).start;
                            usages[j][1] = intervals.get(j).end;
                        }
                        return usages;
                    }
                    break;
                }
                if (ic.getOutInterval().length() == 0) continue;
                return null;
            }
        }
        return null;
    }

    public String expand(Document doc, int offset, String code) {
        if (doc == null) {
            return code;
        }
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        if (!(file instanceof FileImpl)) {
            return code;
        }
        FileImpl fileImpl = (FileImpl)file;
        APTPreprocHandler handler = ((FileImpl)file).getPreprocHandler(offset);
        if (handler == null) {
            return code;
        }
        APTFile aptLight = null;
        try {
            aptLight = APTDriver.findAPTLight((APTFileBuffer)fileImpl.getBuffer());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (aptLight == null) {
            return code;
        }
        CsmProject project = file.getProject();
        if (!(project instanceof ProjectBase)) {
            return code;
        }
        ProjectBase base = (ProjectBase)project;
        APTFileCacheEntry cacheEntry = fileImpl.getAPTCacheEntry(handler, Boolean.FALSE);
        StopOnOffsetParseFileWalker walker = new StopOnOffsetParseFileWalker(base, aptLight, fileImpl, offset, handler, cacheEntry);
        walker.visit();
        TokenStream ts = APTTokenStreamBuilder.buildTokenStream((String)code, (String)fileImpl.getFileLanguage());
        if (ts != null) {
            ts = new APTMacroExpandedStream(ts, (APTMacroCallback)handler.getMacroMap());
            StringBuilder sb = new StringBuilder("");
            try {
                APTToken t = (APTToken)ts.nextToken();
                while (t != null && !APTUtils.isEOF((org.netbeans.modules.cnd.antlr.Token)t)) {
                    sb.append(t.getText());
                    t = (APTToken)ts.nextToken();
                }
            }
            catch (TokenStreamException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return sb.toString();
        }
        return code;
    }

    private String expandInterval(Document doc, TransformationTable tt, int startOffset, int endOffset) {
        IntervalCorrespondence ic;
        if (tt.intervals.isEmpty()) {
            return null;
        }
        int size = tt.intervals.size();
        int startIndex = tt.findInIntervalIndex(startOffset);
        if (startIndex < 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("");
        for (int i = startIndex; i < size && (ic = (IntervalCorrespondence)tt.intervals.get(i)).getInInterval().start < endOffset; ++i) {
            if (ic.getInInterval().end <= startOffset) continue;
            int startShift = startOffset - ic.getInInterval().start;
            if (startShift < 0) {
                startShift = 0;
            }
            if (startShift >= ic.getOutInterval().length()) continue;
            int endShift = startShift + (endOffset - startOffset);
            if (endOffset >= ic.getInInterval().end) {
                endShift = ic.getOutInterval().length();
            }
            if (endShift > ic.getOutInterval().length()) {
                endShift = ic.getOutInterval().length();
            }
            if (endShift - startShift == 0) continue;
            if (ic.isMacro()) {
                if (startShift == 0 && endShift == ic.getOutInterval().length()) {
                    sb.append(ic.getMacroExpansion());
                    continue;
                }
                sb.append(((Object)ic.getMacroExpansion()).toString().substring(startShift, endShift));
                continue;
            }
            if (ic.getOutInterval().length() == 0) continue;
            sb.append(MacroExpansionDocProviderImpl.getDocumentText(doc, ic.getInInterval().start + startShift, endShift - startShift));
        }
        return sb.toString();
    }

    private void expand(final Document doc, final CsmFile file, final TransformationTable tt) {
        if (doc == null) {
            return;
        }
        if (file == null) {
            return;
        }
        final MyTokenSequence fileTS = this.getFileTokenSequence(file, 0, doc.getLength());
        if (fileTS == null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TokenSequence docTS = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)doc.getLength(), (boolean)false, (boolean)true);
                if (docTS == null) {
                    return;
                }
                docTS.moveStart();
                int startOffset = 0;
                int endOffset = doc.getLength();
                tt.setInStart(startOffset);
                tt.setOutStart(0);
                boolean inMacroParams = false;
                boolean inDeadCode = true;
                while (docTS.moveNext()) {
                    Token docToken = docTS.token();
                    int docTokenStartOffset = docTS.offset();
                    int docTokenEndOffset = docTokenStartOffset + docToken.length();
                    if (MacroExpansionDocProviderImpl.this.isWhitespace((Token<TokenId>)docToken)) continue;
                    APTToken fileToken = MacroExpansionDocProviderImpl.this.findToken(fileTS, docTokenStartOffset);
                    if (fileToken == null) {
                        if (!inMacroParams && !inDeadCode) {
                            MacroExpansionDocProviderImpl.this.copyInterval(doc, (endOffset > docTokenStartOffset ? docTokenStartOffset : endOffset) - tt.currentIn.start, tt, null);
                        }
                        tt.appendInterval(endOffset - tt.currentIn.start, 0);
                        break;
                    }
                    if (docTokenEndOffset <= fileToken.getOffset() || !APTUtils.isMacroExpandedToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                        if (MacroExpansionDocProviderImpl.this.isOnInclude((TokenSequence<TokenId>)docTS)) {
                            if (!inMacroParams && !inDeadCode) {
                                MacroExpansionDocProviderImpl.this.copyInterval(doc, docTokenStartOffset - tt.currentIn.start, tt, null);
                            } else {
                                tt.appendInterval(docTokenStartOffset - tt.currentIn.start, 0);
                            }
                            MacroExpansionDocProviderImpl.this.expandIcludeToken((TokenSequence<TokenId>)docTS, doc, file, tt, null);
                        } else if (docTokenEndOffset <= fileToken.getOffset()) {
                            if (inMacroParams || inDeadCode) {
                                tt.appendInterval(docTokenEndOffset - tt.currentIn.start, 0);
                                continue;
                            }
                            MacroExpansionDocProviderImpl.this.copyInterval(doc, docTokenStartOffset - tt.currentIn.start, tt, null);
                            tt.appendInterval(docTokenEndOffset - tt.currentIn.start, 0);
                            inDeadCode = true;
                            continue;
                        }
                        inMacroParams = false;
                        inDeadCode = false;
                        continue;
                    }
                    MacroExpansionDocProviderImpl.this.copyInterval(doc, docTokenStartOffset - tt.currentIn.start, tt, null);
                    MacroExpansionDocProviderImpl.this.expandMacroToken(docTS, fileTS, tt, null);
                    inMacroParams = true;
                }
                MacroExpansionDocProviderImpl.this.copyInterval(doc, endOffset - tt.currentIn.start, tt, null);
            }
        };
        doc.render(r);
    }

    private String expandMacroToken(MyTokenSequence fileTS, int docTokenStartOffset, int docTokenEndOffset, TransformationTable tt) {
        APTToken fileToken = fileTS.token();
        StringBuilder expandedToken = new StringBuilder("");
        int expandedOffsetShift = 0;
        HashMap<Interval, List<Interval>> paramsToExpansion = new HashMap<Interval, List<Interval>>();
        boolean skipIndent = true;
        if (fileToken.getOffset() < docTokenEndOffset) {
            if (!APTUtils.isCommentToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                expandedToken.append(fileToken.getText());
                if (APTUtils.isMacroParamExpandedToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                    this.fillParamsToExpansionMap(fileToken, tt, expandedOffsetShift, paramsToExpansion);
                }
                expandedOffsetShift += fileToken.getText().length();
                skipIndent = false;
            }
            APTToken prevFileToken = fileToken;
            fileTS.moveNext();
            fileToken = fileTS.token();
            while (fileToken != null && !APTUtils.isEOF((org.netbeans.modules.cnd.antlr.Token)fileToken) && fileToken.getOffset() < docTokenEndOffset) {
                if (!APTUtils.isCommentToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                    if (!skipIndent && !APTUtils.areAdjacent((APTToken)prevFileToken, (APTToken)fileToken)) {
                        expandedToken.append(" ");
                        ++expandedOffsetShift;
                    }
                    skipIndent = false;
                    expandedToken.append(fileToken.getText());
                    if (APTUtils.isMacroParamExpandedToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                        this.fillParamsToExpansionMap(fileToken, tt, expandedOffsetShift, paramsToExpansion);
                    }
                    expandedOffsetShift += fileToken.getText().length();
                }
                prevFileToken = fileToken;
                fileTS.moveNext();
                fileToken = fileTS.token();
            }
        }
        tt.appendInterval(docTokenEndOffset - docTokenStartOffset, expandedToken.length(), true, expandedToken.toString(), paramsToExpansion);
        return expandedToken.toString();
    }

    private void expandMacroToken(TokenSequence docTS, MyTokenSequence fileTS, TransformationTable tt, StringBuilder expandedData) {
        this.expandMacroToken(docTS.token(), docTS.offset(), fileTS, tt, expandedData);
    }

    private void expandMacroToken(Token docToken, int docTokenStartOffset, MyTokenSequence fileTS, TransformationTable tt, StringBuilder expandedData) {
        String expandedToken = this.expandMacroToken(fileTS, docTokenStartOffset, docTokenStartOffset + docToken.length(), tt);
        this.addString(expandedToken, expandedData);
    }

    private void expandIcludeToken(TokenSequence<TokenId> docTS, Document inDoc, CsmFile file, TransformationTable tt, StringBuilder expandedData) {
        int incStartOffset = docTS.offset();
        String includeName = this.getIncludeName(file, incStartOffset);
        if (includeName == null) {
            return;
        }
        int incNameStartOffset = incStartOffset;
        int incNameEndOffset = incStartOffset;
        Token docToken = docTS.token();
        TokenId id = docToken.id();
        if (id instanceof CppTokenId) {
            block0 : switch ((CppTokenId)id) {
                case PREPROCESSOR_DIRECTIVE: {
                    TokenSequence embTS = docTS.embedded();
                    if (embTS == null) break;
                    embTS.moveStart();
                    if (!embTS.moveNext()) {
                        return;
                    }
                    Token embToken = embTS.token();
                    if (embToken == null || !(embToken.id() instanceof CppTokenId) || embToken.id() != CppTokenId.PREPROCESSOR_START) {
                        return;
                    }
                    if (!embTS.moveNext()) {
                        return;
                    }
                    this.skipWhitespacesAndComments(embTS);
                    embToken = embTS.token();
                    if (embToken == null || !(embToken.id() instanceof CppTokenId)) break;
                    switch ((CppTokenId)embToken.id()) {
                        case PREPROCESSOR_INCLUDE: {
                            if (!embTS.moveNext()) {
                                return;
                            }
                            this.skipWhitespacesAndComments(embTS);
                            incNameStartOffset = embTS.offset();
                            embToken = embTS.token();
                            while (embToken != null && embToken.id() instanceof CppTokenId && embToken.id() != CppTokenId.NEW_LINE) {
                                if (!embTS.moveNext()) {
                                    return;
                                }
                                incNameEndOffset = embTS.offset();
                                this.skipWhitespacesAndComments(embTS);
                                embToken = embTS.token();
                            }
                            break block0;
                        }
                        default: {
                            return;
                        }
                    }
                }
                default: {
                    return;
                }
            }
        }
        this.copyInterval(inDoc, incNameStartOffset - incStartOffset, tt, expandedData);
        int expandedLength = this.addString(includeName, expandedData);
        tt.appendInterval(incNameEndOffset - incNameStartOffset, expandedLength);
    }

    private String getIncludeName(CsmFile file, int offset) {
        for (CsmInclude inc : file.getIncludes()) {
            if (inc.getStartOffset() != offset) continue;
            if (inc.isSystem()) {
                StringBuilder sb = new StringBuilder("<");
                sb.append(((Object)inc.getIncludeName()).toString());
                sb.append(">");
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder("\"");
            sb.append(((Object)inc.getIncludeName()).toString());
            sb.append("\"");
            return sb.toString();
        }
        return null;
    }

    private void skipWhitespacesAndComments(TokenSequence ts) {
        if (ts != null) {
            Token token = ts.token();
            block3: while (token != null && token.id() instanceof CppTokenId) {
                switch ((CppTokenId)token.id()) {
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: 
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case ESCAPED_LINE: {
                        ts.moveNext();
                        token = ts.token();
                        continue block3;
                    }
                }
                return;
            }
        }
    }

    private void initGuardedBlocks(Document doc, TransformationTable tt) {
        if (doc instanceof StyledDocument) {
            for (IntervalCorrespondence ic : tt.intervals) {
                if (!ic.isMacro()) continue;
                NbDocument.markGuarded((StyledDocument)((StyledDocument)doc), (int)ic.getOutInterval().start, (int)ic.getOutInterval().length());
            }
        }
    }

    private int calcExpansionNumber(TransformationTable tt) {
        int expansionsNumber = 0;
        for (IntervalCorrespondence ic : tt.intervals) {
            if (!ic.isMacro()) continue;
            ++expansionsNumber;
        }
        return expansionsNumber;
    }

    private MyTokenSequence getFileTokenSequence(CsmFile file, int startOffset, int endOffset) {
        TokenStream ts;
        FileImpl fileImpl = null;
        if (file instanceof FileImpl && (ts = (fileImpl = (FileImpl)file).getTokenStream(startOffset, endOffset, 0, false)) != null) {
            return new MyTokenSequence(ts, fileImpl);
        }
        return null;
    }

    private void copyInterval(Document inDoc, int length, TransformationTable tt, StringBuilder expandedString) {
        if (length != 0) {
            this.addString(MacroExpansionDocProviderImpl.getDocumentText(inDoc, tt.currentIn.start, length), expandedString);
            tt.appendInterval(length, length);
        }
    }

    private static String getDocumentText(Document doc, int startOffset, int length) {
        try {
            int docLength = doc.getLength();
            startOffset = startOffset > 0 ? startOffset : 0;
            startOffset = startOffset < docLength ? startOffset : docLength;
            length = length > 0 ? length : 0;
            int n = length = startOffset + length <= docLength ? length : docLength - startOffset;
            if (length > 0) {
                return doc.getText(startOffset, length);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "";
    }

    private boolean isWhitespace(Token<TokenId> docToken) {
        TokenId id = docToken.id();
        if (id instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case WHITESPACE: 
                case ESCAPED_WHITESPACE: 
                case ESCAPED_LINE: 
                case NEW_LINE: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isOnInclude(TokenSequence<TokenId> docTS) {
        Token docToken = docTS.token();
        TokenId id = docToken.id();
        if (id instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case PREPROCESSOR_DIRECTIVE: {
                    TokenSequence embTS = docTS.embedded();
                    if (embTS == null) break;
                    embTS.moveStart();
                    if (!embTS.moveNext()) break;
                    Token embToken = embTS.token();
                    if (embToken == null || !(embToken.id() instanceof CppTokenId) || embToken.id() != CppTokenId.PREPROCESSOR_START) {
                        return false;
                    }
                    if (!embTS.moveNext()) break;
                    this.skipWhitespacesAndComments(embTS);
                    embToken = embTS.token();
                    if (embToken == null || !(embToken.id() instanceof CppTokenId)) break;
                    switch ((CppTokenId)embToken.id()) {
                        case PREPROCESSOR_INCLUDE: 
                        case PREPROCESSOR_INCLUDE_NEXT: {
                            return true;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private int addString(String s, StringBuilder expandedString) {
        if (expandedString != null) {
            expandedString.append(s);
        }
        return s.length();
    }

    String dumpTables(Document doc) {
        StringBuilder sb = new StringBuilder();
        TransformationTable tt = this.getMacroTable(doc);
        if (tt != null) {
            sb.append("MacroTable: ");
            sb.append(tt.toString());
        }
        if ((tt = this.getTransformationTable(doc)) != null) {
            sb.append("TransformationTable: ");
            sb.append(tt.toString());
        }
        return sb.toString();
    }

    private static IntervalCorrespondence createIntervalCorrespondence(Interval interval) {
        return new IntervalCorrespondenceSimple(interval, interval);
    }

    private static IntervalCorrespondence createIntervalCorrespondence(Interval in, Interval out, boolean macro, CharSequence macroExpansion, Map<Interval, List<Interval>> paramsToExpansion) {
        if (!macro && macroExpansion == null && paramsToExpansion == null) {
            return new IntervalCorrespondenceSimple(in, out);
        }
        if (paramsToExpansion != null && paramsToExpansion.isEmpty()) {
            paramsToExpansion = Collections.emptyMap();
        }
        return new IntervalCorrespondenceMacro(in, out, macro, macroExpansion, paramsToExpansion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransformationTable updateMacroTableIfNeeded(Document doc, CsmFile file) {
        if (file == null || doc == null) {
            return null;
        }
        TransformationTable tt = null;
        Object object = doc;
        synchronized (object) {
            tt = this.getMacroTable(doc);
            if (tt == null) {
                tt = new TransformationTable(DocumentUtilities.getDocumentVersion((Document)doc), CsmFileInfoQuery.getDefault().getFileVersion(file));
                doc.putProperty(MACRO_EXPANSION_MACRO_TABLE, tt);
            }
        }
        object = tt;
        synchronized (object) {
            Document document = doc;
            synchronized (document) {
                tt = this.getMacroTable(doc);
                if (tt.documentVersion != DocumentUtilities.getDocumentVersion((Document)doc) || tt.fileVersion != CsmFileInfoQuery.getDefault().getFileVersion(file)) {
                    tt = new TransformationTable(DocumentUtilities.getDocumentVersion((Document)doc), CsmFileInfoQuery.getDefault().getFileVersion(file));
                }
            }
            if (!tt.isInited()) {
                this.expand(doc, file, tt);
                tt.cleanUp();
                document = doc;
                synchronized (document) {
                    doc.putProperty(MACRO_EXPANSION_MACRO_TABLE, tt);
                }
            }
        }
        return tt;
    }

    private static class StopOnOffsetParseFileWalker
    extends APTParseFileWalker {
        private final int stopOffset;

        public StopOnOffsetParseFileWalker(ProjectBase base, APTFile apt, FileImpl file, int offset, APTPreprocHandler preprocHandler, APTFileCacheEntry cacheEntry) {
            super(base, apt, file, preprocHandler, false, null, cacheEntry);
            this.stopOffset = offset;
        }

        protected boolean onAPT(APT node, boolean wasInBranch) {
            if (node.getEndOffset() >= this.stopOffset) {
                this.stop();
                return false;
            }
            return super.onAPT(node, wasInBranch);
        }
    }

    private static class TransformationTable {
        private ArrayList<IntervalCorrespondence> intervals = new ArrayList();
        private Map<CharSequence, CharSequence> cache = new HashMap<CharSequence, CharSequence>();
        private Interval currentIn;
        private Interval currentOut;
        private final long documentVersion;
        private final long fileVersion;

        public TransformationTable(long documentVersion, long fileVersion) {
            this.documentVersion = documentVersion;
            this.fileVersion = fileVersion;
        }

        public void cleanUp() {
            this.cache = null;
        }

        public boolean isInited() {
            return this.cache == null;
        }

        public void setInStart(int start) {
            this.currentIn = new Interval(start);
        }

        public void setOutStart(int start) {
            this.currentOut = new Interval(start);
        }

        public void appendInterval(int inLength, int outLength) {
            this.appendInterval(inLength, outLength, false, null, null);
        }

        public void appendInterval(int inLength, int outLength, boolean macro, String macroExpansion, Map<Interval, List<Interval>> paramsToExpansion) {
            assert (this.cache != null);
            CharSequence cs = CharSequences.create((CharSequence)macroExpansion);
            CharSequence cachedCS = this.cache.get(cs);
            if (cachedCS != null) {
                cs = cachedCS;
            } else {
                this.cache.put(cs, cs);
            }
            this.currentIn.setLength(inLength);
            this.currentOut.setLength(outLength);
            this.intervals.add(MacroExpansionDocProviderImpl.createIntervalCorrespondence(this.currentIn, this.currentOut, macro, cs, paramsToExpansion));
            this.setInStart(this.currentIn.end);
            this.setOutStart(this.currentOut.end);
        }

        public int getOutOffset(int inOffset) {
            if (this.intervals.isEmpty()) {
                return inOffset;
            }
            if (this.intervals.get(0).getInInterval().start > inOffset) {
                int shift = this.intervals.get(0).getInInterval().start - inOffset;
                return this.intervals.get(0).getOutInterval().start - shift;
            }
            IntervalCorrespondence lastMacro = null;
            for (IntervalCorrespondence ic : this.intervals) {
                int shift;
                if (ic.getOutInterval().length() != 0) {
                    lastMacro = null;
                }
                if (ic.isMacro()) {
                    lastMacro = ic;
                }
                if (!ic.getInInterval().contains(inOffset)) continue;
                if (ic.getOutInterval().length() == 0 && lastMacro != null) {
                    for (Interval i : lastMacro.getParamsToExpansion().keySet()) {
                        Interval j;
                        if (!i.contains(inOffset)) continue;
                        int shift2 = inOffset - i.start;
                        if (shift2 >= (j = lastMacro.getParamsToExpansion().get(i).get(0)).length() || shift2 >= j.length()) {
                            return j.end;
                        }
                        return j.start + shift2;
                    }
                }
                if ((shift = inOffset - ic.getInInterval().start) >= ic.getInInterval().length() || shift >= ic.getOutInterval().length()) {
                    return ic.getOutInterval().end;
                }
                if (ic.isMacro()) {
                    return ic.getOutInterval().start;
                }
                return ic.getOutInterval().start + shift;
            }
            int shift = inOffset - this.intervals.get(this.intervals.size() - 1).getInInterval().end;
            return this.intervals.get(this.intervals.size() - 1).getOutInterval().end + shift;
        }

        public int getInOffset(int outOffset) {
            if (this.intervals.isEmpty()) {
                return outOffset;
            }
            if (this.intervals.get(0).getOutInterval().start > outOffset) {
                int shift = this.intervals.get(0).getOutInterval().start - outOffset;
                return this.intervals.get(0).getInInterval().start - shift;
            }
            for (IntervalCorrespondence ic : this.intervals) {
                int shift;
                if (!ic.getOutInterval().contains(outOffset)) continue;
                if (ic.isMacro()) {
                    for (Interval i : ic.getParamsToExpansion().keySet()) {
                        for (Interval j : ic.getParamsToExpansion().get(i)) {
                            if (!j.contains(outOffset)) continue;
                            int shift2 = outOffset - j.start;
                            if (shift2 >= i.length() || shift2 >= j.length()) {
                                return i.end;
                            }
                            return i.start + shift2;
                        }
                    }
                }
                if ((shift = outOffset - ic.getOutInterval().start) >= ic.getOutInterval().length() || shift >= ic.getInInterval().length()) {
                    return ic.getInInterval().end;
                }
                if (ic.isMacro()) {
                    return ic.getInInterval().start;
                }
                return ic.getInInterval().start + shift;
            }
            int shift = outOffset - this.intervals.get(this.intervals.size() - 1).getOutInterval().end;
            return this.intervals.get(this.intervals.size() - 1).getInInterval().end + shift;
        }

        public int getNextMacroExpansionStartOffset(int outOffset) {
            if (this.intervals.isEmpty()) {
                return outOffset;
            }
            for (IntervalCorrespondence ic : this.intervals) {
                if (ic.getOutInterval().start <= outOffset || !ic.isMacro()) continue;
                return ic.getOutInterval().start;
            }
            return outOffset;
        }

        public int getPrevMacroExpansionStartOffset(int outOffset) {
            if (this.intervals.isEmpty()) {
                return outOffset;
            }
            int result = outOffset;
            for (IntervalCorrespondence ic : this.intervals) {
                if (ic.getOutInterval().end >= outOffset) {
                    return result;
                }
                if (!ic.isMacro()) continue;
                result = ic.getOutInterval().start;
            }
            return outOffset;
        }

        public int findInIntervalIndex(int offset) {
            return Collections.binarySearch(this.intervals, MacroExpansionDocProviderImpl.createIntervalCorrespondence(new Interval(offset, offset)), new Comparator<IntervalCorrespondence>(){

                @Override
                public int compare(IntervalCorrespondence o1, IntervalCorrespondence o2) {
                    if (o1.getInInterval().end < o2.getInInterval().start) {
                        return -1;
                    }
                    if (o1.getInInterval().start > o2.getInInterval().end) {
                        return 1;
                    }
                    return 0;
                }
            });
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("");
            for (IntervalCorrespondence ic : this.intervals) {
                sb.append("[" + ic.getInInterval().start + "," + ic.getInInterval().end + "] => [" + ic.getOutInterval().start + "," + ic.getOutInterval().end + "]\n");
            }
            return sb.toString();
        }
    }

    private static class IntervalCorrespondenceMacro
    extends IntervalCorrespondence {
        private final boolean macro;
        private final CharSequence macroExpansion;
        private final Map<Interval, List<Interval>> paramsToExpansion;

        private IntervalCorrespondenceMacro(Interval in, Interval out, boolean macro, CharSequence macroExpansion, Map<Interval, List<Interval>> paramsToExpansion) {
            super(in, out);
            this.macro = macro;
            this.macroExpansion = macroExpansion;
            this.paramsToExpansion = paramsToExpansion;
        }

        @Override
        public CharSequence getMacroExpansion() {
            return this.macroExpansion;
        }

        @Override
        public boolean isMacro() {
            return this.macro;
        }

        @Override
        public Map<Interval, List<Interval>> getParamsToExpansion() {
            return this.paramsToExpansion;
        }
    }

    private static class IntervalCorrespondenceSimple
    extends IntervalCorrespondence {
        private IntervalCorrespondenceSimple(Interval in, Interval out) {
            super(in, out);
        }

        @Override
        public boolean isMacro() {
            return false;
        }
    }

    private static abstract class IntervalCorrespondence {
        private final Interval inInterval;
        private final Interval outInterval;

        public IntervalCorrespondence(Interval in, Interval out) {
            this.inInterval = in;
            this.outInterval = out;
        }

        public CharSequence getMacroExpansion() {
            return null;
        }

        public Interval getInInterval() {
            return this.inInterval;
        }

        public Interval getOutInterval() {
            return this.outInterval;
        }

        public abstract boolean isMacro();

        public Map<Interval, List<Interval>> getParamsToExpansion() {
            return null;
        }

        public String toString() {
            return "IN:" + this.getInInterval() + " OUT:" + this.getOutInterval();
        }
    }

    private static class Interval {
        private final int start;
        private int end;

        public Interval(int start) {
            this.start = start;
            this.end = start;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public void setLength(int length) {
            this.end = this.start + length;
        }

        public Interval(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public Interval(Interval i, int shift) {
            this.start = i.start + shift;
            this.end = i.end + shift;
        }

        public int length() {
            return this.end - this.start;
        }

        public boolean contains(int offset) {
            return this.start <= offset && this.end >= offset;
        }

        public boolean equals(Object o) {
            if (o instanceof Interval) {
                Interval i = (Interval)o;
                return this.start == i.start && this.end == i.end;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + this.start;
            hash = 79 * hash + this.end;
            return hash;
        }

        public String toString() {
            return "[" + this.start + "-" + this.end + "]";
        }
    }

    private static class MyTokenSequence {
        private final TokenStream ts;
        private final FileImpl file;
        private APTToken currentToken = null;

        public MyTokenSequence(TokenStream ts, FileImpl file) {
            this.ts = ts;
            this.file = file;
            this.moveNext();
        }

        public APTToken token() {
            return this.currentToken;
        }

        public void moveNext() {
            try {
                this.currentToken = (APTToken)this.ts.nextToken();
            }
            catch (TokenStreamException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

