/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.java.api.common.project.ui.customizer.EditMediator;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CustomizerLibraries
extends JPanel
implements HelpCtx.Provider,
ListDataListener {
    private EarProjectProperties uiProperties;
    private boolean isSharable;
    private JButton jButtonAddJar;
    private JButton jButtonAddLib;
    private JButton jButtonAddProject;
    private JButton jButtonEdit;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonRemove;
    private JLabel jLabelEmbeddedCP;
    private JLabel jLabelErrorMessage;
    private JList jListCp;
    private JScrollPane jScrollPane2;
    private JButton librariesBrowse;
    private JTextField librariesLocation;
    private JLabel sharedLibrariesLabel;

    public CustomizerLibraries(EarProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        this.jListCp.setModel(uiProperties.DEBUG_CLASSPATH_MODEL);
        this.jListCp.setCellRenderer(uiProperties.CLASS_PATH_LIST_RENDERER);
        EditMediator.register((Project)uiProperties.getProject(), (AntProjectHelper)uiProperties.getProject().getAntProjectHelper(), (ReferenceHelper)uiProperties.getProject().getReferenceHelper(), (EditMediator.ListComponent)EditMediator.createListComponent((JList)this.jListCp), (ButtonModel)this.jButtonAddJar.getModel(), (ButtonModel)this.jButtonAddLib.getModel(), (ButtonModel)this.jButtonAddProject.getModel(), (ButtonModel)this.jButtonRemove.getModel(), (ButtonModel)this.jButtonMoveUp.getModel(), (ButtonModel)this.jButtonMoveDown.getModel(), (ButtonModel)this.jButtonEdit.getModel(), (Document)uiProperties.SHARED_LIBRARIES_MODEL, null, (String[])new String[]{"j2ee_ear_archive", "jar", "folder"}, (FileFilter)EditMediator.JAR_ZIP_FILTER, (int)2);
        this.librariesLocation.setDocument(uiProperties.SHARED_LIBRARIES_MODEL);
        this.testBroken();
        uiProperties.DEBUG_CLASSPATH_MODEL.addListDataListener(this);
        this.isSharable = uiProperties.getProject().getAntProjectHelper().isSharableProject();
        if (!this.isSharable) {
            this.sharedLibrariesLabel.setEnabled(false);
            this.librariesLocation.setEnabled(false);
            this.librariesBrowse.setText(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_CustomizeLibraries_MakeSharable"));
        } else {
            this.librariesLocation.setText(uiProperties.getProject().getAntProjectHelper().getLibrariesLocation());
        }
    }

    private void testBroken() {
        DefaultListModel[] models = new DefaultListModel[]{this.uiProperties.DEBUG_CLASSPATH_MODEL, this.uiProperties.ENDORSED_CLASSPATH_MODEL};
        boolean broken = false;
        for (int i = 0; i < models.length; ++i) {
            Iterator it = ClassPathUiSupport.getIterator((DefaultListModel)models[i]);
            while (it.hasNext()) {
                if (!((ClassPathSupport.Item)it.next()).isBroken()) continue;
                broken = true;
                break;
            }
            if (broken) break;
        }
        if (broken) {
            this.jLabelErrorMessage.setText(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_CustomizeLibraries_Libraries_Error"));
        } else {
            this.jLabelErrorMessage.setText(" ");
        }
    }

    private static String[] splitPath(String s) {
        int i = Math.max(s.lastIndexOf(47), s.lastIndexOf(92));
        if (i == -1) {
            return new String[]{s, null};
        }
        return new String[]{s.substring(0, i), s.substring(i + 1)};
    }

    private void switchLibrary() {
        LibraryManager man;
        String loc = this.librariesLocation.getText();
        if (loc.trim().length() > -1) {
            try {
                File base = FileUtil.toFile((FileObject)this.uiProperties.getProject().getProjectDirectory());
                File location = FileUtil.normalizeFile((File)PropertyUtils.resolveFile((File)base, (String)loc));
                URL url = location.toURI().toURL();
                man = LibraryManager.forLocation((URL)url);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                man = LibraryManager.getDefault();
            }
        } else {
            man = LibraryManager.getDefault();
        }
        DefaultListModel[] models = new DefaultListModel[]{this.uiProperties.DEBUG_CLASSPATH_MODEL, this.uiProperties.ENDORSED_CLASSPATH_MODEL};
        for (int i = 0; i < models.length; ++i) {
            Iterator it = ClassPathUiSupport.getIterator((DefaultListModel)models[i]);
            while (it.hasNext()) {
                ClassPathSupport.Item itm = (ClassPathSupport.Item)it.next();
                if (itm.getType() != 1) continue;
                itm.reassignLibraryManager(man);
            }
        }
        this.jListCp.repaint();
        this.testBroken();
    }

    private void initComponents() {
        this.jLabelEmbeddedCP = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jListCp = new JList();
        this.jButtonAddJar = new JButton();
        this.jButtonAddLib = new JButton();
        this.jButtonAddProject = new JButton();
        this.jButtonRemove = new JButton();
        this.sharedLibrariesLabel = new JLabel();
        this.librariesLocation = new JTextField();
        this.librariesBrowse = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jLabelErrorMessage = new JLabel();
        this.jLabelEmbeddedCP.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabelEmbeddedCP, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizerRun_EmbeddedClasspathElements_JLabel"));
        this.jLabelEmbeddedCP.setVerticalAlignment(1);
        this.jScrollPane2.setPreferredSize(new Dimension(252, 202));
        this.jScrollPane2.setViewportView(this.jListCp);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddJar, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeEAR_AddJar_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddLib, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_AddLibrary_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddProject, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_AddProject_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonRemove, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_Remove_JButton"));
        Mnemonics.setLocalizedText((JLabel)this.sharedLibrariesLabel, (String)MessageFormat.format(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_CustomizeGeneral_SharedLibraries"), new Object[0]));
        this.librariesLocation.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.librariesBrowse, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_CustomizerLibraries_Browse_JButton"));
        this.librariesBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.librariesBrowseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonEdit, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_Edit_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMoveUp, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_MoveUp_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMoveDown, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_MoveDown_JButton"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelErrorMessage, (String)" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelEmbeddedCP).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sharedLibrariesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.librariesLocation, -1, 333, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -1, 464, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.librariesBrowse, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddProject, GroupLayout.Alignment.TRAILING, -2, 119, Short.MAX_VALUE).addComponent(this.jButtonAddLib, GroupLayout.Alignment.TRAILING, -2, 119, Short.MAX_VALUE).addComponent(this.jButtonAddJar, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit, GroupLayout.Alignment.TRAILING, -1, 119, Short.MAX_VALUE).addComponent(this.jButtonRemove, GroupLayout.Alignment.TRAILING, -1, 119, Short.MAX_VALUE).addComponent(this.jButtonMoveUp, GroupLayout.Alignment.TRAILING, -1, 119, Short.MAX_VALUE).addComponent(this.jButtonMoveDown, GroupLayout.Alignment.TRAILING, -1, 119, Short.MAX_VALUE))).addComponent(this.jLabelErrorMessage, -1, 619, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sharedLibrariesLabel).addComponent(this.librariesLocation, -2, -1, -2).addComponent(this.librariesBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelEmbeddedCP).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAddProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddLib).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddJar).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonRemove).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonMoveUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMoveDown)).addComponent(this.jScrollPane2, -1, 271, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelErrorMessage)));
    }

    private void librariesBrowseActionPerformed(ActionEvent evt) {
        if (!this.isSharable) {
            boolean result = CustomizerLibraries.makeSharable(this.uiProperties, new String[1]);
            if (result) {
                this.isSharable = true;
                this.sharedLibrariesLabel.setEnabled(true);
                this.librariesLocation.setEnabled(true);
                this.librariesLocation.setText(this.uiProperties.getProject().getAntProjectHelper().getLibrariesLocation());
                Mnemonics.setLocalizedText((AbstractButton)this.librariesBrowse, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_CustomizerLibraries_Browse_JButton"));
                this.updateJars(this.uiProperties.DEBUG_CLASSPATH_MODEL);
                this.updateJars(this.uiProperties.ENDORSED_CLASSPATH_MODEL);
                this.switchLibrary();
            }
        } else {
            File prjLoc = FileUtil.toFile((FileObject)this.uiProperties.getProject().getProjectDirectory());
            String[] s = CustomizerLibraries.splitPath(this.librariesLocation.getText().trim());
            String loc = SharableLibrariesUtils.browseForLibraryLocation((String)s[0], (Component)this, (File)prjLoc);
            if (loc != null) {
                this.librariesLocation.setText(s[1] != null ? loc + File.separator + s[1] : loc + File.separator + "nblibraries.properties");
                this.switchLibrary();
            }
        }
    }

    static boolean makeSharable(EarProjectProperties uiProperties, String[] returnServerLibrary) {
        ArrayList<String> libs = new ArrayList<String>();
        ArrayList<String> jars = new ArrayList<String>();
        CustomizerLibraries.collectLibs(uiProperties.DEBUG_CLASSPATH_MODEL, libs, jars);
        CustomizerLibraries.collectLibs(uiProperties.EAR_CONTENT_ADDITIONAL_MODEL.getDefaultListModel(), libs, jars);
        CustomizerLibraries.collectLibs(uiProperties.ENDORSED_CLASSPATH_MODEL, libs, jars);
        libs.add("CopyLibs");
        boolean res = SharableLibrariesUtils.showMakeSharableWizard((AntProjectHelper)uiProperties.getProject().getAntProjectHelper(), (ReferenceHelper)uiProperties.getProject().getReferenceHelper(), libs, jars);
        return res;
    }

    private static void collectLibs(DefaultListModel model, List<String> libs, List<String> jarReferences) {
        for (int i = 0; i < model.size(); ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)model.get(i);
            if (item.getType() == 1 && !item.isBroken() && !libs.contains(item.getLibrary().getName())) {
                libs.add(item.getLibrary().getName());
            }
            if (item.getType() != 0 || item.getReference() == null || item.getVariableBasedProperty() != null || jarReferences.contains(item.getReference())) continue;
            jarReferences.add(item.getReference());
        }
    }

    private void updateJars(DefaultListModel model) {
        for (int i = 0; i < model.size(); ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)model.get(i);
            if (item.getType() != 0 || item.getReference() == null) continue;
            item.updateJarReference(this.uiProperties.getProject().getAntProjectHelper());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerLibraries.class);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.testBroken();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.testBroken();
    }
}

