/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.project.ui.DeployOnSaveUtils;
import org.netbeans.modules.j2ee.common.project.ui.J2EEProjectProperties;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ProjectEar;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class EarActionProvider
implements ActionProvider {
    private static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    private static final String COMMAND_COMPILE = "compile";
    private static final String COMMAND_VERIFY = "verify";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "run", "debug", "redeploy", "verify", "delete", "copy", "move", "rename"};
    EarProject project;
    private final UpdateHelper updateHelper;
    Map<String, String[]> commands = new HashMap<String, String[]>();

    public EarActionProvider(EarProject project, UpdateHelper updateHelper) {
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("redeploy", new String[]{"run-deploy"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put(COMMAND_COMPILE, new String[]{COMMAND_COMPILE});
        this.commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
        this.updateHelper = updateHelper;
        this.project = project;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject(this.project.getBuildXmlName());
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(String command, final Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        String realCommand = command;
        J2eeModuleProvider.DeployOnSaveSupport support = this.project.getAppModule().getDeployOnSaveSupport();
        if ("build".equals(realCommand) && this.isCosEnabled() && support != null && support.containsIdeArtifacts()) {
            boolean cleanAndBuild = DeployOnSaveUtils.showBuildActionWarning((Project)this.project, (DeployOnSaveUtils.CustomizerPresenter)new DeployOnSaveUtils.CustomizerPresenter(){

                public void showCustomizer(String category) {
                    CustomizerProviderImpl provider = (CustomizerProviderImpl)EarActionProvider.this.project.getLookup().lookup(CustomizerProviderImpl.class);
                    provider.showCustomizer(category);
                }
            });
            if (cleanAndBuild) {
                realCommand = "rebuild";
            } else {
                return;
            }
        }
        final String commandToExecute = realCommand;
        Runnable action = new Runnable(){

            @Override
            public void run() {
                Properties p = new Properties();
                String[] targetNames = EarActionProvider.this.getTargetNames(commandToExecute, context, p);
                if (targetNames == null) {
                    return;
                }
                if (targetNames.length == 0) {
                    targetNames = null;
                }
                if (p.keySet().size() == 0) {
                    p = null;
                }
                final ProjectEar app = EarActionProvider.this.project.getAppModule();
                try {
                    Deployment.getDefault().suspendDeployOnSave((J2eeModuleProvider)app);
                    ActionUtils.runTarget((FileObject)EarActionProvider.this.findBuildXml(), (String[])targetNames, (Properties)p).addTaskListener(new TaskListener(){

                        public void taskFinished(Task task) {
                            Deployment.getDefault().resumeDeployOnSave((J2eeModuleProvider)app);
                        }
                    });
                }
                catch (IOException e) {
                    Deployment.getDefault().resumeDeployOnSave((J2eeModuleProvider)app);
                    Exceptions.printStackTrace((Throwable)e);
                }
                catch (RuntimeException ex) {
                    Deployment.getDefault().resumeDeployOnSave((J2eeModuleProvider)app);
                    throw ex;
                }
            }
        };
        action.run();
    }

    String[] getTargetNames(String command, Lookup context, Properties p) throws IllegalArgumentException {
        String[] targetNames = this.commands.get(command);
        if (command.equals("run") || command.equals("redeploy")) {
            if (!this.isSelectedServer()) {
                String msg = NbBundle.getMessage(EarActionProvider.class, (String)"MSG_No_Server_Selected");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
                return null;
            }
            if (command.equals("run") && this.isDebugged()) {
                p.setProperty("is.debugged", "true");
            }
            if (command.equals("redeploy")) {
                p.setProperty("forceRedeploy", "true");
            } else {
                p.setProperty("forceRedeploy", "false");
            }
            this.setDirectoryDeploymentProperty(p);
        } else if (command.equals("debug")) {
            SubprojectProvider spp;
            if (!this.isSelectedServer()) {
                String msg = NbBundle.getMessage(EarActionProvider.class, (String)"MSG_No_Server_Selected");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
                return null;
            }
            this.setDirectoryDeploymentProperty(p);
            if (this.isDebugged()) {
                p.setProperty("is.debugged", "true");
            }
            if (null != (spp = (SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class))) {
                StringBuilder edbd = new StringBuilder();
                Set s = spp.getSubprojects();
                for (Project proj : s) {
                    FileObject fo;
                    WebModule wm;
                    WebModuleProvider wmp = (WebModuleProvider)proj.getLookup().lookup(WebModuleProvider.class);
                    if (null == wmp || null == (wm = wmp.findWebModule(proj.getProjectDirectory())) || null == (fo = wm.getDocumentBase())) continue;
                    edbd.append(FileUtil.toFile((FileObject)fo).getAbsolutePath() + ":");
                }
                p.setProperty("ear.docbase.dirs", edbd.toString());
            }
        } else if (targetNames == null) {
            throw new IllegalArgumentException(command);
        }
        return targetNames;
    }

    private void setDirectoryDeploymentProperty(Properties p) {
        String instance = this.updateHelper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (instance != null) {
            J2eeModuleProvider jmp = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            String sdi = jmp.getServerInstanceID();
            J2eeModule mod = jmp.getJ2eeModule();
            if (sdi != null && mod != null) {
                boolean cFD = Deployment.getDefault().canFileDeploy(instance, mod);
                p.setProperty(DIRECTORY_DEPLOYMENT_SUPPORTED, "" + cFD);
            }
        }
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if (this.findBuildXml() == null) {
            return false;
        }
        J2eeModuleProvider.DeployOnSaveSupport support = this.project.getAppModule().getDeployOnSaveSupport();
        if (this.isCosEnabled() && support != null && support.containsIdeArtifacts() && "compile.single".equals(command)) {
            return false;
        }
        if (command.equals(COMMAND_VERIFY)) {
            J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            return provider != null && provider.hasVerifierSupport();
        }
        if (command.equals("run")) {
            boolean isAppClientSelected = this.project.evaluator().getProperty("app.client") != null;
            return this.isSelectedServer() && (!isAppClientSelected || !this.isTargetServerRemote());
        }
        return true;
    }

    private boolean isDebugged() {
        J2eeModuleProvider jmp = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (null == jmp) {
            return false;
        }
        ServerDebugInfo sdi = null;
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            if (null == sdi && null == (sdi = jmp.getServerDebugInfo())) {
                return false;
            }
            AttachingDICookie attCookie = (AttachingDICookie)o;
            if (!(sdi.getTransport().equals("dt_shmem") ? attCookie.getSharedMemoryName().equalsIgnoreCase(sdi.getShmemName()) : attCookie.getHostName() != null && attCookie.getHostName().equalsIgnoreCase(sdi.getHost()) && attCookie.getPortNumber() == sdi.getPort())) continue;
            return true;
        }
        return false;
    }

    private boolean isSelectedServer() {
        String instanceID;
        String id;
        String instance = this.updateHelper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (instance != null && (id = Deployment.getDefault().getServerID(instance)) != null) {
            return true;
        }
        String serverType = this.updateHelper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.type");
        if (serverType != null && (instanceID = J2EEProjectProperties.getMatchingInstance((String)serverType, (J2eeModule.Type)J2eeModule.Type.EAR, (Profile)this.project.getJ2eeProfile())) != null) {
            EarProjectProperties.setServerInstance(this.project, this.updateHelper, instanceID);
            return true;
        }
        return false;
    }

    private boolean isTargetServerRemote() {
        J2eeModuleProvider module = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        InstanceProperties props = module.getInstanceProperties();
        String domain = props.getProperty("DOMAIN");
        String location = props.getProperty("LOCATION");
        return "".equals(domain) && "".equals(location);
    }

    private boolean isCosEnabled() {
        return Boolean.parseBoolean(this.project.evaluator().getProperty("j2ee.compile.on.save"));
    }
}

