/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.api.schema;

import javax.xml.namespace.QName;
import org.netbeans.modules.e2e.api.schema.RepeatableSchemaConstruct;
import org.netbeans.modules.e2e.api.schema.SchemaConstruct;
import org.netbeans.modules.e2e.api.schema.Type;

public class Element
extends RepeatableSchemaConstruct {
    private boolean nillable;
    private Type elementType;

    public Element() {
        super(SchemaConstruct.ConstructType.ELEMENT);
        this.setMinOccurs(1);
        this.setMaxOccurs(1);
        this.nillable = false;
    }

    public Element(QName name) {
        super(SchemaConstruct.ConstructType.ELEMENT, name);
        this.setMinOccurs(1);
        this.setMaxOccurs(1);
        this.nillable = false;
        this.setName(name);
    }

    public Element(QName name, Type elementType) {
        this(name);
        this.elementType = elementType;
    }

    public Element(QName name, Type elementType, int minOccurs, int maxOccurs) {
        this(name, elementType);
        this.nillable = false;
        this.setMinOccurs(minOccurs);
        this.setMaxOccurs(maxOccurs);
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setType(Type elementType) {
        this.elementType = elementType;
    }

    public Type getType() {
        return this.elementType;
    }

    @Override
    public String getJavaName() {
        String javaName = this.getJavaName();
        if (javaName != null) {
            return javaName;
        }
        return this.getName().getLocalPart() + (this.getMaxOccurs() > 1 ? "[]" : "");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("element");
        if (this.getName() != null) {
            sb.append(" name='");
            sb.append(this.getName());
            sb.append("'");
        }
        sb.append(" minOccurs='");
        sb.append(this.getMinOccurs());
        sb.append("'");
        if (this.getMaxOccurs() == Integer.MAX_VALUE) {
            sb.append(" maxOccurs='unbounded'");
        } else {
            sb.append(" maxOccurs='");
            sb.append(this.getMaxOccurs());
            sb.append("'");
        }
        sb.append(" nillable='");
        sb.append(this.nillable);
        sb.append("'");
        sb.append('\n');
        return sb.toString();
    }
}

