/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tabview;

import java.io.IOException;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.tabview.TabView;
import org.primefaces.event.TabChangeEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class TabViewRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        TabView tabView;
        Map params = context.getExternalContext().getRequestParameterMap();
        String activeIndexValue = (String)params.get((tabView = (TabView)component).getClientId(context) + "_activeIndex");
        if (!this.isValueEmpty(activeIndexValue)) {
            tabView.setActiveIndex(Integer.parseInt(activeIndexValue));
        }
        if (tabView.isTabChangeRequest(context)) {
            TabChangeEvent changeEvent = new TabChangeEvent((UIComponent)tabView, tabView.findTabToLoad(context));
            changeEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            tabView.queueEvent(changeEvent);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        TabView tabView = (TabView)component;
        if (tabView.isContentLoadRequest(context)) {
            Tab tabToLoad = tabView.findTabToLoad(context);
            tabToLoad.encodeAll(context);
        } else {
            this.encodeMarkup(context, tabView);
            this.encodeScript(context, tabView);
        }
    }

    protected void encodeScript(FacesContext context, TabView tabView) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tabView.getClientId(context);
        MethodExpression tabChangeListener = tabView.getTabChangeListener();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(tabView.resolveWidgetVar() + " = new PrimeFaces.widget.TabView('" + clientId + "', {");
        writer.write("selected:" + tabView.getActiveIndex());
        writer.write(",dynamic:" + tabView.isDynamic());
        if (tabView.isDynamic() || tabChangeListener != null) {
            writer.write(",url:'" + this.getActionURL(context) + "'");
            writer.write(",cache:" + tabView.isCache());
        }
        if (tabView.isCollapsible()) {
            writer.write(",collapsible:true");
        }
        if (tabView.getEvent() != null) {
            writer.write(",event:'" + tabView.getEvent() + "'");
        }
        if (tabView.getOnTabChange() != null) {
            writer.write(",onTabChange: function(event, ui) {" + tabView.getOnTabChange() + "}");
        }
        if (tabView.getOnTabShow() != null) {
            writer.write(",onTabShow:function(event, ui) {" + tabView.getOnTabShow() + "}");
        }
        if (tabView.getEffect() != null) {
            writer.write(",fx: {");
            writer.write(tabView.getEffect() + ":'toggle'");
            writer.write(",duration:'" + tabView.getEffectDuration() + "'");
            writer.write("}");
        }
        if (tabChangeListener != null) {
            writer.write(",ajaxTabChange:true");
            if (tabView.getOnTabChangeUpdate() != null) {
                writer.write(",onTabChangeUpdate:'" + ComponentUtils.findClientIds(context, (UIComponent)tabView, tabView.getOnTabChangeUpdate()) + "'");
            }
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, TabView tabView) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tabView.getClientId(facesContext);
        int activeIndex = tabView.getActiveIndex();
        writer.startElement("div", (UIComponent)tabView);
        writer.writeAttribute("id", (Object)clientId, null);
        if (tabView.getStyle() != null) {
            writer.writeAttribute("style", (Object)tabView.getStyle(), "style");
        }
        if (tabView.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)tabView.getStyleClass(), "styleClass");
        }
        this.encodeHeaders(facesContext, tabView, activeIndex);
        this.encodeContents(facesContext, tabView, activeIndex);
        this.encodeActiveIndexHolder(facesContext, tabView);
        writer.endElement("div");
    }

    protected void encodeActiveIndexHolder(FacesContext facesContext, TabView tabView) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String paramName = tabView.getClientId(facesContext) + "_activeIndex";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)paramName, null);
        writer.writeAttribute("name", (Object)paramName, null);
        writer.writeAttribute("value", (Object)tabView.getActiveIndex(), null);
        writer.endElement("input");
    }

    protected void encodeHeaders(FacesContext facesContext, TabView tabView, int activeTabIndex) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("ul", null);
        for (UIComponent kid : tabView.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof Tab)) continue;
            Tab tab = (Tab)kid;
            writer.startElement("li", null);
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)("#" + tab.getClientId(facesContext)), null);
            writer.startElement("em", null);
            writer.write(tab.getTitle());
            writer.endElement("em");
            writer.endElement("a");
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    protected void encodeContents(FacesContext facesContext, TabView tabView, int activeTabIndex) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (int i = 0; i < tabView.getChildren().size(); ++i) {
            UIComponent kid = (UIComponent)tabView.getChildren().get(i);
            if (!kid.isRendered() || !(kid instanceof Tab)) continue;
            Tab tab = (Tab)kid;
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)tab.getClientId(facesContext), null);
            if (tabView.isDynamic()) {
                if (i == activeTabIndex) {
                    tab.encodeAll(facesContext);
                }
            } else {
                tab.encodeAll(facesContext);
            }
            writer.endElement("div");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

