/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.layout;

import java.io.Serializable;
import java.util.ArrayList;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.component.layout.LayoutUnit;
import org.primefaces.event.CloseEvent;
import org.primefaces.event.ResizeEvent;
import org.primefaces.event.ToggleEvent;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="yui/resize/assets/skins/sam/resize.css"), @ResourceDependency(library="primefaces", name="layout/layout.css"), @ResourceDependency(library="primefaces", name="yui/utilities/utilities.js"), @ResourceDependency(library="primefaces", name="yui/resize/resize-min.js"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core/core.js"), @ResourceDependency(library="primefaces", name="layout/layout.js")})
public class Layout
extends UIPanel
implements Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Layout";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.LayoutRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.component.";

    public Layout() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
        this.handleAttribute("widgetVar", _widgetVar);
    }

    public boolean isFullPage() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fullPage), (Object)false);
    }

    public void setFullPage(boolean _fullPage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fullPage), (Object)_fullPage);
        this.handleAttribute("fullPage", _fullPage);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
        this.handleAttribute("style", _style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
        this.handleAttribute("styleClass", _styleClass);
    }

    public String getCloseTitle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.closeTitle), null);
    }

    public void setCloseTitle(String _closeTitle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.closeTitle), (Object)_closeTitle);
        this.handleAttribute("closeTitle", _closeTitle);
    }

    public String getCollapseTitle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.collapseTitle), null);
    }

    public void setCollapseTitle(String _collapseTitle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.collapseTitle), (Object)_collapseTitle);
        this.handleAttribute("collapseTitle", _collapseTitle);
    }

    public String getExpandTitle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.expandTitle), null);
    }

    public void setExpandTitle(String _expandTitle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expandTitle), (Object)_expandTitle);
        this.handleAttribute("expandTitle", _expandTitle);
    }

    public MethodExpression getCloseListener() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.closeListener), null);
    }

    public void setCloseListener(MethodExpression _closeListener) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.closeListener), (Object)_closeListener);
        this.handleAttribute("closeListener", _closeListener);
    }

    public String getOnCloseUpdate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onCloseUpdate), null);
    }

    public void setOnCloseUpdate(String _onCloseUpdate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onCloseUpdate), (Object)_onCloseUpdate);
        this.handleAttribute("onCloseUpdate", _onCloseUpdate);
    }

    public MethodExpression getToggleListener() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.toggleListener), null);
    }

    public void setToggleListener(MethodExpression _toggleListener) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.toggleListener), (Object)_toggleListener);
        this.handleAttribute("toggleListener", _toggleListener);
    }

    public String getOnToggleUpdate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onToggleUpdate), null);
    }

    public void setOnToggleUpdate(String _onToggleUpdate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onToggleUpdate), (Object)_onToggleUpdate);
        this.handleAttribute("onToggleUpdate", _onToggleUpdate);
    }

    public MethodExpression getResizeListener() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizeListener), null);
    }

    public void setResizeListener(MethodExpression _resizeListener) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizeListener), (Object)_resizeListener);
        this.handleAttribute("resizeListener", _resizeListener);
    }

    public String getOnResizeUpdate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onResizeUpdate), null);
    }

    public void setOnResizeUpdate(String _onResizeUpdate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onResizeUpdate), (Object)_onResizeUpdate);
        this.handleAttribute("onResizeUpdate", _onResizeUpdate);
    }

    public String getOnResizeComplete() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onResizeComplete), null);
    }

    public void setOnResizeComplete(String _onResizeComplete) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onResizeComplete), (Object)_onResizeComplete);
        this.handleAttribute("onResizeComplete", _onResizeComplete);
    }

    public String getOnCloseComplete() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onCloseComplete), null);
    }

    public void setOnCloseComplete(String _onCloseComplete) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onCloseComplete), (Object)_onCloseComplete);
        this.handleAttribute("onCloseComplete", _onCloseComplete);
    }

    public String getOnToggleComplete() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onToggleComplete), null);
    }

    public void setOnToggleComplete(String _onToggleComplete) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onToggleComplete), (Object)_onToggleComplete);
        this.handleAttribute("onToggleComplete", _onToggleComplete);
    }

    protected LayoutUnit getLayoutUnitByPosition(String name) {
        for (UIComponent child : this.getChildren()) {
            LayoutUnit layoutUnit;
            if (!(child instanceof LayoutUnit) || !(layoutUnit = (LayoutUnit)child).getPosition().equalsIgnoreCase(name)) continue;
            return layoutUnit;
        }
        return null;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodExpression resizeMe;
        super.broadcast(event);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (event instanceof CloseEvent) {
            MethodExpression closeMe = this.getCloseListener();
            if (closeMe != null) {
                closeMe.invoke(facesContext.getELContext(), new Object[]{event});
            }
        } else if (event instanceof ToggleEvent) {
            MethodExpression toggleMe = this.getToggleListener();
            if (toggleMe != null) {
                toggleMe.invoke(facesContext.getELContext(), new Object[]{event});
            }
        } else if (event instanceof ResizeEvent && (resizeMe = this.getResizeListener()) != null) {
            resizeMe.invoke(facesContext.getELContext(), new Object[]{event});
        }
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void handleAttribute(String name, Object value) {
        String cname;
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = this.getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            ValueExpression ve = this.getValueExpression(name);
            if (ve == null) {
                setAttributes.remove(name);
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        fullPage,
        style,
        styleClass,
        closeTitle,
        collapseTitle,
        expandTitle,
        closeListener,
        onCloseUpdate,
        toggleListener,
        onToggleUpdate,
        resizeListener,
        onResizeUpdate,
        onResizeComplete,
        onCloseComplete,
        onToggleComplete;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

