/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.Bundle;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.modules.apisupport.project.ui.wizard.NewTemplateVisualPanel;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

final class BasicConfVisualPanel
extends NewTemplateVisualPanel {
    private boolean wasBundleUpdated;
    private boolean listenersAttached;
    private final DocumentListener cnbDL;
    private final DocumentListener bundleDL;
    private JLabel bundle;
    private JTextField bundleValue;
    private JLabel cnbHint;
    private JLabel codeNameBase;
    private JTextField codeNameBaseValue;
    private JPanel confPanel;
    private JLabel displayName;
    private JTextField displayNameValue;
    private JLabel filler;
    private JCheckBox osgi;

    public BasicConfVisualPanel(NewModuleProjectData data) {
        super(data);
        this.initComponents();
        this.cnbDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                BasicConfVisualPanel.this.checkValues(true, false);
            }
        };
        if (this.isLibraryWizard()) {
            this.osgi.setVisible(false);
        }
        this.bundleDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                BasicConfVisualPanel.this.wasBundleUpdated = true;
                BasicConfVisualPanel.this.checkValues(false, true);
            }
        };
    }

    private boolean checkCodeNameBase() {
        String dotName = this.getCodeNameBaseValue();
        if (dotName.length() == 0) {
            this.setInfo(BasicConfVisualPanel.getMessage("MSG_EmptyCNB"), false);
        } else if (!ApisupportAntUtils.isValidJavaFQN(dotName)) {
            this.setError(BasicConfVisualPanel.getMessage("MSG_InvalidCNB"));
        } else if (this.getData().isSuiteComponent() && this.cnbIsAlreadyInSuite(this.getData().getSuiteRoot(), dotName)) {
            this.setError(NbBundle.getMessage(BasicConfVisualPanel.class, (String)"MSG_ComponentWithSuchCNBAlreadyInSuite", (Object)dotName));
        } else {
            String slashName = dotName.replace('.', '/');
            if (!this.wasBundleUpdated) {
                this.bundleValue.setText(slashName + "/Bundle.properties");
                this.wasBundleUpdated = false;
            }
            if (this.getData().isNetBeansOrg()) {
                String cnbShort = ModuleList.abbreviate(dotName);
                String name = this.getData().getProjectName();
                if (!name.equals(cnbShort)) {
                    this.setError(NbBundle.getMessage(BasicConfVisualPanel.class, (String)"BasicConfVisualPanel_err_wrong_nborg_name", (Object)cnbShort));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkBundle() {
        String path = this.getBundleValue();
        if (path.length() == 0) {
            this.setError(Bundle.BasicConfVisualPanel_err_bundle_empty());
            return false;
        }
        if (path.indexOf(47) == -1) {
            this.setError(Bundle.BasicConfVisualPanel_err_bundle_def_pkg());
            return false;
        }
        if (!path.endsWith(".properties")) {
            this.setError(Bundle.BasicConfVisualPanel_err_bundle_extension());
            return false;
        }
        return true;
    }

    private void checkValues(boolean preferCNB, boolean preferBundle) {
        if (preferCNB && !this.checkCodeNameBase()) {
            return;
        }
        if (preferBundle && !this.checkBundle()) {
            return;
        }
        if (!preferCNB && !this.checkCodeNameBase()) {
            return;
        }
        if (!preferBundle && !this.checkBundle()) {
            return;
        }
        this.markValid();
    }

    void refreshData() {
        String dn = this.getData().getProjectDisplayName();
        this.displayNameValue.setText(dn);
        this.checkValues(true, false);
    }

    void storeData() {
        this.getData().setCodeNameBase(this.getCodeNameBaseValue());
        this.getData().setProjectDisplayName(this.displayNameValue.getText());
        this.getData().setBundle(this.getBundleValue());
        this.getData().setOsgi(this.osgi.isSelected());
    }

    private String getCodeNameBaseValue() {
        return this.codeNameBaseValue.getText().trim();
    }

    private String getBundleValue() {
        return this.bundleValue.getText().trim();
    }

    private boolean cnbIsAlreadyInSuite(String suiteDir, String cnb) {
        FileObject suiteDirFO = FileUtil.toFileObject((File)new File(suiteDir));
        try {
            Project suite = ProjectManager.getDefault().findProject(suiteDirFO);
            if (suite == null) {
                return false;
            }
            for (NbModuleProject p : SuiteUtils.getSubProjects(suite)) {
                if (!ProjectUtils.getInformation((Project)p).getName().equals(cnb)) continue;
                return true;
            }
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
        return false;
    }

    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
    }

    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.codeNameBaseValue.getDocument().addDocumentListener(this.cnbDL);
            this.bundleValue.getDocument().addDocumentListener(this.bundleDL);
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.codeNameBaseValue.getDocument().removeDocumentListener(this.cnbDL);
            this.bundleValue.getDocument().removeDocumentListener(this.bundleDL);
            this.listenersAttached = false;
        }
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(BasicConfVisualPanel.class, (String)key);
    }

    private void initComponents() {
        this.confPanel = new JPanel();
        this.codeNameBase = new JLabel();
        this.codeNameBaseValue = new JTextField();
        this.filler = new JLabel();
        this.cnbHint = new JLabel();
        this.displayName = new JLabel();
        this.displayNameValue = new JTextField();
        this.bundle = new JLabel();
        this.bundleValue = new JTextField();
        this.osgi = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.confPanel.setLayout(new GridBagLayout());
        this.codeNameBase.setLabelFor(this.codeNameBaseValue);
        Mnemonics.setLocalizedText((JLabel)this.codeNameBase, (String)NbBundle.getMessage(BasicConfVisualPanel.class, (String)"LBL_CodeNameBase"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 6, 12);
        this.confPanel.add((Component)this.codeNameBase, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 4, 0);
        this.confPanel.add((Component)this.codeNameBaseValue, gridBagConstraints);
        this.codeNameBaseValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicConfVisualPanel.class, (String)"ACS_CTL_CodeNameBaseValue"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.confPanel.add((Component)this.filler, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.cnbHint, (String)BasicConfVisualPanel.getMessage("LBL_CodeNameBaseHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.confPanel.add((Component)this.cnbHint, gridBagConstraints);
        this.displayName.setLabelFor(this.displayNameValue);
        Mnemonics.setLocalizedText((JLabel)this.displayName, (String)NbBundle.getMessage(BasicConfVisualPanel.class, (String)"LBL_ModuleDisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 12);
        this.confPanel.add((Component)this.displayName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.confPanel.add((Component)this.displayNameValue, gridBagConstraints);
        this.displayNameValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicConfVisualPanel.class, (String)"ACS_CTL_DisplayNameValue"));
        this.bundle.setLabelFor(this.bundleValue);
        Mnemonics.setLocalizedText((JLabel)this.bundle, (String)NbBundle.getMessage(BasicConfVisualPanel.class, (String)"LBL_LocalizingBundle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 5, 0, 12);
        this.confPanel.add((Component)this.bundle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.confPanel.add((Component)this.bundleValue, gridBagConstraints);
        this.bundleValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicConfVisualPanel.class, (String)"ACS_CTL_BundleValue"));
        Mnemonics.setLocalizedText((AbstractButton)this.osgi, (String)NbBundle.getMessage(BasicConfVisualPanel.class, (String)"BasicConfVisualPanel.osgi"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.confPanel.add((Component)this.osgi, gridBagConstraints);
        this.osgi.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicConfVisualPanel.class, (String)"BasicConfVisualPanel.osgi.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add(this.confPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicConfVisualPanel.class, (String)"ACS_BasicConfVisualPanel"));
    }
}

