/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterizeInfo;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterizeWizardPanel1;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterizeWizardPanel2;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterizeWizardPanel3;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class Clusterize
implements WizardDescriptor.ProgressInstantiatingIterator<Clusterize> {
    final File file;
    final Project project;
    final ClusterizeInfo modules;
    private WizardDescriptor.Panel[] panels;
    final WizardDescriptor wizardDescriptor;
    int index;

    private Clusterize(Project p, File f) {
        this.file = f;
        this.project = p;
        this.modules = new ClusterizeInfo("", null, f);
        this.modules.setDisplayName(f.getPath());
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this, (Object)this);
    }

    public static boolean clusterize(Project p, File f) {
        return new Clusterize(p, f).perform();
    }

    private boolean perform() {
        this.wizardDescriptor.createNotificationLineSupport();
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(Clusterize.class, (String)"LAB_ClusterizeWizard"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        return this.wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION;
    }

    private WizardDescriptor.Panel<Clusterize>[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new ClusterizeWizardPanel1(), new ClusterizeWizardPanel2(), new ClusterizeWizardPanel3()};
        }
        return this.panels;
    }

    String getStep(int i) {
        return this.getSteps()[i];
    }

    String[] getSteps() {
        return new String[]{NbBundle.getMessage(Clusterize.class, (String)"LAB_ClusterizeNotValid"), NbBundle.getMessage(Clusterize.class, (String)"LAB_ClusterizeChoose"), NbBundle.getMessage(Clusterize.class, (String)"LAB_ClusterizeSummary")};
    }

    void scanForJars() {
        try {
            Clusterize.scanForJars(this.modules);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static boolean scanForJars(ClusterizeInfo folder) throws InterruptedException {
        File[] children = folder.jar.listFiles();
        folder.getChildren().remove(folder.getChildren().getNodes());
        if (children == null) {
            return false;
        }
        String pref = folder.path.length() == 0 ? "" : folder.path + '/';
        ArrayList<ClusterizeInfo> arr = new ArrayList<ClusterizeInfo>();
        for (File file : children) {
            ManifestManager mm;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (file.isDirectory()) {
                ClusterizeInfo subdir = new ClusterizeInfo(pref + file.getName(), null, file);
                if (!Clusterize.scanForJars(subdir)) continue;
                arr.add(subdir);
                continue;
            }
            if (!file.getName().endsWith(".jar") || (mm = ManifestManager.getInstanceFromJAR((File)file)) == null || mm.getCodeNameBase() == null) continue;
            arr.add(new ClusterizeInfo(pref + file.getName(), mm, file));
        }
        folder.getChildren().add(arr.toArray(new Node[0]));
        return folder.getChildren().getNodesCount() > 0;
    }

    void generateConfigFiles() {
        HashSet<String> autoload = new HashSet<String>();
        HashSet<String> eager = new HashSet<String>();
        HashSet<String> enabled = new HashSet<String>();
        this.modules.categorize(autoload, eager, enabled);
        try {
            AntProjectCookie apc = AntScriptUtils.antProjectCookieFor((FileObject)Clusterize.findBuildXml(this.project));
            AntTargetExecutor.Env execenv = new AntTargetExecutor.Env();
            Properties p = execenv.getProperties();
            this.toProperty(p, "include.autoload", autoload);
            this.toProperty(p, "include.enabled", enabled);
            this.toProperty(p, "include.eager", eager);
            p.setProperty("cluster", this.file.getPath());
            execenv.setProperties(p);
            String[] targetNames = new String[]{"clusterize"};
            ExecutorTask t = AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)execenv).execute(apc, targetNames);
            t.waitFinished();
        }
        catch (IOException e) {
            Util.err.notify((Throwable)e);
        }
    }

    private void toProperty(Properties p, String property, Set<String> strings) {
        if (strings.size() == 0) {
            return;
        }
        String sep = "";
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            sb.append(sep);
            sb.append(s);
            sep = ",";
        }
        p.setProperty(property, sb.toString());
    }

    private static FileObject findBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        this.generateConfigFiles();
        handle.finish();
        return Collections.emptySet();
    }

    public Set instantiate() throws IOException {
        assert (false);
        this.generateConfigFiles();
        return Collections.emptySet();
    }

    public void initialize(WizardDescriptor wizard) {
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public WizardDescriptor.Panel<Clusterize> current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.getStep(this.index);
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        ++this.index;
    }

    public void previousPanel() {
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

