/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.api.BrandingUtils;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.spi.BrandingModel;
import org.netbeans.modules.apisupport.project.spi.ExecProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.Bundle;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.netbeans.modules.apisupport.project.ui.SuiteOperations;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizer;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.awt.DynamicMenuContent;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class SuiteActions
implements ActionProvider,
ExecProject {
    private final SuiteProject project;
    private static final int PROMPT_FOR_APP_NAME_MODE_JNLP = 0;
    private static final int PROMPT_FOR_APP_NAME_MODE_ZIP = 1;

    public Task execute(String ... args) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String r : args) {
            sb.append(r).append(' ');
        }
        Properties p = new Properties();
        p.setProperty("run.args", sb.substring(0, sb.length() - 1));
        return ActionUtils.runTarget((FileObject)SuiteActions.findBuildXml(this.project), (String[])new String[]{"run"}, (Properties)p);
    }

    static Action[] getProjectActions(SuiteProject project) {
        NbPlatform platform = project.getPlatform(true);
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(CommonProjectActions.newFileAction());
        actions.add(null);
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_build"), null));
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_rebuild"), null));
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_clean"), null));
        ArrayList<Action> packageActions = new ArrayList<Action>();
        packageActions.add(ProjectSensitiveActions.projectCommandAction((String)"build-zip", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_zip"), null));
        if (platform != null && platform.getHarnessVersion().compareTo(HarnessVersion.V50u1) >= 0) {
            packageActions.add(ProjectSensitiveActions.projectCommandAction((String)"nbms", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_nbms"), null));
        }
        if (platform != null && platform.getHarnessVersion().compareTo(HarnessVersion.V55u1) >= 0) {
            packageActions.add(ProjectSensitiveActions.projectCommandAction((String)"build-mac", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_mac"), null));
        }
        packageActions.addAll(Utilities.actionsForPath((String)"Projects/org-netbeans-modules-apisupport-project-suite/Actions"));
        actions.add(new SubMenuAction(NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_package_menu"), packageActions));
        actions.add(null);
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_run"), null));
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_debug"), null));
        actions.addAll(Utilities.actionsForPath((String)"Projects/Profiler_Actions_temporary"));
        if (platform != null && platform.getHarnessVersion().compareTo(HarnessVersion.V61) >= 0) {
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_test"), null));
        }
        actions.add(null);
        actions.add(new SubMenuAction(NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_jnlp_menu"), Arrays.asList(ProjectSensitiveActions.projectCommandAction((String)"build-jnlp", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_build_jnlp"), null), ProjectSensitiveActions.projectCommandAction((String)"run-jnlp", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_run_jnlp"), null), ProjectSensitiveActions.projectCommandAction((String)"debug-jnlp", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_debug_jnlp"), null))));
        if (platform != null && platform.getHarnessVersion().compareTo(HarnessVersion.V69) >= 0) {
            actions.add(new SubMenuAction(NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_osgi_menu"), Arrays.asList(ProjectSensitiveActions.projectCommandAction((String)"build-osgi", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_build_osgi"), null), ProjectSensitiveActions.projectCommandAction((String)"build-osgi-obr", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_build_osgi_obr"), null), ProjectSensitiveActions.projectCommandAction((String)"run-osgi", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_run_osgi"), null), ProjectSensitiveActions.projectCommandAction((String)"debug-osgi", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_debug_osgi"), null), ProjectSensitiveActions.projectCommandAction((String)"profile-osgi", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_profile_osgi"), null))));
        }
        actions.add(null);
        actions.add(CommonProjectActions.setAsMainProjectAction());
        actions.add(CommonProjectActions.openSubprojectsAction());
        actions.add(CommonProjectActions.closeProjectAction());
        actions.add(null);
        actions.add(CommonProjectActions.renameProjectAction());
        actions.add(CommonProjectActions.moveProjectAction());
        actions.add(CommonProjectActions.deleteProjectAction());
        actions.add(null);
        actions.add((Action)SystemAction.get(FindAction.class));
        actions.add(null);
        actions.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
        actions.add(null);
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"branding", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_branding"), null));
        actions.add(CommonProjectActions.customizeProjectAction());
        return actions.toArray(new Action[actions.size()]);
    }

    public SuiteActions(SuiteProject project) {
        this.project = project;
    }

    public String[] getSupportedActions() {
        ArrayList<String> actions = new ArrayList<String>(Arrays.asList("build", "clean", "rebuild", "run", "debug", "build-zip", "build-jnlp", "run-jnlp", "debug-jnlp", "build-osgi", "build-osgi-obr", "run-osgi", "debug-osgi", "profile-osgi", "build-mac", "nbms", "profile", "branding", "rename", "move", "delete"));
        NbPlatform platform = this.project.getPlatform(true);
        if (platform != null && platform.getHarnessVersion().compareTo(HarnessVersion.V61) >= 0) {
            actions.add("test");
        }
        return actions.toArray(new String[actions.size()]);
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if ("branding".equals(command)) {
            boolean enabled = false;
            EditableProperties properties = this.project.getHelper().getProperties("nbproject/project.properties");
            if (null != properties) {
                String brandingToken = properties.get((Object)"branding.token");
                enabled = null != brandingToken;
            }
            return enabled;
        }
        if ("delete".equals(command) || "rename".equals(command) || "move".equals(command)) {
            return true;
        }
        if (Arrays.asList(this.getSupportedActions()).contains(command)) {
            return SuiteActions.findBuildXml(this.project) != null;
        }
        throw new IllegalArgumentException(command);
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            if (SuiteOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            }
        } else if ("rename".equals(command)) {
            if (SuiteOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            }
        } else if ("move".equals(command)) {
            if (SuiteOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            }
        } else if ("branding".equals(command)) {
            SuiteProperties properties = new SuiteProperties(this.project, this.project.getHelper(), this.project.getEvaluator(), SuiteUtils.getSubProjects(this.project));
            BrandingModel model = properties.getBrandingModel();
            BrandingUtils.openBrandingEditor((String)Bundle.Title_BrandingEditor(properties.getProjectDisplayName()), (Project)this.project, (BrandingModel)model);
        } else {
            ActionEvent ev;
            HarnessVersion v;
            NbPlatform plaf = this.project.getPlatform(false);
            if (plaf != null && (v = plaf.getHarnessVersion()) != HarnessVersion.UNKNOWN) {
                for (Project p : ((SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class)).getSubprojects()) {
                    if (v.compareTo(((NbModuleProject)p).getMinimumHarnessVersion()) >= 0) continue;
                    ModuleActions.promptForNewerHarness();
                    return;
                }
            }
            ExecutorTask task = null;
            try {
                task = this.invokeActionImpl(command, context);
            }
            catch (IOException e) {
                Util.err.notify((Throwable)e);
            }
            if (task != null && (ev = (ActionEvent)context.lookup(ActionEvent.class)) != null && "waitFinished".equals(ev.getActionCommand())) {
                ExecutorTask[] arr;
                task.waitFinished();
                if (ev.getSource() instanceof ExecutorTask[] && (arr = (ExecutorTask[])ev.getSource()).length > 0) {
                    arr[0] = task;
                }
            }
        }
    }

    public ExecutorTask invokeActionImpl(String command, Lookup context) throws IllegalArgumentException, IOException {
        String[] targetNames;
        Properties p = null;
        if (command.equals("build")) {
            targetNames = new String[]{"build"};
        } else if (command.equals("clean")) {
            targetNames = new String[]{"clean"};
        } else if (command.equals("rebuild")) {
            targetNames = new String[]{"clean", "build"};
        } else if (command.equals("run")) {
            if (this.project.getTestUserDirLockFile().isFile()) {
                p = new Properties();
                p.setProperty("run.args.ide", "--test-userdir-lock-with-invalid-arg");
            }
            targetNames = new String[]{"run"};
        } else if (command.equals("debug")) {
            if (this.project.getTestUserDirLockFile().isFile()) {
                p = new Properties();
                p.setProperty("run.args.ide", "--test-userdir-lock-with-invalid-arg");
            }
            targetNames = new String[]{"debug"};
        } else if (command.equals("test")) {
            targetNames = new String[]{"test"};
        } else if (command.equals("build-zip")) {
            if (this.promptForAppName(1)) {
                return null;
            }
            targetNames = new String[]{"build-zip"};
        } else if (command.equals("build-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            targetNames = new String[]{"build-jnlp"};
        } else if (command.equals("run-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            targetNames = new String[]{"run-jnlp"};
        } else if (command.equals("debug-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            targetNames = new String[]{"debug-jnlp"};
        } else {
            targetNames = new String[]{command};
        }
        return ActionUtils.runTarget((FileObject)SuiteActions.findBuildXml(this.project), (String[])targetNames, p);
    }

    private static FileObject findBuildXml(SuiteProject project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    private boolean promptForAppName(int mode) {
        String msg;
        String name = this.project.getEvaluator().getProperty("app.name");
        if (name != null) {
            return false;
        }
        switch (mode) {
            case 0: {
                msg = NbBundle.getMessage(ModuleActions.class, (String)"ERR_app_name_jnlp");
                break;
            }
            case 1: {
                msg = NbBundle.getMessage(ModuleActions.class, (String)"ERR_app_name_zip");
                break;
            }
            default: {
                throw new AssertionError(mode);
            }
        }
        if (ApisupportAntUIUtils.showAcceptCancelDialog(NbBundle.getMessage(ModuleActions.class, (String)"TITLE_app_name"), msg, NbBundle.getMessage(ModuleActions.class, (String)"LBL_configure_app_name"), NbBundle.getMessage(ModuleActions.class, (String)"ACSD_configure_app_name"), null, 2)) {
            SuiteCustomizer cpi = (SuiteCustomizer)this.project.getLookup().lookup(SuiteCustomizer.class);
            cpi.showCustomizer("Application", "standaloneApp");
        }
        return true;
    }

    private static class SubMenuAction
    extends AbstractAction
    implements ContextAwareAction {
        private final String label;
        private final List<? extends Action> entries;

        SubMenuAction(String label, List<? extends Action> entries) {
            this.label = label;
            this.entries = entries;
        }

        public Action createContextAwareInstance(final Lookup ctx) {
            class A
            extends AbstractAction
            implements Presenter.Popup {
                A() {
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    assert (false);
                }

                public JMenuItem getPopupPresenter() {
                    class Menu
                    extends JMenu
                    implements DynamicMenuContent {
                        Menu() {
                            super(SubMenuAction.this.label);
                        }

                        public JComponent[] getMenuPresenters() {
                            return new JComponent[]{this};
                        }

                        public JComponent[] synchMenuPresenters(JComponent[] items) {
                            return this.getMenuPresenters();
                        }
                    }
                    Menu m = new Menu();
                    for (Action entry : SubMenuAction.this.entries) {
                        if (entry instanceof ContextAwareAction) {
                            entry = ((ContextAwareAction)entry).createContextAwareInstance(ctx);
                        }
                        m.add(entry);
                    }
                    return m;
                }
            }
            return new A();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }
    }
}

