/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.Bundle;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleType;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.NonexistentModuleEntry;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ProjectXMLManager {
    private static final Logger LOG = Logger.getLogger(ProjectXMLManager.class.getName());
    private static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    private static final String BINARY_ORIGIN = "binary-origin";
    static final String BUILD_PREREQUISITE = "build-prerequisite";
    private static final String CLASS_PATH_BINARY_ORIGIN = "binary-origin";
    private static final String CLASS_PATH_EXTENSION = "class-path-extension";
    private static final String CLASS_PATH_RUNTIME_PATH = "runtime-relative-path";
    static final String CODE_NAME_BASE = "code-name-base";
    static final String COMPILE_DEPENDENCY = "compile-dependency";
    private static final String DATA = "data";
    static final String DEPENDENCY = "dependency";
    private static final String EXTRA_COMPILATION_UNIT = "extra-compilation-unit";
    private static final String FRIEND = "friend";
    private static final String FRIEND_PACKAGES = "friend-packages";
    private static final String IMPLEMENTATION_VERSION = "implementation-version";
    static final String MODULE_DEPENDENCIES = "module-dependencies";
    private static final String PACKAGE = "package";
    private static final String PUBLIC_PACKAGES = "public-packages";
    private static final String RELEASE_VERSION = "release-version";
    static final String RUN_DEPENDENCY = "run-dependency";
    private static final String SPECIFICATION_VERSION = "specification-version";
    private static final String STANDALONE = "standalone";
    private static final String SUBPACKAGES = "subpackages";
    private static final String SUITE_COMPONENT = "suite-component";
    private static final String TEST_DEPENDENCIES = "test-dependencies";
    private static final String TEST_TYPE_NAME = "name";
    private static final String TEST_DEPENDENCY = "test-dependency";
    private static final String TEST_DEPENDENCY_CNB = "code-name-base";
    private static final String TEST_DEPENDENCY_RECURSIVE = "recursive";
    private static final String TEST_DEPENDENCY_COMPILE = "compile-dependency";
    private static final String TEST_DEPENDENCY_TEST = "test";
    private static final String TEST_TYPE = "test-type";
    private static final String[] ORDER = new String[]{"code-name-base", "suite-component", "standalone", "module-dependencies", "test-dependencies", "public-packages", "friend-packages", "class-path-extension", "extra-compilation-unit"};
    private final NbModuleProject project;
    private NbPlatform customPlaf;
    private String cnb;
    private SortedSet<ModuleDependency> directDeps;
    private ManifestManager.PackageExport[] publicPackages;
    private Map<String, String> cpExtensions;
    private String[] friends;
    private Element confData;

    public ProjectXMLManager(@NonNull NbModuleProject project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.project = project;
    }

    public static ProjectXMLManager getInstance(File projectDir) throws IOException {
        FileObject dir = FileUtil.toFileObject((File)projectDir);
        NbModuleProject p = (NbModuleProject)ProjectManager.getDefault().findProject(dir);
        if (p == null) {
            throw new IOException("no project in " + projectDir);
        }
        return new ProjectXMLManager(p);
    }

    public void setModuleType(NbModuleType moduleType) {
        Element newModuleType;
        Element _confData = this.getConfData();
        Document doc = _confData.getOwnerDocument();
        Element standaloneEl = ProjectXMLManager.findElement(_confData, STANDALONE);
        if (standaloneEl != null && moduleType == NbModuleType.STANDALONE) {
            return;
        }
        Element suiteCompEl = ProjectXMLManager.findElement(_confData, SUITE_COMPONENT);
        if (suiteCompEl != null && moduleType == NbModuleType.SUITE_COMPONENT) {
            return;
        }
        if (suiteCompEl == null && standaloneEl == null && moduleType == NbModuleType.NETBEANS_ORG) {
            return;
        }
        if (suiteCompEl != null) {
            _confData.removeChild(suiteCompEl);
        }
        if (standaloneEl != null) {
            _confData.removeChild(standaloneEl);
        }
        if ((newModuleType = ProjectXMLManager.createTypeElement(doc, moduleType)) != null) {
            _confData.insertBefore(newModuleType, ProjectXMLManager.findModuleDependencies(_confData));
        }
        this.project.putPrimaryConfigurationData(_confData);
    }

    public SortedSet<ModuleDependency> getDirectDependencies() throws IOException {
        return this.getDirectDependencies(null);
    }

    public SortedSet<ModuleDependency> getDirectDependencies(NbPlatform customPlaf) throws IOException {
        if (this.customPlaf == customPlaf && this.directDeps != null) {
            return this.directDeps;
        }
        this.customPlaf = customPlaf;
        TreeSet<ModuleDependency> _directDeps = new TreeSet<ModuleDependency>(ModuleDependency.CNB_COMPARATOR);
        Element moduleDependencies = ProjectXMLManager.findModuleDependencies(this.getConfData());
        assert (moduleDependencies != null) : "Cannot find <module-dependencies> for: " + this.project;
        File prjDirF = this.project.getProjectDirectoryFile();
        ModuleList ml = customPlaf != null ? ModuleList.getModuleList(prjDirF, customPlaf.getDestDir()) : ModuleList.getModuleList(prjDirF);
        for (Element depEl : XMLUtil.findSubElements((Element)moduleDependencies)) {
            Element cnbEl = ProjectXMLManager.findElement(depEl, "code-name-base");
            String _cnb = XMLUtil.findText((Node)cnbEl);
            ModuleDependency depToAdd = this.getModuleDependency(_cnb, ml, depEl);
            if (depToAdd == null || _directDeps.add(depToAdd)) continue;
            throw new IOException("#175879: corrupted metadata in " + this.project + "; duplicate dep found: " + depToAdd);
        }
        this.directDeps = Collections.unmodifiableSortedSet(_directDeps);
        return this.directDeps;
    }

    private ModuleDependency getModuleDependency(String cnb, ModuleList ml, Element depEl) {
        Element compDepEl;
        ModuleEntry me = ml.getEntry(cnb);
        if (me == null) {
            Util.err.log(16, "Detected dependency on module which cannot be found in the current module's universe (platform, suite): " + cnb);
            me = new NonexistentModuleEntry(cnb);
        }
        String relVer = null;
        String specVer = null;
        boolean implDep = false;
        Element runDepEl = ProjectXMLManager.findElement(depEl, RUN_DEPENDENCY);
        if (runDepEl != null) {
            Element specVerEl;
            Element relVerEl = ProjectXMLManager.findElement(runDepEl, RELEASE_VERSION);
            if (relVerEl != null) {
                relVer = XMLUtil.findText((Node)relVerEl);
            }
            if ((specVerEl = ProjectXMLManager.findElement(runDepEl, SPECIFICATION_VERSION)) != null) {
                specVer = XMLUtil.findText((Node)specVerEl);
            }
            implDep = ProjectXMLManager.findElement(runDepEl, IMPLEMENTATION_VERSION) != null;
        }
        ModuleDependency newDep = new ModuleDependency(me, relVer, specVer, (compDepEl = ProjectXMLManager.findElement(depEl, "compile-dependency")) != null, implDep);
        newDep.buildPrerequisite = ProjectXMLManager.findElement(depEl, BUILD_PREREQUISITE) != null;
        newDep.runDependency = runDepEl != null;
        return newDep;
    }

    public ModuleDependency getModuleDependency(String cnb) throws IOException {
        return this.getModuleDependency(cnb, null);
    }

    public ModuleDependency getModuleDependency(String cnb, NbPlatform customPlaf) throws IOException {
        this.customPlaf = customPlaf;
        Element moduleDependencies = ProjectXMLManager.findModuleDependencies(this.getConfData());
        assert (moduleDependencies != null) : "Cannot find <module-dependencies> for: " + this.project;
        File prjDirF = this.project.getProjectDirectoryFile();
        ModuleList ml = customPlaf != null ? ModuleList.getModuleList(prjDirF, customPlaf.getDestDir()) : ModuleList.getModuleList(prjDirF);
        for (Element dep : XMLUtil.findSubElements((Element)moduleDependencies)) {
            Element cnbEl = ProjectXMLManager.findElement(dep, "code-name-base");
            String depCnb = XMLUtil.findText((Node)cnbEl);
            if (!depCnb.equals(cnb)) continue;
            return this.getModuleDependency(cnb, ml, dep);
        }
        return null;
    }

    public void removeDependency(String cnbToRemove) {
        Element _confData = this.getConfData();
        Element moduleDependencies = ProjectXMLManager.findModuleDependencies(_confData);
        for (Element dep : XMLUtil.findSubElements((Element)moduleDependencies)) {
            Element cnbEl = ProjectXMLManager.findElement(dep, "code-name-base");
            String _cnb = XMLUtil.findText((Node)cnbEl);
            if (!cnbToRemove.equals(_cnb)) continue;
            moduleDependencies.removeChild(dep);
        }
        this.project.putPrimaryConfigurationData(_confData);
    }

    public void removeDependencies(Collection<ModuleDependency> depsToDelete) {
        HashSet<String> cnbsToDelete = new HashSet<String>(depsToDelete.size());
        for (ModuleDependency dep : depsToDelete) {
            cnbsToDelete.add(dep.getModuleEntry().getCodeNameBase());
        }
        this.removeDependenciesByCNB(cnbsToDelete);
    }

    public void removeDependenciesByCNB(Collection<String> cnbsToDelete) {
        Element _confData = this.getConfData();
        Element moduleDependencies = ProjectXMLManager.findModuleDependencies(_confData);
        for (Element dep : XMLUtil.findSubElements((Element)moduleDependencies)) {
            Element cnbEl = ProjectXMLManager.findElement(dep, "code-name-base");
            String _cnb = XMLUtil.findText((Node)cnbEl);
            if (cnbsToDelete.remove(_cnb)) {
                moduleDependencies.removeChild(dep);
            }
            if (cnbsToDelete.size() != 0) continue;
            break;
        }
        if (cnbsToDelete.size() != 0) {
            Util.err.log(16, "Some modules weren't deleted: " + cnbsToDelete);
        }
        this.project.putPrimaryConfigurationData(_confData);
    }

    public void editDependency(ModuleDependency origDep, ModuleDependency newDep) {
        Element _confData = this.getConfData();
        Element moduleDependencies = ProjectXMLManager.findModuleDependencies(_confData);
        List currentDeps = XMLUtil.findSubElements((Element)moduleDependencies);
        Iterator it = currentDeps.iterator();
        while (it.hasNext()) {
            Element dep = (Element)it.next();
            Element cnbEl = ProjectXMLManager.findElement(dep, "code-name-base");
            String _cnb = XMLUtil.findText((Node)cnbEl);
            if (!_cnb.equals(origDep.getModuleEntry().getCodeNameBase())) continue;
            moduleDependencies.removeChild(dep);
            Element nextDep = it.hasNext() ? (Element)it.next() : null;
            ProjectXMLManager.createModuleDependencyElement(moduleDependencies, newDep, nextDep);
            break;
        }
        this.project.putPrimaryConfigurationData(_confData);
    }

    public void addDependency(ModuleDependency md) throws IOException, CyclicDependencyException {
        this.addDependencies(Collections.singleton(md));
    }

    public void addDependencies(Set<ModuleDependency> toAdd) throws IOException, CyclicDependencyException {
        TreeSet<ModuleDependency> deps = new TreeSet<ModuleDependency>(this.getDirectDependencies());
        if (deps.addAll(toAdd)) {
            this.replaceDependencies(deps);
        }
    }

    public String getDependencyCycleWarning(Set<ModuleDependency> candidates) {
        for (ModuleDependency md : candidates) {
            boolean cyclicDep;
            Project candidate;
            FileObject srcLocFO;
            File srcLoc = md.getModuleEntry().getSourceLocation();
            if (srcLoc == null || (srcLocFO = FileUtil.toFileObject((File)srcLoc)) == null) continue;
            try {
                candidate = ProjectManager.getDefault().findProject(srcLocFO);
            }
            catch (IOException x) {
                continue;
            }
            if (candidate == null || !(cyclicDep = ProjectUtils.hasSubprojectCycles((Project)this.project, (Project)candidate))) continue;
            if (ProjectUtils.hasSubprojectCycles((Project)this.project, null)) {
                LOG.log(Level.WARNING, "Starting out with subproject cycles in {0} before even changing them", this.project);
                return null;
            }
            String c = ProjectUtils.getInformation((Project)candidate).getDisplayName();
            String m = ProjectUtils.getInformation((Project)this.project).getDisplayName();
            return Bundle.MSG_cyclic_dep(c, m);
        }
        return null;
    }

    public void replaceDependencies(Set<ModuleDependency> newDeps) throws CyclicDependencyException {
        HashSet<ModuleDependency> addedDeps = new HashSet<ModuleDependency>(newDeps);
        try {
            SortedSet<ModuleDependency> currentDeps = this.getDirectDependencies();
            addedDeps.removeAll(currentDeps);
            String warning = this.getDependencyCycleWarning(addedDeps);
            if (warning != null) {
                throw new CyclicDependencyException(warning);
            }
        }
        catch (IOException x) {
            LOG.log(Level.INFO, null, x);
        }
        Element _confData = this.getConfData();
        Document doc = _confData.getOwnerDocument();
        Element moduleDependencies = ProjectXMLManager.findModuleDependencies(_confData);
        _confData.removeChild(moduleDependencies);
        moduleDependencies = ProjectXMLManager.createModuleElement(doc, MODULE_DEPENDENCIES);
        XMLUtil.appendChildElement((Element)_confData, (Element)moduleDependencies, (String[])ORDER);
        TreeSet<ModuleDependency> sortedDeps = new TreeSet<ModuleDependency>(newDeps);
        for (ModuleDependency md : sortedDeps) {
            ProjectXMLManager.createModuleDependencyElement(moduleDependencies, md, null);
        }
        this.project.putPrimaryConfigurationData(_confData);
        this.directDeps = sortedDeps;
    }

    public void removeClassPathExtensions() {
        Element _confData = this.getConfData();
        NodeList nl = _confData.getElementsByTagNameNS("http://www.netbeans.org/ns/nb-module-project/3", CLASS_PATH_EXTENSION);
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            _confData.removeChild(nl.item(0));
        }
        this.cpExtensions = Collections.emptyMap();
        this.project.putPrimaryConfigurationData(_confData);
    }

    public boolean removeTestDependency(String testType, String cnbToRemove) {
        boolean wasRemoved = false;
        Element _confData = this.getConfData();
        Element testModuleDependenciesEl = ProjectXMLManager.findTestDependenciesElement(_confData);
        Element testTypeRemoveEl = null;
        for (Element type : XMLUtil.findSubElements((Element)testModuleDependenciesEl)) {
            Element nameEl = ProjectXMLManager.findElement(type, TEST_TYPE_NAME);
            String nameOfType = XMLUtil.findText((Node)nameEl);
            if (!testType.equals(nameOfType)) continue;
            testTypeRemoveEl = type;
        }
        if (testTypeRemoveEl != null) {
            for (Element el : XMLUtil.findSubElements(testTypeRemoveEl)) {
                String _cnb;
                Element cnbEl = ProjectXMLManager.findElement(el, "code-name-base");
                if (cnbEl == null || !cnbToRemove.equals(_cnb = XMLUtil.findText((Node)cnbEl))) continue;
                testTypeRemoveEl.removeChild(el);
                wasRemoved = true;
                this.project.putPrimaryConfigurationData(_confData);
            }
        }
        return wasRemoved;
    }

    public boolean addTestDependency(final String testType, final TestModuleDependency newTestDep) throws IOException {
        String UNIT = "unit";
        String QA_FUNCTIONAL = "qa-functional";
        assert ("unit".equals(testType) || "qa-functional".equals(testType)) : "Current impl.supports only qa-functional or unit tests";
        Mutex.ExceptionAction<Boolean> action = new Mutex.ExceptionAction<Boolean>(){

            public Boolean run() throws Exception {
                File projectDir = FileUtil.toFile((FileObject)ProjectXMLManager.this.project.getProjectDirectory());
                ModuleList ml = ModuleList.getModuleList(projectDir);
                HashMap<String, Set<TestModuleDependency>> map = new HashMap<String, Set<TestModuleDependency>>(ProjectXMLManager.this.getTestDependencies(ml));
                TreeSet<TestModuleDependency> testDependenciesSet = (TreeSet<TestModuleDependency>)map.get(testType);
                if (testDependenciesSet == null) {
                    testDependenciesSet = new TreeSet<TestModuleDependency>();
                    map.put(testType, testDependenciesSet);
                } else {
                    testDependenciesSet = new TreeSet(testDependenciesSet);
                }
                if (!testDependenciesSet.add(newTestDep)) {
                    return false;
                }
                Element confData = ProjectXMLManager.this.getConfData();
                Document doc = confData.getOwnerDocument();
                Element testModuleDependenciesEl = ProjectXMLManager.findTestDependenciesElement(confData);
                if (testModuleDependenciesEl == null) {
                    testModuleDependenciesEl = ProjectXMLManager.createModuleElement(doc, ProjectXMLManager.TEST_DEPENDENCIES);
                    XMLUtil.appendChildElement((Element)confData, (Element)testModuleDependenciesEl, (String[])ORDER);
                }
                Element testTypeEl = null;
                for (Element tt : XMLUtil.findSubElements((Element)testModuleDependenciesEl)) {
                    Element nameNode = ProjectXMLManager.findElement(tt, ProjectXMLManager.TEST_TYPE_NAME);
                    assert (nameNode != null) : "should be some child with name";
                    assert (ProjectXMLManager.TEST_TYPE_NAME.equals(nameNode.getLocalName())) : "name node should be first child, but was:" + nameNode.getLocalName() + "or" + nameNode.getNodeName();
                    if (!nameNode.getTextContent().equals(testType)) continue;
                    testTypeEl = tt;
                }
                Element ttEl = testTypeEl;
                Element tmdEl = testModuleDependenciesEl;
                TreeSet<TestModuleDependency> tdSet = testDependenciesSet;
                AuxiliaryConfiguration auxConf = ProjectXMLManager.this.project.getHelper().createAuxiliaryConfiguration();
                auxConf.removeConfigurationFragment(ProjectXMLManager.DATA, "http://www.netbeans.org/ns/nb-module-project/2", true);
                if (ttEl == null) {
                    Element newTestTypeEl = ProjectXMLManager.this.createNewTestTypeElement(doc, testType);
                    tmdEl.appendChild(newTestTypeEl);
                    ProjectXMLManager.this.createTestModuleDependencyElement(newTestTypeEl, newTestDep);
                    ProjectXMLManager.this.project.putPrimaryConfigurationData(confData);
                } else {
                    Node beforeWhat = ttEl.getNextSibling();
                    tmdEl.removeChild(ttEl);
                    Element refreshedTestTypeEl = ProjectXMLManager.this.createNewTestTypeElement(doc, testType);
                    if (beforeWhat == null) {
                        tmdEl.appendChild(refreshedTestTypeEl);
                    } else {
                        tmdEl.insertBefore(refreshedTestTypeEl, beforeWhat);
                    }
                    for (TestModuleDependency tmd : tdSet) {
                        ProjectXMLManager.this.createTestModuleDependencyElement(refreshedTestTypeEl, tmd);
                        ProjectXMLManager.this.project.putPrimaryConfigurationData(confData);
                    }
                }
                return true;
            }
        };
        final AtomicBoolean result = new AtomicBoolean();
        this.project.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction((Mutex.ExceptionAction)action){
            final /* synthetic */ Mutex.ExceptionAction val$action;
            {
                this.val$action = exceptionAction;
            }

            public void run() throws IOException {
                try {
                    ProjectXMLManager.this.project.setRunInAtomicAction(true);
                    result.set((Boolean)ProjectManager.mutex().writeAccess(this.val$action));
                }
                catch (MutexException ex) {
                    throw (IOException)ex.getCause();
                }
                finally {
                    ProjectXMLManager.this.project.setRunInAtomicAction(false);
                }
            }
        });
        return result.get();
    }

    private Element createNewTestTypeElement(Document doc, String testTypeName) {
        Element newTestTypeEl = ProjectXMLManager.createModuleElement(doc, TEST_TYPE);
        Element nameOfTestTypeEl = ProjectXMLManager.createModuleElement(doc, TEST_TYPE_NAME, testTypeName);
        newTestTypeEl.appendChild(nameOfTestTypeEl);
        return newTestTypeEl;
    }

    private void createTestModuleDependencyElement(Element testTypeElement, TestModuleDependency tmd) {
        Document doc = testTypeElement.getOwnerDocument();
        Element tde = ProjectXMLManager.createModuleElement(doc, TEST_DEPENDENCY);
        testTypeElement.appendChild(tde);
        tde.appendChild(ProjectXMLManager.createModuleElement(doc, "code-name-base", tmd.getModule().getCodeNameBase()));
        if (tmd.isRecursive()) {
            tde.appendChild(ProjectXMLManager.createModuleElement(doc, TEST_DEPENDENCY_RECURSIVE));
        }
        if (tmd.isCompile()) {
            tde.appendChild(ProjectXMLManager.createModuleElement(doc, "compile-dependency"));
        }
        if (tmd.isTest()) {
            tde.appendChild(ProjectXMLManager.createModuleElement(doc, TEST_DEPENDENCY_TEST));
        }
    }

    @NonNull
    public Map<String, Set<TestModuleDependency>> getTestDependencies(ModuleList ml) {
        Element testDepsEl = ProjectXMLManager.findTestDependenciesElement(this.getConfData());
        HashMap<String, Set<TestModuleDependency>> testDeps = new HashMap<String, Set<TestModuleDependency>>();
        if (testDepsEl != null) {
            for (Element typeEl : XMLUtil.findSubElements((Element)testDepsEl)) {
                Element testTypeEl = ProjectXMLManager.findElement(typeEl, TEST_TYPE_NAME);
                String testType = null;
                if (testTypeEl != null) {
                    testType = XMLUtil.findText((Node)testTypeEl);
                }
                if (testType == null) {
                    testType = "unit";
                }
                TreeSet<TestModuleDependency> directTestDeps = new TreeSet<TestModuleDependency>();
                for (Element depEl : XMLUtil.findSubElements((Element)typeEl)) {
                    TestModuleDependency tmd;
                    ModuleEntry me;
                    boolean compile;
                    if (!depEl.getTagName().equals(TEST_DEPENDENCY)) continue;
                    Element cnbEl = ProjectXMLManager.findElement(depEl, "code-name-base");
                    boolean test = ProjectXMLManager.findElement(depEl, TEST_DEPENDENCY_TEST) != null;
                    String _cnb = null;
                    if (cnbEl != null) {
                        _cnb = XMLUtil.findText((Node)cnbEl);
                    }
                    boolean recursive = ProjectXMLManager.findElement(depEl, TEST_DEPENDENCY_RECURSIVE) != null;
                    boolean bl = compile = ProjectXMLManager.findElement(depEl, "compile-dependency") != null;
                    if (_cnb == null || (me = ml.getEntry(_cnb)) == null || directTestDeps.add(tmd = new TestModuleDependency(me, test, recursive, compile))) continue;
                    String path = this.project.getPathWithinNetBeansOrg();
                    if (path == null) {
                        path = this.project.getProjectDirectoryFile().getAbsolutePath();
                    }
                    String msg = "Invalid project.xml (" + path + "); testdependency " + tmd.getModule().getCodeNameBase() + " is duplicated!";
                    Util.err.log(16, msg);
                }
                testDeps.put(testType, directTestDeps);
            }
        }
        return testDeps;
    }

    public void replaceClassPathExtensions(Map<String, String> newValues) {
        this.removeClassPathExtensions();
        if (newValues != null && newValues.size() > 0) {
            Element _confData = this.getConfData();
            Document doc = _confData.getOwnerDocument();
            for (Map.Entry<String, String> entry : newValues.entrySet()) {
                Element cpel = ProjectXMLManager.createModuleElement(doc, CLASS_PATH_EXTENSION);
                Element runtime = ProjectXMLManager.createModuleElement(doc, CLASS_PATH_RUNTIME_PATH, entry.getKey());
                cpel.appendChild(runtime);
                String binaryPath = entry.getValue();
                if (binaryPath != null) {
                    Element binary = ProjectXMLManager.createModuleElement(doc, "binary-origin", binaryPath);
                    cpel.appendChild(binary);
                }
                _confData.appendChild(cpel);
            }
            this.cpExtensions = new HashMap<String, String>(newValues);
            this.project.putPrimaryConfigurationData(_confData);
        }
    }

    public void replacePublicPackages(Set<String> newPackages) {
        this.removePublicAndFriends();
        Element _confData = this.getConfData();
        Document doc = _confData.getOwnerDocument();
        Element publicPackagesEl = ProjectXMLManager.createModuleElement(doc, PUBLIC_PACKAGES);
        this.insertPublicOrFriend(publicPackagesEl);
        for (String pkg : newPackages) {
            publicPackagesEl.appendChild(ProjectXMLManager.createModuleElement(doc, PACKAGE, pkg));
        }
        this.project.putPrimaryConfigurationData(_confData);
        this.publicPackages = null;
    }

    private void insertPublicOrFriend(Element packagesEl) {
        XMLUtil.appendChildElement((Element)this.getConfData(), (Element)packagesEl, (String[])ORDER);
    }

    public void replaceFriends(Set<String> friends, Set<String> packagesToExpose) {
        this.removePublicAndFriends();
        Element _confData = this.getConfData();
        Document doc = _confData.getOwnerDocument();
        Element friendPackages = ProjectXMLManager.createModuleElement(doc, FRIEND_PACKAGES);
        this.insertPublicOrFriend(friendPackages);
        for (String friend : friends) {
            friendPackages.appendChild(ProjectXMLManager.createModuleElement(doc, FRIEND, friend));
        }
        for (String pkg : packagesToExpose) {
            friendPackages.appendChild(ProjectXMLManager.createModuleElement(doc, PACKAGE, pkg));
        }
        this.project.putPrimaryConfigurationData(_confData);
        this.publicPackages = null;
    }

    public ManifestManager.PackageExport[] getPublicPackages() {
        if (this.publicPackages == null) {
            this.publicPackages = ProjectXMLManager.findPublicPackages(this.getConfData());
        }
        return this.publicPackages;
    }

    public String[] getFriends() {
        if (this.friends == null) {
            this.friends = ProjectXMLManager.findFriends(this.getConfData());
        }
        return this.friends;
    }

    public String[] getBinaryOrigins() {
        LinkedHashSet<String> origins = new LinkedHashSet<String>(this.getClassPathExtensions().values());
        origins.remove(null);
        return origins.toArray(new String[origins.size()]);
    }

    public Map<String, String> getClassPathExtensions() {
        if (this.cpExtensions != null) {
            return Collections.unmodifiableMap(this.cpExtensions);
        }
        HashMap<String, String> cps = new HashMap<String, String>();
        for (Element cpExtEl : XMLUtil.findSubElements((Element)this.getConfData())) {
            if (!CLASS_PATH_EXTENSION.equals(cpExtEl.getTagName())) continue;
            Element binOrigEl = ProjectXMLManager.findElement(cpExtEl, "binary-origin");
            Element runtimePathEl = ProjectXMLManager.findElement(cpExtEl, CLASS_PATH_RUNTIME_PATH);
            cps.put(XMLUtil.findText((Node)runtimePathEl), binOrigEl != null ? XMLUtil.findText((Node)binOrigEl) : null);
        }
        this.cpExtensions = cps;
        return Collections.unmodifiableMap(this.cpExtensions);
    }

    public String getCodeNameBase() {
        if (this.cnb == null) {
            Element cnbEl = ProjectXMLManager.findElement(this.getConfData(), "code-name-base");
            this.cnb = XMLUtil.findText((Node)cnbEl);
        }
        return this.cnb;
    }

    static void createModuleDependencyElement(Element moduleDependencies, ModuleDependency md, Element nextSibling) {
        Document doc = moduleDependencies.getOwnerDocument();
        Element modDepEl = ProjectXMLManager.createModuleElement(doc, DEPENDENCY);
        moduleDependencies.insertBefore(modDepEl, nextSibling);
        modDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, "code-name-base", md.getModuleEntry().getCodeNameBase()));
        if (md.buildPrerequisite) {
            modDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, BUILD_PREREQUISITE));
        }
        if (md.hasCompileDependency()) {
            modDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, "compile-dependency"));
        }
        if (!md.runDependency) {
            return;
        }
        Element runDepEl = ProjectXMLManager.createModuleElement(doc, RUN_DEPENDENCY);
        modDepEl.appendChild(runDepEl);
        String rv = md.getReleaseVersion();
        if (rv != null && !rv.trim().equals("")) {
            runDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, RELEASE_VERSION, rv));
        }
        if (md.hasImplementationDependency()) {
            runDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, IMPLEMENTATION_VERSION));
        } else {
            String sv = md.getSpecificationVersion();
            if (sv != null && !"".equals(sv)) {
                runDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, SPECIFICATION_VERSION, sv));
            }
        }
    }

    private void removePublicAndFriends() {
        Element _publicPackages;
        Element friendPackages = ProjectXMLManager.findFriendsElement(this.getConfData());
        if (friendPackages != null) {
            this.getConfData().removeChild(friendPackages);
        }
        if ((_publicPackages = ProjectXMLManager.findPublicPackagesElement(this.getConfData())) != null) {
            this.getConfData().removeChild(_publicPackages);
        }
    }

    private static Element findElement(Element parentEl, String elementName) {
        return XMLUtil.findElement((Element)parentEl, (String)elementName, (String)"http://www.netbeans.org/ns/nb-module-project/3");
    }

    static Element findModuleDependencies(Element parentEl) {
        return ProjectXMLManager.findElement(parentEl, MODULE_DEPENDENCIES);
    }

    private static Element findTestDependenciesElement(Element parentEl) {
        return ProjectXMLManager.findElement(parentEl, TEST_DEPENDENCIES);
    }

    private static Element findPublicPackagesElement(Element parentEl) {
        return ProjectXMLManager.findElement(parentEl, PUBLIC_PACKAGES);
    }

    private static Element findFriendsElement(Element parentEl) {
        return ProjectXMLManager.findElement(parentEl, FRIEND_PACKAGES);
    }

    private static Element createModuleElement(Document doc, String name) {
        return doc.createElementNS("http://www.netbeans.org/ns/nb-module-project/3", name);
    }

    private static Element createModuleElement(Document doc, String name, String innerText) {
        Element el = ProjectXMLManager.createModuleElement(doc, name);
        el.appendChild(doc.createTextNode(innerText));
        return el;
    }

    private static Element createSuiteElement(Document doc, String name) {
        return doc.createElementNS("http://www.netbeans.org/ns/nb-module-suite-project/1", name);
    }

    private static Element createSuiteElement(Document doc, String name, String innerText) {
        Element el = ProjectXMLManager.createSuiteElement(doc, name);
        el.appendChild(doc.createTextNode(innerText));
        return el;
    }

    private static Set<ManifestManager.PackageExport> findAllPackages(Element parent) {
        HashSet<ManifestManager.PackageExport> packages = new HashSet<ManifestManager.PackageExport>();
        for (Element pkgEl : XMLUtil.findSubElements((Element)parent)) {
            if (PACKAGE.equals(pkgEl.getTagName())) {
                packages.add(new ManifestManager.PackageExport(XMLUtil.findText((Node)pkgEl), false));
                continue;
            }
            if (!SUBPACKAGES.equals(pkgEl.getTagName())) continue;
            packages.add(new ManifestManager.PackageExport(XMLUtil.findText((Node)pkgEl), true));
        }
        return packages;
    }

    public static ManifestManager.PackageExport[] findPublicPackages(Element confData) {
        Element ppEl = ProjectXMLManager.findPublicPackagesElement(confData);
        HashSet<ManifestManager.PackageExport> pps = new HashSet<ManifestManager.PackageExport>();
        if (ppEl != null) {
            pps.addAll(ProjectXMLManager.findAllPackages(ppEl));
        }
        if ((ppEl = ProjectXMLManager.findFriendsElement(confData)) != null) {
            pps.addAll(ProjectXMLManager.findAllPackages(ppEl));
        }
        return pps.isEmpty() ? ManifestManager.EMPTY_EXPORTED_PACKAGES : pps.toArray(new ManifestManager.PackageExport[pps.size()]);
    }

    public static String[] findFriends(Element confData) {
        Element friendsEl = ProjectXMLManager.findFriendsElement(confData);
        if (friendsEl != null) {
            TreeSet<String> friends = new TreeSet<String>();
            for (Element friendEl : XMLUtil.findSubElements((Element)friendsEl)) {
                if (!FRIEND.equals(friendEl.getTagName())) continue;
                friends.add(XMLUtil.findText((Node)friendEl));
            }
            return friends.toArray(new String[friends.size()]);
        }
        return null;
    }

    static void generateEmptyModuleTemplate(FileObject projectXml, String cnb, NbModuleType moduleType, String ... compileDepsCnbs) throws IOException {
        Document prjDoc = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element typeEl = prjDoc.createElementNS(PROJECT_NS, "type");
        typeEl.appendChild(prjDoc.createTextNode("org.netbeans.modules.apisupport.project"));
        prjDoc.getDocumentElement().appendChild(typeEl);
        Element confEl = prjDoc.createElementNS(PROJECT_NS, "configuration");
        prjDoc.getDocumentElement().appendChild(confEl);
        Element dataEl = ProjectXMLManager.createModuleElement(confEl.getOwnerDocument(), DATA);
        confEl.appendChild(dataEl);
        Document dataDoc = dataEl.getOwnerDocument();
        dataEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, "code-name-base", cnb));
        Element moduleTypeEl = ProjectXMLManager.createTypeElement(dataDoc, moduleType);
        if (moduleTypeEl != null) {
            dataEl.appendChild(moduleTypeEl);
        }
        Element deps = ProjectXMLManager.createModuleElement(dataDoc, MODULE_DEPENDENCIES);
        for (String depCnb : compileDepsCnbs) {
            Element modDepEl = ProjectXMLManager.createModuleElement(dataDoc, DEPENDENCY);
            modDepEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, "code-name-base", depCnb));
            modDepEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, BUILD_PREREQUISITE));
            modDepEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, "compile-dependency"));
            deps.appendChild(modDepEl);
        }
        dataEl.appendChild(deps);
        dataEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, PUBLIC_PACKAGES));
        ProjectXMLManager.safelyWrite(projectXml, prjDoc);
    }

    static void generateLibraryModuleTemplate(FileObject projectXml, String cnb, NbModuleType moduleType, Set<String> publicPackages, Map<String, String> extensions) throws IOException {
        Document prjDoc = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element typeEl = prjDoc.createElementNS(PROJECT_NS, "type");
        typeEl.appendChild(prjDoc.createTextNode("org.netbeans.modules.apisupport.project"));
        prjDoc.getDocumentElement().appendChild(typeEl);
        Element confEl = prjDoc.createElementNS(PROJECT_NS, "configuration");
        prjDoc.getDocumentElement().appendChild(confEl);
        Element dataEl = ProjectXMLManager.createModuleElement(confEl.getOwnerDocument(), DATA);
        confEl.appendChild(dataEl);
        Document dataDoc = dataEl.getOwnerDocument();
        dataEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, "code-name-base", cnb));
        Element moduleTypeEl = ProjectXMLManager.createTypeElement(dataDoc, moduleType);
        if (moduleTypeEl != null) {
            dataEl.appendChild(moduleTypeEl);
        }
        dataEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, MODULE_DEPENDENCIES));
        Element packages = ProjectXMLManager.createModuleElement(dataDoc, PUBLIC_PACKAGES);
        dataEl.appendChild(packages);
        for (String string : publicPackages) {
            packages.appendChild(ProjectXMLManager.createModuleElement(dataDoc, PACKAGE, string));
        }
        for (Map.Entry entry : extensions.entrySet()) {
            Element cp = ProjectXMLManager.createModuleElement(dataDoc, CLASS_PATH_EXTENSION);
            dataEl.appendChild(cp);
            cp.appendChild(ProjectXMLManager.createModuleElement(dataDoc, CLASS_PATH_RUNTIME_PATH, (String)entry.getKey()));
            cp.appendChild(ProjectXMLManager.createModuleElement(dataDoc, "binary-origin", (String)entry.getValue()));
        }
        ProjectXMLManager.safelyWrite(projectXml, prjDoc);
    }

    private static Element createTypeElement(Document dataDoc, NbModuleType type) {
        Element result = null;
        if (type == NbModuleType.STANDALONE) {
            result = ProjectXMLManager.createModuleElement(dataDoc, STANDALONE);
        } else if (type == NbModuleType.SUITE_COMPONENT) {
            result = ProjectXMLManager.createModuleElement(dataDoc, SUITE_COMPONENT);
        }
        return result;
    }

    public static void generateEmptySuiteTemplate(FileObject projectXml, String name) throws IOException {
        Document prjDoc = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element typeEl = prjDoc.createElementNS(PROJECT_NS, "type");
        typeEl.appendChild(prjDoc.createTextNode("org.netbeans.modules.apisupport.project.suite"));
        prjDoc.getDocumentElement().appendChild(typeEl);
        Element confEl = prjDoc.createElementNS(PROJECT_NS, "configuration");
        prjDoc.getDocumentElement().appendChild(confEl);
        Element dataEl = ProjectXMLManager.createSuiteElement(confEl.getOwnerDocument(), DATA);
        confEl.appendChild(dataEl);
        Document dataDoc = dataEl.getOwnerDocument();
        dataEl.appendChild(ProjectXMLManager.createSuiteElement(dataDoc, TEST_TYPE_NAME, name));
        ProjectXMLManager.safelyWrite(projectXml, prjDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safelyWrite(FileObject projectXml, Document prjDoc) throws IOException {
        OutputStream os = projectXml.getOutputStream();
        try {
            XMLUtil.write((Document)prjDoc, (OutputStream)os, (String)"UTF-8");
        }
        finally {
            os.close();
        }
    }

    private Element getConfData() {
        if (this.confData == null) {
            this.confData = this.project.getPrimaryConfigurationData();
        }
        return this.confData;
    }

    public static class CyclicDependencyException
    extends Exception {
        private CyclicDependencyException(String message) {
            super(message);
        }
    }
}

