/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.project.ProfilingSettingsSupport;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.spi.ProfilingSettingsManagerProvider;
import org.netbeans.modules.profiler.stp.NewCustomConfiguration;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;

public class NBProfilingSettingsManager
extends ProfilingSettingsManagerProvider {
    private static final String PROFILING_SETTINGS_STORAGE_FILENAME = "configurations";
    private static final String PROFILING_SETTINGS_STORAGE_FILEEXT = "xml";
    private static final String PROP_LAST_SELECTED_SETTINGS_INDEX = "profiler.settings.lastselected";
    private static final int DEFAULT_SETTINGS_COUNT = 3;

    public ProfilingSettingsManager.ProfilingSettingsDescriptor getProfilingSettings(Lookup.Provider project) {
        final LinkedList profilingSettings = new LinkedList();
        final int[] lastSelectedProfilingSettingsIndex = new int[]{-1};
        try {
            FileObject settingsStorage = ProjectStorage.getSettingsFolder((Lookup.Provider)project, (boolean)false);
            if (settingsStorage != null) {
                final Lookup.Provider projectF = project;
                FileSystem fs = settingsStorage.getFileSystem();
                fs.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        FileObject profilingSettingsStorage = NBProfilingSettingsManager.this.getProfilingSettingsStorage(projectF);
                        if (profilingSettingsStorage != null) {
                            Properties properties = NBProfilingSettingsManager.this.loadSettings(profilingSettingsStorage);
                            int index = 0;
                            while (properties.getProperty(index + "_" + "profiler.settings.settings.name") != null) {
                                ProfilingSettings settings = new ProfilingSettings();
                                settings.load((Map)properties, Integer.toString(index) + "_");
                                if (settings != null) {
                                    profilingSettings.add(settings);
                                }
                                ++index;
                            }
                            try {
                                lastSelectedProfilingSettingsIndex[0] = Integer.parseInt(properties.getProperty(NBProfilingSettingsManager.PROP_LAST_SELECTED_SETTINGS_INDEX, "0"));
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            ProfilingSettingsSupport.SettingsCustomizer customizer = ProfilingSettingsSupport.get((Lookup.Provider)projectF).getSettingsCustomizer();
                            if (customizer != null) {
                                customizer.loadCustomSettings(properties);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(65536, e.getMessage());
        }
        ProfilingSettings[] profilingSettingsArr = new ProfilingSettings[profilingSettings.size()];
        if (profilingSettingsArr.length < 3) {
            profilingSettingsArr = this.createDefaultSettings();
        } else {
            profilingSettings.toArray(profilingSettingsArr);
        }
        return new ProfilingSettingsManager.ProfilingSettingsDescriptor(profilingSettingsArr, lastSelectedProfilingSettingsIndex[0] == -1 ? null : profilingSettingsArr[lastSelectedProfilingSettingsIndex[0]]);
    }

    public ProfilingSettings createDuplicateSettings(ProfilingSettings originalSettings, ProfilingSettings[] availableConfigurations) {
        return NewCustomConfiguration.createDuplicateConfiguration(originalSettings, availableConfigurations);
    }

    public ProfilingSettings createNewSettings(ProfilingSettings[] availableConfigurations) {
        return NewCustomConfiguration.createNewConfiguration(availableConfigurations);
    }

    public ProfilingSettings createNewSettings(int type, ProfilingSettings[] availableConfigurations) {
        return NewCustomConfiguration.createNewConfiguration(type, availableConfigurations);
    }

    public ProfilingSettings renameSettings(ProfilingSettings originalSettings, ProfilingSettings[] availableConfigurations) {
        return NewCustomConfiguration.renameConfiguration(originalSettings, availableConfigurations);
    }

    public void storeProfilingSettings(ProfilingSettings[] profilingSettings, ProfilingSettings lastSelectedProfilingSettings, Lookup.Provider project) {
        try {
            FileObject settingsStorage;
            if (profilingSettings == null || profilingSettings.length < 3) {
                profilingSettings = this.createDefaultSettings();
            }
            if (lastSelectedProfilingSettings == null) {
                lastSelectedProfilingSettings = profilingSettings[0];
            }
            if ((settingsStorage = ProjectStorage.getSettingsFolder((Lookup.Provider)project, (boolean)true)) == null) {
                ErrorManager.getDefault().log(65536, "Cannot create project settings folder for " + project + ", settings cannot be saved.");
                return;
            }
            final Lookup.Provider projectF = project;
            final ProfilingSettings[] profilingSettingsF = profilingSettings;
            final ProfilingSettings lastSelectedProfilingSettingsF = lastSelectedProfilingSettings;
            FileSystem fs = settingsStorage.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject profilingSettingsStorage = NBProfilingSettingsManager.this.getProfilingSettingsStorage(projectF);
                    if (profilingSettingsStorage == null) {
                        profilingSettingsStorage = NBProfilingSettingsManager.this.createProfilingSettingsStorage(projectF);
                    }
                    if (profilingSettingsStorage != null) {
                        Properties properties = new Properties();
                        int lastSelectedProfilingSettingsIndex = -1;
                        for (int i = 0; i < profilingSettingsF.length; ++i) {
                            ProfilingSettings settings = profilingSettingsF[i];
                            if (settings == lastSelectedProfilingSettingsF) {
                                lastSelectedProfilingSettingsIndex = i;
                            }
                            settings.store((Map)properties, Integer.toString(i) + "_");
                        }
                        properties.put(NBProfilingSettingsManager.PROP_LAST_SELECTED_SETTINGS_INDEX, Integer.toString(lastSelectedProfilingSettingsIndex));
                        ProfilingSettingsSupport.SettingsCustomizer customizer = ProfilingSettingsSupport.get((Lookup.Provider)projectF).getSettingsCustomizer();
                        if (customizer != null) {
                            customizer.storeCustomSettings(properties);
                        }
                        NBProfilingSettingsManager.this.storeSettings(profilingSettingsStorage, properties);
                    }
                }
            });
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(65536, e.getMessage());
        }
    }

    private FileObject getProfilingSettingsStorage(Lookup.Provider project) throws IOException {
        FileObject projectSettingsFolder = ProjectStorage.getSettingsFolder((Lookup.Provider)project, (boolean)true);
        FileObject profilingSettingsStorage = projectSettingsFolder.getFileObject(PROFILING_SETTINGS_STORAGE_FILENAME, PROFILING_SETTINGS_STORAGE_FILEEXT);
        return profilingSettingsStorage;
    }

    private ProfilingSettings[] createDefaultSettings() {
        return new ProfilingSettings[]{ProfilingSettingsPresets.createMonitorPreset(), ProfilingSettingsPresets.createCPUPreset(), ProfilingSettingsPresets.createMemoryPreset()};
    }

    private FileObject createProfilingSettingsStorage(Lookup.Provider project) throws IOException {
        FileObject projectSettingsFolder = ProjectStorage.getSettingsFolder((Lookup.Provider)project, (boolean)true);
        FileObject profilingSettingsStorage = projectSettingsFolder.createData(PROFILING_SETTINGS_STORAGE_FILENAME, PROFILING_SETTINGS_STORAGE_FILEEXT);
        return profilingSettingsStorage;
    }

    private Properties loadSettings(FileObject storage) throws IOException {
        Properties properties = new Properties();
        InputStream is = storage.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        properties.loadFromXML(bis);
        bis.close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSettings(FileObject storage, Properties properties) throws IOException {
        FileLock lock = null;
        try {
            lock = storage.lock();
            OutputStream os = storage.getOutputStream(lock);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            properties.storeToXML(os, null);
            bos.close();
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }
}

