/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.SendJMSMessageUiSupport;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.ServiceLocatorStrategyPanel;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SendJmsMessagePanel
extends JPanel {
    public static final String IS_VALID = SendJmsMessagePanel.class.getName() + ".IS_VALID";
    private final J2eeModuleProvider provider;
    private final Set<MessageDestination> moduleDestinations;
    private final Set<MessageDestination> serverDestinations;
    private final List<SendJMSMessageUiSupport.MdbHolder> mdbs;
    private final boolean isDestinationCreationSupportedByServerPlugin;
    private final ServiceLocatorStrategyPanel slPanel;
    private NotificationLineSupport statusLine;
    private JButton addButton;
    private JTextField connectionFactoryTextField;
    private ButtonGroup destinationGroup;
    private JLabel destinationLabel;
    private JTextField destinationText;
    private JLabel jLabel1;
    private JComboBox mdbCombo;
    private JRadioButton mdbRadio;
    private JComboBox projectDestinationsCombo;
    private JRadioButton projectDestinationsRadio;
    private JComboBox serverDestinationsCombo;
    private JRadioButton serverDestinationsRadio;
    private JPanel serviceLocatorPanel;

    private SendJmsMessagePanel(J2eeModuleProvider provider, Set<MessageDestination> moduleDestinations, Set<MessageDestination> serverDestinations, List<SendJMSMessageUiSupport.MdbHolder> mdbs, String lastLocator, ClasspathInfo cpInfo) {
        this.initComponents();
        this.provider = provider;
        this.moduleDestinations = moduleDestinations;
        this.serverDestinations = serverDestinations;
        this.mdbs = mdbs;
        this.isDestinationCreationSupportedByServerPlugin = provider.getConfigSupport().supportsCreateMessageDestination();
        this.slPanel = new ServiceLocatorStrategyPanel(lastLocator, cpInfo);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                SendJmsMessagePanel.this.verifyAndFire();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                SendJmsMessagePanel.this.verifyAndFire();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                SendJmsMessagePanel.this.verifyAndFire();
            }
        });
    }

    public static SendJmsMessagePanel newInstance(J2eeModuleProvider provider, Set<MessageDestination> moduleDestinations, Set<MessageDestination> serverDestinations, List<SendJMSMessageUiSupport.MdbHolder> mdbs, String lastLocator, ClasspathInfo cpInfo) {
        SendJmsMessagePanel sjmp = new SendJmsMessagePanel(provider, moduleDestinations, serverDestinations, mdbs, lastLocator, cpInfo);
        sjmp.initialize();
        sjmp.verifyAndFire();
        sjmp.handleConnectionFactory();
        return sjmp;
    }

    public void setNotificationLine(NotificationLineSupport statusLine) {
        this.statusLine = statusLine;
    }

    public MessageDestination getDestination() {
        if (this.projectDestinationsRadio.isSelected()) {
            return (MessageDestination)this.projectDestinationsCombo.getSelectedItem();
        }
        if (this.serverDestinationsRadio.isSelected()) {
            return (MessageDestination)this.serverDestinationsCombo.getSelectedItem();
        }
        SendJMSMessageUiSupport.MdbHolder mdbHolder = (SendJMSMessageUiSupport.MdbHolder)this.mdbCombo.getSelectedItem();
        if (mdbHolder != null) {
            return mdbHolder.getMessageDestination();
        }
        return null;
    }

    public String getConnectionFactory() {
        return this.connectionFactoryTextField.getText();
    }

    public String getServiceLocator() {
        return this.slPanel.classSelected();
    }

    public Project getMdbHolderProject() {
        if (this.mdbRadio.isSelected()) {
            SendJMSMessageUiSupport.MdbHolder mdbHolder = (SendJMSMessageUiSupport.MdbHolder)this.mdbCombo.getSelectedItem();
            return mdbHolder.getProject();
        }
        return null;
    }

    private void initialize() {
        this.registerListeners();
        this.setupProjectDestinationsOption();
        this.setupMessageDrivenOption();
        this.setupServiceLocatorPanel();
        this.handleComboBoxes();
        this.populate();
    }

    private void registerListeners() {
        this.projectDestinationsRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
                SendJmsMessagePanel.this.handleComboBoxes();
            }
        });
        this.serverDestinationsRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
                SendJmsMessagePanel.this.handleComboBoxes();
            }
        });
        this.mdbRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
                SendJmsMessagePanel.this.handleComboBoxes();
            }
        });
        this.projectDestinationsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
            }
        });
        this.serverDestinationsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
            }
        });
        this.mdbCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
                SendJmsMessagePanel.this.handleConnectionFactory();
            }
        });
        this.connectionFactoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SendJmsMessagePanel.this.verifyAndFire();
            }
        });
    }

    private void setupProjectDestinationsOption() {
        if (J2eeModule.Type.EJB.equals(this.provider.getJ2eeModule().getType())) {
            this.projectDestinationsRadio.setEnabled(true);
            this.setupAddButton();
            this.projectDestinationsRadio.setSelected(true);
        } else {
            this.projectDestinationsRadio.setEnabled(false);
            this.addButton.setEnabled(false);
            this.serverDestinationsRadio.setSelected(true);
        }
    }

    private void setupMessageDrivenOption() {
        this.mdbRadio.setEnabled(J2eeModule.Type.EJB.equals(this.provider.getJ2eeModule().getType()) || Utils.isPartOfJ2eeApp(this.provider));
    }

    private void setupAddButton() {
        if (!this.isDestinationCreationSupportedByServerPlugin) {
            this.addButton.setEnabled(false);
        }
    }

    private void handleComboBoxes() {
        this.projectDestinationsCombo.setEnabled(this.projectDestinationsRadio.isSelected());
        this.serverDestinationsCombo.setEnabled(this.serverDestinationsRadio.isSelected());
        this.mdbCombo.setEnabled(this.mdbRadio.isSelected());
        this.destinationText.setEnabled(this.mdbRadio.isSelected());
        this.handleConnectionFactory();
    }

    private void handleConnectionFactory() {
        MessageDestination messageDestination = this.getDestination();
        if (messageDestination != null) {
            this.connectionFactoryTextField.setText(messageDestination.getName() + "Factory");
        } else {
            this.connectionFactoryTextField.setText(null);
        }
    }

    private void setupServiceLocatorPanel() {
        this.slPanel.addPropertyChangeListener("ServiceLocatorStrategyPanel_isValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue = evt.getNewValue();
                if (newvalue != null && newvalue instanceof Boolean) {
                    boolean isServiceLocatorOk = (Boolean)newvalue;
                    if (isServiceLocatorOk) {
                        SendJmsMessagePanel.this.verifyAndFire();
                    } else {
                        SendJmsMessagePanel.this.firePropertyChange(IS_VALID, true, false);
                    }
                }
            }
        });
        this.serviceLocatorPanel.add((Component)this.slPanel, "Center");
    }

    private void populate() {
        SendJMSMessageUiSupport.populateDestinations(this.moduleDestinations, this.projectDestinationsCombo, null);
        SendJMSMessageUiSupport.populateDestinations(this.serverDestinations, this.serverDestinationsCombo, null);
        SendJMSMessageUiSupport.populateMessageDrivenBeans(this.mdbs, this.mdbCombo, this.destinationText);
    }

    void verifyAndFire() {
        boolean isValid = this.verifyComponents();
        this.firePropertyChange(IS_VALID, !isValid, isValid);
    }

    private boolean verifyComponents() {
        if (this.destinationGroup.getSelection() == null || this.getDestination() == null) {
            this.setInfo("ERR_NoDestinationSelected");
            return false;
        }
        if (this.getConnectionFactory().trim().length() < 1) {
            this.setInfo("ERR_NoConnectionFactorySelected");
            return false;
        }
        if (this.statusLine != null) {
            this.statusLine.clearMessages();
        }
        return true;
    }

    private void setInfo(String key) {
        if (this.statusLine != null) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(SendJmsMessagePanel.class, (String)key));
        }
    }

    private void initComponents() {
        this.destinationGroup = new ButtonGroup();
        this.projectDestinationsRadio = new JRadioButton();
        this.serverDestinationsRadio = new JRadioButton();
        this.projectDestinationsCombo = new JComboBox();
        this.serverDestinationsCombo = new JComboBox();
        this.addButton = new JButton();
        this.mdbRadio = new JRadioButton();
        this.mdbCombo = new JComboBox();
        this.serviceLocatorPanel = new JPanel();
        this.destinationLabel = new JLabel();
        this.destinationText = new JTextField();
        this.jLabel1 = new JLabel();
        this.connectionFactoryTextField = new JTextField();
        this.destinationGroup.add(this.projectDestinationsRadio);
        this.projectDestinationsRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.projectDestinationsRadio, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"LBL_ProjectDestinations"));
        this.projectDestinationsRadio.setMargin(new Insets(0, 0, 0, 0));
        this.destinationGroup.add(this.serverDestinationsRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.serverDestinationsRadio, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"LBL_ServerDestinations"));
        this.serverDestinationsRadio.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SendJmsMessagePanel.this.addButtonActionPerformed(evt);
            }
        });
        this.destinationGroup.add(this.mdbRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.mdbRadio, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"LBL_MessageDrivenBean"));
        this.mdbRadio.setMargin(new Insets(0, 0, 0, 0));
        this.serviceLocatorPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.destinationLabel, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"LBL_Destination"));
        this.destinationText.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SendJmsMessagePanel.class, (String)"LBL_ConnectionFactory"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.serviceLocatorPanel, -1, 631, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectDestinationsRadio).addComponent(this.serverDestinationsRadio).addComponent(this.mdbRadio).addComponent(this.destinationLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.destinationText, -1, 360, Short.MAX_VALUE).addComponent(this.mdbCombo, GroupLayout.Alignment.TRAILING, 0, 360, Short.MAX_VALUE).addComponent(this.serverDestinationsCombo, GroupLayout.Alignment.TRAILING, 0, 360, Short.MAX_VALUE).addComponent(this.projectDestinationsCombo, GroupLayout.Alignment.TRAILING, 0, 360, Short.MAX_VALUE).addComponent(this.connectionFactoryTextField, -1, 360, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addContainerGap()).addComponent(this.jLabel1))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectDestinationsRadio).addComponent(this.addButton).addComponent(this.projectDestinationsCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverDestinationsRadio).addComponent(this.serverDestinationsCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mdbRadio).addComponent(this.mdbCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.destinationLabel).addComponent(this.destinationText, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.connectionFactoryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serviceLocatorPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.projectDestinationsRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_JMSProjectDestination"));
        this.serverDestinationsRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_JMSServerDestination"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_AddMessageDestination"));
        this.mdbRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_JMSMessageDestination"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_SendJMSMessage"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SendJmsMessagePanel.class, (String)"ACSD_SendJMSMessage"));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        MessageDestination destination = SendJMSMessageUiSupport.createMessageDestination(this.provider, this.moduleDestinations, this.serverDestinations);
        if (destination != null) {
            this.moduleDestinations.add(destination);
            SendJMSMessageUiSupport.populateDestinations(this.moduleDestinations, this.projectDestinationsCombo, destination);
        }
    }
}

