/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MessageDestinationPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class MessageDestinationUiSupport {
    public static DestinationsHolder getDestinations(final J2eeModuleProvider j2eeModuleProvider) {
        assert (j2eeModuleProvider != null);
        final DestinationsHolder holder = new DestinationsHolder();
        if (SwingUtilities.isEventDispatchThread()) {
            ProgressSupport.BackgroundAction action = new ProgressSupport.BackgroundAction(){

                public void run(ProgressSupport.Context actionContext) {
                    String msg = NbBundle.getMessage(MessageDestinationUiSupport.class, (String)"MSG_RetrievingDestinations");
                    actionContext.progress(msg);
                    try {
                        holder.setModuleDestinations(j2eeModuleProvider.getConfigSupport().getMessageDestinations());
                        holder.setServerDestinations(j2eeModuleProvider.getConfigSupport().getServerMessageDestinations());
                    }
                    catch (ConfigurationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            Set<1> asyncActions = Collections.singleton(action);
            ProgressSupport.invoke(asyncActions);
        } else {
            try {
                holder.setModuleDestinations(j2eeModuleProvider.getConfigSupport().getMessageDestinations());
                holder.setServerDestinations(j2eeModuleProvider.getConfigSupport().getServerMessageDestinations());
            }
            catch (ConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return holder;
    }

    public static void populateDestinations(Set<MessageDestination> destinations, JComboBox comboBox, MessageDestination selectedItem) {
        assert (destinations != null);
        assert (comboBox != null);
        comboBox.setRenderer(new MessageDestinationListCellRenderer());
        ArrayList<MessageDestination> sortedDestinations = new ArrayList<MessageDestination>(destinations);
        Collections.sort(sortedDestinations, new MessageDestinationComparator());
        comboBox.removeAllItems();
        for (MessageDestination d : sortedDestinations) {
            comboBox.addItem(d);
        }
        if (selectedItem != null) {
            comboBox.setSelectedItem(selectedItem);
        }
    }

    public static MessageDestination createMessageDestination(J2eeModuleProvider j2eeModuleProvider, Set<MessageDestination> moduleDestinations, Set<MessageDestination> serverDestinations) {
        assert (j2eeModuleProvider != null);
        assert (moduleDestinations != null);
        assert (serverDestinations != null);
        HashMap<String, MessageDestination.Type> destinations = new HashMap<String, MessageDestination.Type>();
        for (MessageDestination md : moduleDestinations) {
            destinations.put(md.getName(), md.getType());
        }
        for (MessageDestination md : serverDestinations) {
            destinations.put(md.getName(), md.getType());
        }
        MessageDestinationPanel messageDestination = MessageDestinationPanel.newInstance(destinations);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)messageDestination, NbBundle.getMessage(MessageDestinationPanel.class, (String)"LBL_AddMessageDestination"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(MessageDestinationPanel.class), null);
        NotificationLineSupport statusLine = dialogDescriptor.createNotificationLineSupport();
        messageDestination.setNotificationLine(statusLine);
        dialogDescriptor.setValid(false);
        messageDestination.addPropertyChangeListener(MessageDestinationPanel.IS_VALID, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue = evt.getNewValue();
                if (newvalue != null && newvalue instanceof Boolean) {
                    dialogDescriptor.setValid(((Boolean)newvalue).booleanValue());
                }
            }
        });
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        MessageDestination md = null;
        if (option == DialogDescriptor.OK_OPTION) {
            md = MessageDestinationUiSupport.createMessageDestination(j2eeModuleProvider, messageDestination.getDestinationName(), messageDestination.getDestinationType());
        }
        return md;
    }

    private static MessageDestination createMessageDestination(final J2eeModuleProvider j2eeModuleProvider, final String destinationName, final MessageDestination.Type destinationType) {
        final MessageDestination[] messageDestinations = new MessageDestination[1];
        ProgressSupport.BackgroundAction action = new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context actionContext) {
                String msg = NbBundle.getMessage(MessageDestinationUiSupport.class, (String)"MSG_CreatingDestination");
                actionContext.progress(msg);
                try {
                    messageDestinations[0] = j2eeModuleProvider.getConfigSupport().createMessageDestination(destinationName, destinationType);
                }
                catch (ConfigurationException ce) {
                    Exceptions.printStackTrace((Throwable)ce);
                }
            }
        };
        Set<3> asyncActions = Collections.singleton(action);
        ProgressSupport.invoke(asyncActions);
        return messageDestinations[0];
    }

    private static class MessageDestinationListCellRenderer
    extends DefaultListCellRenderer {
        private MessageDestinationListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof MessageDestination) {
                MessageDestination md = (MessageDestination)value;
                this.setText(md.getName());
                String type = MessageDestination.Type.QUEUE.equals((Object)md.getType()) ? "LBL_Queue" : "LBL_Topic";
                StringBuilder sb = new StringBuilder(md.getName());
                sb.append(" [");
                sb.append(NbBundle.getMessage(MessageDestinationUiSupport.class, (String)type));
                sb.append("]");
                this.setToolTipText(sb.toString());
            } else {
                this.setText(value != null ? value.toString() : "");
                this.setToolTipText("");
            }
            return this;
        }
    }

    private static class MessageDestinationComparator
    implements Comparator<MessageDestination> {
        private MessageDestinationComparator() {
        }

        @Override
        public int compare(MessageDestination md1, MessageDestination md2) {
            if (md1 == null) {
                return md2 == null ? 0 : -1;
            }
            if (md2 == null) {
                return 1;
            }
            String destName1 = md1.getName();
            String destName2 = md2.getName();
            if (destName1 == null) {
                return destName2 == null ? 0 : -1;
            }
            return destName2 == null ? 1 : destName1.compareToIgnoreCase(destName2);
        }
    }

    public static class DestinationsHolder {
        private Set<MessageDestination> moduleDestinations;
        private Set<MessageDestination> serverDestinations;

        public synchronized void setModuleDestinations(Set<MessageDestination> moduleDestinations) {
            this.moduleDestinations = moduleDestinations;
        }

        public synchronized void setServerDestinations(Set<MessageDestination> serverDestinations) {
            this.serverDestinations = serverDestinations;
        }

        public synchronized Set<MessageDestination> getModuleDestinations() {
            if (this.moduleDestinations == null) {
                this.moduleDestinations = new HashSet<MessageDestination>();
            }
            return this.moduleDestinations;
        }

        public synchronized Set<MessageDestination> getServerDestinations() {
            if (this.serverDestinations == null) {
                this.serverDestinations = new HashSet<MessageDestination>();
            }
            return this.serverDestinations;
        }
    }
}

