/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.ActivationConfig;
import org.netbeans.modules.j2ee.dd.api.ejb.ActivationConfigProperty;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class MessageGenerator {
    private static final String EJB21_EJBCLASS = "Templates/J2EE/EJB21/MessageDrivenEjbClass.java";
    private static final String EJB30_QUEUE_EJBCLASS = "Templates/J2EE/EJB30/MessageDrivenQueueEjbClass.java";
    private static final String EJB30_TOPIC_EJBCLASS = "Templates/J2EE/EJB30/MessageDrivenTopicEjbClass.java";
    private final FileObject pkg;
    private final org.netbeans.modules.j2ee.deployment.common.api.MessageDestination messageDestination;
    private final boolean isSimplified;
    private final boolean isXmlBased;
    private final EJBNameOptions ejbNameOptions;
    private final String ejbName;
    private final String ejbClassName;
    private final String displayName;
    private final String packageName;
    private final String packageNameWithDot;
    private final Map<String, String> templateParameters;

    public static MessageGenerator create(String wizardTargetName, FileObject pkg, org.netbeans.modules.j2ee.deployment.common.api.MessageDestination messageDestination, boolean isSimplified, boolean isXmlBased) {
        return new MessageGenerator(wizardTargetName, pkg, messageDestination, isSimplified, isXmlBased, false);
    }

    protected MessageGenerator(String wizardTargetName, FileObject pkg, org.netbeans.modules.j2ee.deployment.common.api.MessageDestination messageDestination, boolean isSimplified, boolean isXmlBased, boolean isTest) {
        this.pkg = pkg;
        this.messageDestination = messageDestination;
        this.isSimplified = isSimplified;
        this.isXmlBased = isXmlBased;
        this.ejbNameOptions = new EJBNameOptions();
        this.ejbName = this.ejbNameOptions.getMessageDrivenEjbNamePrefix() + wizardTargetName + this.ejbNameOptions.getMessageDrivenEjbNameSuffix();
        this.ejbClassName = this.ejbNameOptions.getMessageDrivenEjbClassPrefix() + wizardTargetName + this.ejbNameOptions.getMessageDrivenEjbClassSuffix();
        this.displayName = this.ejbNameOptions.getMessageDrivenDisplayNamePrefix() + wizardTargetName + this.ejbNameOptions.getMessageDrivenDisplayNameSuffix();
        this.packageName = EjbGenerationUtil.getSelectedPackageName(pkg);
        this.packageNameWithDot = this.packageName + ".";
        this.templateParameters = new HashMap<String, String>();
        this.templateParameters.put("package", this.packageName);
        this.templateParameters.put("messageDestinationName", messageDestination.getName());
        if (isTest) {
            this.templateParameters.put("date", "{date}");
            this.templateParameters.put("time", "{time}");
            this.templateParameters.put("user", "{user}");
        }
    }

    public FileObject generate() throws IOException {
        FileObject resultFileObject = null;
        if (this.isSimplified) {
            resultFileObject = this.generateEJB30Classes();
            if (this.isXmlBased) {
                this.generateEJB30Xml();
            }
        } else {
            resultFileObject = this.generateEJB21Classes();
            if (this.isXmlBased) {
                try {
                    this.generateEJB21Xml();
                }
                catch (VersionNotSupportedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            try {
                Project project = FileOwnerQuery.getOwner((FileObject)this.pkg);
                J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
                j2eeModuleProvider.getConfigSupport().bindMdbToMessageDestination(this.ejbName, this.messageDestination.getName(), this.messageDestination.getType());
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return resultFileObject;
    }

    private FileObject generateEJB21Classes() throws IOException {
        return GenerationUtils.createClass((String)EJB21_EJBCLASS, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
    }

    private boolean isQueue() {
        return MessageDestination.Type.QUEUE.equals((Object)this.messageDestination.getType());
    }

    private FileObject generateEJB30Classes() throws IOException {
        String ejbClassTemplate = this.isQueue() ? EJB30_QUEUE_EJBCLASS : EJB30_TOPIC_EJBCLASS;
        return GenerationUtils.createClass((String)ejbClassTemplate, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
    }

    private void generateEJB21Xml() throws IOException, VersionNotSupportedException {
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.pkg);
        org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = DDProvider.getDefault().getDDRoot(ejbModule.getDeploymentDescriptor());
        EnterpriseBeans beans = ejbJar.getEnterpriseBeans();
        MessageDriven messageDriven = null;
        if (beans == null) {
            beans = ejbJar.newEnterpriseBeans();
            ejbJar.setEnterpriseBeans(beans);
        }
        messageDriven = beans.newMessageDriven();
        ActivationConfig config = messageDriven.newActivationConfig();
        ActivationConfigProperty destProp = config.newActivationConfigProperty();
        destProp.setActivationConfigPropertyName("destinationType");
        ActivationConfigProperty ackProp = config.newActivationConfigProperty();
        ackProp.setActivationConfigPropertyName("acknowledgeMode");
        ackProp.setActivationConfigPropertyValue("Auto-acknowledge");
        config.addActivationConfigProperty(ackProp);
        if (this.isQueue()) {
            String queue = "javax.jms.Queue";
            messageDriven.setMessageDestinationType(queue);
            destProp.setActivationConfigPropertyValue(queue);
        } else {
            String topic = "javax.jms.Topic";
            messageDriven.setMessageDestinationType(topic);
            destProp.setActivationConfigPropertyValue(topic);
            ActivationConfigProperty durabilityProp = config.newActivationConfigProperty();
            durabilityProp.setActivationConfigPropertyName("subscriptionDurability");
            durabilityProp.setActivationConfigPropertyValue("Durable");
            config.addActivationConfigProperty(durabilityProp);
            ActivationConfigProperty clientIdProp = config.newActivationConfigProperty();
            clientIdProp.setActivationConfigPropertyName("clientId");
            clientIdProp.setActivationConfigPropertyValue(this.ejbName);
            config.addActivationConfigProperty(clientIdProp);
            ActivationConfigProperty subscriptionNameProp = config.newActivationConfigProperty();
            subscriptionNameProp.setActivationConfigPropertyName("subscriptionName");
            subscriptionNameProp.setActivationConfigPropertyValue(this.ejbName);
            config.addActivationConfigProperty(subscriptionNameProp);
        }
        config.addActivationConfigProperty(destProp);
        messageDriven.setActivationConfig(config);
        messageDriven.setEjbName(this.ejbName);
        messageDriven.setDisplayName(this.displayName);
        messageDriven.setEjbClass(this.packageNameWithDot + this.ejbClassName);
        messageDriven.setTransactionType("Container");
        beans.addMessageDriven(messageDriven);
        AssemblyDescriptor assemblyDescriptor = ejbJar.getSingleAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = ejbJar.newAssemblyDescriptor();
            ejbJar.setAssemblyDescriptor(assemblyDescriptor);
        }
        MessageDestination ddMessageDestination = assemblyDescriptor.newMessageDestination();
        String destinationLink = this.messageDestination.getName();
        ddMessageDestination.setDisplayName("Destination for " + this.displayName);
        ddMessageDestination.setMessageDestinationName(destinationLink);
        assemblyDescriptor.addMessageDestination(ddMessageDestination);
        messageDriven.setMessageDestinationLink(destinationLink);
        ContainerTransaction containerTransaction = assemblyDescriptor.newContainerTransaction();
        containerTransaction.setTransAttribute("Required");
        Method method = containerTransaction.newMethod();
        method.setEjbName(this.ejbName);
        method.setMethodName("*");
        containerTransaction.addMethod(method);
        assemblyDescriptor.addContainerTransaction(containerTransaction);
        ejbJar.write(ejbModule.getDeploymentDescriptor());
    }

    private void generateEJB30Xml() throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }
}

