/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;

class ResultTreeScrollController
implements TreeWillExpandListener,
TreeExpansionListener {
    private int lastX = -1;
    private JScrollPane scrollPane;
    private JTree tree;

    private ResultTreeScrollController(JScrollPane scrollPane, JTree tree) {
        this.scrollPane = scrollPane;
        this.tree = tree;
    }

    @Override
    public synchronized void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        this.lastX = (int)this.scrollPane.getViewport().getViewPosition().getX();
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeExpanded(final TreeExpansionEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle r = ResultTreeScrollController.this.tree.getPathBounds(event.getPath());
                Object treeNode = event.getPath().getLastPathComponent();
                int childCount = ResultTreeScrollController.this.tree.getModel().getChildCount(treeNode);
                int height = (int)r.getHeight() * (childCount + 1);
                Rectangle rectToShow = new Rectangle(ResultTreeScrollController.this.lastX, (int)r.getY(), ResultTreeScrollController.this.scrollPane.getWidth() - 20, height);
                ResultTreeScrollController.this.tree.scrollRectToVisible(rectToShow);
            }
        });
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent tee) {
    }

    static void register(JScrollPane scrollPane, JTree tree) {
        ResultTreeScrollController h = new ResultTreeScrollController(scrollPane, tree);
        tree.addTreeWillExpandListener(h);
        tree.addTreeExpansionListener(h);
        tree.setScrollsOnExpand(false);
    }
}

