/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.nio.charset.Charset;
import java.util.List;
import org.netbeans.modules.search.ArraySet;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultTreeModel;
import org.netbeans.modules.search.ResultViewPanel;
import org.netbeans.modules.search.SpecialSearchGroup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openidex.search.SearchType;

public final class ResultModel {
    private static final int COUNT_LIMIT = 500;
    private static final int DETAILS_COUNT_LIMIT = 5000;
    private final long creationTime;
    private int totalDetailsCount = 0;
    private ResultTreeModel treeModel;
    private ResultViewPanel resultView;
    private Limit limitReached = null;
    private SpecialSearchGroup searchGroup;
    final boolean isBasicCriteriaOnly;
    final BasicSearchCriteria basicCriteria;
    private final boolean isFullText;
    final String replaceString;
    final boolean searchAndReplace;
    private final List<MatchingObject> matchingObjects = new ArraySet(500).ordering(true).nullIsAllowed(false);
    private String finishMessage;
    private MatchingObject infoCacheMatchingObject;
    private Boolean infoCacheHasDetails;
    private int infoCacheDetailsCount;
    private Node[] infoCacheDetailNodes;
    private final Node[] EMPTY_NODES_ARRAY = new Node[0];

    ResultModel(SpecialSearchGroup searchGroup, String replaceString) {
        this.searchGroup = searchGroup;
        this.replaceString = replaceString;
        this.searchAndReplace = replaceString != null;
        this.basicCriteria = searchGroup.basicCriteria;
        this.isFullText = this.basicCriteria != null && this.basicCriteria.isFullText();
        this.isBasicCriteriaOnly = searchGroup.getSearchTypes().length == 0;
        this.creationTime = System.currentTimeMillis();
    }

    long getCreationTime() {
        return this.creationTime;
    }

    void setObserver(ResultTreeModel observer) {
        this.treeModel = observer;
    }

    void setObserver(ResultViewPanel observer) {
        this.resultView = observer;
    }

    synchronized void close() {
        if (this.matchingObjects != null && !this.matchingObjects.isEmpty()) {
            for (MatchingObject matchingObj : this.matchingObjects) {
                matchingObj.cleanup();
            }
        }
        this.searchGroup = null;
    }

    synchronized boolean objectFound(Object object, Charset charset) {
        assert (this.limitReached == null);
        assert (this.treeModel != null);
        assert (this.resultView != null);
        MatchingObject mo = new MatchingObject(this, object, charset);
        if (this.add(mo)) {
            this.totalDetailsCount += this.getDetailsCount(mo);
            this.treeModel.objectFound(mo, this.matchingObjects.indexOf(mo));
            this.resultView.objectFound(mo, this.totalDetailsCount);
            return !this.checkLimits();
        }
        return false;
    }

    private boolean add(MatchingObject matchingObject) {
        try {
            return this.matchingObjects.add(matchingObject);
        }
        catch (IllegalStateException ise) {
            this.limitReached = Limit.FILES_COUNT_LIMIT;
            return false;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean checkLimits() {
        if (this.totalDetailsCount >= 5000) {
            this.limitReached = Limit.MATCHES_COUNT_LIMIT;
            return true;
        }
        return false;
    }

    synchronized void objectBecameInvalid(MatchingObject matchingObj) {
        int index = this.matchingObjects.indexOf(matchingObj);
        assert (index != -1);
        this.treeModel.objectBecameInvalid(matchingObj);
    }

    synchronized int getTotalDetailsCount() {
        return this.totalDetailsCount;
    }

    synchronized List<MatchingObject> getMatchingObjects() {
        return this.matchingObjects;
    }

    boolean hasDetails() {
        return this.totalDetailsCount != 0;
    }

    Boolean canHaveDetails() {
        Boolean ret = this.isFullText ? Boolean.TRUE : (this.isBasicCriteriaOnly ? Boolean.FALSE : null);
        return ret;
    }

    private void prepareCacheFor(MatchingObject matchingObject) {
        if (matchingObject != this.infoCacheMatchingObject) {
            this.infoCacheHasDetails = null;
            this.infoCacheDetailsCount = -1;
            this.infoCacheDetailNodes = null;
            this.infoCacheMatchingObject = matchingObject;
        }
    }

    synchronized int getDetailsCount(MatchingObject matchingObject) {
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheDetailsCount == -1) {
            this.infoCacheDetailsCount = this.getDetailsCountReal(matchingObject);
            if (this.infoCacheDetailsCount == 0) {
                this.infoCacheDetailNodes = this.EMPTY_NODES_ARRAY;
            }
        }
        assert (this.infoCacheDetailsCount >= 0);
        return this.infoCacheDetailsCount;
    }

    private int getDetailsCountReal(MatchingObject matchingObject) {
        int count;
        int n = count = this.isFullText ? this.basicCriteria.getDetailsCount(matchingObject.getFileObject()) : 0;
        if (this.isBasicCriteriaOnly) {
            return count;
        }
        DataObject foundObject = matchingObject.getDataObject();
        for (SearchType searchType : this.searchGroup.getSearchTypes()) {
            Node[] detailNodes = searchType.getDetails((Object)foundObject);
            count += detailNodes != null ? detailNodes.length : 0;
        }
        return count;
    }

    synchronized Node[] getDetails(MatchingObject matchingObject) {
        Node[] detailNodes;
        if (matchingObject == null) {
            return null;
        }
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheDetailNodes == null) {
            detailNodes = this.getDetailsReal(matchingObject);
            this.infoCacheDetailNodes = detailNodes != null ? detailNodes : this.EMPTY_NODES_ARRAY;
            this.infoCacheDetailsCount = this.infoCacheDetailNodes.length;
        } else {
            Node[] nodeArray = detailNodes = this.infoCacheDetailNodes != this.EMPTY_NODES_ARRAY ? this.infoCacheDetailNodes : null;
        }
        assert (this.infoCacheDetailNodes != null && (this.infoCacheDetailNodes == this.EMPTY_NODES_ARRAY || this.infoCacheDetailNodes.length > 0));
        assert (detailNodes == null || detailNodes.length > 0);
        return detailNodes;
    }

    private Node[] getDetailsReal(MatchingObject matchingObject) {
        Node[] nodesTotal = null;
        if (this.basicCriteria != null) {
            Node[] nodeArray = nodesTotal = this.basicCriteria.isFullText() ? this.basicCriteria.getDetails(matchingObject.getFileObject()) : null;
        }
        if (this.isBasicCriteriaOnly) {
            return nodesTotal;
        }
        DataObject foundObject = matchingObject.getDataObject();
        for (SearchType searchType : this.searchGroup.getSearchTypes()) {
            Node[] detailNodes = searchType.getDetails((Object)foundObject);
            if (detailNodes == null || detailNodes.length == 0) continue;
            if (nodesTotal == null) {
                nodesTotal = detailNodes;
                continue;
            }
            Node[] oldNodesTotal = nodesTotal;
            nodesTotal = new Node[nodesTotal.length + detailNodes.length];
            System.arraycopy(oldNodesTotal, 0, nodesTotal, 0, oldNodesTotal.length);
            System.arraycopy(detailNodes, 0, nodesTotal, oldNodesTotal.length, detailNodes.length);
        }
        return nodesTotal;
    }

    synchronized int size() {
        return this.matchingObjects.size();
    }

    synchronized SpecialSearchGroup getSearchGroup() {
        return this.searchGroup;
    }

    synchronized SearchType[] getQueriedSearchTypes() {
        if (this.searchGroup != null) {
            return this.searchGroup.getSearchTypes();
        }
        return new SearchType[0];
    }

    synchronized boolean wasLimitReached() {
        return this.limitReached != null;
    }

    String getLimitDisplayName() {
        return this.limitReached != null ? this.limitReached.getDisplayName() : null;
    }

    synchronized void searchException(RuntimeException ex) {
        ErrorManager.Annotation[] annotations = ErrorManager.getDefault().findAnnotations((Throwable)ex);
        for (int i = 0; i < annotations.length; ++i) {
            ErrorManager.Annotation annotation = annotations[i];
            if (annotation.getSeverity() != 256) continue;
            this.finishMessage = annotation.getLocalizedMessage();
            if (this.finishMessage == null) continue;
            return;
        }
        this.finishMessage = ex.getLocalizedMessage();
    }

    synchronized String getExceptionMsg() {
        return this.finishMessage;
    }

    ResultViewPanel getResultView() {
        return this.resultView;
    }

    synchronized FileObject getCommonSearchFolder() {
        if (this.searchGroup != null) {
            return this.searchGroup.getCommonSearchFolder();
        }
        return null;
    }

    static enum Limit {
        FILES_COUNT_LIMIT("TEXT_MSG_LIMIT_REACHED_FILES_COUNT", 500),
        MATCHES_COUNT_LIMIT("TEXT_MSG_LIMIT_REACHED_MATCHES_COUNT", 5000);

        private final String bundleKey;
        private final Integer value;

        private Limit(String bundleKey, Integer limit) {
            this.bundleKey = bundleKey;
            this.value = limit;
        }

        String getDisplayName() {
            return NbBundle.getMessage(Limit.class, (String)this.bundleKey, (Object)this.value);
        }

        public Integer getValue() {
            return this.value;
        }
    }
}

