/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.drilldown;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ui.charts.AbstractPieChartModel;
import org.netbeans.modules.profiler.categorization.api.Category;
import org.netbeans.modules.profiler.drilldown.DrillDown;
import org.netbeans.modules.profiler.drilldown.DrillDownListener;

public abstract class DrillDownPieChartModel
extends AbstractPieChartModel
implements DrillDownListener {
    protected static final Logger LOGGER = Logger.getLogger(DrillDownPieChartModel.class.getName());
    private static Color[] COLORS = new Color[]{new Color(0x99FF99), new Color(0x99CC99), new Color(0x666633), new Color(0x336666), new Color(0x6699CC), new Color(0x9999CC), new Color(0xFFCCFF), new Color(0xCC9999), new Color(0x660099), new Color(26112)};
    protected DrillDown drillDown;
    private final Object itemMapLock = new Object();
    private int[] itemMap = null;
    private int itemCount = 0;
    private List<Category> subCategories;

    public DrillDownPieChartModel(DrillDown model) {
        this.setDrillDown(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDrillDown(DrillDown model) {
        if (this.drillDown != null) {
            this.drillDown.removeListener(this);
        }
        this.drillDown = model;
        Object object = this.itemMapLock;
        synchronized (object) {
            this.updateItemMap();
        }
        this.drillDown.addListener(this);
    }

    public Color getItemColor(int index) {
        if (index == -1) {
            return Color.BLACK;
        }
        return COLORS[index % COLORS.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemCount() {
        Object object = this.itemMapLock;
        synchronized (object) {
            return this.itemCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getItemDescription(int index) {
        if (index == -1 || this.getMappedIndex(index) == -1) {
            return "";
        }
        Object object = this.itemMapLock;
        synchronized (object) {
            if (this.subCategories != null) {
                return this.subCategories.get(this.getMappedIndex(index)).getLabel();
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataChanged() {
        Object object = this.itemMapLock;
        synchronized (object) {
            this.updateItemMap();
        }
        this.fireChartDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drillDownPathChanged(List newDrillDownPath) {
        Object object = this.itemMapLock;
        synchronized (object) {
            this.updateItemMap();
        }
        this.fireChartDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drilldown(int index) {
        if (index == -1 || this.getMappedIndex(index) == -1) {
            return;
        }
        Category toDrill = null;
        Object object = this.itemMapLock;
        synchronized (object) {
            if (this.subCategories == null || this.subCategories.isEmpty()) {
                return;
            }
            toDrill = this.subCategories.get(this.getMappedIndex(index));
        }
        if (toDrill != null) {
            this.drillDown.drilldown(toDrill.getId());
        }
    }

    public void drillup() {
        this.drillDown.drillup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drillup(int index) {
        if (index == -1 || this.getMappedIndex(index) == -1) {
            return;
        }
        Category toDrill = null;
        Object object = this.itemMapLock;
        synchronized (object) {
            if (this.subCategories == null || this.subCategories.isEmpty()) {
                return;
            }
            toDrill = this.subCategories.get(this.getMappedIndex(index));
        }
        this.drillDown.drillup(toDrill.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData() {
        Object object = this.itemMapLock;
        synchronized (object) {
            return this.drillDown != null && this.itemCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Category> getSubCategories() {
        ArrayList<Category> cats = new ArrayList<Category>();
        Object object = this.itemMapLock;
        synchronized (object) {
            if (this.subCategories != null) {
                cats.addAll(this.subCategories);
            }
        }
        return cats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Category getCategoryAt(int index) {
        Object object = this.itemMapLock;
        synchronized (object) {
            if (this.subCategories == null || this.subCategories.isEmpty()) {
                return Category.DEFAULT;
            }
            return this.subCategories.get(this.getMappedIndex(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMappedIndex(int index) {
        Object object = this.itemMapLock;
        synchronized (object) {
            if (index < 0 || index >= this.itemMap.length) {
                return -1;
            }
            return this.itemMap[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemMap() {
        Object object = this.itemMapLock;
        synchronized (object) {
            this.subCategories = this.drillDown.getSubCategories();
            if (this.subCategories == null || this.subCategories.isEmpty()) {
                return;
            }
            int counter = 0;
            int mapCounter = 0;
            int[] map = new int[this.subCategories.size()];
            for (Category category : this.subCategories) {
                if (this.drillDown.getCategoryTime(category, false) > 0L) {
                    map[mapCounter++] = counter;
                }
                ++counter;
            }
            this.itemCount = mapCounter > 0 ? mapCounter : 0;
            this.itemMap = map;
        }
    }
}

