/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.whitelist.project;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.Preferences;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.whitelist.WhiteListQuery;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.netbeans.spi.whitelist.WhiteListQueryImplementation;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class WhiteListCategoryPanel
extends JPanel
implements ActionListener {
    private static final String WHITELISTS_PATH = "org-netbeans-api-java/whitelists/";
    private static Map<Project, Reference<WhiteListLookup>> lookupCache = new WeakHashMap<Project, Reference<WhiteListLookup>>();
    private Project p;
    public static final String PROP_WHITELIST_ENABLED = "whitelist-enabled";
    public static final String PROP_WHITELIST = "whitelist-";
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public WhiteListCategoryPanel(Project p) {
        this.p = p;
        this.initComponents();
        WhiteListsModel model = new WhiteListsModel(this.getTableContent());
        this.jTable1.setModel(model);
        this.jTable1.getTableHeader().setVisible(false);
        this.jTable1.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.jTable1.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.jTable1.getColumnModel().getColumn(0).setMaxWidth(25);
        this.jTable1.getColumnModel().getColumn(0).setMinWidth(25);
    }

    private List<Desc> getTableContent() {
        ArrayList<Desc> l = new ArrayList<Desc>();
        for (WhiteListQueryImplementation.UserSelectable userSelectable : WhiteListCategoryPanel.getUserSelectableWhiteLists()) {
            l.add(new Desc(userSelectable, WhiteListCategoryPanel.isWhiteListEnabledInProject(this.p, userSelectable.getId())));
        }
        return l;
    }

    public static ProjectCustomizer.CompositeCategoryProvider createWhiteListCategoryProvider(Map attrs) {
        return new Factory(Boolean.TRUE.equals((Boolean)attrs.get("show")));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (Desc d : ((WhiteListsModel)this.jTable1.getModel()).whitelists) {
            WhiteListCategoryPanel.enableWhiteListInProject(this.p, d.w.getId(), d.active);
        }
    }

    public static boolean isWhiteListPanelEnabled(@NonNull Project p) {
        Preferences prefs = ProjectUtils.getPreferences((Project)p, WhiteListQuery.class, (boolean)true);
        return prefs.getBoolean(PROP_WHITELIST_ENABLED, false);
    }

    public static boolean isWhiteListEnabledInProject(@NonNull Project p, @NonNull String whiteListId) {
        Preferences prefs = ProjectUtils.getPreferences((Project)p, WhiteListQuery.class, (boolean)true);
        return prefs.getBoolean(PROP_WHITELIST + whiteListId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableWhiteListInProject(@NonNull Project p, final @NonNull String whiteListId, final boolean enable) {
        final Preferences prefs = ProjectUtils.getPreferences((Project)p, WhiteListQuery.class, (boolean)true);
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                prefs.putBoolean(WhiteListCategoryPanel.PROP_WHITELIST + whiteListId, enable);
                if (enable) {
                    prefs.putBoolean(WhiteListCategoryPanel.PROP_WHITELIST_ENABLED, true);
                }
            }
        });
        Class<WhiteListCategoryPanel> clazz = WhiteListCategoryPanel.class;
        synchronized (WhiteListCategoryPanel.class) {
            WhiteListLookup lkp;
            Reference<WhiteListLookup> lkpRef = lookupCache.get(p);
            if (lkpRef != null && (lkp = lkpRef.get()) != null) {
                lkp.updateLookup();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static Collection<? extends WhiteListQueryImplementation.UserSelectable> getUserSelectableWhiteLists() {
        return Lookups.forPath((String)WHITELISTS_PATH).lookupResult(WhiteListQueryImplementation.UserSelectable.class).allInstances();
    }

    public static Lookup getEnabledUserSelectableWhiteLists(@NonNull Project p) {
        WhiteListLookup lkp;
        Reference<WhiteListLookup> lkpRef = lookupCache.get(p);
        if (lkpRef == null || (lkp = lkpRef.get()) == null) {
            lkp = new WhiteListLookup(p);
            lookupCache.put(p, new WeakReference<WhiteListLookup>(lkp));
        }
        return lkp;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel1.setText(NbBundle.getMessage(WhiteListCategoryPanel.class, (String)"WhiteListCategoryPanel.jLabel1.text"));
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(283, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 263, Short.MAX_VALUE)));
    }

    private static class WhiteListLookup
    extends ProxyLookup {
        private Project p;
        private boolean initialized = false;

        public WhiteListLookup(Project p) {
            this.p = p;
        }

        protected synchronized void beforeLookup(Lookup.Template<?> template) {
            if (!this.initialized && WhiteListQueryImplementation.class.equals((Object)template.getType())) {
                this.initialized = true;
                this.updateLookup();
            }
            super.beforeLookup(template);
        }

        private void updateLookup() {
            ArrayList<WhiteListQueryImplementation.UserSelectable> impls = new ArrayList<WhiteListQueryImplementation.UserSelectable>();
            for (WhiteListQueryImplementation.UserSelectable w : Lookups.forPath((String)WhiteListCategoryPanel.WHITELISTS_PATH).lookupAll(WhiteListQueryImplementation.UserSelectable.class)) {
                if (!WhiteListCategoryPanel.isWhiteListEnabledInProject(this.p, w.getId())) continue;
                impls.add(w);
            }
            this.setLookups(new Lookup[]{Lookups.fixed((Object[])impls.toArray(new WhiteListQueryImplementation.UserSelectable[impls.size()]))});
        }
    }

    private static class WhiteListsModel
    implements TableModel {
        private List<Desc> whitelists;
        private String[] header = new String[]{"Enabled", "Whitelist"};
        private Class[] headerClass = new Class[]{Boolean.class, String.class};

        public WhiteListsModel(List<Desc> whitelists) {
            assert (whitelists.size() > 0);
            this.whitelists = new ArrayList<Desc>(whitelists);
        }

        @Override
        public int getRowCount() {
            return this.whitelists.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.header[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.headerClass[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Desc srd = this.whitelists.get(rowIndex);
            if (columnIndex == 0) {
                return srd.active;
            }
            return srd.w.getDisplayName();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue instanceof Boolean) {
                this.whitelists.get(rowIndex).active = (Boolean)aValue;
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }

    private static class Desc {
        private WhiteListQueryImplementation.UserSelectable w;
        private boolean active;

        public Desc(WhiteListQueryImplementation.UserSelectable w, boolean active) {
            this.w = w;
            this.active = active;
        }
    }

    public static class Factory
    implements ProjectCustomizer.CompositeCategoryProvider {
        private static final String CATEGORY_WHITELIST = "WhiteList";
        private final boolean alwaysShowWhiteListPanel;

        public Factory(boolean showWhiteListPanel) {
            this.alwaysShowWhiteListPanel = showWhiteListPanel;
        }

        public ProjectCustomizer.Category createCategory(Lookup context) {
            Project p = (Project)context.lookup(Project.class);
            if (p == null) {
                return null;
            }
            if (WhiteListCategoryPanel.getUserSelectableWhiteLists().isEmpty()) {
                return null;
            }
            if (!WhiteListCategoryPanel.isWhiteListPanelEnabled(p) && !this.alwaysShowWhiteListPanel) {
                return null;
            }
            return ProjectCustomizer.Category.create((String)CATEGORY_WHITELIST, (String)NbBundle.getMessage(WhiteListCategoryPanel.class, (String)"LBL_CategoryWhitelist"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        }

        public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
            Project p = (Project)context.lookup(Project.class);
            assert (p != null);
            WhiteListCategoryPanel customizerPanel = new WhiteListCategoryPanel(p);
            category.setStoreListener((ActionListener)customizerPanel);
            return customizerPanel;
        }
    }
}

