/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.project;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.form.project.FormClassLoader;
import org.netbeans.modules.form.project.ProjectClassLoader;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ClassPathUtils {
    private static Map<Project, FormClassLoader> loaders = new WeakHashMap<Project, FormClassLoader>();
    static final ClassLoadingType SYSTEM_CLASS = new ClassLoadingType("system");
    static final ClassLoadingType SYSTEM_CLASS_WITH_PROJECT = new ClassLoadingType("system_with_project");
    private static final ClassLoadingType[] CLASS_LOADING_TYPES = new ClassLoadingType[]{SYSTEM_CLASS, SYSTEM_CLASS_WITH_PROJECT};
    private static final String CL_LAYER_BASE = "org-netbeans-modules-form/classloader/";

    public static Class<?> loadClass(String name, FileObject fileInProject) throws ClassNotFoundException {
        return Class.forName(name, true, ClassPathUtils.getFormClassLoader(fileInProject));
    }

    public static boolean checkUserClass(String name, FileObject fileInProject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/execute");
        if (classPath == null) {
            return false;
        }
        String fileName = name.replace('.', '/').concat(".class");
        return classPath.findResource(fileName) != null;
    }

    public static void resetFormClassLoader(Project p) {
        loaders.remove(p);
    }

    private static FormClassLoader getFormClassLoader(FileObject fileInProject) {
        Project p = FileOwnerQuery.getOwner((FileObject)fileInProject);
        FormClassLoader fcl = loaders.get(p);
        ClassLoader existingProjectCL = fcl != null ? fcl.getProjectClassLoader() : null;
        ClassLoader newProjectCL = ProjectClassLoader.getUpToDateClassLoader(fileInProject, existingProjectCL);
        if (fcl == null || newProjectCL != existingProjectCL) {
            fcl = new FormClassLoader(newProjectCL);
            loaders.put(p, fcl);
        }
        return fcl;
    }

    public static ClassLoader getProjectClassLoader(FileObject fileInProject) {
        return ClassPathUtils.getFormClassLoader(fileInProject).getProjectClassLoader();
    }

    static ClassLoadingType getClassLoadingType(String className) {
        int i = className.lastIndexOf("[L");
        if (i != -1) {
            className = className.substring(i + 2, className.length() - 1);
        }
        for (ClassLoadingType clType : CLASS_LOADING_TYPES) {
            if (!ClassPathUtils.isClassLoadingType(className, clType)) continue;
            return clType;
        }
        return null;
    }

    public static Class loadClass(ClassSource classSource) throws ClassNotFoundException {
        String className = classSource.getClassName();
        if (className == null) {
            return null;
        }
        ClassLoader loader = null;
        if (!classSource.hasEntries()) {
            loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        } else {
            try {
                List<URL> urlList = classSource.getClasspath();
                if (urlList.size() <= 0) {
                    return null;
                }
                URL[] roots = new URL[urlList.size()];
                urlList.toArray(roots);
                loader = ClassPathSupport.createClassPath((URL[])roots).getClassLoader(true);
            }
            catch (Exception ex) {
                IllegalArgumentException iae = new IllegalArgumentException();
                ErrorManager.getDefault().annotate((Throwable)iae, (Throwable)ex);
                throw iae;
            }
        }
        return loader.loadClass(classSource.getClassName());
    }

    public static boolean isOnClassPath(FileObject fileInProject, String className) {
        String resourceName = className.replace('.', '/') + ".class";
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/compile");
        if (classPath == null) {
            return false;
        }
        return classPath.findResource(resourceName) != null;
    }

    public static boolean isJava6ProjectPlatform(FileObject fileInProject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/boot");
        if (classPath == null) {
            return false;
        }
        return classPath.findResource("javax/swing/GroupLayout.class") != null;
    }

    public static Boolean updateProject(final FileObject fileInProject, final ClassSource classSource) throws IOException {
        if (!classSource.hasEntries()) {
            return Boolean.FALSE;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileInProject);
        if (project == null) {
            return Boolean.FALSE;
        }
        String msg = ClassPathUtils.getBundleString("MSG_UpdatingClassPath");
        Object retVal = ProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<Object>(){

            public Object run(ProgressHandle handle) {
                try {
                    return classSource.addToProjectClassPath(fileInProject, "classpath/compile");
                }
                catch (IOException ioex) {
                    return ioex;
                }
            }
        }, (String)msg, (boolean)false);
        if (retVal instanceof IOException) {
            throw (IOException)retVal;
        }
        Boolean updated = (Boolean)retVal;
        return updated;
    }

    public static String getClassSourceDescription(ClassSource classSource) {
        if (classSource == null || !classSource.hasEntries()) {
            String className = classSource.getClassName();
            if (className != null) {
                if (className.startsWith("javax.") || className.startsWith("java.")) {
                    return ClassPathUtils.getBundleString("MSG_StandardJDKSource");
                }
                if (className.startsWith("org.netbeans.")) {
                    return ClassPathUtils.getBundleString("MSG_NetBeansSource");
                }
            }
            return NbBundle.getMessage(ClassPathUtils.class, (String)"MSG_UnspecifiedSource");
        }
        return classSource.getEntries().iterator().next().getDisplayName();
    }

    static String getBundleString(String key) {
        return NbBundle.getBundle(ClassPathUtils.class).getString(key);
    }

    private static boolean isClassLoadingType(String className, ClassLoadingType clType) {
        List<ClassPattern> list = ClassPathUtils.getClassPatterns(clType);
        if (list == null) {
            return false;
        }
        for (ClassPattern cp : list) {
            switch (cp.type) {
                case 0: {
                    if (!className.equals(cp.name)) break;
                    return true;
                }
                case 1: {
                    if (!className.startsWith(cp.name) || className.lastIndexOf(46) > cp.name.length()) break;
                    return true;
                }
                case 2: {
                    if (!className.startsWith(cp.name)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static List<ClassPattern> getClassPatterns(ClassLoadingType clType) {
        List<ClassPattern> list = clType.patterns;
        if (list == null) {
            list = ClassPathUtils.loadClassPatterns(ClassPathUtils.getClassPatternsFolder(clType));
            clType.patterns = list;
        }
        return list;
    }

    private static FileObject getClassPatternsFolder(final ClassLoadingType clType) {
        FileObject folder = clType.folder;
        if (folder == null) {
            folder = ClassPathUtils.getClassPatternsFolder(clType.folderName);
            if (folder == null) {
                return null;
            }
            clType.folder = folder;
            folder.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileDataCreated(FileEvent ev) {
                    clType.patterns = null;
                    loaders.clear();
                }

                public void fileDeleted(FileEvent ev) {
                    clType.patterns = null;
                    if (ev.getFile() == clType.folder) {
                        clType.folder.removeFileChangeListener((FileChangeListener)this);
                        clType.folder = null;
                    }
                    loaders.clear();
                }
            });
        }
        return folder;
    }

    private static FileObject getClassPatternsFolder(String folderName) {
        FileObject folder = null;
        if (folderName != null) {
            try {
                folder = FileUtil.getConfigFile((String)(CL_LAYER_BASE + folderName));
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return folder;
    }

    private static List<ClassPattern> loadClassPatterns(FileObject folder) {
        ArrayList<ClassPattern> list = new ArrayList<ClassPattern>();
        if (folder == null) {
            return list;
        }
        FileObject[] files = folder.getChildren();
        for (int i = 0; i < files.length; ++i) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(files[i].getInputStream()));
                String line = r.readLine();
                while (line != null) {
                    if (!(line = line.trim()).equals("")) {
                        ClassPattern cp = line.endsWith("**") ? new ClassPattern(line.substring(0, line.length() - 2), 2) : (line.endsWith("*") ? new ClassPattern(line.substring(0, line.length() - 1), 1) : new ClassPattern(line, 0));
                        list.add(cp);
                    }
                    line = r.readLine();
                }
                continue;
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return list;
    }

    private static class ClassPattern {
        static final int CLASS = 0;
        static final int PACKAGE = 1;
        static final int PACKAGE_AND_SUBPACKAGES = 2;
        String name;
        int type;

        ClassPattern(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }

    static class ClassLoadingType {
        private String folderName;
        private FileObject folder;
        private List<ClassPattern> patterns;

        private ClassLoadingType(String folderName) {
            this.folderName = folderName;
        }
    }
}

