/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridActionPerformer;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridBoundsChange;
import org.openide.util.actions.SystemAction;

public class UndoRedoSupport {
    private static Map<FormModel, UndoRedoSupport> supportMap = new WeakHashMap<FormModel, UndoRedoSupport>();
    GridActionPerformer performer;
    UndoAction undoAction;
    RedoAction redoAction;
    boolean undoInProgress;
    boolean redoInProgress;
    int undoableEdits;
    int redoableEdits;

    private UndoRedoSupport(FormModel model) {
        model.getUndoRedoManager().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (UndoRedoSupport.this.undoInProgress) {
                    --UndoRedoSupport.this.undoableEdits;
                    ++UndoRedoSupport.this.redoableEdits;
                } else if (UndoRedoSupport.this.redoInProgress) {
                    ++UndoRedoSupport.this.undoableEdits;
                    --UndoRedoSupport.this.redoableEdits;
                } else {
                    ++UndoRedoSupport.this.undoableEdits;
                    UndoRedoSupport.this.redoableEdits = 0;
                }
                UndoRedoSupport.this.undoAction.updateEnabled();
                UndoRedoSupport.this.redoAction.updateEnabled();
            }
        });
        this.undoAction = new UndoAction((Action)SystemAction.get(org.openide.actions.UndoAction.class));
        this.redoAction = new RedoAction((Action)SystemAction.get(org.openide.actions.RedoAction.class));
    }

    static UndoRedoSupport getSupport(FormModel model) {
        UndoRedoSupport support = supportMap.get(model);
        if (support == null) {
            support = UndoRedoSupport.createUndoRedoSupport(model);
            supportMap.put(model, support);
        }
        return support;
    }

    private static UndoRedoSupport createUndoRedoSupport(FormModel model) {
        return new UndoRedoSupport(model);
    }

    public void reset(GridActionPerformer performer) {
        this.performer = performer;
        this.undoableEdits = 0;
        this.redoableEdits = 0;
        this.undoAction.updateEnabled();
        this.redoAction.updateEnabled();
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    static class DelegateGridAction
    extends AbstractGridAction {
        protected Action delegate;

        protected DelegateGridAction(Action delegate) {
            this.delegate = delegate;
        }

        @Override
        public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
            GridInfoProvider info = gridManager.getGridInfo();
            int oldColumns = info.getColumnCount();
            int oldRows = info.getRowCount();
            GridUtils.removePaddingComponents(gridManager);
            this.delegate.actionPerformed(null);
            gridManager.updateLayout(true);
            HashSet<Component> newSelection = new HashSet<Component>();
            for (Component comp : context.getSelectedComponents()) {
                if (comp.getParent() == null) continue;
                newSelection.add(comp);
            }
            context.setSelectedComponents(newSelection);
            GridUtils.revalidateGrid(gridManager);
            gridManager.updateGaps(false);
            int newColumns = info.getColumnCount();
            int newRows = info.getRowCount();
            int columns = Math.max(oldColumns, newColumns);
            int rows = Math.max(oldRows, newRows);
            GridUtils.addPaddingComponents(gridManager, columns, rows);
            GridUtils.revalidateGrid(gridManager);
            return null;
        }
    }

    class RedoAction
    extends DelegateAction {
        RedoAction(Action delegate) {
            super(delegate);
            this.updateEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UndoRedoSupport.this.redoInProgress = true;
                UndoRedoSupport.this.performer.performAction(new DelegateGridAction(this.delegate));
            }
            finally {
                UndoRedoSupport.this.redoInProgress = false;
            }
        }

        final void updateEnabled() {
            this.setEnabled(UndoRedoSupport.this.redoableEdits > 0);
        }
    }

    class UndoAction
    extends DelegateAction {
        UndoAction(Action delegate) {
            super(delegate);
            this.updateEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UndoRedoSupport.this.undoInProgress = true;
                UndoRedoSupport.this.performer.performAction(new DelegateGridAction(this.delegate));
            }
            finally {
                UndoRedoSupport.this.undoInProgress = false;
            }
        }

        final void updateEnabled() {
            this.setEnabled(UndoRedoSupport.this.undoableEdits > 0);
        }
    }

    static abstract class DelegateAction
    extends AbstractAction {
        protected Action delegate;

        protected DelegateAction(Action delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.delegate.putValue(key, value);
        }
    }
}

