/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.FormLoaderSettings;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public final class FormEditorCustomizer
extends JPanel
implements ActionListener,
ChangeListener {
    private JCheckBox cbFold = new JCheckBox();
    private JCheckBox cbAssistant = new JCheckBox();
    private JCheckBox cbFQN = new JCheckBox();
    private JComboBox cbModifier = new JComboBox();
    private JRadioButton rbGenerateLocals = new JRadioButton();
    private JRadioButton rbGenerateFields = new JRadioButton();
    private JComboBox cbLayoutStyle = new JComboBox();
    private JComboBox cbComponentNames = new JComboBox();
    private JComboBox cbListenerStyle = new JComboBox();
    private JComboBox cbAutoI18n = new JComboBox();
    private PropertyPanel guideLineColEditor = new PropertyPanel();
    private PropertyPanel selectionBorderColEditor = new PropertyPanel();
    private boolean changed = false;
    private boolean listen = false;

    public FormEditorCustomizer() {
        ButtonGroup group = new ButtonGroup();
        FormEditorCustomizer.loc(this.cbFold, "Fold");
        FormEditorCustomizer.loc(this.cbAssistant, "Assistant");
        FormEditorCustomizer.loc(this.cbFQN, "Generate_FQN");
        FormEditorCustomizer.loc(this.rbGenerateLocals, "Generate_Locals");
        group.add(this.rbGenerateLocals);
        FormEditorCustomizer.loc(this.rbGenerateFields, "Generate_Fields");
        group.add(this.rbGenerateFields);
        this.cbModifier.addItem(FormEditorCustomizer.loc("Public_Modifier"));
        this.cbModifier.addItem(FormEditorCustomizer.loc("Default_Modifier"));
        this.cbModifier.addItem(FormEditorCustomizer.loc("Protected_Modifier"));
        this.cbModifier.addItem(FormEditorCustomizer.loc("Private_Modifier"));
        this.cbLayoutStyle.addItem(FormEditorCustomizer.loc("CTL_LAYOUT_CODE_AUTO"));
        this.cbLayoutStyle.addItem(FormEditorCustomizer.loc("CTL_LAYOUT_CODE_JDK6"));
        this.cbLayoutStyle.addItem(FormEditorCustomizer.loc("CTL_LAYOUT_CODE_LIBRARY"));
        this.cbComponentNames.addItem(FormEditorCustomizer.loc("CTL_AUTO_NAMING_DEFAULT"));
        this.cbComponentNames.addItem(FormEditorCustomizer.loc("CTL_AUTO_NAMING_ON"));
        this.cbComponentNames.addItem(FormEditorCustomizer.loc("CTL_AUTO_NAMING_OFF"));
        this.cbListenerStyle.addItem(FormEditorCustomizer.loc("Anonymous"));
        this.cbListenerStyle.addItem(FormEditorCustomizer.loc("InnerClass"));
        this.cbListenerStyle.addItem(FormEditorCustomizer.loc("MainClass"));
        this.cbAutoI18n.addItem(FormEditorCustomizer.loc("CTL_AUTO_RESOURCE_DEFAULT"));
        this.cbAutoI18n.addItem(FormEditorCustomizer.loc("CTL_AUTO_RESOURCE_ON"));
        this.cbAutoI18n.addItem(FormEditorCustomizer.loc("CTL_AUTO_RESOURCE_OFF"));
        JLabel generateComponetsLabel = new JLabel(FormEditorCustomizer.loc("Generate_Components"));
        JLabel variableModifierLabel = new JLabel();
        JLabel layoutStyleLabel = new JLabel();
        JLabel componentNamesLabel = new JLabel();
        JLabel selectionBorderColLabel = new JLabel();
        JLabel guideLineColLabel = new JLabel();
        JLabel listenerStyleLabel = new JLabel();
        JLabel autoI18nLabel = new JLabel();
        FormEditorCustomizer.loc(variableModifierLabel, "Variable_Modifier");
        FormEditorCustomizer.loc(layoutStyleLabel, "Layout_Style");
        FormEditorCustomizer.loc(componentNamesLabel, "Component_Names");
        FormEditorCustomizer.loc(listenerStyleLabel, "Listener_Style");
        FormEditorCustomizer.loc(autoI18nLabel, "Auto_I18n");
        FormEditorCustomizer.loc(selectionBorderColLabel, "Selection_Border_Color");
        FormEditorCustomizer.loc(guideLineColLabel, "Guiding_Line_Color");
        generateComponetsLabel.setToolTipText(FormEditorCustomizer.loc("Generate_Components_Hint"));
        variableModifierLabel.setToolTipText(FormEditorCustomizer.loc("HINT_VARIABLES_MODIFIER"));
        layoutStyleLabel.setToolTipText(FormEditorCustomizer.loc("HINT_LAYOUT_CODE_TARGET"));
        componentNamesLabel.setToolTipText(FormEditorCustomizer.loc("HINT_AUTO_SET_COMPONENT_NAME"));
        listenerStyleLabel.setToolTipText(FormEditorCustomizer.loc("HINT_LISTENER_GENERATION_STYLE"));
        autoI18nLabel.setToolTipText(FormEditorCustomizer.loc("HINT_AUTO_RESOURCE_GLOBAL"));
        guideLineColLabel.setToolTipText(FormEditorCustomizer.loc("HINT_GUIDING_LINE_COLOR"));
        selectionBorderColLabel.setToolTipText(FormEditorCustomizer.loc("HINT_SELECTION_BORDER_COLOR"));
        this.cbFold.setToolTipText(FormEditorCustomizer.loc("HINT_FOLD_GENERATED_CODE"));
        this.cbAssistant.setToolTipText(FormEditorCustomizer.loc("HINT_ASSISTANT_SHOWN"));
        this.cbFQN.setToolTipText(FormEditorCustomizer.loc("HINT_GENERATE_FQN"));
        this.rbGenerateLocals.getAccessibleContext().setAccessibleDescription(FormEditorCustomizer.loc("Generate_Locals_ACSD"));
        this.rbGenerateFields.getAccessibleContext().setAccessibleDescription(FormEditorCustomizer.loc("Generate_Fields_ACSD"));
        variableModifierLabel.setLabelFor(this.cbModifier);
        layoutStyleLabel.setLabelFor(this.cbLayoutStyle);
        componentNamesLabel.setLabelFor(this.cbComponentNames);
        listenerStyleLabel.setLabelFor(this.cbListenerStyle);
        autoI18nLabel.setLabelFor(this.cbAutoI18n);
        guideLineColLabel.setLabelFor((Component)this.guideLineColEditor);
        selectionBorderColLabel.setLabelFor((Component)this.selectionBorderColEditor);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(generateComponetsLabel).addComponent(variableModifierLabel).addComponent(layoutStyleLabel).addComponent(componentNamesLabel).addComponent(listenerStyleLabel).addComponent(autoI18nLabel).addComponent(guideLineColLabel).addComponent(selectionBorderColLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.rbGenerateLocals).addComponent(this.rbGenerateFields).addComponent(this.cbFold).addComponent(this.cbAssistant).addComponent(this.cbFQN).addComponent(this.cbModifier, -1, -1, Short.MAX_VALUE).addComponent(this.cbLayoutStyle, -1, -1, Short.MAX_VALUE).addComponent(this.cbComponentNames, -1, -1, Short.MAX_VALUE).addComponent(this.cbListenerStyle, -1, -1, Short.MAX_VALUE).addComponent(this.cbAutoI18n, -1, -1, Short.MAX_VALUE).addComponent((Component)this.guideLineColEditor, -1, -1, Short.MAX_VALUE).addComponent((Component)this.selectionBorderColEditor, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(generateComponetsLabel).addComponent(this.rbGenerateLocals)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbGenerateFields).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(variableModifierLabel).addComponent(this.cbModifier)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(listenerStyleLabel).addComponent(this.cbListenerStyle)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(autoI18nLabel).addComponent(this.cbAutoI18n)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(layoutStyleLabel).addComponent(this.cbLayoutStyle)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(componentNamesLabel).addComponent(this.cbComponentNames)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbFold).addComponent(this.cbAssistant).addComponent(this.cbFQN).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(guideLineColLabel, GroupLayout.Alignment.CENTER).addComponent((Component)this.guideLineColEditor, GroupLayout.Alignment.CENTER, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(selectionBorderColLabel, GroupLayout.Alignment.CENTER).addComponent((Component)this.selectionBorderColEditor, GroupLayout.Alignment.CENTER, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addContainerGap());
        this.setBorder(new TitledBorder(FormEditorCustomizer.loc("Code_Generation")));
        this.cbFold.addActionListener(this);
        this.cbAssistant.addActionListener(this);
        this.cbFQN.addActionListener(this);
        this.cbLayoutStyle.addActionListener(this);
        this.cbComponentNames.addActionListener(this);
        this.cbListenerStyle.addActionListener(this);
        this.cbModifier.addActionListener(this);
        this.rbGenerateFields.addActionListener(this);
        this.rbGenerateLocals.addActionListener(this);
        this.cbAutoI18n.addActionListener(this);
    }

    private static String loc(String key) {
        return NbBundle.getMessage(FormEditorCustomizer.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)FormEditorCustomizer.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)FormEditorCustomizer.loc(key));
        }
    }

    void update() {
        this.listen = false;
        FormLoaderSettings options = FormLoaderSettings.getInstance();
        try {
            this.selectionBorderColEditor.setProperty((Node.Property)new PropertySupport.Reflection((Object)options, Color.class, "selectionBorderColor"));
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        try {
            this.guideLineColEditor.setProperty((Node.Property)new PropertySupport.Reflection((Object)options, Color.class, "guidingLineColor"));
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.cbFold.setSelected(options.getFoldGeneratedCode());
        this.cbAssistant.setSelected(options.getAssistantShown());
        this.cbFQN.setSelected(options.getGenerateFQN());
        this.rbGenerateLocals.setSelected(options.getVariablesLocal());
        this.rbGenerateFields.setSelected(!options.getVariablesLocal());
        if ((options.getVariablesModifier() & 1) > 0) {
            this.cbModifier.setSelectedIndex(0);
        } else if ((options.getVariablesModifier() & 4) > 0) {
            this.cbModifier.setSelectedIndex(2);
        } else if ((options.getVariablesModifier() & 2) > 0) {
            this.cbModifier.setSelectedIndex(3);
        } else {
            this.cbModifier.setSelectedIndex(1);
        }
        this.cbListenerStyle.setSelectedIndex(options.getListenerGenerationStyle());
        this.cbLayoutStyle.setSelectedIndex(options.getLayoutCodeTarget());
        this.cbComponentNames.setSelectedIndex(options.getAutoSetComponentName());
        this.cbAutoI18n.setSelectedIndex(options.getI18nAutoMode());
        this.listen = true;
        this.changed = false;
    }

    void applyChanges() {
        FormLoaderSettings options = FormLoaderSettings.getInstance();
        options.setFoldGeneratedCode(this.cbFold.isSelected());
        options.setAssistantShown(this.cbAssistant.isSelected());
        options.setGenerateFQN(this.cbFQN.isSelected());
        options.setListenerGenerationStyle(this.cbListenerStyle.getSelectedIndex());
        options.setLayoutCodeTarget(this.cbLayoutStyle.getSelectedIndex());
        options.setAutoSetComponentName(this.cbComponentNames.getSelectedIndex());
        options.setI18nAutoMode(this.cbAutoI18n.getSelectedIndex());
        options.setVariablesLocal(this.rbGenerateLocals.isSelected());
        switch (this.cbModifier.getSelectedIndex()) {
            case 0: {
                options.setVariablesModifier(1);
                break;
            }
            case 1: {
                options.setVariablesModifier(0);
                break;
            }
            case 2: {
                options.setVariablesModifier(4);
                break;
            }
            case 3: {
                options.setVariablesModifier(2);
            }
        }
        this.changed = false;
    }

    void cancel() {
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listen) {
            this.changed = true;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.listen) {
            this.changed = true;
        }
    }
}

