/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.lib.editor.util.ListenerList;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.LockedViewHierarchy;
import org.netbeans.modules.editor.lib2.view.ViewApiPackageAccessor;
import org.netbeans.modules.editor.lib2.view.ViewHierarchy;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyChange;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyEvent;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyListener;
import org.openide.util.Exceptions;

public final class ViewHierarchyImpl {
    static final Logger OP_LOG = Logger.getLogger("org.netbeans.editor.view.op");
    static final Logger CHANGE_LOG = Logger.getLogger("org.netbeans.editor.view.change");
    static final Logger BUILD_LOG = Logger.getLogger("org.netbeans.editor.view.build");
    static final Logger PAINT_LOG = Logger.getLogger("org.netbeans.editor.view.paint");
    static final Logger SPAN_LOG = Logger.getLogger("org.netbeans.editor.view.span");
    static final Logger REPAINT_LOG = Logger.getLogger("org.netbeans.editor.view.repaint");
    static final Logger CHECK_LOG = Logger.getLogger("org.netbeans.editor.view.check");
    static final Logger SETTINGS_LOG = Logger.getLogger("org.netbeans.editor.view.settings");
    static final Logger EVENT_LOG = Logger.getLogger("org.netbeans.editor.view.event");
    static final Logger LOG = Logger.getLogger(ViewHierarchyImpl.class.getName());
    private final JTextComponent textComponent;
    private final ViewHierarchy viewHierarchy;
    private final ListenerList<ViewHierarchyListener> listenerList;
    private DocumentView docView;
    private LockedViewHierarchy lock;
    private Thread lockThread;
    private int extraLockDepth;
    private Exception lockStack;

    public static synchronized ViewHierarchyImpl get(JTextComponent component) {
        ViewHierarchyImpl ViewHierarchyImpl2 = (ViewHierarchyImpl)component.getClientProperty(ViewHierarchyImpl.class);
        if (ViewHierarchyImpl2 == null) {
            ViewHierarchyImpl2 = new ViewHierarchyImpl(component);
            component.putClientProperty(ViewHierarchyImpl.class, ViewHierarchyImpl2);
        }
        return ViewHierarchyImpl2;
    }

    private ViewHierarchyImpl(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.listenerList = new ListenerList();
        this.viewHierarchy = ViewApiPackageAccessor.get().createViewHierarchy(this);
    }

    @NonNull
    public JTextComponent textComponent() {
        return this.textComponent;
    }

    @NonNull
    public ViewHierarchy viewHierarchy() {
        return this.viewHierarchy;
    }

    public void setDocumentView(DocumentView docView) {
        this.docView = docView;
    }

    public synchronized LockedViewHierarchy lock() {
        try {
            Thread curThread = Thread.currentThread();
            while (this.lock != null) {
                if (this.lockThread == curThread) {
                    ++this.extraLockDepth;
                    return this.lock;
                }
                this.wait();
            }
            this.lock = ViewApiPackageAccessor.get().createLockedViewHierarchy(this);
            this.lockThread = curThread;
            if (LOG.isLoggable(Level.FINER)) {
                this.lockStack = new Exception("ViewHierarchy.lock() caller stack");
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.INFO, this.lockStack.getMessage(), this.lockStack);
                }
            }
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted attempt to aquire lock");
        }
        return this.lock;
    }

    public synchronized void unlock(LockedViewHierarchy lock) {
        if (lock != this.lock) {
            throw new IllegalStateException("Invalid LockedViewHierarchy.unlock(): Not a locker");
        }
        if (this.extraLockDepth > 0) {
            --this.extraLockDepth;
            return;
        }
        this.lock = null;
        this.notifyAll();
    }

    public double modelToY(LockedViewHierarchy lock, int offset) {
        this.ensureLocker(lock);
        if (this.docView != null) {
            return this.docView.modelToYUnlocked(offset);
        }
        return this.fallBackModelToY(offset);
    }

    private double fallBackModelToY(int offset) {
        Rectangle s;
        try {
            s = this.textComponent.modelToView(offset);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            s = null;
        }
        if (s != null) {
            return s.getBounds().y;
        }
        return 0.0;
    }

    public double[] modelToY(LockedViewHierarchy lock, int[] offsets) {
        this.ensureLocker(lock);
        if (this.docView != null) {
            return this.docView.modelToYUnlocked(offsets);
        }
        double[] ys = new double[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            ys[i] = this.fallBackModelToY(offsets[i]);
        }
        return ys;
    }

    public Shape modelToView(LockedViewHierarchy lock, int offset, Position.Bias bias) {
        this.ensureLocker(lock);
        if (this.docView != null) {
            return this.docView.modelToViewUnlocked(offset, this.docView.getAllocation(), bias);
        }
        TextUI ui = this.textComponent.getUI();
        try {
            return ui != null ? ui.modelToView(this.textComponent, offset, bias) : null;
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    public Shape modelToParagraphView(LockedViewHierarchy lock, int offset) {
        int index;
        this.ensureLocker(lock);
        Shape ret = null;
        if (this.docView != null && this.docView.op.isActive() && (index = this.docView.getViewIndex(offset)) >= 0) {
            ret = this.docView.getChildAllocation(index, this.docView.getAllocation());
        }
        return ret;
    }

    public int viewToModel(LockedViewHierarchy lock, double x, double y, Position.Bias[] biasReturn) {
        this.ensureLocker(lock);
        if (this.docView != null) {
            return this.docView.viewToModelUnlocked(x, y, this.docView.getAllocation(), biasReturn);
        }
        TextUI ui = this.textComponent.getUI();
        return ui != null ? Integer.valueOf(ui.viewToModel(this.textComponent, new Point((int)x, (int)y), biasReturn)) : null;
    }

    public float getDefaultRowHeight(LockedViewHierarchy lock) {
        this.ensureLocker(lock);
        return this.docView.op.getDefaultRowHeight();
    }

    public float getDefaultCharWidth(LockedViewHierarchy lock) {
        this.ensureLocker(lock);
        return this.docView.op.getDefaultCharWidth();
    }

    public void addViewHierarchyListener(ViewHierarchyListener l) {
        this.listenerList.add((EventListener)l);
    }

    public void removeViewHierarchyListener(ViewHierarchyListener l) {
        this.listenerList.remove((EventListener)l);
    }

    void fireChange(ViewHierarchyChange change) {
        ViewHierarchyEvent evt = ViewApiPackageAccessor.get().createEvent(this.viewHierarchy, change);
        if (EVENT_LOG.isLoggable(Level.FINE)) {
            EVENT_LOG.fine("Firing event: " + evt + "\n");
        }
        for (ViewHierarchyListener l : this.listenerList.getListeners()) {
            l.viewHierarchyChanged(evt);
        }
    }

    private void ensureLocker(LockedViewHierarchy lock) {
        if (lock != this.lock) {
            throw new IllegalStateException("Not locker of view hierarchy for component:\n" + this.textComponent);
        }
    }

    public String toString() {
        return this.docView != null ? this.docView.getDumpId() : "<NULL-docView>";
    }
}

