/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Shape;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

final class TextLayoutUtils {
    private TextLayoutUtils() {
    }

    public static float getHeight(TextLayout textLayout) {
        float height = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        return (float)Math.ceil(height);
    }

    public static float getWidth(TextLayout textLayout) {
        float x0 = TextLayoutUtils.index2X(textLayout, 0);
        float x1 = TextLayoutUtils.index2X(textLayout, textLayout.getCharacterCount());
        float width = Math.abs(x1 - x0);
        width = (float)Math.ceil(x1 - x0);
        return width;
    }

    public static float index2X(TextLayout textLayout, int index) {
        TextHitInfo hit = TextHitInfo.leading(index);
        float[] info = textLayout.getCaretInfo(hit);
        return info[0];
    }

    public static Shape getRealAlloc(TextLayout textLayout, Rectangle2D textLayoutRect, TextHitInfo startHit, TextHitInfo endHit) {
        Rectangle2D.Double zeroBasedRect = ViewUtils.shape2Bounds(textLayoutRect);
        zeroBasedRect.x = 0.0;
        zeroBasedRect.y = 0.0;
        Shape ret = textLayout.getVisualHighlightShape(startHit, endHit, zeroBasedRect);
        AffineTransform transform = AffineTransform.getTranslateInstance(textLayoutRect.getX(), textLayoutRect.getY());
        ret = transform.createTransformedShape(ret);
        return ret;
    }

    public static String toStringShort(TextLayout textLayout) {
        return "[" + textLayout.getCharacterCount() + "]W=" + TextLayoutUtils.getWidth(textLayout);
    }

    public static String toString(TextLayout textLayout) {
        return TextLayoutUtils.toStringShort(textLayout) + "; " + textLayout.toString();
    }
}

